/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class ConnectorConfiguration {
    public static final String TDCH_PRE_JOB_HOOK = "tdch.pre.job.hook";
    public static final String TDCH_POST_JOB_HOOK = "tdch.post.job.hook";
    public static final String TDCH_PLUGIN_INPUT_FORMAT = "tdch.plugin.input.format";
    public static final String TDCH_PLUGIN_OUTPUT_FORMAT = "tdch.plugin.output.format";
    public static final String TDCH_INPUT_SERDE = "tdch.input.serde";
    public static final String TDCH_OUTPUT_SERDE = "tdch.output.serde";
    public static final String TDCH_PLUGIN_INPUT_PROCESSOR = "tdch.plugin.input.processor";
    public static final String TDCH_PLUGIN_OUTPUT_PROCESSOR = "tdch.plugin.output.processor";
    public static final String TDCH_DATA_CONVERTER = "tdch.plugin.data.converter";
    public static final String TDCH_PLUGIN_INPUT_SPLIT_CLASS = "tdch.plugin.input.split";
    public static final String TDCH_JOB_MAPPER = "tdch.job.mapper";
    public static final String TDCH_JOB_REDUCER = "tdch.job.reducer";
    public static final String TDCH_USE_COMBINED_INPUT_FORMAT = "tdch.use.combined.input.format";
    public static final String TDCH_USE_PARTITIONED_OUTPUT_FORMAT = "tdch.use.partitioned.output.format";
    public static final String TDCH_NUM_MAPPERS = "tdch.num.mappers";
    public static final String TDCH_NUM_REDUCERS = "tdch.num.reducers";
    public static final String TDCH_JOB_SUCCEEDED = "tdch.job.succeeded";
    public static final String TDCH_THROTTLE_NUM_MAPPERS = "tdch.throttle.num.mappers";
    public static final String TDCH_THROTTLE_NUM_MAPPERS_MIN_MAPPERS = "tdch.throttle.num.mappers.min.mappers";
    public static final String TDCH_THROTTLE_NUM_MAPPERS_RETRY_SECONDS = "tdch.throttle.num.mappers.retry.seconds";
    public static final String TDCH_THROTTLE_NUM_MAPPERS_RETRY_COUNT = "tdch.throttle.num.mappers.retry.count";
    public static final String TDCH_STRING_TRUNCATE = "tdch.string.truncate";
    public static final String TDCH_OUTPUT_PARTITION_COLUMN_NAMES = "tdch.output.partition.column.names";
    public static final String TDCH_INPUT_CONVERTER_RECORD_SCHEMA = "tdch.intput.converter.record.schema";
    public static final String TDCH_OUTPUT_CONVERTER_RECORD_SCHEMA = "tdch.output.converter.record.schema";
    public static final String TDCH_INTER_MAP_COMPRESSION = "mapreduce.map.output.compress";
    public static final String TDCH_INTER_MAP_COMPRESSION_CODEC = "mapreduce.map.output.compress.codec";
    public static final String TDCH_INPUT_COMPRESSION = "mapreduce.output.fileoutputformat.compress";
    public static final String TDCH_INPUT_COMPRESSION_TYPE = "mapreduce.output.fileoutputformat.compress.type";
    public static final String TDCH_INPUT_COMPRESSION_CODEC = "mapreduce.output.fileoutputformat.compress.codec";
    public static final String TDCH_OUTPUT_LOGGING_FLAG = "tdch.output.hdfs.logging";
    public static final String TDCH_OUTPUT_LOGGING_PATH = "tdch.output.hdfs.logging.path";
    public static final String TDCH_OUTPUT_LOGGING_DELIMITER = "tdch.output.hdfs.logging.delimiter";
    public static final String TDCH_OUTPUT_LOGGING_LIMIT = "tdch.output.hdfs.logging.limit";
    public static final String TDCH_OUTPUT_WRITE_PHASE_CLOSE = "tdch.output.write.phase.close";
    public static final String TDCH_PLUGIN_CONF_FILE = "tdch.job.plugin.configuration.file";
    public static final String TDCH_INPUT_DATE_FORMAT = "tdch.input.date.format";
    public static final String TDCH_OUTPUT_DATE_FORMAT = "tdch.output.date.format";
    public static final String TDCH_INPUT_TIMESTAMP_FORMAT = "tdch.input.timestamp.format";
    public static final String TDCH_OUTPUT_TIMESTAMP_FORMAT = "tdch.output.timestamp.format";
    public static final String TDCH_INPUT_TIME_FORMAT = "tdch.input.time.format";
    public static final String TDCH_OUTPUT_TIME_FORMAT = "tdch.output.time.format";
    public static final String TDCH_INPUT_TIMEZONE_ID = "tdch.input.timezone.id";
    public static final String TDCH_OUTPUT_TIMEZONE_ID = "tdch.output.timezone.id";
    public static final String VALUE_JOB_TYPE_HCAT = "hcat";
    public static final String VALUE_JOB_TYPE_HIVE = "hive";
    public static final String VALUE_JOB_TYPE_HDFS = "hdfs";
    public static final String VALUE_JOB_TYPE_TERADATA = "teradata";
    public static final String VALUE_FILE_FORMAT_TEXTFILE = "textfile";
    public static final String VALUE_FILE_FORMAT_SEQUENCEFILE = "sequencefile";
    public static final String VALUE_FILE_FORMAT_RCFILE = "rcfile";
    public static final String VALUE_FILE_FORMAT_AVROFILE = "avrofile";
    public static final String VALUE_FILE_FORMAT_ORCFILE = "orcfile";
    public static final String VALUE_FILE_FORMAT_ORC = "orc";
    public static final String VALUE_FILE_FORMAT_PARQUET = "parquet";
    public static final String VALUE_MAPRED_INPUT_DIR = "mapred.input.dir";
    public static final String VALUE_MAPRED_OUTPUT_DIR = "mapred.output.dir";
    public static final int VALUE_NUMBER_MAPPERS_DEFAULT = 2;
    public static final int VALUE_NUMBER_REDUCERS_DEFAULT = 0;
    public static final int VALUE_THROTTLE_MAPPERS_RETRY_SECONDS_DEFAULT = 5;
    public static final int VALUE_THROTTLE_MAPPERS_RETRY_COUNT_DEFAULT = 12;
    public static final int VALUE_CONNECTOR_DUG_OPTION_CLOSED = 0;
    public static final int VALUE_CONNECTOR_WRITE_PHASE_CLOSED = 1;
    public static final String TDCH_DEFAULT_INPUT_SPLIT = "com.teradata.connector.teradata.TeradataInputFormat$TeradataInputSplit";
    private static final int MAX_CONFIG_ITEM_LIMIT = 100;
    private static final String POST_FIX = ".";

    public static void setPreJobHook(Configuration configuration, String preJobHooks) {
        configuration.set(TDCH_PRE_JOB_HOOK, preJobHooks);
    }

    public static String getPreJobHook(Configuration configuration) {
        return configuration.get(TDCH_PRE_JOB_HOOK);
    }

    public static void setPostJobHook(Configuration configuration, String postJobHooks) {
        configuration.set(TDCH_POST_JOB_HOOK, postJobHooks);
    }

    public static String getPostJobHook(Configuration configuration) {
        return configuration.get(TDCH_POST_JOB_HOOK);
    }

    public static void setPlugInInputFormat(Configuration configuration, String plugInInputFormatClass) {
        configuration.set(TDCH_PLUGIN_INPUT_FORMAT, plugInInputFormatClass);
    }

    public static String getPlugInInputFormat(Configuration configuration) {
        return configuration.get(TDCH_PLUGIN_INPUT_FORMAT, "");
    }

    public static void setPlugInOutputFormat(Configuration configuration, String plugInOutputFormatClass) {
        configuration.set(TDCH_PLUGIN_OUTPUT_FORMAT, plugInOutputFormatClass);
    }

    public static String getPlugInOutputFormat(Configuration configuration) {
        return configuration.get(TDCH_PLUGIN_OUTPUT_FORMAT, "");
    }

    public static void setInputSerDe(Configuration configuration, String sourceSerDeClass) {
        configuration.set(TDCH_INPUT_SERDE, sourceSerDeClass);
    }

    public static String getInputSerDe(Configuration configuration) {
        return configuration.get(TDCH_INPUT_SERDE, "");
    }

    public static void setOutputSerDe(Configuration configuration, String targetSerDeClass) {
        configuration.set(TDCH_OUTPUT_SERDE, targetSerDeClass);
    }

    public static String getOutputSerDe(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_SERDE, "");
    }

    public static void setPlugInInputProcessor(Configuration configuration, String plugInInputProcessorClass) {
        configuration.set(TDCH_PLUGIN_INPUT_PROCESSOR, plugInInputProcessorClass);
    }

    public static String getPlugInInputProcessor(Configuration configuration) {
        return configuration.get(TDCH_PLUGIN_INPUT_PROCESSOR, "");
    }

    public static void setPlugInOutputProcessor(Configuration configuration, String plugInOutputProcessorClass) {
        configuration.set(TDCH_PLUGIN_OUTPUT_PROCESSOR, plugInOutputProcessorClass);
    }

    public static String getPlugInOutputProcessor(Configuration configuration) {
        return configuration.get(TDCH_PLUGIN_OUTPUT_PROCESSOR, "");
    }

    public static void setDataConverter(Configuration configuration, String plugedInDataConverter) {
        configuration.set(TDCH_DATA_CONVERTER, plugedInDataConverter);
    }

    public static String getDataConverter(Configuration configuration) {
        return configuration.get(TDCH_DATA_CONVERTER, "");
    }

    public static void setPluginConf(Configuration configuration, String filePath) {
        configuration.set(TDCH_PLUGIN_CONF_FILE, filePath);
    }

    public static String getPluginConf(Configuration configuration) {
        return configuration.get(TDCH_PLUGIN_CONF_FILE, "");
    }

    public static void setInputSplit(Configuration configuration, String inputClass) {
        configuration.set(TDCH_PLUGIN_INPUT_SPLIT_CLASS, inputClass);
    }

    public static String getInputSplit(Configuration configuration) {
        return configuration.get(TDCH_PLUGIN_INPUT_SPLIT_CLASS, TDCH_DEFAULT_INPUT_SPLIT);
    }

    public static void setJobMapper(Configuration configuration, String jobMapperClass) {
        configuration.set(TDCH_JOB_MAPPER, jobMapperClass);
    }

    public static String getJobMapper(Configuration configuration) {
        return configuration.get(TDCH_JOB_MAPPER, "");
    }

    public static void setJobReducer(Configuration configuration, String jobReducerClass) {
        configuration.set(TDCH_JOB_REDUCER, jobReducerClass);
    }

    public static String getJobReducer(Configuration configuration) {
        return configuration.get(TDCH_JOB_REDUCER, "");
    }

    public static void setUseCombinedInputFormat(Configuration configuration, boolean useCombinedInputFormat) {
        configuration.setBoolean(TDCH_USE_COMBINED_INPUT_FORMAT, useCombinedInputFormat);
    }

    public static boolean getUseCombinedInputFormat(Configuration configuration) {
        return configuration.getBoolean(TDCH_USE_COMBINED_INPUT_FORMAT, true);
    }

    public static void setUsePartitionedOutputFormat(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_USE_PARTITIONED_OUTPUT_FORMAT, value);
    }

    public static boolean getUsePartitionedOutputFormat(Configuration configuration) {
        return configuration.getBoolean(TDCH_USE_PARTITIONED_OUTPUT_FORMAT, false);
    }

    public static void setNumMappers(Configuration configuration, int numMappers) {
        configuration.setInt(TDCH_NUM_MAPPERS, numMappers);
    }

    public static int getNumMappers(Configuration configuration) {
        return configuration.getInt(TDCH_NUM_MAPPERS, 2);
    }

    public static void setCompressionInter(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_INTER_MAP_COMPRESSION, value);
    }

    public static boolean getCompressionInter(Configuration configuration) {
        return configuration.getBoolean(TDCH_INTER_MAP_COMPRESSION, false);
    }

    public static void setEnableHdfsLoggingFlag(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_OUTPUT_LOGGING_FLAG, value);
    }

    public static boolean getEnableHdfsLoggingFlag(Configuration configuration) {
        return configuration.getBoolean(TDCH_OUTPUT_LOGGING_FLAG, false);
    }

    public static void setLogDelimiter(Configuration configuration, String value) {
        configuration.set(TDCH_OUTPUT_LOGGING_DELIMITER, value);
    }

    public static String getLogDelimiter(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_LOGGING_DELIMITER, "|");
    }

    public static void setLogRowsCount(Configuration configuration, int value) {
        configuration.setInt(TDCH_OUTPUT_LOGGING_LIMIT, value);
    }

    public static int getLogRowsCount(Configuration configuration) {
        return configuration.getInt(TDCH_OUTPUT_LOGGING_LIMIT, 100);
    }

    public static void setHdfsLoggingPath(Configuration configuration, String path) {
        configuration.set(TDCH_OUTPUT_LOGGING_PATH, path);
    }

    public static String getHdfsLoggingPath(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_LOGGING_PATH, "");
    }

    public static void setCompressionInterCodec(Configuration configuration, String interCodec) {
        configuration.set(TDCH_INTER_MAP_COMPRESSION_CODEC, interCodec);
    }

    public static String getCompressionInterCodec(Configuration configuration) {
        return configuration.get(TDCH_INTER_MAP_COMPRESSION_CODEC, "NONE");
    }

    public static void setTargetCompression(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_INPUT_COMPRESSION, value);
    }

    public static boolean getTargetCompression(Configuration configuration) {
        return configuration.getBoolean(TDCH_INPUT_COMPRESSION, false);
    }

    public static void setTargetCompressionType(Configuration configuration, String type) {
        configuration.set(TDCH_INPUT_COMPRESSION_TYPE, type);
    }

    public static String getTargetCompressionType(Configuration configuration) {
        return configuration.get(TDCH_INPUT_COMPRESSION_TYPE, "NONE");
    }

    public static void setTargetCompressionCodec(Configuration configuration, String codec) {
        configuration.set(TDCH_INPUT_COMPRESSION_CODEC, codec);
    }

    public static String getTargetCompressionCodec(Configuration configuration) {
        return configuration.get(TDCH_INPUT_COMPRESSION_CODEC, "org.apache.hadoop.io.compress.GzipCodec");
    }

    public static void setThrottleNumMappers(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_THROTTLE_NUM_MAPPERS, value);
    }

    public static boolean getThrottleNumMappers(Configuration configuration) {
        return configuration.getBoolean(TDCH_THROTTLE_NUM_MAPPERS, false);
    }

    public static void setThrottleNumMappersMinMappers(Configuration configuration, int minMappers) {
        configuration.setInt(TDCH_THROTTLE_NUM_MAPPERS_MIN_MAPPERS, minMappers);
    }

    public static int getThrottleNumMappersMinMappers(Configuration configuration) {
        return configuration.getInt(TDCH_THROTTLE_NUM_MAPPERS_MIN_MAPPERS, 0);
    }

    public static void setThrottleNumMappersRetrySeconds(Configuration configuration, int retrySeconds) {
        configuration.setInt(TDCH_THROTTLE_NUM_MAPPERS_RETRY_SECONDS, retrySeconds);
    }

    public static int getThrottleNumMappersRetrySeconds(Configuration configuration) {
        return configuration.getInt(TDCH_THROTTLE_NUM_MAPPERS_RETRY_SECONDS, 5);
    }

    public static void setThrottleNumMappersRetryCount(Configuration configuration, int retryCount) {
        configuration.setInt(TDCH_THROTTLE_NUM_MAPPERS_RETRY_COUNT, retryCount);
    }

    public static int getThrottleNumMappersRetryCount(Configuration configuration) {
        return configuration.getInt(TDCH_THROTTLE_NUM_MAPPERS_RETRY_COUNT, 12);
    }

    public static void setStringTruncate(Configuration configuration, boolean value) {
        configuration.setBoolean(TDCH_STRING_TRUNCATE, value);
    }

    public static boolean getStringTruncate(Configuration configuration) {
        return configuration.getBoolean(TDCH_STRING_TRUNCATE, true);
    }

    public static void setNumReducers(Configuration configuration, int numReducers) {
        configuration.setInt(TDCH_NUM_REDUCERS, numReducers);
    }

    public static int getNumReducers(Configuration configuration) {
        return configuration.getInt(TDCH_NUM_REDUCERS, 0);
    }

    public static void setJobSucceeded(Configuration configuration, boolean jobSucceeded) {
        configuration.setBoolean(TDCH_JOB_SUCCEEDED, jobSucceeded);
    }

    public static boolean getJobSucceeded(Configuration configuration) {
        return configuration.getBoolean(TDCH_JOB_SUCCEEDED, true);
    }

    public static void setOutputPartitionColumnNames(Configuration configuration, String targetPartitionColumnNames) {
        configuration.set(TDCH_OUTPUT_PARTITION_COLUMN_NAMES, targetPartitionColumnNames);
    }

    public static String getOutputPartitionColumnNames(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_PARTITION_COLUMN_NAMES, "");
    }

    public static void setInputConverterRecordSchema(Configuration configuration, String inputRecordSchema) {
        configuration.set(TDCH_INPUT_CONVERTER_RECORD_SCHEMA, inputRecordSchema);
    }

    public static String getInputConverterRecordSchema(Configuration configuration) {
        return configuration.get(TDCH_INPUT_CONVERTER_RECORD_SCHEMA, "");
    }

    public static void setOutputConverterRecordSchema(Configuration configuration, String inputRecordSchema) {
        configuration.set(TDCH_OUTPUT_CONVERTER_RECORD_SCHEMA, inputRecordSchema);
    }

    public static String getOutputConverterRecordSchema(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_CONVERTER_RECORD_SCHEMA, "");
    }

    public static int getDebugOption(Configuration configuration) {
        return configuration.getInt(TDCH_OUTPUT_WRITE_PHASE_CLOSE, 0);
    }

    public static void setDebugOption(Configuration configuration, int debugOption) {
        configuration.setInt(TDCH_OUTPUT_WRITE_PHASE_CLOSE, debugOption);
    }

    public static String getInputDateFormat(Configuration configuration) {
        return configuration.get(TDCH_INPUT_DATE_FORMAT, "");
    }

    public static void setInputDateFormat(Configuration configuration, String inputDateFormat) {
        configuration.set(TDCH_INPUT_DATE_FORMAT, inputDateFormat);
    }

    public static String getOutputDateFormat(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_DATE_FORMAT, "");
    }

    public static void setOutputDateFormat(Configuration configuration, String outputDateFormat) {
        configuration.set(TDCH_OUTPUT_DATE_FORMAT, outputDateFormat);
    }

    public static String getInputTimestampFormat(Configuration configuration) {
        return configuration.get(TDCH_INPUT_TIMESTAMP_FORMAT, "");
    }

    public static void setInputTimestampFormat(Configuration configuration, String inputDateFormat) {
        configuration.set(TDCH_INPUT_TIMESTAMP_FORMAT, inputDateFormat);
    }

    public static String getOutputTimestampFormat(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_TIMESTAMP_FORMAT, "");
    }

    public static void setOutputTimestampFormat(Configuration configuration, String outputDateFormat) {
        configuration.set(TDCH_OUTPUT_TIMESTAMP_FORMAT, outputDateFormat);
    }

    public static String getInputTimeFormat(Configuration configuration) {
        return configuration.get(TDCH_INPUT_TIME_FORMAT, "");
    }

    public static void setInputTimeFormat(Configuration configuration, String inputDateFormat) {
        configuration.set(TDCH_INPUT_TIME_FORMAT, inputDateFormat);
    }

    public static String getOutputTimeFormat(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_TIME_FORMAT, "");
    }

    public static void setOutputTimeFormat(Configuration configuration, String outputDateFormat) {
        configuration.set(TDCH_OUTPUT_TIME_FORMAT, outputDateFormat);
    }

    public static String getInputTimezoneId(Configuration configuration) {
        return configuration.get(TDCH_INPUT_TIMEZONE_ID, "");
    }

    public static void setInputTimezoneId(Configuration configuration, String inputTimezoneId) {
        configuration.set(TDCH_INPUT_TIMEZONE_ID, inputTimezoneId);
    }

    public static String getOutputTimezoneId(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_TIMEZONE_ID, "");
    }

    public static void setOutputTimezoneId(Configuration configuration, String outputTimezoneId) {
        configuration.set(TDCH_OUTPUT_TIMEZONE_ID, outputTimezoneId);
    }

    public static List<String> getAllConfigurationItems(Configuration config, String name) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= 100; ++i) {
            String value = config.get(name + POST_FIX + i, "").trim();
            if (value.isEmpty()) continue;
            list.add(value);
        }
        return list;
    }

    public static enum direction {
        input,
        output;

    }
}

