/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConnectorJobRunner;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorPluginUtils;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.common.utils.HdfsAppender;
import com.teradata.connector.common.utils.StandardCharsets;
import com.teradata.connector.hcat.utils.HCatPlugInConfiguration;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveUtils;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ConnectorImportTool
extends Configured
implements Tool {
    private static Log logger = LogFactory.getLog(ConnectorImportTool.class);
    private String jobType = "hdfs";
    private String method = "split.by.hash";
    private String fileFormat = "textfile";

    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf());
        try {
            if (this.processArgs((JobContext)job, args) < 0) {
                this.printHelp();
                return 0;
            }
        }
        catch (ConnectorException e) {
            this.printHelp();
            throw e;
        }
        return ConnectorJobRunner.runJob(job);
    }

    public void printHelp() {
        System.out.println("hadoop jar teradata-hadoop-connector.jar");
        System.out.println("     com.teradata.connector.common.tool.ConnectorImportTool");
        System.out.println("     [-conf <conf file>] (optional)");
        System.out.println("     [-jobtype <job type>] (values: hdfs, hive, and hcat, default is hdfs)");
        System.out.println("     [-fileformat <file format>] (values: sequencefile, textfile, avrofile, orcfile (or orc), rcfile, and parquet, default is textfile)");
        System.out.println("     [-classname <classname>] (optional)");
        System.out.println("     [-url <url>] (optional)");
        System.out.println("     [-username <username>] (optional)");
        System.out.println("     [-password <password>] (optional)");
        System.out.println("     [-batchsize <batchsize>] (optional, default value is 10000)");
        System.out.println("     [-accesslock <true|false>] (optional, default value is false)");
        System.out.println("     [-queryband <queryband>] (optional)");
        System.out.println("     [-targetpaths <path>] (optional, applicable for hdfs and hive jobs)]");
        System.out.println("     [-sourcetable <tablename>] (optional, use -sourcetable or -sourcequery but not both)");
        System.out.println("     [-sourceconditions <conditions>] (optional, use with -sourcetable option)");
        System.out.println("     [-sourcefieldnames <fieldnames>] (optional, comma delimited format)");
        System.out.println("     [-sourcerecordschema <record schema>] (optional, comma delimited format)");
        System.out.println("     [-targetrecordschema <record schema>] (optional, comma delimited format)");
        System.out.println("     [-sourcequery <query>] (optional, use either -sourcetable or -sourcequery but not both)");
        System.out.println("     [-sourcecountquery <countquery>] (optional, use with -sourcequery option)");
        System.out.println("     [-targetdatabase <database>] (optional)");
        System.out.println("     [-targettable <table>] (optional)");
        System.out.println("     [-targetfieldnames <fields>] (optional, comma separated format");
        System.out.println("     [-targettableschema <schema>] (optional, comma separated format");
        System.out.println("     [-targetpartitionschema <schema>] (optional, comma separated format, used with -targettableschema only");
        System.out.println("     [-separator <separator>] (optional,used to separate fields in text)");
        System.out.println("     [-lineseparator <lineseparator>] (optional, used to separate different lines, only useful for hive and hcat job)");
        System.out.println("     [-enclosedby <enclosed-by-character> (optional, used to enclose text, only useful for hdfs job)]");
        System.out.println("     [-escapedby  <escaped-by-character> (optional, used to escape special characters, only useful for hdfs job)]");
        System.out.println("     [-nullstring <string>] (optional, a string to replace null value of string type)");
        System.out.println("     [-nullnonstring <string>] (optional, a string to replace null value of non-string type, only useful for hdfs job)");
        System.out.println("    [-method <method>] (optional import method, values: internal.fastexport, split.by.partition, split.by.hash, split.by.value and split.by.amp only for Teradata version 14.10.00.02, default is split.by.hash)");
        System.out.println("    [-nummappers <num>] (optional, default is 2)");
        System.out.println("    [-throttlemappers <true> (optional, overwrite nummappers value based on cluster resources)");
        System.out.println("    [-minmappers <num>] (optional, only overwrite nummappers value if/when minmappers are available)");
        System.out.println("    [-splitbycolumn <column name>] (optional for split.by.hash and split.by.value methods)");
        System.out.println("    [-forcestage <true>] (optional force to use stage table, default is false)");
        System.out.println("    [-stagetablename <table name>] (optional)");
        System.out.println("    [-stagedatabase <database>] (optional)");
        System.out.println("    [-numpartitionsinstaging <num>] (optional)");
        System.out.println("    [-fastexportsockethost <host>] (optional)");
        System.out.println("    [-fastexportsocketport <port>] (optional)");
        System.out.println("    [-fastexportsockettimeout <time(ms)>] (optional, default is 8 minutes)");
        System.out.println("    [-hiveconf <target path>] (optional, required for hive and hcat jobs launched on non-name nodes)]");
        System.out.println("    [-usexview <true|false>] (optional, default is true)");
        System.out.println("    [-targetcompression <I|O|B>] (optional, required for hive and hdfs jobs for enabling compression)]");
        System.out.println("    [-targetcompressiontype <BLOCK|RECORD|NONE>] (optional, required for hive and hdfs jobs for types of compression)]");
        System.out.println("    [-targetcompressioncodec <LZO|SNAPPY|BZIP2|GZIP>] (optional, required for hive and hdfs jobs for compression codecs selection)]");
        System.out.println("    [-avroschema <avro schema>] (optional, an inline Avro schema definition)");
        System.out.println("    [-avroschemafile <path>] (optional, a file path for Avro schema definition)");
        System.out.println("    [-debugoption <debug option value>] (optional, a debug option to close some stages of the whole hadoop job)");
        System.out.println("    [-sourcedateformat <date format>] (optional, a default date format for all converters that convert string to date)");
        System.out.println("    [-targetdateformat <date format>] (optional, a default date format for all converters that convert date  to string )");
        System.out.println("    [-sourcetimeformat <time format>] (optional, a default time format for all converters that convert string to time)");
        System.out.println("    [-targettimeformat <time format>] (optional, a default time format for all converters that convert time  to string )");
        System.out.println("    [-sourcetimestampformat <timestamp format>] (optional, a default timestamp format for all converters that convert string to timestamp)");
        System.out.println("    [-targettimestampformat <timestamp format>] (optional, a default timestamp format for all converters that convert timestamp  to string )");
        System.out.println("    [-sourcetimezoneid <timezone id>] (optional, a default input timezone id for all converters that convert timestamp to another timestamp");
        System.out.println("    [-targettimezoneid <timezone id>] (optional, a default output timezone id for all converters that convert timestamp to another timestamp");
        System.out.println("    [-stringtruncate <false>] (optional, do not automatically truncate strings and error)");
        System.out.println("    [-h|help] (optional)");
        System.out.println("");
    }

    private int processArgs(JobContext context, String[] args) throws ConnectorException {
        ArrayList<String> newSchemaList;
        List<String> schemaList;
        ConnectorSchemaParser parser;
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        int length = args.length;
        if (length < 1) {
            throw new ConnectorException(12021);
        }
        for (int i = 0; i < length; ++i) {
            String arg = args[i];
            if (arg == null || arg.isEmpty()) {
                return 0;
            }
            if (arg.charAt(0) != '-') {
                throw new ConnectorException(12001);
            }
            if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("-help")) {
                return -1;
            }
            if (++i < length) {
                String value = args[i];
                if (value == null) {
                    throw new ConnectorException(12001);
                }
                configurationMap.put(arg, value);
                continue;
            }
            throw new ConnectorException(12001);
        }
        Configuration configuration = context.getConfiguration();
        configuration.addResource("teradata-import-properties.xml");
        if (configurationMap.containsKey("-jobtype")) {
            this.jobType = ((String)configurationMap.remove("-jobtype")).toLowerCase();
        }
        if (!(this.jobType.equalsIgnoreCase("hcat") || this.jobType.equalsIgnoreCase("hdfs") || this.jobType.equalsIgnoreCase("hive"))) {
            throw new ConnectorException(12002);
        }
        if (this.jobType.equals("hcat")) {
            logger.warn((Object)"The TDCH hcatalog plugin is deprecated, and will be removed in a future release");
        }
        if (configurationMap.containsKey("-fileformat")) {
            this.fileFormat = ((String)configurationMap.remove("-fileformat")).toLowerCase();
            this.fileFormat = HadoopConfigurationUtils.getAliasFileFormatName(this.fileFormat);
        }
        if (!(this.fileFormat.equalsIgnoreCase("textfile") || this.fileFormat.equalsIgnoreCase("rcfile") || this.fileFormat.equalsIgnoreCase("orcfile") || this.fileFormat.equalsIgnoreCase("sequencefile") || this.fileFormat.equalsIgnoreCase("avrofile") || this.fileFormat.equalsIgnoreCase("parquet"))) {
            throw new ConnectorException(12016);
        }
        if (configurationMap.containsKey("-method")) {
            this.method = ((String)configurationMap.remove("-method")).toLowerCase();
        }
        if (!(this.method.equalsIgnoreCase("split.by.partition") || this.method.equalsIgnoreCase("split.by.hash") || this.method.equalsIgnoreCase("split.by.value") || this.method.equalsIgnoreCase("split.by.amp") || this.method.equalsIgnoreCase("idata.stream") || this.method.equalsIgnoreCase("internal.fastexport"))) {
            throw new ConnectorException(12010);
        }
        if (configurationMap.containsKey("-nummappers")) {
            try {
                int numMappers = Integer.parseInt((String)configurationMap.remove("-nummappers"));
                if (numMappers < 1) {
                    throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", " greater than zero "));
                }
                ConnectorConfiguration.setNumMappers(configuration, numMappers);
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", "integer"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", "integer"), e);
            }
        }
        if (configurationMap.containsKey("-targetcompression")) {
            String targetcompression = ((String)configurationMap.remove("-targetcompression")).toUpperCase();
            if (targetcompression.equals("I")) {
                ConnectorConfiguration.setCompressionInter(configuration, true);
                ConnectorConfiguration.setCompressionInterCodec(configuration, "org.apache.hadoop.io.compress.SnappyCodec");
            } else if (targetcompression.equals("O") || targetcompression.equals("B")) {
                String targetcompressiontype = "";
                String targetcompressioncodec = "";
                String targetoutputcodec = "";
                if (configurationMap.containsKey("-targetcompressiontype")) {
                    targetcompressiontype = ((String)configurationMap.remove("-targetcompressiontype")).toUpperCase();
                }
                if (configurationMap.containsKey("-targetcompressioncodec")) {
                    targetcompressioncodec = ((String)configurationMap.remove("-targetcompressioncodec")).toUpperCase();
                }
                if (targetcompressiontype.equals("") || targetcompressioncodec.equals("")) {
                    throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-targetcompressiontype or -targetcompressioncodec", " is empty "));
                }
                if (targetcompression.equals("B")) {
                    ConnectorConfiguration.setCompressionInter(configuration, true);
                    ConnectorConfiguration.setCompressionInterCodec(configuration, "org.apache.hadoop.io.compress.SnappyCodec");
                }
                ConnectorConfiguration.setTargetCompression(configuration, true);
                ConnectorConfiguration.setTargetCompressionType(configuration, targetcompressiontype);
                if (targetcompressioncodec.equals("SNAPPY")) {
                    targetoutputcodec = "org.apache.hadoop.io.compress.SnappyCodec";
                } else if (targetcompressioncodec.equals("GZIP")) {
                    targetoutputcodec = "org.apache.hadoop.io.compress.GzipCodec";
                } else if (targetcompressioncodec.equals("LZO")) {
                    targetoutputcodec = "com.hadoop.compression.lzo.LzoCodec";
                } else if (targetcompressioncodec.equals("BZIP2")) {
                    targetoutputcodec = "org.apache.hadoop.io.compress.BZip2Codec";
                }
                ConnectorConfiguration.setTargetCompressionCodec(configuration, targetoutputcodec);
            }
        }
        if (configurationMap.containsKey("-throttlemappers")) {
            ConnectorConfiguration.setThrottleNumMappers(configuration, Boolean.parseBoolean((String)configurationMap.remove("-throttlemappers")));
        }
        if (configurationMap.containsKey("-minmappers")) {
            try {
                int minMappers = Integer.parseInt((String)configurationMap.remove("-minmappers"));
                if (minMappers < 1) {
                    throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-minmappers", " greater than zero "));
                }
                ConnectorConfiguration.setThrottleNumMappersMinMappers(configuration, minMappers);
            }
            catch (NumberFormatException e) {
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-minmappers", "integer"), e);
            }
        }
        int numReducers = 0;
        if (configurationMap.containsKey("-numreducers")) {
            try {
                numReducers = Integer.parseInt((String)configurationMap.remove("-numreducers"));
                ConnectorConfiguration.setNumReducers(configuration, numReducers);
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-numreducers", "integer"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-numreducers", "integer"), e);
            }
        }
        if (numReducers != 0) {
            logger.warn((Object)"You are trying calling reducer phase");
        }
        if (configurationMap.containsKey("-hiveconf")) {
            HivePlugInConfiguration.setOutputConfigureFile(configuration, (String)configurationMap.remove("-hiveconf"));
        }
        if (configurationMap.containsKey("-classname")) {
            TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, (String)configurationMap.remove("-classname"));
        }
        if (configurationMap.containsKey("-url")) {
            TeradataPlugInConfiguration.setInputJdbcUrl(configuration, (String)configurationMap.remove("-url"));
        }
        if (configurationMap.containsKey("-username")) {
            TeradataPlugInConfiguration.setInputTeradataUserName(context, ((String)configurationMap.remove("-username")).getBytes(StandardCharsets.UTF_8));
        }
        if (configurationMap.containsKey("-password")) {
            TeradataPlugInConfiguration.setInputTeradataPassword(context, ((String)configurationMap.remove("-password")).getBytes(StandardCharsets.UTF_8));
        }
        if (configurationMap.containsKey("-accesslock")) {
            TeradataPlugInConfiguration.setInputAccessLock(configuration, Boolean.parseBoolean((String)configurationMap.remove("-accesslock")));
        }
        if (configurationMap.containsKey("-queryband")) {
            TeradataPlugInConfiguration.setInputQueryBand(configuration, (String)configurationMap.remove("-queryband"));
        }
        if (configurationMap.containsKey("-sourcetable")) {
            TeradataPlugInConfiguration.setInputTable(configuration, (String)configurationMap.remove("-sourcetable"));
        }
        if (configurationMap.containsKey("-sourceconditions")) {
            TeradataPlugInConfiguration.setInputConditions(configuration, (String)configurationMap.remove("-sourceconditions"));
        }
        String sourceFieldNames = "";
        if (configurationMap.containsKey("-sourcefieldnames")) {
            sourceFieldNames = (String)configurationMap.remove("-sourcefieldnames");
            String[] sourceFieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(sourceFieldNames);
            TeradataPlugInConfiguration.setInputFieldNamesArray(configuration, sourceFieldNamesArray);
        }
        if (configurationMap.containsKey("-sourcequery")) {
            TeradataPlugInConfiguration.setInputQuery(configuration, (String)configurationMap.remove("-sourcequery"));
            logger.warn((Object)("The method will be defaulted to \"split.by.partition\" as \"" + this.method + "\" is not supported for -sourcequery option. Please use -sourcetable option in case you want to specify \"" + this.method + "\" method."));
            this.method = "split.by.partition";
        }
        String outputPluginName = this.jobType.equalsIgnoreCase("hcat") ? this.jobType : this.jobType + "-" + this.fileFormat;
        String inputPluginName = this.method.equalsIgnoreCase("idata.stream") ? this.method : "teradata-" + this.method;
        ConnectorPluginUtils.configConnectorOutputPlugins(configuration, outputPluginName);
        ConnectorPluginUtils.configConnectorInputPlugins(configuration, inputPluginName);
        if (configurationMap.containsKey("-sourcecountquery")) {
            configurationMap.remove("-sourcecountquery");
        }
        if (configurationMap.containsKey("-targetdatabase")) {
            String targetDatabase = (String)configurationMap.remove("-targetdatabase");
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputDatabase(configuration, targetDatabase);
            } else if (this.jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setOutputDatabase(configuration, targetDatabase);
            } else {
                logger.warn((Object)"user provided database for job types excepts Hive and HCat");
            }
        }
        if (configurationMap.containsKey("-targettable")) {
            String targetTable = (String)configurationMap.remove("-targettable");
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputTable(configuration, targetTable);
            } else if (this.jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setOutputTable(configuration, targetTable);
            } else {
                logger.warn((Object)"user provided table for job types excepts Hive and HCat");
            }
        }
        if (configurationMap.containsKey("-targetpaths")) {
            String targetPathString = (String)configurationMap.remove("-targetpaths");
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputPaths(configuration, targetPathString);
            } else if (this.jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputPaths(configuration, targetPathString);
            } else {
                logger.warn((Object)"user provided path for job types excepts Hive and HDFS");
            }
        }
        String targetFieldNames = "";
        if (configurationMap.containsKey("-targetfieldnames")) {
            targetFieldNames = (String)configurationMap.remove("-targetfieldnames");
            String[] targetFieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(targetFieldNames);
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputFieldNamesArray(configuration, targetFieldNamesArray);
            } else if (this.jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputFieldNamesArray(configuration, targetFieldNamesArray);
            } else if (this.jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setOutputFieldNamesArray(configuration, targetFieldNamesArray);
            }
        }
        if (configurationMap.containsKey("-targettableschema")) {
            String targetTableSchema = (String)configurationMap.remove("-targettableschema");
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputTableSchema(configuration, targetTableSchema);
            } else if (this.jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputSchema(configuration, targetTableSchema);
            } else {
                logger.warn((Object)"user provided table schema for job types excepts Hive and HDFS");
            }
        }
        if (configurationMap.containsKey("-separator")) {
            String separator = (String)configurationMap.remove("-separator");
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputSeparator(configuration, separator);
            } else if (this.jobType.equalsIgnoreCase("hdfs") && this.fileFormat.equalsIgnoreCase("textfile")) {
                HdfsPlugInConfiguration.setOutputSeparator(configuration, separator);
            } else {
                logger.warn((Object)"user provided separator for job types excepts Hive and HDFS");
            }
        }
        if (configurationMap.containsKey("-forcestage")) {
            TeradataPlugInConfiguration.setInputStageTableForced(configuration, Boolean.parseBoolean((String)configurationMap.remove("-forcestage")));
        }
        if (configurationMap.containsKey("-stagetablename")) {
            TeradataPlugInConfiguration.setInputStageTableName(configuration, (String)configurationMap.remove("-stagetablename"));
        }
        if (configurationMap.containsKey("-stagedatabase")) {
            TeradataPlugInConfiguration.setInputStageDatabase(configuration, (String)configurationMap.remove("-stagedatabase"));
        }
        if (configurationMap.containsKey("-batchsize")) {
            try {
                TeradataPlugInConfiguration.setInputBatchSize(configuration, Integer.parseInt((String)configurationMap.remove("-batchsize")));
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-batchsize", "integer"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-batchsize", "integer"), e);
            }
        }
        if (configurationMap.containsKey("-splitbycolumn")) {
            TeradataPlugInConfiguration.setInputSplitByColumn(configuration, (String)configurationMap.remove("-splitbycolumn"));
        }
        if (configurationMap.containsKey("-lineseparator")) {
            HivePlugInConfiguration.setOutputLineSeparator(configuration, (String)configurationMap.remove("-lineseparator"));
        }
        if (configurationMap.containsKey("-nullstring")) {
            String nullString = (String)configurationMap.remove("-nullstring");
            if (this.jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputNullString(configuration, nullString);
            } else if (this.jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputNullString(configuration, nullString);
            } else {
                logger.warn((Object)"user provided null string for job types excepts Hive and HDFS");
            }
        }
        if (configurationMap.containsKey("-nullnonstring")) {
            HdfsPlugInConfiguration.setOutputNullNonString(configuration, (String)configurationMap.remove("-nullnonstring"));
        }
        if (configurationMap.containsKey("-escapedby")) {
            HdfsPlugInConfiguration.setOutputEscapedBy(configuration, (String)configurationMap.remove("-escapedby"));
        }
        if (configurationMap.containsKey("-enclosedby")) {
            HdfsPlugInConfiguration.setOutputEnclosedBy(configuration, (String)configurationMap.remove("-enclosedby"));
        }
        if (configurationMap.containsKey("-jobclientoutput")) {
            HdfsAppender.addHDFSAppender((String)configurationMap.remove("-jobclientoutput"));
        }
        if (configurationMap.containsKey("-usexviews")) {
            TeradataPlugInConfiguration.setInputDataDictionaryUseXView(configuration, Boolean.parseBoolean((String)configurationMap.remove("-usexviews")));
        }
        if (configurationMap.containsKey("-avroschema")) {
            HdfsPlugInConfiguration.setOutputAvroSchema(configuration, (String)configurationMap.remove("-avroschema"));
        }
        if (configurationMap.containsKey("-avroschemafile")) {
            HdfsPlugInConfiguration.setOutputAvroSchemaFile(configuration, (String)configurationMap.remove("-avroschemafile"));
        }
        if (configurationMap.containsKey("-numpartitionsinstaging")) {
            try {
                TeradataPlugInConfiguration.setInputNumPartitions(configuration, Integer.parseInt((String)configurationMap.remove("-numpartitionsinstaging")));
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-numpartitionsinstaging", "long"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-numpartitionsinstaging", "long"), e);
            }
        }
        if (configurationMap.containsKey("-fastexportsockethost")) {
            TeradataPlugInConfiguration.setInputFastExportSocketHost(configuration, (String)configurationMap.remove("-fastexportsockethost"));
        }
        if (configurationMap.containsKey("-fastexportsocketport")) {
            try {
                TeradataPlugInConfiguration.setInputFastExportSocketPort(configuration, Integer.parseInt((String)configurationMap.remove("-fastexportsocketport")));
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-fastexportsocketport", "integer"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-fastexportsocketport", "integer"), e);
            }
        }
        if (configurationMap.containsKey("-fastexportsockettimeout")) {
            try {
                TeradataPlugInConfiguration.setInputFastExportSocketTimeout(configuration, Long.parseLong((String)configurationMap.remove("-fastexportsockettimeout")));
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-fastexportsockettimeout", "long"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-fastexportsockettimeout", "long"), e);
            }
        }
        if (configurationMap.containsKey("-targetpartitionschema")) {
            ConnectorConfiguration.setUsePartitionedOutputFormat(configuration, true);
            String targetPartitionSchema = (String)configurationMap.remove("-targetpartitionschema");
            HivePlugInConfiguration.setOutputPartitionSchema(configuration, targetPartitionSchema);
            List<String> targetPartitionList = ConnectorSchemaUtils.parseColumns(targetPartitionSchema);
            List<String> targetPartitonColumnList = ConnectorSchemaUtils.parseColumnNames(targetPartitionList);
            if (!targetFieldNames.isEmpty()) {
                List<String> targetFieldList = ConnectorSchemaUtils.parseColumns(targetFieldNames);
                List<String> targetFieldColumnList = ConnectorSchemaUtils.parseColumnNames(targetFieldList);
                int[] mapping = TeradataSchemaUtils.getColumnMapping(targetFieldColumnList, targetPartitonColumnList.toArray(new String[targetPartitonColumnList.size()]));
                List<String> sourceFieldList = ConnectorSchemaUtils.parseColumns(sourceFieldNames);
                List<String> sourceFieldColumnList = ConnectorSchemaUtils.parseColumnNames(sourceFieldList);
                String[] targetPartitionArray = new String[targetPartitonColumnList.size()];
                for (int index = 0; index < mapping.length; ++index) {
                    targetPartitionArray[index] = sourceFieldColumnList.get(mapping[index]);
                }
                ConnectorConfiguration.setOutputPartitionColumnNames(configuration, ConnectorSchemaUtils.concatFieldNamesArray(targetPartitionArray));
            }
        }
        if (this.jobType.equalsIgnoreCase("hive") && HiveUtils.isHiveOutputTablePartitioned(configuration)) {
            ConnectorConfiguration.setUsePartitionedOutputFormat(configuration, true);
        }
        if (configurationMap.containsKey("-sourcerecordschema")) {
            String sourceRecordSchema = (String)configurationMap.remove("-sourcerecordschema");
            parser = new ConnectorSchemaParser();
            schemaList = parser.tokenize(sourceRecordSchema);
            newSchemaList = new ArrayList<String>();
            for (String schema : schemaList) {
                newSchemaList.add(schema.trim());
            }
            ConnectorRecordSchema recordSchema = new ConnectorRecordSchema(newSchemaList.size());
            int index = 0;
            for (String schema : newSchemaList) {
                recordSchema.setFieldType(index, ConnectorSchemaUtils.lookupDataTypeAndValidate(schema));
                if (ConnectorSchemaUtils.lookupDataTypeAndValidate(schema) == 1883) {
                    int position = schema.indexOf(40);
                    if (position == -1) {
                        throw new ConnectorException(15013);
                    }
                    recordSchema.setDataTypeConverter(index, schema.substring(0, position).trim());
                    String[] parameters = ConnectorSchemaUtils.getUdfParameters(schema);
                    String[] newParameters = new String[parameters.length];
                    int pos = 0;
                    for (String parameter : parameters) {
                        newParameters[pos++] = configuration.get(parameter.trim(), "");
                    }
                    recordSchema.setParameters(index, newParameters);
                }
                ++index;
            }
            ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(recordSchema)));
            logger.info((Object)("source record schema is " + sourceRecordSchema));
        }
        if (configurationMap.containsKey("-targetrecordschema")) {
            String targetRecordSchema = (String)configurationMap.remove("-targetrecordschema");
            parser = new ConnectorSchemaParser();
            schemaList = parser.tokenize(targetRecordSchema);
            newSchemaList = new ArrayList();
            for (String schema : schemaList) {
                newSchemaList.add(schema.trim());
            }
            ConnectorRecordSchema recordschema = new ConnectorRecordSchema(newSchemaList.size());
            int index = 0;
            for (String schema : newSchemaList) {
                recordschema.setFieldType(index, ConnectorSchemaUtils.lookupDataTypeAndValidate(schema));
                if (ConnectorSchemaUtils.lookupDataTypeAndValidate(schema) == 1883) {
                    throw new ConnectorException(14019);
                }
                ++index;
            }
            ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(recordschema)));
            logger.info((Object)("target record schema is " + targetRecordSchema));
        }
        if (configurationMap.containsKey("-debugoption")) {
            int debugOption = Integer.parseInt((String)configurationMap.remove("-debugoption"));
            ConnectorConfiguration.setDebugOption(configuration, debugOption);
        }
        if (configurationMap.containsKey("-sourcedateformat")) {
            ConnectorConfiguration.setInputDateFormat(configuration, (String)configurationMap.remove("-sourcedateformat"));
        }
        if (configurationMap.containsKey("-sourcetimeformat")) {
            ConnectorConfiguration.setInputTimeFormat(configuration, (String)configurationMap.remove("-sourcetimeformat"));
        }
        if (configurationMap.containsKey("-sourcetimestampformat")) {
            ConnectorConfiguration.setInputTimestampFormat(configuration, (String)configurationMap.remove("-sourcetimestampformat"));
        }
        if (configurationMap.containsKey("-targetdateformat")) {
            ConnectorConfiguration.setOutputDateFormat(configuration, (String)configurationMap.remove("-targetdateformat"));
        }
        if (configurationMap.containsKey("-targettimeformat")) {
            ConnectorConfiguration.setOutputTimeFormat(configuration, (String)configurationMap.remove("-targettimeformat"));
        }
        if (configurationMap.containsKey("-targettimestampformat")) {
            ConnectorConfiguration.setOutputTimestampFormat(configuration, (String)configurationMap.remove("-targettimestampformat"));
        }
        if (configurationMap.containsKey("-sourcetimezoneid")) {
            ConnectorConfiguration.setInputTimezoneId(configuration, (String)configurationMap.remove("-sourcetimezoneid"));
        }
        if (configurationMap.containsKey("-targettimezoneid")) {
            ConnectorConfiguration.setOutputTimezoneId(configuration, (String)configurationMap.remove("-targettimezoneid"));
        }
        if (configurationMap.containsKey("-stringtruncate")) {
            ConnectorConfiguration.setStringTruncate(configuration, Boolean.parseBoolean((String)configurationMap.remove("-stringtruncate")));
        }
        if (configurationMap.containsKey("-upt")) {
            TeradataPlugInConfiguration.setUnicodePassthrough(configuration, Boolean.parseBoolean((String)configurationMap.remove("-upt")));
        }
        if (!configurationMap.isEmpty()) {
            String unrecognizedParams = "";
            for (String key : configurationMap.keySet()) {
                unrecognizedParams = unrecognizedParams + key + " ";
            }
            throw new ConnectorException(15008, unrecognizedParams);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int res = 1;
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)("ConnectorImportTool starts at " + start));
            res = ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
            long end = System.currentTimeMillis();
            logger.info((Object)("ConnectorImportTool ends at " + end));
            logger.info((Object)("ConnectorImportTool time is " + (end - start) / 1000L + "s"));
        }
        catch (Throwable e) {
            logger.info((Object)ConnectorStringUtils.getExceptionStack(e));
            res = e instanceof ConnectorException ? ((ConnectorException)e).getCode() : 10000;
        }
        finally {
            logger.info((Object)("job completed with exit code " + res));
            if (res > 255) {
                res /= 1000;
            }
            System.exit(res);
        }
    }
}

