/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConnectorExportTool;
import com.teradata.connector.test.group.SlowTests;
import junit.framework.Assert;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ConnectorExportToolTest {
    final String dbs = System.getProperty("dbs");
    final String databasename = System.getProperty("databasename");
    final String user = System.getProperty("user");
    final String password = System.getProperty("password");

    @Test
    public void testRun() throws Exception {
        String[] args;
        try {
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])new String[0]);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Export tool parameters is not provided"));
        }
        try {
            args = new String[]{"-jobtype", "spark"};
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Export job type is invalid"));
        }
        try {
            args = new String[]{"-fileformat", "newsequence"};
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Export file format is invalid"));
        }
        try {
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])new String[]{"-method", "split.by.nothing"});
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Export method is invalid, should be one of 'batch.insert','fastload','internal.fastload'"));
        }
        try {
            args = new String[]{"-nummappers", "i"};
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("NumberFormatException: For input string: \"i\""));
        }
        try {
            args = new String[]{"-numreducers", "i"};
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("NumberFormatException: For input string: \"i\""));
        }
        try {
            args = new String[]{"-targetfieldcount", "i", "-fastloadsocketport", "i", "-errorlimit", "i", "-batchsize", "i", "-fastloadsockettimeout", "i"};
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("NumberFormatException: For input string: \"i\""));
        }
    }

    @Category(value={SlowTests.class})
    @Test
    public void testRunJob() throws Exception {
        String[] args = new String[]{"-url", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, "-username", this.user, "-password", this.password, "-classname", "com.teradata.jdbc.TeraDriver", "-fileformat", "textfile", "-jobtype", "hdfs", "-targettable", this.databasename + ".export_hdfs_fun1", "-nummappers", "2", "-sourcepaths", "-method", "batch.insert"};
        try {
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])args);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Export tool parameters is invalid"));
        }
        String[] argsUnknown = new String[]{"-url", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, "-username", this.user, "-password", this.password, "-classname", "com.teradata.jdbc.TeraDriver", "-fileformat", "textfile", "-jobtype", "hdfs", "-nummappers", "2", "-sourcepaths", "/", "-method", "batch.insert"};
        try {
            ToolRunner.run((Tool)new ConnectorExportTool(), (String[])argsUnknown);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("Export target table name is not provided"));
        }
        String[] newArgs = new String[]{"-url", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, "-username", this.user, "-password", this.password, "-classname", "com.teradata.jdbc.TeraDriver", "-fileformat", "textfile", "-jobtype", "hdfs", "-targettable", this.databasename + ".export_hdfs_fun1", "-nummappers", "2", "-sourcepaths", "/user/root/export_hdfs_fun1", "-method", "batch.insert", "-lineseparator", "\n", "-targettimeformat", "HH//mm:ss", "-targettimestampformat", "dd/MM/yyyy HH//mm:ss.SSSSSS"};
        try {
            int res = ToolRunner.run((Tool)new ConnectorExportTool(), (String[])newArgs);
            Assert.assertEquals((int)res, (int)0);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Input path does not exist: /user/root/export_hdfs_fun1")) {
                return;
            }
            throw e;
        }
    }
}

