/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tdwallet;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tdwallet.Cleanup;
import com.teradata.connector.common.utils.StandardCharsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.rmi.dgc.VMID;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.tools.ant.util.JavaEnvUtils;

public class WalletCaller {
    private static String myTempDirPathWithSeparator;
    private static final Process process;

    public static final void performSubstitutions(JobContext context) {
        WalletCaller.performSubstitutions(context, myTempDirPathWithSeparator);
    }

    private static final native void performSubstitutions(JobContext var0, String var1);

    private static final Process getCleanupProcess() throws ExceptionInInitializerError {
        try {
            Map.Entry entry3;
            String osNameOtbe;
            block16: {
                Map.Entry entry22;
                block15: {
                    String osNameJava = System.getProperty("os.name");
                    if (null == osNameJava) {
                        throw new ConnectorException(15038);
                    }
                    LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
                    m.put("Linux", "suselinux");
                    m.put("Windows", "nt");
                    m.put("Mac", "macos");
                    m.put("SunOS", "solaris");
                    m.put("Solaris", "solaris");
                    m.put("HP-UX", "hpux");
                    m.put("AIX", "aix");
                    Map javaOtbeOsNameMap = Collections.unmodifiableMap(m);
                    for (Map.Entry entry22 : javaOtbeOsNameMap.entrySet()) {
                        if (!osNameJava.contains((CharSequence)entry22.getKey())) continue;
                        break block15;
                    }
                    throw new ConnectorException(15035, osNameJava);
                }
                osNameOtbe = (String)entry22.getValue();
                String archNameJava = System.getProperty("os.arch");
                if (null == archNameJava) {
                    throw new ConnectorException(15039);
                }
                LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
                m.put("x86", "i386");
                m.put("i386", "i386");
                m.put("i686", "i386");
                m.put("x86_64", "x8664");
                m.put("amd64", "x8664");
                m.put("IA64N", "ia64");
                m.put("RISC", "pa.32");
                m.put("Power", "power.32");
                m.put("ppc", "power.32");
                m.put("sparc", "sparc.32");
                Map javaOtbeArchNameMap = Collections.unmodifiableMap(m);
                for (Map.Entry entry3 : javaOtbeArchNameMap.entrySet()) {
                    if (!archNameJava.contains((CharSequence)entry3.getKey())) continue;
                    break block16;
                }
                throw new ConnectorException(15036, archNameJava);
            }
            String chipNameOtbe = (String)entry3.getValue();
            String libraryName = "WalletCaller-" + osNameOtbe + "-" + chipNameOtbe;
            String walletCallerLibraryName = System.mapLibraryName(libraryName);
            if (null == walletCallerLibraryName) {
                throw new ConnectorException(15042, libraryName);
            }
            InputStream walletStream = WalletCaller.class.getResourceAsStream(walletCallerLibraryName);
            if (null == walletStream) {
                throw new ConnectorException(15037, walletCallerLibraryName);
            }
            String javaExecutable = JavaEnvUtils.getJreExecutable((String)"java");
            if (null == javaExecutable) {
                throw new ConnectorException(15040);
            }
            String fileSeparator = System.getProperty("file.separator");
            if (null == fileSeparator) {
                throw new ConnectorException(15044);
            }
            String pathSeparator = System.getProperty("path.separator");
            if (null == pathSeparator) {
                throw new ConnectorException(15047);
            }
            Class<Cleanup> cleanupClass = Cleanup.class;
            String cleanupResourceName = cleanupClass.getName().replace('.', '/') + ".class";
            URL url = cleanupClass.getClassLoader().getResource(cleanupResourceName);
            String protocol = url.getProtocol();
            String path = url.getPath();
            if (!"file".equals(protocol)) {
                throw new ConnectorException(15041);
            }
            String dir = path.substring(0, path.length() - cleanupResourceName.length());
            String javaClassPath = dir + pathSeparator + dir + "lib" + fileSeparator + "*";
            String javaIoTmpdir = System.getProperty("java.io.tmpdir");
            if (null == javaIoTmpdir) {
                throw new ConnectorException(15043);
            }
            File tempDir = new File(javaIoTmpdir);
            tempDir.mkdirs();
            ProcessBuilder processBuilder = new ProcessBuilder(javaExecutable, "-classpath", javaClassPath, Cleanup.class.getName()).directory(tempDir);
            Process process = processBuilder.start();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(process.getOutputStream());
            VMID vmid = new VMID();
            if (null == vmid) {
                throw new ConnectorException(15045);
            }
            File myTempDir = new File(tempDir.getAbsolutePath() + fileSeparator + "." + new BigInteger(vmid.toString().getBytes(StandardCharsets.UTF_8)).toString(36) + new Object(){}.getClass().getEnclosingClass().getCanonicalName());
            String myTempDirPath = myTempDir.getAbsolutePath();
            objectOutputStream.writeObject(myTempDirPath);
            objectOutputStream.flush();
            if (!myTempDir.mkdirs()) {
                throw new ConnectorException(15046, myTempDirPath);
            }
            myTempDirPathWithSeparator = myTempDirPath + fileSeparator;
            File tempFile = new File(myTempDirPathWithSeparator + walletCallerLibraryName);
            FileOutputStream outputStream = new FileOutputStream(tempFile);
            IOUtils.copy((InputStream)walletStream, (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            ((OutputStream)outputStream).close();
            System.load(tempFile.getAbsolutePath());
            return process;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static {
        process = WalletCaller.getCleanupProcess();
    }
}

