/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.converter;

import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.test.group.SlowTests;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ConnectorDataTypeConverterTest {
    final String dbs = System.getProperty("dbs");
    final String databasename = System.getProperty("databasename");
    final String user = System.getProperty("user");
    final String password = System.getProperty("password");

    @Test
    public void testIntegerToInteger() {
        ConnectorDataTypeConverter.IntegerToInteger converter = new ConnectorDataTypeConverter.IntegerToInteger();
        int input = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerToLong() {
        ConnectorDataTypeConverter.IntegerToLong converter = new ConnectorDataTypeConverter.IntegerToLong();
        int input = 1;
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerToShort() {
        ConnectorDataTypeConverter.IntegerToShort converter = new ConnectorDataTypeConverter.IntegerToShort();
        int input = 1;
        int output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
        input = 1234566;
        try {
            output = ((Short)((ConnectorDataTypeConverter)converter).convert(input)).shortValue();
        }
        catch (NumberFormatException E) {
            output = 12345;
            Assert.assertFalse((input == output ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIntegerToTinyInt() {
        ConnectorDataTypeConverter.IntegerToTinyInt converter = new ConnectorDataTypeConverter.IntegerToTinyInt();
        int input = 1;
        byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerToFloat() {
        ConnectorDataTypeConverter.IntegerToFloat converter = new ConnectorDataTypeConverter.IntegerToFloat();
        int input = 1;
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerToDouble() {
        ConnectorDataTypeConverter.IntegerToDouble converter = new ConnectorDataTypeConverter.IntegerToDouble();
        int input = 1;
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerToBigDecimal() {
        ConnectorDataTypeConverter.IntegerToBigDecimalWithScale converter = new ConnectorDataTypeConverter.IntegerToBigDecimalWithScale();
        converter.setScale(5);
        int input = 1;
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output.scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testIntegerToBoolean() {
        int trueValue = -1;
        int falseValue = 0;
        ConnectorDataTypeConverter.IntegerToBoolean converter = new ConnectorDataTypeConverter.IntegerToBoolean();
        boolean trueBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(trueValue);
        boolean falseBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(falseValue);
        Assert.assertTrue((boolean)trueBool);
        Assert.assertTrue((!falseBool ? 1 : 0) != 0);
    }

    @Test
    public void testIntegerToString() {
        ConnectorDataTypeConverter.IntegerToString converter = new ConnectorDataTypeConverter.IntegerToString();
        Integer input = 1;
        String output = "1";
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(input).toString().equals(output));
    }

    @Test
    public void testLongToInteger() {
        ConnectorDataTypeConverter.LongToInteger converter = new ConnectorDataTypeConverter.LongToInteger();
        long input = 1L;
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
        input = 123456789112L;
        try {
            output = (Integer)((ConnectorDataTypeConverter)converter).convert(input);
        }
        catch (NumberFormatException E) {
            output = 123456789;
            Assert.assertFalse((input == (long)output ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLongToLong() {
        ConnectorDataTypeConverter.LongToLong converter = new ConnectorDataTypeConverter.LongToLong();
        long input = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == 1L ? 1 : 0) != 0);
    }

    @Test
    public void testLongToShort() {
        ConnectorDataTypeConverter.LongToShort converter = new ConnectorDataTypeConverter.LongToShort();
        long input = 1L;
        int output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
        input = 12345667L;
        try {
            output = ((Short)((ConnectorDataTypeConverter)converter).convert(input)).shortValue();
        }
        catch (NumberFormatException E) {
            output = 12345;
            Assert.assertFalse((input == (long)output ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLongToTinyInt() {
        ConnectorDataTypeConverter.LongToTinyInt converter = new ConnectorDataTypeConverter.LongToTinyInt();
        long input = 1L;
        byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testLongToFloat() {
        ConnectorDataTypeConverter.LongToFloat converter = new ConnectorDataTypeConverter.LongToFloat();
        long input = 1L;
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testLongToDouble() {
        ConnectorDataTypeConverter.LongToDouble converter = new ConnectorDataTypeConverter.LongToDouble();
        long input = 1L;
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testLongToBigDecimal() {
        ConnectorDataTypeConverter.LongToBigDecimalWithScale converter = new ConnectorDataTypeConverter.LongToBigDecimalWithScale();
        converter.setScale(5);
        long input = 1L;
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output.scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testLongToDate() {
        ConnectorDataTypeConverter.LongToDateTZ converter = new ConnectorDataTypeConverter.LongToDateTZ("GMT");
        long input = 1L;
        java.sql.Date output = (java.sql.Date)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new java.sql.Date(1L).toString()));
    }

    @Test
    public void testLongToTimestamp() {
    }

    @Test
    public void testLongToBoolean() {
        ConnectorDataTypeConverter.LongToBoolean converter = new ConnectorDataTypeConverter.LongToBoolean();
        long input_one = 1L;
        long input_zero = 0L;
        boolean output_true = true;
        boolean output_false = false;
        Assert.assertTrue(((Boolean)((ConnectorDataTypeConverter)converter).convert(input_one) == output_true ? 1 : 0) != 0);
        Assert.assertTrue(((Boolean)((ConnectorDataTypeConverter)converter).convert(input_zero) == output_false ? 1 : 0) != 0);
    }

    @Test
    public void testLongToString() {
        ConnectorDataTypeConverter.LongToString converter = new ConnectorDataTypeConverter.LongToString();
        long input = 1L;
        String output = "1";
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(input).toString().equals(output));
    }

    @Test
    public void testShortToInteger() {
        ConnectorDataTypeConverter.ShortToInteger converter = new ConnectorDataTypeConverter.ShortToInteger();
        short input = 1;
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testShortToLong() {
        ConnectorDataTypeConverter.ShortToLong converter = new ConnectorDataTypeConverter.ShortToLong();
        short input = 1;
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testShortToShort() {
        ConnectorDataTypeConverter.ShortToShort converter = new ConnectorDataTypeConverter.ShortToShort();
        short input = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testShortToTinyInt() {
        ConnectorDataTypeConverter.ShortToTinyInt converter = new ConnectorDataTypeConverter.ShortToTinyInt();
        short input = 1;
        Byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testShortToFloat() {
        ConnectorDataTypeConverter.ShortToFloat converter = new ConnectorDataTypeConverter.ShortToFloat();
        short input = 1;
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testShortToDouble() {
        ConnectorDataTypeConverter.ShortToDouble converter = new ConnectorDataTypeConverter.ShortToDouble();
        short input = 1;
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testShortToBigDecimal() {
        ConnectorDataTypeConverter.ShortToBigDecimalWithScale converter = new ConnectorDataTypeConverter.ShortToBigDecimalWithScale();
        converter.setScale(5);
        short input = 1;
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output.scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testShortToBoolean() {
        short trueValue = 1;
        short falseValue = 0;
        ConnectorDataTypeConverter.ShortToBoolean converter = new ConnectorDataTypeConverter.ShortToBoolean();
        boolean trueBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(trueValue);
        boolean falseBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(falseValue);
        Assert.assertTrue((boolean)trueBool);
        Assert.assertTrue((!falseBool ? 1 : 0) != 0);
    }

    @Test
    public void testShortToString() {
        ConnectorDataTypeConverter.ShortToString converter = new ConnectorDataTypeConverter.ShortToString();
        short input = 1;
        String output = "1";
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(input).toString().equals(output));
    }

    @Test
    public void testTinyIntToInteger() {
        ConnectorDataTypeConverter.TinyIntToInteger converter = new ConnectorDataTypeConverter.TinyIntToInteger();
        byte input = 1;
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToLong() {
        ConnectorDataTypeConverter.TinyIntToLong converter = new ConnectorDataTypeConverter.TinyIntToLong();
        byte input = 1;
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToShort() {
        ConnectorDataTypeConverter.TinyIntToShort converter = new ConnectorDataTypeConverter.TinyIntToShort();
        byte input = 1;
        short output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToTinyInt() {
        ConnectorDataTypeConverter.TinyIntToTinyInt converter = new ConnectorDataTypeConverter.TinyIntToTinyInt();
        byte input = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToFloat() {
        ConnectorDataTypeConverter.TinyIntToFloat converter = new ConnectorDataTypeConverter.TinyIntToFloat();
        byte input = 1;
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToDouble() {
        ConnectorDataTypeConverter.TinyIntToDouble converter = new ConnectorDataTypeConverter.TinyIntToDouble();
        byte input = 1;
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToBigDecimal() {
        ConnectorDataTypeConverter.TinyIntToBigDecimalWithScale converter = new ConnectorDataTypeConverter.TinyIntToBigDecimalWithScale();
        converter.setScale(5);
        byte input = 1;
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output.scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testTinyIntToBoolean() {
        byte trueValue = 1;
        byte falseValue = 0;
        ConnectorDataTypeConverter.TinyIntToBoolean converter = new ConnectorDataTypeConverter.TinyIntToBoolean();
        boolean trueBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(trueValue);
        boolean falseBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(falseValue);
        Assert.assertTrue((boolean)trueBool);
        Assert.assertTrue((!falseBool ? 1 : 0) != 0);
    }

    @Test
    public void testTinyIntToString() {
        ConnectorDataTypeConverter.TinyIntToString converter = new ConnectorDataTypeConverter.TinyIntToString();
        byte input = 1;
        String output = "1";
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(input).toString().equals(output));
    }

    @Test
    public void testFloatToInteger() {
        ConnectorDataTypeConverter.FloatToInteger converter = new ConnectorDataTypeConverter.FloatToInteger();
        float input = Float.parseFloat("1.0");
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input)) == output ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToLong() {
        ConnectorDataTypeConverter.FloatToLong converter = new ConnectorDataTypeConverter.FloatToLong();
        float input = Float.parseFloat("1.0");
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input)) == output ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToShort() {
        ConnectorDataTypeConverter.FloatToShort converter = new ConnectorDataTypeConverter.FloatToShort();
        float input = Float.parseFloat("1.0");
        short output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input)) == output ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToTinyInt() {
        ConnectorDataTypeConverter.FloatToTinyInt converter = new ConnectorDataTypeConverter.FloatToTinyInt();
        float input = Float.parseFloat("1.0");
        byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input)) == output ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToFloat() {
        ConnectorDataTypeConverter.FloatToFloat converter = new ConnectorDataTypeConverter.FloatToFloat();
        float input = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input))).floatValue() == Float.parseFloat("1.0") ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToDouble() {
        ConnectorDataTypeConverter.FloatToDouble converter = new ConnectorDataTypeConverter.FloatToDouble();
        float input = Float.parseFloat("1.0");
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input)) == output ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToBigDecimal() {
        ConnectorDataTypeConverter.FloatToBigDecimalWithScale converter = new ConnectorDataTypeConverter.FloatToBigDecimalWithScale();
        converter.setScale(5);
        float input = Float.parseFloat("1.0");
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input));
        Assert.assertTrue((output.scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testFloatToBoolean() {
        float trueValue = Float.parseFloat("1.0");
        float falseValue = Float.parseFloat("0.0");
        ConnectorDataTypeConverter.FloatToBoolean converter = new ConnectorDataTypeConverter.FloatToBoolean();
        boolean trueBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(trueValue));
        boolean falseBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(falseValue));
        Assert.assertTrue((boolean)trueBool);
        Assert.assertTrue((!falseBool ? 1 : 0) != 0);
    }

    @Test
    public void testFloatToString() {
        ConnectorDataTypeConverter.FloatToString converter = new ConnectorDataTypeConverter.FloatToString();
        float input = Float.parseFloat("1.0");
        String output = "1.0";
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(Float.valueOf(input)).toString().equals(output));
    }

    @Test
    public void testDoubleToInteger() {
        ConnectorDataTypeConverter.DoubleToInteger converter = new ConnectorDataTypeConverter.DoubleToInteger();
        double input = 1.0;
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToLong() {
        ConnectorDataTypeConverter.DoubleToLong converter = new ConnectorDataTypeConverter.DoubleToLong();
        double input = 1.0;
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToShort() {
        ConnectorDataTypeConverter.DoubleToShort converter = new ConnectorDataTypeConverter.DoubleToShort();
        double input = 1.0;
        short output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToTinyInt() {
        ConnectorDataTypeConverter.DoubleToTinyInt converter = new ConnectorDataTypeConverter.DoubleToTinyInt();
        double input = 1.0;
        byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToFloat() {
        ConnectorDataTypeConverter.DoubleToFloat converter = new ConnectorDataTypeConverter.DoubleToFloat();
        double input = 1.0;
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToDouble() {
        ConnectorDataTypeConverter.DoubleToDouble converter = new ConnectorDataTypeConverter.DoubleToDouble();
        double input = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToBigDecimal() {
        ConnectorDataTypeConverter.DoubleToBigDecimalWithScale converter = new ConnectorDataTypeConverter.DoubleToBigDecimalWithScale();
        converter.setScale(5);
        double input = 1.0;
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output.scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testDoubleToBoolean() {
        double trueValue = 1.0;
        double falseValue = 0.0;
        ConnectorDataTypeConverter.DoubleToBoolean converter = new ConnectorDataTypeConverter.DoubleToBoolean();
        boolean trueBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(trueValue);
        boolean falseBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(falseValue);
        Assert.assertTrue((boolean)trueBool);
        Assert.assertTrue((!falseBool ? 1 : 0) != 0);
    }

    @Test
    public void testDoubleToString() {
        ConnectorDataTypeConverter.DoubleToString converter = new ConnectorDataTypeConverter.DoubleToString();
        double input = 1.0;
        String output = "1.0";
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(input).toString().equals(output));
    }

    @Test
    public void testBigDecimalToInteger() {
        ConnectorDataTypeConverter.BigDecimalToInteger converter = new ConnectorDataTypeConverter.BigDecimalToInteger();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToLong() {
        ConnectorDataTypeConverter.BigDecimalToLong converter = new ConnectorDataTypeConverter.BigDecimalToLong();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToShort() {
        ConnectorDataTypeConverter.BigDecimalToShort converter = new ConnectorDataTypeConverter.BigDecimalToShort();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        short output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToTinyInt() {
        ConnectorDataTypeConverter.BigDecimalToTinyInt converter = new ConnectorDataTypeConverter.BigDecimalToTinyInt();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToFloat() {
        ConnectorDataTypeConverter.BigDecimalToFloat converter = new ConnectorDataTypeConverter.BigDecimalToFloat();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToDouble() {
        ConnectorDataTypeConverter.BigDecimalToDouble converter = new ConnectorDataTypeConverter.BigDecimalToDouble();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToBigDecimal() {
        ConnectorDataTypeConverter.BigDecimalToBigDecimalWithScale converter = new ConnectorDataTypeConverter.BigDecimalToBigDecimalWithScale();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        Assert.assertTrue((boolean)((BigDecimal)((ConnectorDataTypeConverter)converter).convert(input)).setScale(5).equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testBigDecimalToBoolean() {
        ConnectorDataTypeConverter.BigDecimalToBoolean converter = new ConnectorDataTypeConverter.BigDecimalToBoolean();
        boolean trueBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(new BigDecimal(1).setScale(5));
        boolean falseBool = (Boolean)((ConnectorDataTypeConverter)converter).convert(new BigDecimal(0).setScale(5));
        Assert.assertTrue((boolean)trueBool);
        Assert.assertTrue((!falseBool ? 1 : 0) != 0);
    }

    @Test
    public void testBigDecimalToString() {
        ConnectorDataTypeConverter.BigDecimalToString converter = new ConnectorDataTypeConverter.BigDecimalToString();
        BigDecimal input = new BigDecimal(1);
        input.setScale(5);
        String output = "1";
        Assert.assertTrue((boolean)((String)((ConnectorDataTypeConverter)converter).convert(input)).equals(output));
    }

    @Test
    public void testBooleanToInteger() {
        ConnectorDataTypeConverter.BooleanToInteger converter = new ConnectorDataTypeConverter.BooleanToInteger();
        int defaultvalue = 1;
        int falsedefaultvalue = 0;
        converter.setDefaultValue(defaultvalue);
        converter.setFalseDefaultValue(falsedefaultvalue);
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(truevalue) == 1 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(falsevalue) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToLong() {
        ConnectorDataTypeConverter.BooleanToLong converter = new ConnectorDataTypeConverter.BooleanToLong();
        long defaultvalue = 1L;
        long falsedefaultvalue = 0L;
        converter.setDefaultValue(defaultvalue);
        converter.setFalseDefaultValue(falsedefaultvalue);
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(truevalue) == defaultvalue ? 1 : 0) != 0);
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(falsevalue) == falsedefaultvalue ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToShort() {
        ConnectorDataTypeConverter.BooleanToShort converter = new ConnectorDataTypeConverter.BooleanToShort();
        short defaultvalue = 1;
        short falsedefaultvalue = 0;
        converter.setDefaultValue(defaultvalue);
        converter.setFalseDefaultValue(falsedefaultvalue);
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(truevalue) == defaultvalue ? 1 : 0) != 0);
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(falsevalue) == falsedefaultvalue ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToTinyInt() {
        ConnectorDataTypeConverter.BooleanToTinyInt converter = new ConnectorDataTypeConverter.BooleanToTinyInt();
        byte defaultvalue = 1;
        byte falsedefaultvalue = 0;
        converter.setDefaultValue(defaultvalue);
        converter.setFalseDefaultValue(falsedefaultvalue);
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(truevalue) == defaultvalue ? 1 : 0) != 0);
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(falsevalue) == falsedefaultvalue ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToFloat() {
        ConnectorDataTypeConverter.BooleanToFloat converter = new ConnectorDataTypeConverter.BooleanToFloat();
        float defaultvalue = Float.parseFloat("1.0");
        float falsedefaultvalue = Float.parseFloat("0.0");
        converter.setDefaultValue(Float.valueOf(defaultvalue));
        converter.setFalseDefaultValue(Float.valueOf(falsedefaultvalue));
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(truevalue)).floatValue() == defaultvalue ? 1 : 0) != 0);
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(falsevalue)).floatValue() == falsedefaultvalue ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToDouble() {
        ConnectorDataTypeConverter.BooleanToDouble converter = new ConnectorDataTypeConverter.BooleanToDouble();
        double defaultvalue = 1.0;
        double falsedefaultvalue = 0.0;
        converter.setDefaultValue(defaultvalue);
        converter.setFalseDefaultValue(falsedefaultvalue);
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(truevalue) == defaultvalue ? 1 : 0) != 0);
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(falsevalue) == falsedefaultvalue ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToBigDecimal() {
        ConnectorDataTypeConverter.BooleanToBigDecimalWithScale converter = new ConnectorDataTypeConverter.BooleanToBigDecimalWithScale();
        BigDecimal defaultvalue = new BigDecimal(1);
        defaultvalue.setScale(5);
        BigDecimal falsedefaultvalue = new BigDecimal(0);
        falsedefaultvalue.setScale(5);
        converter.setDefaultValue(defaultvalue);
        converter.setFalseDefaultValue(falsedefaultvalue);
        converter.setScale(5);
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue((boolean)((BigDecimal)((ConnectorDataTypeConverter)converter).convert(truevalue)).equals(new BigDecimal(1).setScale(5)));
        Assert.assertTrue((boolean)((BigDecimal)((ConnectorDataTypeConverter)converter).convert(falsevalue)).equals(new BigDecimal(0).setScale(5)));
    }

    @Test
    public void testBooleanToBoolean() {
        ConnectorDataTypeConverter.BooleanToBoolean converter = new ConnectorDataTypeConverter.BooleanToBoolean();
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue((boolean)((Boolean)((ConnectorDataTypeConverter)converter).convert(truevalue)));
        Assert.assertTrue(((Boolean)((ConnectorDataTypeConverter)converter).convert(falsevalue) == false ? 1 : 0) != 0);
    }

    @Test
    public void testBooleanToString() {
        ConnectorDataTypeConverter.BooleanToString converter = new ConnectorDataTypeConverter.BooleanToString();
        boolean truevalue = true;
        boolean falsevalue = false;
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(truevalue).toString().equals("true"));
        Assert.assertTrue((boolean)((ConnectorDataTypeConverter)converter).convert(falsevalue).toString().equals("false"));
    }

    @Test
    public void testStringToInteger() {
        ConnectorDataTypeConverter.StringToInteger converter = new ConnectorDataTypeConverter.StringToInteger();
        String input = "1";
        int output = 1;
        Assert.assertTrue(((Integer)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testStringToLong() {
        ConnectorDataTypeConverter.StringToLong converter = new ConnectorDataTypeConverter.StringToLong();
        String input = "1";
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testStringToShort() {
        ConnectorDataTypeConverter.StringToShort converter = new ConnectorDataTypeConverter.StringToShort();
        String input = "1";
        short output = 1;
        Assert.assertTrue(((Short)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testStringToTinyInt() {
        ConnectorDataTypeConverter.StringToTinyInt converter = new ConnectorDataTypeConverter.StringToTinyInt();
        String input = "1";
        byte output = 1;
        Assert.assertTrue(((Byte)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testStringToFloat() {
        ConnectorDataTypeConverter.StringToFloat converter = new ConnectorDataTypeConverter.StringToFloat();
        String input = "1.0";
        float output = Float.parseFloat("1.0");
        Assert.assertTrue((((Float)((ConnectorDataTypeConverter)converter).convert(input)).floatValue() == output ? 1 : 0) != 0);
    }

    @Test
    public void testStringToDouble() {
        ConnectorDataTypeConverter.StringToDouble converter = new ConnectorDataTypeConverter.StringToDouble();
        String input = "1.0";
        double output = 1.0;
        Assert.assertTrue(((Double)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testStringToBigDecimal() {
        ConnectorDataTypeConverter.StringToBigDecimalWithScale converter = new ConnectorDataTypeConverter.StringToBigDecimalWithScale();
        converter.setScale(5);
        String input = "1";
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((((BigDecimal)((ConnectorDataTypeConverter)converter).convert(input)).scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
    }

    @Test
    public void testStringToBigDecimalUnbounded() {
        ConnectorDataTypeConverter.StringToBigDecimalUnbounded converter = new ConnectorDataTypeConverter.StringToBigDecimalUnbounded();
        converter.setScale(5);
        String input = "1";
        BigDecimal output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((((BigDecimal)((ConnectorDataTypeConverter)converter).convert(input)).scale() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal(1).setScale(5)));
        converter.setScale(0);
        converter.setPrecision(40);
        converter.setLength(47);
        input = "15553.6789236772";
        output = (BigDecimal)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((((BigDecimal)((ConnectorDataTypeConverter)converter).convert(input)).scale() == 10 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)output.equals(new BigDecimal("15553.6789236772").setScale(10)));
    }

    @Test
    public void testStringToBoolean() {
        ConnectorDataTypeConverter.StringToBoolean converter = new ConnectorDataTypeConverter.StringToBoolean();
        String inputTrue = "true";
        String inputFalse = "false";
        Assert.assertTrue((boolean)((Boolean)((ConnectorDataTypeConverter)converter).convert(inputTrue)));
        Assert.assertTrue(((Boolean)((ConnectorDataTypeConverter)converter).convert(inputFalse) == false ? 1 : 0) != 0);
    }

    @Test
    public void testStringToString() {
        String input = "12345";
        ConnectorDataTypeConverter.StringToString converter = new ConnectorDataTypeConverter.StringToString();
        converter.setLength(4);
        Assert.assertTrue((boolean)converter.convert(input).toString().equals("1234"));
        boolean exceptionThrown = false;
        try {
            converter.setTruncate(false);
            String string = converter.convert(input).toString();
        }
        catch (RuntimeException e) {
            exceptionThrown = true;
            Assert.assertTrue((boolean)e.getMessage().equals("String would be truncated"));
        }
        Assert.assertTrue((exceptionThrown ? 1 : 0) != 0);
        ConnectorDataTypeConverter.StringToString converter2 = new ConnectorDataTypeConverter.StringToString(true, 4);
        Assert.assertTrue((boolean)converter2.convert(input).toString().equals("1234"));
        converter2.setLength(0);
        Assert.assertTrue((boolean)converter2.convert(input).toString().equals("12345"));
        converter2.setLength(-1);
        Assert.assertTrue((boolean)converter2.convert(input).toString().equals("12345"));
    }

    @Test
    public void testStringToDate() {
        ConnectorDataTypeConverter.StringToDate converter = new ConnectorDataTypeConverter.StringToDate();
        String input = "2014-01-22";
        java.sql.Date output = (java.sql.Date)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new java.sql.Date(114, 0, 22).toString()));
    }

    @Test
    public void testStringToDateWithFormat() {
        ConnectorDataTypeConverter.StringToDateWithFormat converter = new ConnectorDataTypeConverter.StringToDateWithFormat("yyyy/MM/dd");
        String input = "2014/01/22";
        java.sql.Date output = (java.sql.Date)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new java.sql.Date(114, 0, 22).toString()));
    }

    @Test
    public void testStringToTime() {
        ConnectorDataTypeConverter.StringToTime converter = new ConnectorDataTypeConverter.StringToTime();
        String input = "14:39:40";
        Time output = (Time)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new Time(14, 39, 40).toString()));
    }

    @Test
    public void testStringToTimeWithFormat() {
        ConnectorDataTypeConverter.StringToTimeWithFormat converter = new ConnectorDataTypeConverter.StringToTimeWithFormat("HH//mm:ss");
        String input = "14//39:40";
        Time output = (Time)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new Time(14, 39, 40).toString()));
    }

    @Test
    public void testStringToTimestamp() {
        ConnectorDataTypeConverter.StringToTimestamp converter = new ConnectorDataTypeConverter.StringToTimestamp();
        String input = "2014-01-22 14:39:40.000003";
        Timestamp output = (Timestamp)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new Timestamp(114, 0, 22, 14, 39, 40, 3000).toString()));
    }

    @Test
    public void testStringToTimestampWithFormat() {
        ConnectorDataTypeConverter.StringToTimestampWithFormat converter = new ConnectorDataTypeConverter.StringToTimestampWithFormat("yyyy/MM/dd HH//mm:ss.SSS");
        String input = "2014/01/22 14//39:40.123";
        Timestamp output = (Timestamp)((ConnectorDataTypeConverter)converter).convert(input);
        Timestamp compareTimestamp = new Timestamp(114, 0, 22, 14, 39, 40, 123000000);
        Assert.assertTrue((boolean)compareTimestamp.equals(output));
    }

    @Test
    public void testStringToBinary() {
        ConnectorDataTypeConverter.StringToBinary converter = new ConnectorDataTypeConverter.StringToBinary();
        String input = "1";
        byte[] output = new byte[input.length()];
        output = (byte[])((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output[0] == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStringToPeriod() throws SQLException, ClassNotFoundException {
        ConnectorDataTypeConverter.StringToPeriod converter = new ConnectorDataTypeConverter.StringToPeriod();
        String input = "(2013-12-18, 2013-12-19)";
        Object output = ((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(input));
    }

    @Test
    public void testStringToInterval() {
        ConnectorDataTypeConverter.StringToInterval converter = new ConnectorDataTypeConverter.StringToInterval();
        String input = "1";
        Object output = ((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(input));
    }

    @Category(value={SlowTests.class})
    @Test
    public void testPeriodToString() throws ClassNotFoundException, SQLException {
        ConnectorDataTypeConverter.PeriodToString converter = new ConnectorDataTypeConverter.PeriodToString();
        TeradataConnection conn = new TeradataConnection("com.teradata.jdbc.TeraDriver", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, this.user, this.password, false);
        conn.connect();
        PreparedStatement query = conn.getConnection().prepareStatement("select f16 from TD_ALL_DATATYPE_small");
        ResultSet result = query.executeQuery();
        if (result.next()) {
            Struct input = (Struct)result.getObject(1);
            String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
            Assert.assertTrue((boolean)output.equals("(2013-12-18, 2013-12-19)"));
        }
        conn.close();
    }

    @Category(value={SlowTests.class})
    @Test
    public void testIntervalToString() throws SQLException, ClassNotFoundException {
        ConnectorDataTypeConverter.IntervalToString converter = new ConnectorDataTypeConverter.IntervalToString();
        TeradataConnection conn = new TeradataConnection("com.teradata.jdbc.TeraDriver", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, this.user, this.password, false);
        conn.connect();
        PreparedStatement query = conn.getConnection().prepareStatement("select f19 from TD_ALL_DATATYPE_small");
        ResultSet result = query.executeQuery();
        if (result.next()) {
            Object input = result.getObject(1);
            String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
            Assert.assertTrue((boolean)output.equals("    1"));
        }
        conn.close();
    }

    @Category(value={SlowTests.class})
    @Test
    public void testClobToString() throws ClassNotFoundException, SQLException {
        ConnectorDataTypeConverter.ClobToString converter = new ConnectorDataTypeConverter.ClobToString();
        TeradataConnection conn = new TeradataConnection("com.teradata.jdbc.TeraDriver", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, this.user, this.password, false);
        conn.connect();
        PreparedStatement query = conn.getConnection().prepareStatement("select f3 from TD_ALL_DATATYPE_other");
        ResultSet result = query.executeQuery();
        if (result.next()) {
            Clob input = result.getClob("f3");
            String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
            Assert.assertTrue((boolean)output.equals("c:/noven/Clob.txt"));
        }
        conn.close();
    }

    @Category(value={SlowTests.class})
    @Test
    public void testBlobToBinary() throws ClassNotFoundException, SQLException {
        ConnectorDataTypeConverter.BlobToBinary converter = new ConnectorDataTypeConverter.BlobToBinary();
        TeradataConnection conn = new TeradataConnection("com.teradata.jdbc.TeraDriver", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, this.user, this.password, false);
        conn.connect();
        PreparedStatement query = conn.getConnection().prepareStatement("select f2 from TD_ALL_DATATYPE_other");
        ResultSet result = query.executeQuery();
        if (result.next()) {
            Blob input = result.getBlob("f2");
            byte[] output = (byte[])((ConnectorDataTypeConverter)converter).convert(input);
            Assert.assertTrue((output[0] == 0 ? 1 : 0) != 0);
            Assert.assertTrue((output[1] == 17 ? 1 : 0) != 0);
            Assert.assertTrue((output[2] == 16 ? 1 : 0) != 0);
        }
        conn.close();
    }

    @Category(value={SlowTests.class})
    @Test
    public void testBlobToString() throws ClassNotFoundException, SQLException {
        ConnectorDataTypeConverter.BlobToString converter = new ConnectorDataTypeConverter.BlobToString();
        TeradataConnection conn = new TeradataConnection("com.teradata.jdbc.TeraDriver", "jdbc:teradata://" + this.dbs + "/database=" + this.databasename, this.user, this.password, false);
        conn.connect();
        PreparedStatement query = conn.getConnection().prepareStatement("select f2 from TD_ALL_DATATYPE_other");
        ResultSet result = query.executeQuery();
        if (result.next()) {
            Blob input = result.getBlob("f2");
            String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
            Assert.assertTrue((boolean)output.equals("001110"));
        }
        conn.close();
    }

    @Test
    public void testDateToDate() {
        ConnectorDataTypeConverter.DateToDate converter = new ConnectorDataTypeConverter.DateToDate();
        java.sql.Date input = new java.sql.Date(114, 0, 22);
        java.sql.Date output = (java.sql.Date)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new java.sql.Date(114, 0, 22).toString()));
    }

    @Test
    public void testDateToLong() {
        ConnectorDataTypeConverter.DateToLong converter = new ConnectorDataTypeConverter.DateToLong();
        java.sql.Date input = new java.sql.Date(1L);
        long output = 1L;
        Assert.assertTrue(((Long)((ConnectorDataTypeConverter)converter).convert(input) == output ? 1 : 0) != 0);
    }

    @Test
    public void testDateToTimestamp() {
        ConnectorDataTypeConverter.DateToTimestamp converter = new ConnectorDataTypeConverter.DateToTimestamp();
        java.sql.Date input = new java.sql.Date(114, 0, 22);
        Timestamp output = (Timestamp)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new Timestamp(114, 0, 22, 0, 0, 0, 0).toString()));
    }

    @Test
    public void testDateToString() {
        ConnectorDataTypeConverter.DateToString converter = new ConnectorDataTypeConverter.DateToString();
        java.sql.Date input = new java.sql.Date(114, 0, 22);
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)input.toString().equals(output));
    }

    @Test
    public void testTimeToTime() {
        ConnectorDataTypeConverter.TimeToTime converter = new ConnectorDataTypeConverter.TimeToTime();
        Time input = new Time(14, 39, 40);
        Time output = (Time)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(input.toString()));
    }

    @Test
    public void testTimeToTimeWithTimeZone() {
        ConnectorDataTypeConverter.TimeToTimeWithTimeZone converter = new ConnectorDataTypeConverter.TimeToTimeWithTimeZone("0");
        Time input = new Time(14, 39, 40);
        Time output = (Time)((ConnectorDataTypeConverter)converter).convert(input);
        long diff = TimeZone.getDefault().getRawOffset();
        if (TimeZone.getDefault().inDaylightTime(new Date(1000L * output.getTime())) || TimeZone.getDefault().inDaylightTime(new Date(1000L * input.getTime()))) {
            diff += 3600000L;
        }
        Assert.assertTrue((output.getTime() - input.getTime() == diff ? 1 : 0) != 0);
    }

    @Test
    public void testTimeToString() {
        ConnectorDataTypeConverter.TimeToString converter = new ConnectorDataTypeConverter.TimeToString();
        Time input = new Time(14, 39, 40);
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals("14:39:40"));
    }

    @Test
    public void testTimeToStringWithFormat() {
        ConnectorDataTypeConverter.TimeToStringWithFormat converter = new ConnectorDataTypeConverter.TimeToStringWithFormat("HH/mm:ss");
        Time input = new Time(14, 39, 40);
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals("14/39:40"));
    }

    @Test
    public void testTimestampToLong() {
        ConnectorDataTypeConverter.TimestampToLong converter = new ConnectorDataTypeConverter.TimestampToLong();
        Timestamp input = new Timestamp(114, 0, 22, 14, 39, 40, 3000);
        Long output = (Long)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((input.getTime() == output.longValue() ? 1 : 0) != 0);
    }

    @Test
    public void testTimeStampToDate() {
        ConnectorDataTypeConverter.TimestampToDate converter = new ConnectorDataTypeConverter.TimestampToDate();
        Timestamp input = new Timestamp(114, 0, 22, 14, 39, 40, 3000);
        java.sql.Date output = (java.sql.Date)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new java.sql.Date(114, 0, 22).toString()));
    }

    @Test
    public void testTimeStampToTime() {
        ConnectorDataTypeConverter.TimestampToTime converter = new ConnectorDataTypeConverter.TimestampToTime();
        Timestamp input = new Timestamp(114, 0, 22, 14, 7, 0, 3000);
        Time output = (Time)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.toString().equals(new Time(14, 7, 0).toString()));
    }

    @Test
    public void testTimestampToTimestamp() {
        ConnectorDataTypeConverter.TimestampToTimestamp converter = new ConnectorDataTypeConverter.TimestampToTimestamp();
        Timestamp input = new Timestamp(114, 0, 22, 14, 39, 40, 3000);
        Timestamp output = (Timestamp)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)input.equals(output));
    }

    @Test
    public void testTimestampToTimestampWithTimeZone() {
        ConnectorDataTypeConverter.TimestampToTimestampTZ converter = new ConnectorDataTypeConverter.TimestampToTimestampTZ("0");
        Timestamp input = new Timestamp(114, 0, 22, 14, 39, 40, 3000);
        Timestamp output = (Timestamp)((ConnectorDataTypeConverter)converter).convert(input);
        long diff = TimeZone.getDefault().getRawOffset();
        if (TimeZone.getDefault().inDaylightTime(new Date(1000L * output.getTime())) || TimeZone.getDefault().inDaylightTime(new Date(1000L * input.getTime()))) {
            diff += 3600000L;
        }
        Assert.assertTrue((output.getTime() - input.getTime() == diff ? 1 : 0) != 0);
    }

    @Test
    public void testTimeStampToString() {
        ConnectorDataTypeConverter.TimestampToString converter = new ConnectorDataTypeConverter.TimestampToString();
        Timestamp input = new Timestamp(114, 0, 22, 14, 39, 40, 3000);
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals("2014-01-22 14:39:40.000003"));
    }

    @Test
    public void testTimestampToStringWithFormat() {
        ConnectorDataTypeConverter.TimestampToStringWithFormat converter = new ConnectorDataTypeConverter.TimestampToStringWithFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Timestamp input = new Timestamp(114, 0, 22, 14, 39, 40, 3000000);
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals("2014/01/22 14:39:40.003"));
    }

    @Test
    public void testBinaryToBinary() {
        ConnectorDataTypeConverter.BinaryToBinary converter = new ConnectorDataTypeConverter.BinaryToBinary();
        byte[] input = new byte[]{1};
        byte[] output = new byte[1];
        output = (byte[])((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((output[0] == input[0] ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryToString() {
        ConnectorDataTypeConverter.BinaryToString converter = new ConnectorDataTypeConverter.BinaryToString();
        byte[] input = new byte[]{1};
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals("01"));
    }

    @Test
    public void testObjectToString() {
        ConnectorDataTypeConverter.ObjectToString converter = new ConnectorDataTypeConverter.ObjectToString();
        Object input = new Object();
        input = 1;
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals(input.toString()));
    }

    @Test
    public void testObjectToJsonString() {
        ConnectorDataTypeConverter.ObjectToJsonString converter = new ConnectorDataTypeConverter.ObjectToJsonString();
        Object input = new Object();
        input = 1;
        String output = (String)((ConnectorDataTypeConverter)converter).convert(input);
        Assert.assertTrue((boolean)output.equals(input.toString()));
    }
}

