/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorPartitionedRecordWriter;
import com.teradata.connector.common.ConnectorPartitionedWritable;
import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.converter.ConnectorConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorMapredUtils;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class DummyRecordWriter<K, V>
extends RecordWriter<ConnectorRecord, Writable> {
    private Log logger = LogFactory.getLog(ConnectorPartitionedRecordWriter.class);
    protected long startTimestamp = 0L;
    private TaskAttemptContext context;
    protected ConnectorSerDe targetSerDe = null;
    protected ConnectorConverter dataConverter = null;
    private Map<String, RecordWriter> baseRecordWriters;
    private Map<String, OutputFormat> baseOutputFormats;
    private Map<String, TaskAttemptContext> taskContexts;
    private Configuration configuration;
    private long end_timestamp = 0L;
    private long start_timestamp = System.currentTimeMillis();

    public DummyRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        this.logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
        this.context = context;
        this.configuration = context.getConfiguration();
        this.baseOutputFormats = new HashMap<String, OutputFormat>();
        this.baseRecordWriters = new HashMap<String, RecordWriter>();
        this.taskContexts = new HashMap<String, TaskAttemptContext>();
        try {
            this.targetSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getOutputSerDe(this.configuration)).newInstance();
            this.targetSerDe.initialize((JobContext)context, ConnectorConfiguration.direction.output);
            String converterClass = ConnectorConfiguration.getDataConverter(this.configuration);
            if (!converterClass.isEmpty()) {
                this.dataConverter = (ConnectorConverter)Class.forName(ConnectorConfiguration.getDataConverter(this.configuration)).newInstance();
                this.dataConverter.initialize((JobContext)context);
                this.dataConverter.lookupConverter(this.getSourceConnectorRecordSchema(this.configuration));
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected ConnectorRecordSchema getSourceConnectorRecordSchema(Configuration configuration) {
        ConnectorRecordSchema schema = null;
        try {
            schema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration));
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        return schema;
    }

    public void write(ConnectorRecord key, Writable value) throws IOException, InterruptedException {
        ConnectorPartitionedWritable partWritable;
        if (this.dataConverter != null) {
            ConnectorRecord targetConnectorRecord = null;
            targetConnectorRecord = this.dataConverter.convert(key);
            partWritable = (ConnectorPartitionedWritable)this.targetSerDe.serialize(targetConnectorRecord);
        } else {
            partWritable = (ConnectorPartitionedWritable)this.targetSerDe.serialize(key);
        }
        String pathString = partWritable.getPartitionPath();
        if (!this.baseRecordWriters.containsKey(pathString)) {
            Path path = new Path(pathString);
            Configuration subConfiguration = new Configuration(this.context.getConfiguration());
            subConfiguration.setBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
            subConfiguration.set("mapred.output.dir", path.toString());
            subConfiguration.set("mapred.work.output.dir", path.toString());
            TaskAttemptContext taskContext = ConnectorMapredUtils.createTaskAttemptContext(subConfiguration, this.context);
            JobContext jobContext = ConnectorMapredUtils.createJobContext(taskContext);
            OutputFormat pluginOutputFormat = null;
            try {
                pluginOutputFormat = (OutputFormat)Class.forName(ConnectorConfiguration.getPlugInOutputFormat(this.configuration)).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            pluginOutputFormat.checkOutputSpecs(jobContext);
            OutputCommitter baseOutputCommitter = pluginOutputFormat.getOutputCommitter(taskContext);
            baseOutputCommitter.setupJob(jobContext);
            baseOutputCommitter.setupTask(taskContext);
            RecordWriter baseRecordWriter = pluginOutputFormat.getRecordWriter(taskContext);
            this.baseOutputFormats.put(pathString, pluginOutputFormat);
            this.baseRecordWriters.put(pathString, baseRecordWriter);
            this.taskContexts.put(pathString, taskContext);
        }
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        for (String key : this.taskContexts.keySet()) {
            OutputFormat baseOutputFormat = this.baseOutputFormats.get(key);
            RecordWriter baseRecordWriter = this.baseRecordWriters.get(key);
            TaskAttemptContext taskContext = this.taskContexts.get(key);
            baseRecordWriter.close(taskContext);
            OutputCommitter baseOutputCommitter = baseOutputFormat.getOutputCommitter(taskContext);
            baseOutputCommitter.commitTask(context);
            JobContext jobContext = ConnectorMapredUtils.createJobContext(taskContext);
            baseOutputCommitter.commitJob(jobContext);
        }
        this.end_timestamp = System.currentTimeMillis();
        this.logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
        this.logger.info((Object)("the total elapsed time of recordwriter " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
    }
}

