/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.utils;

import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import junit.framework.Assert;
import org.junit.Test;

public class TeradataSchemaUtilsTest {
    @Test
    public void testGetFieldNamesFromSchema() throws Exception {
        String schema = "f1 INTEGER,f2 BLOB(2048),f3 CLOB(2048) CHARACTER SET LATIN,f4 SYSUDTLIB.TYPE_ARY";
        Assert.assertEquals((String)"\"f1\",\"f2\",\"f3\",\"f4\"", (String)TeradataSchemaUtils.getFieldNamesFromSchema(schema));
    }

    @Test
    public void testColumnSchemaToTableDesc() throws Exception {
        String schema = "f1 INTEGER,f2 BLOB(2048),f3 CLOB(2048) CHARACTER SET LATIN,f4 SYSUDTLIB.TYPE_ARY";
        TeradataTableDesc tableDesc = TeradataSchemaUtils.columnSchemaToTableDesc(schema);
        Assert.assertEquals((String)"f1", (String)tableDesc.getColumn(0).getName());
        Assert.assertEquals((String)"BLOB(2048)", (String)tableDesc.getColumn(1).getTypeName());
        Assert.assertEquals((int)1883, (int)tableDesc.getColumn(3).getType());
    }

    @Test
    public void testGetTimestampFromCalendar() throws Exception {
        Calendar cal = Calendar.getInstance();
        long millis = cal.getTimeInMillis();
        Timestamp ts = TeradataSchemaUtils.getTimestampFromCalendar(cal);
        Assert.assertEquals((long)millis, (long)ts.getTime());
    }
}

