/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.TeradataObjectArrayWritable;
import com.teradata.connector.teradata.converter.TeradataDataType;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class TeradataSerDe
implements ConnectorSerDe {
    TeradataObjectArrayWritable objectArrayWritable = null;
    String targetTableDescText = "";
    String sourceTableDescText = "";
    TeradataTableDesc targetTableDesc = null;
    String[] targetFieldNamesArray = null;
    String[] sourceFieldNamesArray = null;
    TeradataDataType[] inputSchemaDataTypes = null;
    int[] targetMappings = null;
    Object[] targetObjects = null;
    boolean sqlXmlExists = false;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        this.sourceFieldNamesArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        this.sourceTableDescText = TeradataPlugInConfiguration.getInputTableDesc(configuration);
        HashMap<Object, Object> retHashMap = new HashMap();
        retHashMap = TeradataSchemaUtils.lookupTeradataDataTypes(this.sourceTableDescText, this.sourceFieldNamesArray);
        this.inputSchemaDataTypes = (TeradataDataType[])retHashMap.get("TeradataDataType");
        this.sqlXmlExists = Boolean.parseBoolean(retHashMap.get("SQLXMLEXISTS").toString());
        if (direction2 == ConnectorConfiguration.direction.output) {
            this.targetTableDescText = TeradataPlugInConfiguration.getOutputTableDesc(configuration);
            this.targetTableDesc = TeradataSchemaUtils.tableDescFromText(this.targetTableDescText);
            this.targetFieldNamesArray = TeradataPlugInConfiguration.getOutputFieldNamesArray(configuration);
            int[] fieldTypes = new int[]{};
            int[] fieldScales = new int[]{};
            String[] fieldTypeNames = null;
            fieldTypes = TeradataSchemaUtils.lookupTypesFromTableDescText(this.targetTableDescText, this.targetFieldNamesArray);
            fieldTypeNames = TeradataSchemaUtils.lookupTypeNamesFromTableDescText(this.targetTableDescText, this.targetFieldNamesArray);
            fieldScales = TeradataSchemaUtils.lookupFieldsSQLDataScales(this.targetTableDescText, this.targetFieldNamesArray);
            this.targetMappings = TeradataSchemaUtils.lookupMappingFromTableDescText(this.targetTableDescText, this.targetFieldNamesArray);
            this.objectArrayWritable = new TeradataObjectArrayWritable();
            this.objectArrayWritable.setNullJdbcTypes(fieldTypes);
            this.objectArrayWritable.setNullJdbcScales(fieldScales);
            this.objectArrayWritable.setRecordTypes(fieldTypeNames);
            int recordLength = this.targetTableDesc.getColumns().length;
            this.targetObjects = new Object[recordLength];
            for (int i = 0; i < recordLength; ++i) {
                this.targetObjects[i] = null;
            }
        }
    }

    @Override
    public ConnectorRecord deserialize(Writable writable) throws ConnectorException {
        ConnectorRecord connectorRecord = (ConnectorRecord)writable;
        TeradataDataType[] teradataDataType = this.inputSchemaDataTypes;
        int recordLength = this.sourceFieldNamesArray.length;
        if (this.sqlXmlExists) {
            for (int i = 0; i < recordLength; ++i) {
                if (!teradataDataType[i].equals(TeradataDataType.TeradataDataTypeImpl.SQLXML)) continue;
                connectorRecord.set(i, teradataDataType[i].transform(connectorRecord.get(i)));
            }
        }
        return connectorRecord;
    }

    @Override
    public Writable serialize(ConnectorRecord connectorRecord) throws ConnectorException {
        int index = 0;
        for (int position : this.targetMappings) {
            this.targetObjects[position] = connectorRecord.get(index++);
        }
        this.objectArrayWritable.setObjects(this.targetObjects);
        return this.objectArrayWritable;
    }
}

