/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.schema;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import java.util.ArrayList;
import java.util.List;

public class TeradataViewDesc {
    private String name = "";
    private String databaseName = "";
    private String query = "";
    private List<TeradataColumnDesc> columns = new ArrayList<TeradataColumnDesc>();
    private Boolean accessLock = false;

    public void setName(String name) {
        this.name = name;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setQuery(String query) throws ConnectorException {
        if (!query.toUpperCase().trim().startsWith("SEL") && !query.toUpperCase().trim().startsWith("SELECT")) {
            throw new IllegalArgumentException("Only SELECT query is supported");
        }
        this.query = query;
    }

    public void setColumns(TeradataColumnDesc[] columns) {
        this.columns.clear();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                this.columns.add(columns[i]);
            }
        }
    }

    public void addColumnInfo(TeradataColumnDesc columnInfo) {
        if (columnInfo != null) {
            this.columns.add(columnInfo);
        }
    }

    public void setAccessLock(Boolean accessLock) {
        this.accessLock = accessLock;
    }

    public String getName() {
        return this.name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getQualifiedName() {
        String result = "";
        if (!this.databaseName.isEmpty()) {
            result = result + this.quoteName(this.databaseName) + ".";
        }
        result = result + this.quoteName(this.name);
        return result;
    }

    public String getQuery() {
        return this.query;
    }

    public TeradataColumnDesc[] getColumns() {
        return this.columns.toArray(new TeradataColumnDesc[0]);
    }

    public TeradataColumnDesc getColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            return null;
        }
        return this.columns.get(index);
    }

    public String getColumnsString() {
        StringBuilder sb = new StringBuilder();
        int columnCount = this.columns.size();
        for (int i = 0; i < columnCount; ++i) {
            sb.append(this.quoteName(this.columns.get(i).getName())).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public Boolean getAccessLock() {
        return this.accessLock;
    }

    private String quoteName(String objectName) {
        if (objectName == null || objectName.isEmpty()) {
            return "";
        }
        if (objectName.charAt(0) == '\"' && objectName.charAt(objectName.length() - 1) == '\"') {
            return objectName;
        }
        return '\"' + objectName + '\"';
    }
}

