/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.schema;

import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeradataTableDesc {
    private String name = "";
    private String databaseName = "";
    private boolean multiset = true;
    private boolean hasPrimaryIndex = true;
    private boolean hasPartitionColumns = true;
    private int blockSize = 0;
    private ArrayList<TeradataColumnDesc> columns = new ArrayList();
    private List<String> primaryIndices = new ArrayList<String>();
    private List<String> partitionColumnNames = new ArrayList<String>();

    public void setBlockSize(int blockSize_) {
        this.blockSize = blockSize_;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setName(String name_) {
        this.name = name_;
    }

    public void setDatabaseName(String databaseName_) {
        this.databaseName = databaseName_;
    }

    public void setMultiset(boolean multiset_) {
        this.multiset = multiset_;
    }

    public void setColumns(TeradataColumnDesc[] columns_) {
        this.columns.clear();
        if (columns_ != null) {
            for (int i = 0; i < columns_.length; ++i) {
                this.columns.add(columns_[i]);
            }
        }
    }

    public void addColumn(TeradataColumnDesc columnInfo_) {
        if (columnInfo_ != null) {
            this.columns.add(columnInfo_);
        }
    }

    public void setHasPrimaryIndex(boolean hasPrimaryIndex_) {
        this.hasPrimaryIndex = hasPrimaryIndex_;
    }

    public void addPrimaryIndex(String primaryIndexName_) {
        if (primaryIndexName_ != null && !primaryIndexName_.isEmpty()) {
            this.primaryIndices.add(primaryIndexName_);
            this.hasPrimaryIndex = true;
        }
    }

    public void removePrimaryIndex(int index_) {
        if (index_ >= 0 && this.primaryIndices.size() > index_) {
            this.primaryIndices.remove(index_);
        }
    }

    public void setHasPartitionColumns(boolean hasPartitionColumns_) {
        this.hasPartitionColumns = hasPartitionColumns_;
    }

    public void addPartitionColumn(String partitionColumn_) {
        if (partitionColumn_ != null && !partitionColumn_.isEmpty()) {
            this.partitionColumnNames.add(partitionColumn_);
        }
    }

    public void removePartitionColumn(int index_) {
        if (index_ >= 0 && this.partitionColumnNames.size() > index_) {
            this.partitionColumnNames.remove(index_);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getQualifiedName() {
        String result = "";
        if (this.databaseName != null && !this.databaseName.isEmpty()) {
            result = result + this.quoteName(this.databaseName) + ".";
        }
        result = result + this.quoteName(this.name);
        return result;
    }

    public boolean isMultiset() {
        return this.multiset;
    }

    public TeradataColumnDesc[] getColumns() {
        return this.columns.toArray(new TeradataColumnDesc[0]);
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            columnNames[i] = this.columns.get(i).getName();
        }
        return columnNames;
    }

    public Map<String, Integer> getColumnNameMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.columns.size(); ++i) {
            map.put(this.columns.get(i).getName(), i);
        }
        return map;
    }

    public Map<String, Integer> getColumnNameLowerCaseMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.columns.size(); ++i) {
            map.put(this.columns.get(i).getName().toLowerCase(), i);
        }
        return map;
    }

    public TeradataColumnDesc getColumn(int index_) {
        if (index_ < 0 || index_ >= this.columns.size()) {
            return null;
        }
        return this.columns.get(index_);
    }

    public boolean hasPrimaryIndex() {
        return this.hasPrimaryIndex;
    }

    public List<String> getPrimaryIndices() {
        return this.primaryIndices;
    }

    public boolean hasPartitionColumns() {
        return this.hasPartitionColumns;
    }

    public List<String> getPartitionColumnNames() {
        return this.partitionColumnNames;
    }

    public String getColumnsString() {
        StringBuilder sb = new StringBuilder();
        int columnCount = this.columns.size();
        for (int i = 0; i < columnCount; ++i) {
            sb.append(this.quoteName(this.columns.get(i).getName())).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String quoteName(String objectName) {
        if (objectName == null || objectName.isEmpty()) {
            return "";
        }
        if (objectName.charAt(0) == '\"' && objectName.charAt(objectName.length() - 1) == '\"') {
            return this.escapeDoubleQuote(objectName);
        }
        return '\"' + this.escapeDoubleQuote(objectName) + '\"';
    }

    private String escapeDoubleQuote(String objectName) {
        return objectName.replace("\"", "\"\"");
    }
}

