/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.processor;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataInputProcessor;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;

public class TeradataSplitByValueProcessor
extends TeradataInputProcessor {
    @Override
    protected void setupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
    }

    @Override
    protected void cleanupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
    }

    @Override
    protected void validateConfiguration(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        super.validateConfiguration(configuration, connection);
        String inputTableName = TeradataConnection.getQuotedEscapedName(TeradataPlugInConfiguration.getInputDatabase(configuration), TeradataPlugInConfiguration.getInputTable(configuration));
        String splitColumn = this.getSplitColumn(inputTableName, configuration);
        TeradataPlugInConfiguration.setInputSplitByColumn(configuration, splitColumn);
    }

    protected String getSplitColumn(String tableName, Configuration configuration) throws ConnectorException {
        String splitColumn;
        block6: {
            splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
            int numMappers = ConnectorConfiguration.getNumMappers(configuration);
            if (!splitColumn.isEmpty() || numMappers == 1) {
                return splitColumn;
            }
            try {
                String[] tempPrimaryIndexs;
                String[] primaryKeys = this.connection.getPrimaryKey(tableName);
                if (primaryKeys.length > 0) {
                    splitColumn = primaryKeys[0];
                    break block6;
                }
                String[] primaryIndexs = this.connection.getPrimaryIndex(tableName);
                if (primaryIndexs.length < 1 && (tempPrimaryIndexs = this.connection.getColumnNamesForTable(tableName)).length > 0) {
                    primaryIndexs = new String[]{tempPrimaryIndexs[0]};
                }
                if (primaryIndexs.length > 0) {
                    splitColumn = primaryIndexs[0];
                    break block6;
                }
                throw new ConnectorException(23002);
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        return splitColumn;
    }
}

