/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.teradata.TeradataInputFormat;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class TeradataSplitByHashInputFormat
extends TeradataInputFormat {
    protected static final String SQL_SELECT_NOSTAGE_RANGE = "SELECT %s FROM %s WHERE %s HASHAMP(HASHBUCKET(HASHROW(%s)))";

    @Override
    public void validateConfiguration(JobContext context) throws ConnectorException {
        super.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        if (splitColumn.isEmpty() && numMappers != 1) {
            throw new ConnectorException(23002);
        }
        this.connection = TeradataUtils.openInputConnection(context);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        this.validateConfiguration(context);
        Configuration configuration = context.getConfiguration();
        this.inputTableName = TeradataConnection.getQuotedEscapedName(TeradataPlugInConfiguration.getInputDatabase(configuration), TeradataPlugInConfiguration.getInputTable(configuration));
        this.inputConditions = TeradataPlugInConfiguration.getInputConditions(configuration);
        this.inputFieldNamesArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        Boolean accessLock = TeradataPlugInConfiguration.getInputAccessLock(configuration);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        String[] locations = HadoopConfigurationUtils.getAllActiveHosts(context);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (numMappers == 1) {
            String inputSplitSql = TeradataConnection.getSelectSQL(this.inputTableName, this.inputFieldNamesArray, this.inputConditions);
            if (accessLock.booleanValue()) {
                inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
            }
            TeradataInputFormat.TeradataInputSplit split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
            split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
            splits.add(split);
        } else {
            String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
            String splitSql = this.inputConditions.isEmpty() ? String.format(SQL_SELECT_NOSTAGE_RANGE, ConnectorSchemaUtils.concatFieldNamesArray(ConnectorSchemaUtils.quoteFieldNamesArray(this.inputFieldNamesArray)), this.inputTableName, "", TeradataConnection.getQuotedName(splitColumn)) : String.format(SQL_SELECT_NOSTAGE_RANGE, ConnectorSchemaUtils.concatFieldNamesArray(ConnectorSchemaUtils.quoteFieldNamesArray(this.inputFieldNamesArray)), this.inputTableName, "(" + this.inputConditions + ") AND ", TeradataConnection.getQuotedName(splitColumn));
            int numAmps = TeradataPlugInConfiguration.getInputNumAmps(configuration);
            int ampRange = numAmps / numMappers;
            int remainder = numAmps % numMappers;
            if (numAmps == numMappers) {
                for (int i = 0; i < numMappers; ++i) {
                    String inputSplitSql = splitSql + " = " + i;
                    if (accessLock.booleanValue()) {
                        inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                    }
                    TeradataInputFormat.TeradataInputSplit split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                    split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split);
                }
            } else {
                TeradataInputFormat.TeradataInputSplit split;
                String inputSplitSql;
                int i;
                int currAmpId = 0;
                for (i = 1; i <= remainder; ++i) {
                    inputSplitSql = splitSql + " BETWEEN " + currAmpId + " AND " + String.valueOf(currAmpId + ampRange);
                    if (accessLock.booleanValue()) {
                        inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                    }
                    split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                    split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split);
                    currAmpId = currAmpId + ampRange + 1;
                }
                for (i = remainder + 1; i < numMappers; ++i) {
                    inputSplitSql = splitSql + " BETWEEN " + currAmpId + " AND " + String.valueOf(currAmpId + ampRange - 1);
                    if (accessLock.booleanValue()) {
                        inputSplitSql = TeradataConnection.addAccessLockToSql(inputSplitSql);
                    }
                    split = new TeradataInputFormat.TeradataInputSplit(inputSplitSql);
                    split.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                    splits.add(split);
                    currAmpId += ampRange;
                }
                String inputSplitSql2 = splitSql + " BETWEEN " + currAmpId + " AND " + String.valueOf(numAmps - 1);
                if (accessLock.booleanValue()) {
                    inputSplitSql2 = TeradataConnection.addAccessLockToSql(inputSplitSql2);
                }
                TeradataInputFormat.TeradataInputSplit split2 = new TeradataInputFormat.TeradataInputSplit(inputSplitSql2);
                split2.setLocations(HadoopConfigurationUtils.selectUniqueActiveHosts(locations, 6));
                splits.add(split2);
            }
        }
        TeradataUtils.closeConnection(this.connection);
        return splits;
    }
}

