/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataInternalFastloadProcessor;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import com.teradata.jdbc.jdbc_4.TDSession;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class TeradataInternalFastloadOutputFormat<K, V extends DBWritable>
extends OutputFormat<K, DBWritable> {
    private static Log logger = LogFactory.getLog(TeradataInternalFastloadOutputFormat.class);
    public static String MSG_FASTLOAD_TRANSFER_BEGIN = "FASTLOAD_TRANSFER_BEGIN";
    public static String MSG_FASTLOAD_TRANSFER_END = "FASTLOAD_TRANSFER_END";
    public static String MSG_FASTLOAD_CONNECTION_READY = "FASTLOAD_CONNECTION_READY";
    public static String MSG_FASTLOAD_CONNECTION_CLOSE = "FASTLOAD_CONNECTION_CLOSE";
    protected static String PARAM_FASTLOAD_CONNECTION = "PARTITION=FASTLOAD,CONNECT_FUNCTION=2,LOGON_SEQUENCE_NUMBER=";
    protected static String PARAM_LSN_CONNECTION = "TMODE=TERA,CONNECT_FUNCTION=1";
    protected static String SQL_GET_LSN = "{fn teradata_logon_sequence_number()}";
    protected static String SQL_FASTLOAD_DATAFORM = "SET SESSION DateForm = IntegerDate";
    protected static String SQL_CHECKPOINT_LOADING_END = "CHECKPOINT LOADING END";
    protected static String SQL_BEGIN_LOADING = "BEGIN LOADING";
    protected static String SQL_END_LOADING = "END LOADING";
    protected static String FASTLOAD_FILE_NAME = "fastloadfile";
    private static final String CHECK_WORKLOAD = "CHECK WORKLOAD FOR ";
    private static final String CHECK_WORKLOAD_END = "CHECK WORKLOAD END";
    private static final String LSS_TYPE = "LSS_TYPE=L";
    private static final String FASTLOAD_QUERY_BAND = "UtilityName=JDBCL;";
    public static String MSG_FASTLOAD_PING = "FASTLOAD_PING";
    public static int SOCKET_CONNECT_TIMEOUT = 5000;
    public static int SOCKET_CONNECT_RETRY_MAX = 50;
    public static int SOCKET_CONNECT_RETRY_WAIT_MIN = 200;
    public static int SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED = 500;
    protected static int SOCKET_SERVER_ACCEPT_TIME_OUT = 20000;
    protected static Connection lsnConnection;
    protected static ServerSocket server;
    protected String charset = "";
    protected int readyConnCount = 0;
    protected int readyTaskCount = 0;
    protected static int SOCKET_PING_TIME_OUT;

    protected void validateConfiguration(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        TeradataConnection connection = TeradataUtils.openOutputConnection(context);
        String outputProcessor = ConnectorConfiguration.getPlugInOutputProcessor(configuration);
        if (outputProcessor.isEmpty()) {
            TeradataUtils.validateOutputTeradataProperties(configuration, connection);
            TeradataSchemaUtils.setupTeradataTargetTableSchema(configuration, connection);
        }
        connection.close();
    }

    private void configFastloadConnectivity(JobContext context, int numTasks) throws SQLException, IOException {
        String submitJobDir;
        Configuration configuration = context.getConfiguration();
        String host = TeradataPlugInConfiguration.getOutputFastloadSocketHost(configuration);
        int port = TeradataPlugInConfiguration.getOutputFastloadSocketPort(configuration);
        String lsnNumber = lsnConnection.nativeSQL(SQL_GET_LSN);
        if (lsnNumber == null || lsnNumber.length() == 0) {
            throw new SQLException("lsn number missing");
        }
        logger.debug((Object)("fastload lsn number is " + lsnNumber));
        TeradataPlugInConfiguration.setOutputFastloadLsn(configuration, lsnNumber);
        if (host.isEmpty() || host.equalsIgnoreCase("default") || host.equalsIgnoreCase("localhost")) {
            host = HadoopConfigurationUtils.getClusterNodeInterface(context);
            TeradataPlugInConfiguration.setOutputFastloadSocketHost(configuration, host);
        }
        if (port == 0) {
            port = server.getLocalPort();
            TeradataPlugInConfiguration.setOutputFastloadSocketPort(configuration, port);
        }
        if ((submitJobDir = configuration.get("mapreduce.job.dir")) == null || submitJobDir.trim().equals("")) {
            return;
        }
        Path path = new Path(submitJobDir, FASTLOAD_FILE_NAME);
        FileSystem fileSystem = path.getFileSystem(configuration);
        if (fileSystem.exists(path)) {
            throw new ConnectorException(24001);
        }
        String maxReplicaString = configuration.get("dfs.replication.max");
        short maxReplicaNum = (short)(maxReplicaString == null || maxReplicaString.isEmpty() ? 512 : Integer.parseInt(maxReplicaString));
        FSDataOutputStream outputStream = numTasks < maxReplicaNum ? fileSystem.create(path, (short)numTasks) : fileSystem.create(path, maxReplicaNum);
        outputStream.writeUTF(lsnNumber);
        outputStream.writeUTF(host);
        outputStream.writeUTF(Integer.valueOf(port).toString());
        outputStream.close();
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        if (ConnectorConfiguration.getPlugInOutputProcessor(configuration).isEmpty()) {
            this.validateConfiguration(context);
        }
        String classname = TeradataPlugInConfiguration.getOutputJdbcDriverClass(configuration);
        String url = TeradataPlugInConfiguration.getOutputJdbcUrl(configuration);
        boolean isFastFail = TeradataPlugInConfiguration.getOutputFastFail(configuration);
        try {
            boolean isGoverned = TeradataConnection.getJDBCURLParameters(url).isGoverned();
            server = HadoopConfigurationUtils.createServerSocket(TeradataPlugInConfiguration.getOutputFastloadSocketPort(configuration), TeradataPlugInConfiguration.getOutputFastloadSocketBacklog(configuration));
            boolean enableUnicodePassthrough = TeradataPlugInConfiguration.getUnicodePassthrough(configuration);
            lsnConnection = TeradataConnection.getConnection(classname, url, TeradataPlugInConfiguration.getOutputTeradataUserName(context), TeradataPlugInConfiguration.getOutputTeradataPassword(context), isGoverned || isFastFail ? "LSS_TYPE=L," + PARAM_LSN_CONNECTION : PARAM_LSN_CONNECTION, enableUnicodePassthrough);
            String queryBandProperty = TeradataPlugInConfiguration.getOutputQueryBand(configuration) + (isGoverned || isFastFail ? FASTLOAD_QUERY_BAND : "");
            TeradataUtils.validateQueryBand(queryBandProperty);
            TeradataConnection.setQueryBandProperty(lsnConnection, queryBandProperty);
            int TASMSessnNum = TeradataInternalFastloadOutputFormat.getFastloadSessionCount(configuration);
            ConnectorConfiguration.setNumMappers(configuration, TASMSessnNum);
            int numTasks = this.validateAndGetTaskNumber(context);
            if (numTasks == 0) {
                return;
            }
            this.charset = TeradataConnection.getURLParamValue(url, "CHARSET");
            if (this.charset == null || !this.charset.equalsIgnoreCase("UTF8") && !this.charset.equalsIgnoreCase("UTF16")) {
                this.charset = "";
            }
            this.configFastloadConnectivity(context, numTasks);
            logger.info((Object)("started load task: " + numTasks));
            InternalFastloadCoordinator coordinator = new InternalFastloadCoordinator(numTasks, configuration);
            Thread thread = new Thread(coordinator);
            thread.start();
        }
        catch (SQLException e) {
            TeradataUtils.closeConnection(lsnConnection);
            this.closeServer(server);
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            TeradataUtils.closeConnection(lsnConnection);
            this.closeServer(server);
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RecordWriter<K, DBWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        int port;
        String host;
        String lsn;
        Configuration configuration = context.getConfiguration();
        String submitJobHost = configuration.get("mapreduce.job.submithostname");
        String submitJobDir = configuration.get("mapreduce.job.dir");
        Path path = new Path(submitJobDir, FASTLOAD_FILE_NAME);
        FileSystem fileSystem = path.getFileSystem(configuration);
        if (fileSystem.exists(path)) {
            FSDataInputStream inputStream = fileSystem.open(path);
            lsn = inputStream.readUTF();
            host = inputStream.readUTF();
            port = Integer.parseInt(inputStream.readUTF());
            inputStream.close();
        } else {
            lsn = TeradataPlugInConfiguration.getOutputFastloadLsn(configuration);
            host = TeradataPlugInConfiguration.getOutputFastloadSocketHost(configuration);
            port = TeradataPlugInConfiguration.getOutputFastloadSocketPort(configuration);
        }
        logger.debug((Object)("fastload mapper socket host is " + host));
        logger.debug((Object)("fastload mapper socket port is " + port));
        Socket socket = null;
        Connection fastLoadConnection = null;
        try {
            int retryCount = 0;
            while (socket == null) {
                try {
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(host, port), SOCKET_CONNECT_TIMEOUT);
                    socket.setTcpNoDelay(true);
                    logger.debug((Object)"Connection to InternalFastload coordinator successful");
                }
                catch (Exception e) {
                    if (++retryCount >= SOCKET_CONNECT_RETRY_MAX) {
                        logger.debug((Object)("After " + retryCount + " retries, unable to connect to InternalFastload coordinator"));
                        throw new ConnectorException(e.getMessage(), e);
                    }
                    socket = null;
                    if (!submitJobHost.isEmpty() && retryCount % 10 == 0) {
                        try {
                            socket = new Socket();
                            socket.connect(new InetSocketAddress(submitJobHost, port), SOCKET_CONNECT_TIMEOUT);
                            socket.setTcpNoDelay(true);
                            host = submitJobHost;
                            logger.debug((Object)"Connection to InternalFastload coordinator successful via mapreduce.job.submithostname");
                        }
                        catch (Exception e2) {
                            logger.debug((Object)("Caught exception " + e.getMessage()));
                        }
                    }
                    try {
                        int waitSeconds = new Random().nextInt(SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED) + SOCKET_CONNECT_RETRY_WAIT_MIN;
                        Thread.sleep(waitSeconds);
                    }
                    catch (InterruptedException e1) {
                        logger.debug((Object)"InterruptedException occurred during random sleep between retries");
                    }
                }
            }
            DataInputStream in = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            String taskAttempId = context.getTaskAttemptID().toString();
            if (context.getTaskAttemptID().getId() > 0) {
                logger.debug((Object)"Current task attempt ID is > 0, internal.fastload doesn't support preemption/failover, fastload job failed");
                out.writeUTF("Fastload job failed on task " + taskAttempId);
                out.flush();
                throw new ConnectorException(22002);
            }
            if (lsn == null || lsn.isEmpty()) {
                logger.debug((Object)"No LSN found for fastload job, fastload job failed.");
                out.writeUTF("Fastload job failed on task " + taskAttempId);
                out.flush();
                throw new ConnectorException(22012);
            }
            logger.debug((Object)("fastload task lsn number is " + lsn));
            String timeConnProperties = "";
            String url = TeradataPlugInConfiguration.getOutputJdbcUrl(configuration).toLowerCase();
            if (!url.contains("/tsnano=") && !url.contains(",tsnano=")) {
                timeConnProperties = timeConnProperties + "tsnano=6,";
            }
            if (!url.contains("/tnano=") && !url.contains(",tnano=")) {
                timeConnProperties = timeConnProperties + "tnano=6,";
            }
            String queryBandProperty = TeradataPlugInConfiguration.getOutputQueryBand(configuration);
            boolean isGoverned = TeradataConnection.getJDBCURLParameters(url).isGoverned();
            boolean isFastFail = TeradataPlugInConfiguration.getOutputFastFail(configuration);
            String connection_param = isGoverned || isFastFail ? "LSS_TYPE=L," + PARAM_FASTLOAD_CONNECTION : PARAM_FASTLOAD_CONNECTION;
            logger.debug((Object)"Creating JDBC fastload connection to DBS");
            fastLoadConnection = !ConnectorStringUtils.isEmpty(queryBandProperty) ? TeradataConnection.getConnection(TeradataPlugInConfiguration.getOutputJdbcDriverClass(configuration), TeradataPlugInConfiguration.getOutputJdbcUrl(configuration), TeradataPlugInConfiguration.getOutputTeradataUserName((JobContext)context), TeradataPlugInConfiguration.getOutputTeradataPassword((JobContext)context), timeConnProperties + connection_param + lsn + "," + queryBandProperty) : TeradataConnection.getConnection(TeradataPlugInConfiguration.getOutputJdbcDriverClass(configuration), TeradataPlugInConfiguration.getOutputJdbcUrl(configuration), TeradataPlugInConfiguration.getOutputTeradataUserName((JobContext)context), TeradataPlugInConfiguration.getOutputTeradataPassword((JobContext)context), timeConnProperties + connection_param + lsn);
            fastLoadConnection.setAutoCommit(false);
            PreparedStatement prepareStatement = fastLoadConnection.prepareStatement(null);
            logger.info((Object)("fastload connection is created for task " + taskAttempId));
            out.writeUTF(MSG_FASTLOAD_CONNECTION_READY);
            out.flush();
            String message = in.readUTF();
            if (!message.contains(MSG_FASTLOAD_TRANSFER_BEGIN)) {
                logger.debug((Object)("Received unsupported message from InternalFastload coordinator: " + message));
                throw new ConnectorException(22001);
            }
            logger.debug((Object)"Received fastload transfer begin message from InternalFastload coordinator");
            int batchSize = TeradataPlugInConfiguration.getOutputBatchSize(configuration);
            TeradataInternalFastLoadRecordWriter teradataInternalFastLoadRecordWriter = new TeradataInternalFastLoadRecordWriter(fastLoadConnection, prepareStatement, batchSize, host, port);
            this.closeSocket(socket);
            return teradataInternalFastLoadRecordWriter;
        }
        catch (SQLException e) {
            try {
                throw new ConnectorException(e.getMessage(), e);
                catch (UnknownHostException e2) {
                    throw new ConnectorException(e2.getMessage(), e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new ConnectorException(e3.getMessage(), e3);
                }
                catch (IOException e4) {
                    TeradataUtils.closeConnection(fastLoadConnection);
                    fastLoadConnection = null;
                    throw new ConnectorException(e4.getMessage(), e4);
                }
            }
            catch (Throwable throwable) {
                this.closeSocket(socket);
                socket = null;
                throw throwable;
            }
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new FileOutputCommitter(FileOutputFormat.getOutputPath((JobContext)context), context);
    }

    protected void closeServer(ServerSocket server) {
        if (server != null && !server.isClosed()) {
            try {
                server.close();
            }
            catch (IOException e1) {
                logger.debug((Object)e1.getMessage());
            }
        }
    }

    protected void closeSocket(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e1) {
                logger.debug((Object)e1.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getJobStatus() {
        Class<TeradataInternalFastloadProcessor> clazz = TeradataInternalFastloadProcessor.class;
        synchronized (TeradataInternalFastloadProcessor.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return TeradataInternalFastloadProcessor.jobSuccess;
        }
    }

    private static int getFastloadSessionCount(Configuration configuration) throws SQLException {
        TDSession session = (TDSession)lsnConnection;
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        boolean isGoverned = session.getURLParameters().isGoverned();
        String check_workload_end = (!isGoverned ? "{fn TERADATA_FAILFAST}" : "") + CHECK_WORKLOAD_END;
        if (session.useCheckWorkload()) {
            String outputDatabase = TeradataPlugInConfiguration.getOutputDatabase(configuration);
            String errorTableDatabase = TeradataPlugInConfiguration.getOutputErrorTableDatabase(configuration);
            if (errorTableDatabase.isEmpty()) {
                errorTableDatabase = outputDatabase;
            }
            String errorTable1 = TeradataConnection.getQuotedEscapedName(errorTableDatabase, TeradataPlugInConfiguration.getOutputErrorTable1Name(configuration));
            String errorTable2 = TeradataConnection.getQuotedEscapedName(errorTableDatabase, TeradataPlugInConfiguration.getOutputErrorTable2Name(configuration));
            String outputTableName = TeradataPlugInConfiguration.getOutputTable(configuration);
            outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
            String checkWorkLoad = CHECK_WORKLOAD + SQL_BEGIN_LOADING + " " + outputTableName + " ERRORFILES " + errorTable1 + ", " + errorTable2 + " WITH INTERVAL";
            Statement controlStmt = lsnConnection.createStatement();
            controlStmt.executeUpdate(checkWorkLoad);
            ResultSet rs = controlStmt.executeQuery(check_workload_end);
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.next() && rsmd.getColumnCount() >= 2 && rs.getString(1) != null) {
                if (rs.getString(1).trim().equalsIgnoreCase("Y")) {
                    int count = rs.getInt(2);
                    if (count > 0) {
                        int numSugSessn = Math.min(numMappers, count);
                        if (numSugSessn < numMappers) {
                            logger.info((Object)("user provided number of Mappers [" + numMappers + "] is overridden by [" + numSugSessn + "] returned from DBS"));
                        } else {
                            logger.info((Object)("user provided number of Mappers is NOT overridden by [" + count + "] DBS."));
                        }
                        return numSugSessn;
                    }
                    logger.info((Object)("invalid number " + count + " returned from DBS"));
                } else {
                    logger.info((Object)"returned TASM-flag is N");
                }
            } else {
                logger.info((Object)"unrecognized column returned");
            }
            rs.close();
            controlStmt.close();
        } else {
            logger.info((Object)"TDCH is not controlled by TASM");
        }
        return numMappers;
    }

    private int validateAndGetTaskNumber(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        int numTasks = ConnectorConfiguration.getNumReducers(configuration);
        int numAmps = TeradataPlugInConfiguration.getOutputNumAmps(configuration);
        if (numTasks == 0) {
            try {
                numTasks = ((InputFormat)ReflectionUtils.newInstance((Class)context.getInputFormatClass(), (Configuration)configuration)).getSplits(context).size();
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            int maxMapTasks = HadoopConfigurationUtils.getMaxMapTasks(context);
            if (numTasks == 0) {
                return 0;
            }
            if (numTasks > maxMapTasks && maxMapTasks > 0) {
                logger.warn((Object)("The number of map tasks requested (" + numTasks + ") is greater than the maximum number of map tasks supported by the Hadoop cluster; in some situations the TDCH job may result in deadlock due to the internal.fastload requirement that all map tasks are run concurrently"));
            }
        } else {
            int maxReduceTasks = HadoopConfigurationUtils.getMaxReduceTasks(context);
            if (numTasks > maxReduceTasks && maxReduceTasks > 0) {
                throw new ConnectorException(22005);
            }
        }
        if (numTasks > numAmps) {
            throw new ConnectorException(22006);
        }
        return numTasks;
    }

    static {
        server = null;
        SOCKET_PING_TIME_OUT = 60000;
    }

    public class TeradataInternalFastLoadRecordWriter
    extends RecordWriter<K, DBWritable> {
        private Log logger = LogFactory.getLog(TeradataInternalFastLoadRecordWriter.class);
        private Socket socket;
        private DataInputStream in = null;
        private DataOutputStream out = null;
        private String host = null;
        private int port = 0;
        private Connection connection;
        private PreparedStatement preparedStatement;
        int batchSize;
        int batchCount = 0;
        protected long end_timestamp = 0L;
        protected long start_timestamp = System.currentTimeMillis();

        public TeradataInternalFastLoadRecordWriter(Connection connection, PreparedStatement preparedStatement, int batchSize, String host, int port) throws IOException {
            this.logger.info((Object)("TeradataRecordWriter starts at " + this.start_timestamp));
            this.connection = connection;
            this.preparedStatement = preparedStatement;
            this.batchSize = batchSize;
            this.host = host;
            this.port = port;
        }

        public void write(K key, DBWritable value) throws IOException {
            block6: {
                try {
                    value.write(this.preparedStatement);
                    this.preparedStatement.addBatch();
                    ++this.batchCount;
                    if (this.batchCount < this.batchSize) break block6;
                    try {
                        this.preparedStatement.executeBatch();
                    }
                    catch (BatchUpdateException batchUpdateException) {
                        // empty catch block
                    }
                    this.batchCount = 0;
                }
                catch (SQLException e) {
                    ConnectorException start = new ConnectorException(e.getMessage(), e);
                    while (e != null) {
                        StackTraceElement[] elements = e.getStackTrace();
                        int n = elements.length;
                        for (int i = 0; i < n; ++i) {
                            this.logger.error((Object)(elements[i].getFileName() + ":" + elements[i].getLineNumber() + ">> " + elements[i].getMethodName() + "()"));
                        }
                        e = e.getNextException();
                    }
                    TeradataUtils.closeConnection(this.connection);
                    throw start;
                }
            }
        }

        public void close(TaskAttemptContext context) throws IOException {
            int retryCount = 0;
            this.logger.debug((Object)"Attempting to connect to InternalFastload coordinator to signal data transfer complete");
            while (this.socket == null) {
                try {
                    this.socket = new Socket(this.host, this.port);
                    this.socket.setTcpNoDelay(true);
                    this.logger.debug((Object)"Connected to InternalFastload coordinator successfully");
                }
                catch (ConnectException e) {
                    if (++retryCount >= SOCKET_CONNECT_RETRY_MAX) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                    this.socket = null;
                    try {
                        int waitSeconds = new Random().nextInt(SOCKET_CONNECT_RETRY_WAIT_RANDOM_SEED) + SOCKET_CONNECT_RETRY_WAIT_MIN;
                        Thread.sleep(waitSeconds);
                    }
                    catch (InterruptedException e1) {
                        this.logger.debug((Object)"InterruptedException occurred during random sleep between retries");
                    }
                }
            }
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            try {
                String message;
                if (this.batchCount > 0) {
                    try {
                        this.preparedStatement.executeBatch();
                    }
                    catch (BatchUpdateException e) {
                        // empty catch block
                    }
                    this.batchCount = 0;
                }
                this.logger.debug((Object)("Signaling to InternalFastload coordinator data transfer is complete for task " + context.getTaskAttemptID().toString()));
                this.out.writeUTF(MSG_FASTLOAD_TRANSFER_END);
                this.out.flush();
                this.logger.info((Object)"fastload: transfer data finished");
                while ((message = this.in.readUTF()).equals(MSG_FASTLOAD_PING)) {
                    this.logger.info((Object)"ping message received. ignore.");
                }
                if (!message.equals(MSG_FASTLOAD_CONNECTION_CLOSE)) {
                    this.logger.debug((Object)("Received unsupported message from InternalFastload coordinator: " + message));
                    throw new IOException("fastload: message " + MSG_FASTLOAD_CONNECTION_CLOSE + " expected");
                }
                this.connection.close();
                this.socket.close();
                this.end_timestamp = System.currentTimeMillis();
                this.logger.info((Object)("TeradataRecordWriter ended at: " + this.end_timestamp));
                this.logger.info((Object)("TeradataRecordWriter duration in seconds: " + (this.end_timestamp - this.start_timestamp) / 1000L));
            }
            catch (SQLException e) {
                SQLException root = e;
                while (e != null) {
                    StackTraceElement[] elements = e.getStackTrace();
                    int n = elements.length;
                    for (int i = 0; i < n; ++i) {
                        this.logger.error((Object)(elements[i].getFileName() + ":" + elements[i].getLineNumber() + ">> " + elements[i].getMethodName() + "()"));
                    }
                    e = e.getNextException();
                }
                throw new IOException(new ConnectorException(root.getMessage(), root));
            }
            finally {
                this.connection = null;
            }
        }
    }

    class InternalFastloadCoordinator
    implements Runnable {
        private int numTasks;
        private Configuration configuration;
        private Log logger = LogFactory.getLog(InternalFastloadCoordinator.class);

        InternalFastloadCoordinator(int numTasks, Configuration configuration) {
            this.numTasks = numTasks;
            this.configuration = configuration;
        }

        @Override
        public void run() {
            try {
                this.beginLoading(this.numTasks, this.configuration, server);
                this.logger.debug((Object)"Begin loading complete, starting end loading logic");
                this.endLoading(this.numTasks, server);
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage());
                try {
                    TeradataUtils.closeConnection(lsnConnection);
                }
                catch (ConnectorException e1) {
                    this.logger.error((Object)e1.getMessage());
                }
                TeradataInternalFastloadOutputFormat.this.closeServer(server);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void beginLoading(int taskCount, Configuration configuration, ServerSocket server) throws ConnectorException {
            int i;
            Socket[] sockets = new Socket[taskCount];
            try {
                TeradataColumnDesc fieldDesc;
                int index;
                server.setSoTimeout(SOCKET_SERVER_ACCEPT_TIME_OUT);
                long timeoutValue = TeradataPlugInConfiguration.getOutputFastloadSocketTimeout(configuration);
                long startTime = System.currentTimeMillis();
                while (TeradataInternalFastloadOutputFormat.this.readyConnCount < taskCount) {
                    if (!TeradataInternalFastloadOutputFormat.getJobStatus()) {
                        this.logger.debug((Object)"TeradataInternalFastloadProcessor.jobSuccess is false");
                        throw new ConnectorException(22002);
                    }
                    try {
                        sockets[TeradataInternalFastloadOutputFormat.this.readyConnCount] = server.accept();
                        sockets[TeradataInternalFastloadOutputFormat.this.readyConnCount].setTcpNoDelay(true);
                        DataInputStream in = new DataInputStream(sockets[TeradataInternalFastloadOutputFormat.this.readyConnCount++].getInputStream());
                        String command = in.readUTF();
                        if (!command.contains(MSG_FASTLOAD_CONNECTION_READY)) {
                            this.logger.debug((Object)("Received failure message from mapper: " + command));
                            throw new ConnectorException(22002);
                        }
                        this.logger.debug((Object)("Received fastload ready message from mapper (" + TeradataInternalFastloadOutputFormat.this.readyConnCount + "/" + taskCount + ")"));
                    }
                    catch (SocketTimeoutException e) {
                        long endTime = System.currentTimeMillis();
                        if (endTime - startTime < timeoutValue) continue;
                        throw new ConnectorException(22003);
                    }
                }
                this.logger.debug((Object)"Setting DBS session dateform = integerdate");
                Statement statement = lsnConnection.createStatement();
                statement.executeUpdate(SQL_FASTLOAD_DATAFORM);
                String outputDatabase = TeradataPlugInConfiguration.getOutputDatabase(configuration);
                String errorTableDatabase = TeradataPlugInConfiguration.getOutputErrorTableDatabase(configuration);
                if (errorTableDatabase.isEmpty()) {
                    errorTableDatabase = outputDatabase;
                }
                String errorTable1 = TeradataConnection.getQuotedEscapedName(errorTableDatabase, TeradataPlugInConfiguration.getOutputErrorTable1Name(configuration));
                String errorTable2 = TeradataConnection.getQuotedEscapedName(errorTableDatabase, TeradataPlugInConfiguration.getOutputErrorTable2Name(configuration));
                String outputTableName = TeradataPlugInConfiguration.getOutputTable(configuration);
                outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
                String beginLoading = SQL_BEGIN_LOADING + " " + outputTableName + " ERRORFILES " + errorTable1 + ", " + errorTable2 + " WITH INTERVAL";
                this.logger.debug((Object)("Executing beginloading command: " + beginLoading));
                statement.execute(beginLoading);
                lsnConnection.setAutoCommit(false);
                TeradataTableDesc targetTableDesc = TeradataSchemaUtils.tableDescFromText(TeradataPlugInConfiguration.getOutputTableDesc(configuration));
                TeradataColumnDesc[] fieldDescs = targetTableDesc.getColumns();
                String[] fieldTypes4Using = new String[fieldDescs.length];
                String[] fieldNames = new String[fieldDescs.length];
                int lowestScale = 6;
                for (index = 0; index < fieldDescs.length; ++index) {
                    fieldDesc = fieldDescs[index];
                    if (fieldDesc.getType() != 92 && fieldDesc.getType() != 93 || fieldDesc.getScale() >= lowestScale) continue;
                    lowestScale = fieldDesc.getScale();
                }
                for (index = 0; index < fieldDescs.length; ++index) {
                    fieldDesc = fieldDescs[index];
                    fieldNames[index] = fieldDesc.getName();
                    fieldTypes4Using[index] = fieldDesc.getTypeString4Using(TeradataInternalFastloadOutputFormat.this.charset, lowestScale);
                }
                String usingInsertSQL = TeradataConnection.getUsingSQL(outputTableName, fieldNames, fieldTypes4Using, TeradataInternalFastloadOutputFormat.this.charset);
                this.logger.info((Object)usingInsertSQL);
                this.logger.debug((Object)("Executing using insert command: " + usingInsertSQL));
                statement.executeUpdate(usingInsertSQL);
                statement.close();
                TeradataInternalFastloadOutputFormat.this.readyConnCount = 0;
                server.setSoTimeout(0);
                this.logger.debug((Object)"Signaling to mappers to begin fastload transfer");
                while (TeradataInternalFastloadOutputFormat.this.readyConnCount < taskCount) {
                    DataOutputStream out = new DataOutputStream(sockets[TeradataInternalFastloadOutputFormat.this.readyConnCount++].getOutputStream());
                    out.writeUTF(MSG_FASTLOAD_TRANSFER_BEGIN);
                    out.flush();
                }
                TeradataInternalFastloadOutputFormat.this.readyConnCount = 0;
                while (TeradataInternalFastloadOutputFormat.this.readyConnCount < taskCount) {
                    sockets[TeradataInternalFastloadOutputFormat.this.readyConnCount++].close();
                }
                i = 0;
            }
            catch (SQLException e) {
                try {
                    throw new ConnectorException(e.getMessage(), e);
                    catch (IOException e2) {
                        throw new ConnectorException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    int i2 = 0;
                    while (true) {
                        if (i2 >= sockets.length) {
                            throw throwable;
                        }
                        TeradataInternalFastloadOutputFormat.this.closeSocket(sockets[i2]);
                        sockets[i2] = null;
                        ++i2;
                    }
                }
            }
            while (i < sockets.length) {
                TeradataInternalFastloadOutputFormat.this.closeSocket(sockets[i]);
                sockets[i] = null;
                ++i;
            }
            return;
        }

        private void sendPingMsg(DataOutputStream[] outs) throws IOException {
            for (int i = 0; i < outs.length; ++i) {
                if (outs[i] == null) continue;
                outs[i].writeUTF(MSG_FASTLOAD_PING);
                outs[i].flush();
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void endLoading(int taskCount, ServerSocket server) throws ConnectorException {
            int i;
            Socket[] sockets = new Socket[taskCount];
            try {
                DataOutputStream[] outs = new DataOutputStream[taskCount];
                server.setSoTimeout(SOCKET_PING_TIME_OUT);
                TeradataInternalFastloadOutputFormat.this.readyTaskCount = 0;
                while (TeradataInternalFastloadOutputFormat.this.readyTaskCount < taskCount) {
                    if (!TeradataInternalFastloadOutputFormat.getJobStatus()) {
                        this.logger.debug((Object)"TeradataInternalFastloadProcessor.jobSuccess is false");
                        throw new ConnectorException(22002);
                    }
                    try {
                        sockets[TeradataInternalFastloadOutputFormat.this.readyTaskCount] = server.accept();
                        sockets[TeradataInternalFastloadOutputFormat.this.readyTaskCount].setTcpNoDelay(true);
                    }
                    catch (SocketTimeoutException e) {
                        this.sendPingMsg(outs);
                        continue;
                    }
                    DataInputStream in = new DataInputStream(sockets[TeradataInternalFastloadOutputFormat.this.readyTaskCount].getInputStream());
                    outs[TeradataInternalFastloadOutputFormat.this.readyTaskCount] = new DataOutputStream(sockets[TeradataInternalFastloadOutputFormat.this.readyTaskCount].getOutputStream());
                    String command = in.readUTF();
                    if (!command.contains(MSG_FASTLOAD_TRANSFER_END)) {
                        this.logger.debug((Object)("Received failure message from mapper: " + command));
                        throw new ConnectorException(22002);
                    }
                    ++TeradataInternalFastloadOutputFormat.this.readyTaskCount;
                    this.logger.debug((Object)("Received fastload complete message from mapper (" + TeradataInternalFastloadOutputFormat.this.readyConnCount + "/" + taskCount + ")"));
                }
                server.setSoTimeout(0);
                Statement statement = lsnConnection.createStatement();
                this.logger.debug((Object)("Executing checkpoint loading command " + SQL_CHECKPOINT_LOADING_END));
                statement.executeUpdate(SQL_CHECKPOINT_LOADING_END);
                lsnConnection.commit();
                this.logger.debug((Object)("Executing end loading command: " + SQL_END_LOADING));
                statement.executeUpdate(SQL_END_LOADING);
                lsnConnection.commit();
                lsnConnection.setAutoCommit(true);
                statement.close();
                this.logger.debug((Object)"Signaling to mappers fastload transfer is complete");
                TeradataInternalFastloadOutputFormat.this.readyTaskCount = 0;
                while (TeradataInternalFastloadOutputFormat.this.readyTaskCount < taskCount) {
                    outs[TeradataInternalFastloadOutputFormat.this.readyTaskCount].writeUTF(MSG_FASTLOAD_CONNECTION_CLOSE);
                    outs[TeradataInternalFastloadOutputFormat.this.readyTaskCount].flush();
                    ++TeradataInternalFastloadOutputFormat.this.readyTaskCount;
                }
                TeradataInternalFastloadOutputFormat.this.readyTaskCount = 0;
                while (TeradataInternalFastloadOutputFormat.this.readyTaskCount < taskCount) {
                    sockets[TeradataInternalFastloadOutputFormat.this.readyTaskCount++].close();
                }
                i = 0;
            }
            catch (SQLException e) {
                try {
                    throw new ConnectorException(e.getMessage(), e);
                    catch (IOException e2) {
                        throw new ConnectorException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    int i2 = 0;
                    while (true) {
                        if (i2 >= sockets.length) {
                            throw throwable;
                        }
                        TeradataInternalFastloadOutputFormat.this.closeSocket(sockets[i2]);
                        sockets[i2] = null;
                        ++i2;
                    }
                }
            }
            while (i < sockets.length) {
                TeradataInternalFastloadOutputFormat.this.closeSocket(sockets[i]);
                sockets[i] = null;
                ++i;
            }
            return;
        }
    }
}

