/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.sample.plugin.converter;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorConverter;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.sample.plugin.converter.CommonDBDataTypeDefinition;
import com.teradata.connector.sample.plugin.utils.CommonDBConfiguration;
import com.teradata.connector.sample.plugin.utils.CommonDBSchemaUtils;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class CommonDBConverter
extends ConnectorConverter {
    protected static final int NUMBER_PRECISION_MAX = 38;
    protected TeradataTableDesc targetTableDesc = null;
    protected ConnectorRecordSchema targetRecordSchema = null;
    protected ConnectorRecordSchema sourceRecordSchema = null;
    protected int columnCount = 0;
    protected ConnectorDataTypeConverter[] dataTypeConverters = null;
    protected Configuration configuration;
    protected ConnectorRecord targetRecord = null;

    @Override
    public ConnectorDataTypeConverter[] lookupConverter(Configuration configuraion, ConnectorRecordSchema sourceRecordSchema) throws ConnectorException {
        TeradataColumnDesc[] teradataColumnDescs = this.targetTableDesc.getColumns();
        this.dataTypeConverters = new ConnectorDataTypeConverter[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                int sourceType = sourceRecordSchema == null ? 12 : sourceRecordSchema.getFieldType(i);
                int targetType = teradataColumnDescs[i].getType();
                TeradataColumnDesc targetColumnDesc = this.targetTableDesc.getColumn(i);
                if (sourceType == 1883) {
                    this.dataTypeConverters[i] = ConnectorSchemaUtils.lookupUDF(sourceRecordSchema, i);
                    if (this.dataTypeConverters[i] != null) continue;
                    throw new ConnectorException(11001);
                }
                this.dataTypeConverters[i] = this.lookupDataTypeConverter(sourceType, targetType, i, targetColumnDesc);
                boolean nullable = targetColumnDesc.isNullable();
                this.dataTypeConverters[i].setNullable(nullable);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        this.targetRecord = new ConnectorRecord(this.columnCount);
        return this.dataTypeConverters;
    }

    @Override
    public void lookupConverter(ConnectorRecordSchema sourceRecordSchema) throws ConnectorException {
        this.dataTypeConverters = this.lookupConverter(this.configuration, sourceRecordSchema);
    }

    @Override
    public ConnectorRecord convert(ConnectorRecord sourceRecord) throws ConnectorException {
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                this.targetRecord.set(i, this.dataTypeConverters[i].convert(sourceRecord.get(i)));
                continue;
            }
            catch (ConnectorException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        return this.targetRecord;
    }

    @Override
    public void initialize(JobContext context) throws ConnectorException {
        this.configuration = context.getConfiguration();
        this.sourceRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(this.configuration));
        this.targetRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(this.configuration));
        if (this.targetRecordSchema == null || this.targetRecordSchema.getLength() == 0) {
            throw new ConnectorException(14018);
        }
        if (this.sourceRecordSchema != null && this.sourceRecordSchema.getLength() != 0 && this.sourceRecordSchema.getLength() != this.targetRecordSchema.getLength()) {
            throw new ConnectorException(14017);
        }
        this.targetTableDesc = CommonDBSchemaUtils.tableDescFromText(CommonDBConfiguration.getOutputTableDesc(this.configuration));
        this.columnCount = this.targetRecordSchema.getLength();
    }

    protected ConnectorDataTypeConverter lookupDataTypeConverter(int sourceType, int targetType, int index, TeradataColumnDesc targetColumnDesc) throws ConnectorException {
        ConnectorDataTypeConverter converter = new ConnectorDataTypeConverter.ObjectToString();
        block1 : switch (sourceType) {
            case 4: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.IntegerToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.IntegerToLong();
                        converter.setDefaultValue(CommonDBDataTypeDefinition.INTEGER_NULL_VALUE);
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.IntegerToShort();
                        converter.setDefaultValue(CommonDBDataTypeDefinition.INTEGER_NULL_VALUE);
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.IntegerToTinyInt();
                        converter.setDefaultValue(CommonDBDataTypeDefinition.INTEGER_NULL_VALUE);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.IntegerToDouble();
                        converter.setDefaultValue(CommonDBDataTypeDefinition.INTEGER_NULL_VALUE);
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.IntegerToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.IntegerToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.IntegerToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.IntegerToBoolean();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.IntegerToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.INTEGER_NULL_VALUE);
                break;
            }
            case -5: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.LongToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.LongToLong();
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.LongToShort();
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.LongToTinyInt();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.LongToDouble();
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.LongToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.LongToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.LongToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.LongToBoolean();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.LongToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.BIGINT_NULL_VALUE);
                break;
            }
            case 5: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.ShortToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.ShortToLong();
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.ShortToShort();
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.ShortToTinyInt();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.ShortToDouble();
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.ShortToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.ShortToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.ShortToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.ShortToBoolean();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.ShortToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.SMALLINT_NULL_VALUE);
                break;
            }
            case -6: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.TinyIntToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.TinyIntToLong();
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.TinyIntToShort();
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.TinyIntToTinyInt();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.TinyIntToDouble();
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.TinyIntToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.TinyIntToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.TinyIntToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.TinyIntToBoolean();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.TinyIntToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.TINYINT_NULL_VALUE);
                break;
            }
            case 16: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.BooleanToInteger();
                        ((ConnectorDataTypeConverter.BooleanToInteger)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.INTEGER_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToInteger)converter).setDefaultValue(CommonDBDataTypeDefinition.INTEGER_TRUE_VALUE);
                        break block1;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.BooleanToLong();
                        ((ConnectorDataTypeConverter.BooleanToLong)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.LONG_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToLong)converter).setDefaultValue(CommonDBDataTypeDefinition.LONG_TRUE_VALUE);
                        break block1;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.BooleanToShort();
                        ((ConnectorDataTypeConverter.BooleanToShort)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.INTEGER_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToShort)converter).setDefaultValue(CommonDBDataTypeDefinition.INTEGER_TRUE_VALUE);
                        break block1;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.BooleanToTinyInt();
                        ((ConnectorDataTypeConverter.BooleanToTinyInt)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.INTEGER_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToTinyInt)converter).setDefaultValue(CommonDBDataTypeDefinition.INTEGER_TRUE_VALUE);
                        break block1;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.BooleanToDouble();
                        ((ConnectorDataTypeConverter.BooleanToDouble)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.DOUBLE_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToDouble)converter).setDefaultValue(CommonDBDataTypeDefinition.DOUBLE_TRUE_VALUE);
                        break block1;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.BooleanToBigDecimal();
                        ((ConnectorDataTypeConverter.BooleanToBigDecimal)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.BIGDECIMAL_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToBigDecimal)converter).setDefaultValue(CommonDBDataTypeDefinition.BIGDECIMAL_TRUE_VALUE);
                        break block1;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.BooleanToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setFalseDefaultValue(CommonDBDataTypeDefinition.BIGDECIMAL_FALSE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setDefaultValue(CommonDBDataTypeDefinition.BIGDECIMAL_TRUE_VALUE);
                        ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        ((ConnectorDataTypeConverter.BooleanToBigDecimalWithScale)converter).setPrecision(targetColumnDesc.getPrecision());
                        break block1;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BooleanToString();
                        break block1;
                    }
                }
                throw new ConnectorException(14007);
            }
            case 6: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.FloatToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.FloatToLong();
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.FloatToShort();
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.FloatToTinyInt();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.FloatToDouble();
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.FloatToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.FloatToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.FloatToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        ((ConnectorDataTypeConverter.FloatToBigDecimalWithScale)converter).setPrecision(targetColumnDesc.getPrecision());
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.FloatToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.FLOAT_NULL_VALUE);
                break;
            }
            case 7: 
            case 8: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.DoubleToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.DoubleToLong();
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.DoubleToShort();
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.DoubleToTinyInt();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.DoubleToDouble();
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.DoubleToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.DoubleToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.DoubleToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.DoubleToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.DOUBLE_NULL_VALUE);
                break;
            }
            case 2: 
            case 3: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToInteger();
                        break;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToLong();
                        break;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToShort();
                        break;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToTinyInt();
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToDouble();
                        break;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToBigDecimal();
                        break;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.BigDecimalToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BigDecimalToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.BIGDECIMAL_NULL_VALUE);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                switch (targetType) {
                    case 4: {
                        converter = new ConnectorDataTypeConverter.StringToInteger();
                        break block1;
                    }
                    case -5: {
                        converter = new ConnectorDataTypeConverter.StringToLong();
                        break block1;
                    }
                    case 5: {
                        converter = new ConnectorDataTypeConverter.StringToShort();
                        break block1;
                    }
                    case -6: {
                        converter = new ConnectorDataTypeConverter.StringToTinyInt();
                        break block1;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        converter = new ConnectorDataTypeConverter.StringToDouble();
                        break block1;
                    }
                    case 2: {
                        converter = new ConnectorDataTypeConverter.StringToBigDecimal();
                        break block1;
                    }
                    case 3: {
                        converter = new ConnectorDataTypeConverter.StringToBigDecimalWithScale();
                        ((ConnectorDataTypeConverter.StringToBigDecimalWithScale)converter).setScale(targetColumnDesc.getScale());
                        break block1;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.StringToString();
                        break block1;
                    }
                    case 16: {
                        converter = new ConnectorDataTypeConverter.StringToBoolean();
                        break block1;
                    }
                    case 91: {
                        converter = new ConnectorDataTypeConverter.StringToDate();
                        break block1;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.StringToTime();
                        break block1;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.StringToTimestamp();
                        break block1;
                    }
                    case 2002: {
                        converter = new ConnectorDataTypeConverter.StringToPeriod();
                        break block1;
                    }
                    case 1111: {
                        converter = new ConnectorDataTypeConverter.StringToInterval();
                        break block1;
                    }
                    case -3: 
                    case -2: {
                        converter = new ConnectorDataTypeConverter.StringToBinary();
                        break block1;
                    }
                }
                throw new ConnectorException(14007);
            }
            case 91: {
                switch (targetType) {
                    case 91: {
                        converter = new ConnectorDataTypeConverter.DateToDate();
                        break block1;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.DateToTimestamp();
                        break block1;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.DateToString();
                        break block1;
                    }
                }
                throw new ConnectorException(14007);
            }
            case 92: {
                switch (targetType) {
                    case 92: {
                        converter = new ConnectorDataTypeConverter.TimeToTime();
                        break block1;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.TimeToString();
                        break block1;
                    }
                }
                throw new ConnectorException(14007);
            }
            case 93: {
                switch (targetType) {
                    case 91: {
                        converter = new ConnectorDataTypeConverter.TimestampToDate();
                        break block1;
                    }
                    case 92: {
                        converter = new ConnectorDataTypeConverter.TimestampToTime();
                        break block1;
                    }
                    case 93: {
                        converter = new ConnectorDataTypeConverter.TimestampToTimestamp();
                        break block1;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.TimestampToString();
                        break block1;
                    }
                }
                throw new ConnectorException(14007);
            }
            case 2005: {
                switch (targetType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.ClobToString();
                        break block1;
                    }
                }
                throw new ConnectorException(14007);
            }
            case 2004: {
                switch (targetType) {
                    case -2: {
                        converter = new ConnectorDataTypeConverter.BlobToBinary();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2004: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BlobToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.BINARY_NULL_VALUE);
                break;
            }
            case -3: 
            case -2: {
                switch (targetType) {
                    case -3: 
                    case -2: 
                    case 2004: {
                        converter = new ConnectorDataTypeConverter.BinaryToBinary();
                        break;
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.BinaryToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue(CommonDBDataTypeDefinition.BINARY_NULL_VALUE);
                break;
            }
            case 2002: {
                switch (targetType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2002: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.PeriodToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue("");
                break;
            }
            case 1111: {
                switch (targetType) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 1111: 
                    case 2005: {
                        converter = new ConnectorDataTypeConverter.IntervalToString();
                        break;
                    }
                    default: {
                        throw new ConnectorException(14007);
                    }
                }
                converter.setDefaultValue("");
                break;
            }
            case 1883: {
                try {
                    Constructor<?>[] constructors;
                    String[] parameters = this.sourceRecordSchema.getParameters(index);
                    int length = this.sourceRecordSchema.getParameters(index).length;
                    Object[] objects = new Object[length];
                    for (Constructor<?> constructor : constructors = Class.forName(this.sourceRecordSchema.getDataTypeConverter(index)).getConstructors()) {
                        Class<?>[] parameterClasses = constructor.getParameterTypes();
                        if (parameterClasses.length != length) continue;
                        for (int i = 0; i < length; ++i) {
                            objects[i] = parameterClasses[i].cast(parameters[i]);
                        }
                        converter = (ConnectorDataTypeConverter)constructor.newInstance(objects);
                        break block1;
                    }
                    break;
                }
                catch (InstantiationException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
            }
        }
        return converter;
    }

    @Override
    public Map<Integer, Boolean> initializeNullable() throws ConnectorException {
        return null;
    }

    @Override
    public Map<Integer, Object> initializeDefaultValue() throws ConnectorException {
        return null;
    }

    @Override
    public Map<Integer, Object> initializeFalseDefaultValue() throws ConnectorException {
        return null;
    }

    @Override
    public Map<Integer, Object> initializeTrueDefaultValue() throws ConnectorException {
        return null;
    }
}

