/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.idatastream.utils;

import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import org.apache.hadoop.conf.Configuration;

public class IDataStreamPlugInConfiguration {
    protected static final String TDCH_OUTPUT_IDATASTREAM_SOCKET_HOST = "tdch.output.idatastream.socket.host";
    protected static final String TDCH_OUTPUT_IDATASTREAM_SOCKET_PORT = "tdch.output.idatastream.socket.port";
    protected static final String TDCH_OUTPUT_IDATASTREAM_FIELD_TYPES = "tdch.output.idatastream.schema.types";
    protected static final String TDCH_OUTPUT_IDATASTREAM_FIELD_TYPES_JSON = "tdch.output.idatastream.schema.types.json";
    protected static final String TDCH_OUTPUT_IDATASTREAM_FIELD_NAMES = "tdch.output.idatastream.schema.names";
    protected static final String TDCH_OUTPUT_IDATASTREAM_FIELD_NAMES_JSON = "tdch.output.idatastream.schema.names.json";
    protected static final String TDCH_OUTPUT_IDATASTREAM_LE_SERVER = "tdch.output.idatastream.le.server";
    protected static final String TDCH_INPUT_IDATASTREAM_SOCKET_HOST = "tdch.input.idatastream.socket.host";
    protected static final String TDCH_INPUT_IDATASTREAM_SOCKET_PORT = "tdch.input.idatastream.socket.port";
    protected static final String TDCH_INPUT_IDATASTREAM_FIELD_TYPES = "tdch.input.idatastream.schema.types";
    protected static final String TDCH_INPUT_IDATASTREAM_FIELD_TYPES_JSON = "tdch.input.idatastream.schema.types.json";
    protected static final String TDCH_INPUT_IDATASTREAM_FIELD_NAMES = "tdch.input.idatastream.schema.names";
    protected static final String TDCH_INPUT_IDATASTREAM_FIELD_NAMES_JSON = "tdch.input.idatastream.schema.names.json";
    protected static final String TDCH_INPUT_IDATASTREAM_LE_SERVER = "tdch.input.idatastream.le.server";
    public static final String VALUE_IDATASTREAM_METHOD = "idata.stream";

    public static void setOutputSocketHost(Configuration configuration, String iDataStreamSocketHost) {
        configuration.set(TDCH_OUTPUT_IDATASTREAM_SOCKET_HOST, iDataStreamSocketHost);
    }

    public static String getOutputSocketHost(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_IDATASTREAM_SOCKET_HOST, "");
    }

    public static void setOutputSocketPort(Configuration configuration, String tptSocketPort) {
        configuration.set(TDCH_OUTPUT_IDATASTREAM_SOCKET_PORT, tptSocketPort);
    }

    public static String getOutputSocketPort(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_IDATASTREAM_SOCKET_PORT, "");
    }

    public static void setOutputFieldNames(Configuration configuration, String fieldNames) {
        String quotedFieldNames = ConnectorSchemaUtils.quoteFieldNames(fieldNames);
        configuration.set(TDCH_OUTPUT_IDATASTREAM_FIELD_NAMES, quotedFieldNames);
        String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(fieldNames);
        fieldNamesArray = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNamesArray);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNamesArray);
        configuration.set(TDCH_OUTPUT_IDATASTREAM_FIELD_NAMES_JSON, fieldNamesJson);
    }

    public static String getOutputFieldNames(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_OUTPUT_IDATASTREAM_FIELD_NAMES, "");
        return fieldNamesJson;
    }

    public static String[] getOutputFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_OUTPUT_IDATASTREAM_FIELD_NAMES_JSON, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setOutputFieldTypes(Configuration configuration, String fieldTypes) {
        String quotedFieldTypes = ConnectorSchemaUtils.quoteFieldNames(fieldTypes);
        configuration.set(TDCH_OUTPUT_IDATASTREAM_FIELD_TYPES, quotedFieldTypes);
        String[] fieldTypesArray = ConnectorSchemaUtils.convertFieldNamesToArray(fieldTypes);
        fieldTypesArray = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldTypesArray);
        String fieldTypesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldTypesArray);
        configuration.set(TDCH_OUTPUT_IDATASTREAM_FIELD_TYPES_JSON, fieldTypesJson);
    }

    public static String getOutputFieldTypes(Configuration configuration) {
        String fieldTypesJson = configuration.get(TDCH_OUTPUT_IDATASTREAM_FIELD_TYPES, "");
        return fieldTypesJson;
    }

    public static String[] getOutputFieldTypesArray(Configuration configuration) {
        String fieldTypesJson = configuration.get(TDCH_OUTPUT_IDATASTREAM_FIELD_TYPES_JSON, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldTypesJson);
    }

    public static void setOutputLittleEndianServer(Configuration configuration, String tptLittleEndianServer) {
        configuration.set(TDCH_OUTPUT_IDATASTREAM_LE_SERVER, tptLittleEndianServer);
    }

    public static String getOutputLittleEndianServer(Configuration configuration) {
        return configuration.get(TDCH_OUTPUT_IDATASTREAM_LE_SERVER, "");
    }

    public static void setInputSocketHost(Configuration configuration, String tptSocketHost) {
        configuration.set(TDCH_INPUT_IDATASTREAM_SOCKET_HOST, tptSocketHost);
    }

    public static String getInputSocketHost(Configuration configuration) {
        return configuration.get(TDCH_INPUT_IDATASTREAM_SOCKET_HOST, "");
    }

    public static void setInputSocketPort(Configuration configuration, String tptSocketPort) {
        configuration.set(TDCH_INPUT_IDATASTREAM_SOCKET_PORT, tptSocketPort);
    }

    public static String getInputSocketPort(Configuration configuration) {
        return configuration.get(TDCH_INPUT_IDATASTREAM_SOCKET_PORT, "");
    }

    public static void setInputFieldNames(Configuration configuration, String fieldNames) {
        String quotedFieldNames = ConnectorSchemaUtils.quoteFieldNames(fieldNames);
        configuration.set(TDCH_INPUT_IDATASTREAM_FIELD_NAMES, quotedFieldNames);
        String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(fieldNames);
        fieldNamesArray = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNamesArray);
        String fieldNamesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldNamesArray);
        configuration.set(TDCH_INPUT_IDATASTREAM_FIELD_NAMES_JSON, fieldNamesJson);
    }

    public static String getInputFieldNames(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_INPUT_IDATASTREAM_FIELD_NAMES, "");
        return fieldNamesJson;
    }

    public static String[] getInputFieldNamesArray(Configuration configuration) {
        String fieldNamesJson = configuration.get(TDCH_INPUT_IDATASTREAM_FIELD_NAMES_JSON, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldNamesJson);
    }

    public static void setInputFieldTypes(Configuration configuration, String fieldTypes) {
        String quotedFieldTypes = ConnectorSchemaUtils.quoteFieldNames(fieldTypes);
        configuration.set(TDCH_INPUT_IDATASTREAM_FIELD_TYPES, quotedFieldTypes);
        String[] fieldTypesArray = ConnectorSchemaUtils.convertFieldNamesToArray(fieldTypes);
        fieldTypesArray = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldTypesArray);
        String fieldTypesJson = ConnectorSchemaUtils.fieldNamesToJson(fieldTypesArray);
        configuration.set(TDCH_INPUT_IDATASTREAM_FIELD_TYPES_JSON, fieldTypesJson);
    }

    public static String getInputFieldTypes(Configuration configuration) {
        String fieldTypesJson = configuration.get(TDCH_INPUT_IDATASTREAM_FIELD_TYPES, "");
        return fieldTypesJson;
    }

    public static String[] getInputFieldTypesArray(Configuration configuration) {
        String fieldTypesJson = configuration.get(TDCH_INPUT_IDATASTREAM_FIELD_TYPES_JSON, "");
        return ConnectorSchemaUtils.fieldNamesFromJson(fieldTypesJson);
    }

    public static void setInputLittleEndianServer(Configuration configuration, String tptLittleEndianServer) {
        configuration.set(TDCH_INPUT_IDATASTREAM_LE_SERVER, tptLittleEndianServer);
    }

    public static String getInputLittleEndianServer(Configuration configuration) {
        return configuration.get(TDCH_INPUT_IDATASTREAM_LE_SERVER, "");
    }
}

