/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.idatastream;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class IDataStreamImportServer
implements Runnable {
    protected int port = 5555;
    protected int nummappers = 1;
    protected String inputdatafile = "internal";
    protected String[] inputdatafiles;
    protected String outputdatafile = "internal";
    protected String[] outputdatafiles;
    protected String schema = "int,varchar";
    protected Socket[] execSockets = null;
    protected int numRows = 10;
    protected boolean noNulls = true;
    protected ServerSocket serverSocket = null;

    public static void main(String[] args) {
        boolean completed;
        IDataStreamImportServer server = null;
        if (args.length >= 7) {
            boolean noNulls;
            int nummappers;
            int port;
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                port = 5555;
            }
            try {
                nummappers = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                nummappers = 2;
            }
            String direction2 = args[2];
            String inputdatafile = args[3];
            String outputdatafile = args[4];
            String schema = args[5];
            int numRows = Integer.parseInt(args[6]);
            boolean bl = noNulls = "true".equals(args[7]);
            if (direction2.equals("import")) {
                server = new IDataStreamImportServer(port, nummappers, inputdatafile, outputdatafile, schema, numRows, noNulls);
            } else {
                IDataStreamImportServer Iserver;
                IDataStreamImportServer iDataStreamImportServer = Iserver = new IDataStreamImportServer(port, nummappers, inputdatafile, outputdatafile, schema, numRows, noNulls);
                iDataStreamImportServer.getClass();
                server = iDataStreamImportServer.new IDataStreamExportServer(port, nummappers, outputdatafile);
            }
        } else {
            server = new IDataStreamImportServer();
        }
        ExecutorService exe = Executors.newSingleThreadExecutor();
        exe.execute(server);
        exe.shutdown();
        try {
            completed = exe.awaitTermination(200L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            completed = false;
        }
        if (completed) {
            System.out.println("IDataStreami(Import|Export)Server shutdown gracefully");
        } else {
            System.out.println("IDataStream(Import|Export)Server shutdown by timeout/interruption");
            exe.shutdownNow();
            server.shutdownServer();
        }
    }

    public IDataStreamImportServer() {
    }

    public IDataStreamImportServer(int port, int nummappers, String inputdatafile, String outputdatafile, String schema, int numRows, boolean noNulls) {
        this.port = port;
        this.nummappers = nummappers;
        this.inputdatafile = inputdatafile;
        this.inputdatafiles = inputdatafile.split(",");
        this.outputdatafile = outputdatafile;
        this.schema = schema;
        this.execSockets = new Socket[nummappers];
        this.numRows = numRows;
        this.noNulls = noNulls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.inputdatafile.equals("internal") && this.inputdatafiles.length != this.nummappers) {
            System.out.println("User must supply input files for all mappers");
            return;
        }
        ExecutorService exe = Executors.newFixedThreadPool(this.nummappers);
        try {
            boolean completed;
            if (!this.outputdatafile.equals("internal")) {
                this.serverSocket = new ServerSocket(this.port);
            }
            for (int i = 0; i < this.nummappers; ++i) {
                InputStream is = this.inputdatafile.equals("internal") ? new IDataStreamGenerator(i, this.schema, this.numRows, this.noNulls) : new FileInputStream(this.inputdatafile);
                ArrayList<OutputStream> oss = new ArrayList<OutputStream>();
                if (this.outputdatafile.equals("internal")) {
                    oss.add(new FileOutputStream("part_m_00000" + i));
                } else {
                    Socket s;
                    oss.add(new FileOutputStream("part_m_00000" + i));
                    System.out.println("Waiting for " + (this.nummappers - i) + " incoming connections");
                    this.execSockets[i] = s = this.serverSocket.accept();
                    oss.add(s.getOutputStream());
                }
                exe.execute(new DataWriter(i, is, oss));
            }
            exe.shutdown();
            try {
                completed = exe.awaitTermination(50L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                completed = false;
            }
            if (completed) {
                System.out.println("DataWriters shutdown gracefully");
            } else {
                System.out.println("DataWriters shutdown by timeout/interruption");
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (!this.outputdatafile.equals("internal") && this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void dataWriterComplete(int id) {
        System.out.println("Datawriter " + id + " complete");
        try {
            if (!this.outputdatafile.equals("internal")) {
                while (this.execSockets[id].getInputStream().read() != -1) {
                    Thread.sleep(5000L);
                }
                this.execSockets[id].close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdownServer() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class IDataStreamGenerator
    extends InputStream {
        private int id = 0;
        private int numCols = 0;
        private int numRows = 0;
        private int rowCount = 0;
        private DataGen[] gens = null;
        private boolean noNulls = false;
        private boolean[] nulCols = null;
        private BitSet bitset = null;
        private int curCol = 0;
        private int rowSize = 0;
        private int indByteSize = 0;
        private Random rand = null;

        public IDataStreamGenerator() {
        }

        public IDataStreamGenerator(int id, String schema, int numRows, boolean noNulls) {
            this.id = id;
            String[] cols = schema.split(",");
            this.numCols = cols.length;
            this.numRows = numRows;
            this.noNulls = noNulls;
            this.nulCols = new boolean[this.numCols];
            Arrays.fill(this.nulCols, false);
            this.rand = new Random();
            this.indByteSize = (int)Math.ceil((float)this.numCols / 8.0f);
            this.bitset = new BitSet(this.indByteSize * 8);
            System.out.println("Bitset initialized with length " + this.indByteSize * 8);
            this.gens = new DataGen[this.numCols];
            for (int i = 0; i < this.numCols; ++i) {
                try {
                    String classname = "IDataStreamImportServer$IDataStreamGenerator$" + cols[i].toLowerCase() + "Gen";
                    Constructor<?>[] meth = Class.forName(classname).getConstructors();
                    this.gens[i] = (DataGen)meth[0].newInstance(this);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] buffer, int offset, int size) {
            if (this.rowCount == this.numRows) {
                return -1;
            }
            String nulColS = "";
            int curSize = 0;
            if (this.curCol == 0) {
                int i;
                if (!this.noNulls) {
                    for (i = 0; i < this.numCols; ++i) {
                        this.nulCols[i] = this.rand.nextInt(4) == 3;
                        this.bitset.set(i, this.nulCols[i]);
                    }
                }
                this.rowSize = 0;
                for (i = 0; i < this.numCols; ++i) {
                    this.rowSize += this.gens[i].getSize(this.nulCols[i]);
                    nulColS = !this.nulCols[i] ? nulColS + "notnull," : nulColS + "null,";
                }
                this.rowSize += this.indByteSize;
                nulColS = "";
                if (this.bitset.isEmpty()) {
                    nulColS = "00";
                } else {
                    System.out.println("Bitlength is " + this.bitset.length());
                    for (i = 0; i < this.indByteSize; ++i) {
                        nulColS = nulColS + String.format("%02x", this.bitsetToByteArray(this.bitset)[i]);
                    }
                }
                System.out.println("DSG" + this.id + ": Writing record " + this.rowCount + ", column 0, size " + this.rowSize + ", indicator bytes are " + nulColS);
                if (offset + 2 + this.indByteSize < size) {
                    System.arraycopy(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.rowSize).array(), 0, buffer, offset, 2);
                    System.arraycopy(this.bitsetToByteArray(this.bitset), 0, buffer, offset + 2, this.indByteSize);
                    curSize = 2 + this.indByteSize;
                } else {
                    return -1;
                }
            }
            byte[] data = this.gens[this.curCol].genData();
            while (offset + curSize + data.length < size) {
                System.arraycopy(data, 0, buffer, offset + curSize, data.length);
                curSize += data.length;
                data = null;
                if (++this.curCol == this.numCols) {
                    int i;
                    buffer[curSize++] = 10;
                    this.curCol = 0;
                    if (++this.rowCount == this.numRows) {
                        System.arraycopy("EOD".getBytes(), 0, buffer, offset + curSize, 3);
                        curSize += 3;
                        break;
                    }
                    if (!this.noNulls) {
                        for (i = 0; i < this.numCols; ++i) {
                            this.nulCols[i] = this.rand.nextInt(4) == 3;
                            this.bitset.set(i, this.nulCols[i]);
                        }
                    }
                    this.rowSize = 0;
                    for (i = 0; i < this.numCols; ++i) {
                        this.rowSize += this.gens[i].getSize(this.nulCols[i]);
                    }
                    this.rowSize += this.indByteSize;
                    nulColS = "";
                    if (this.bitset.isEmpty()) {
                        nulColS = "00";
                    } else {
                        for (i = 0; i < this.indByteSize; ++i) {
                            nulColS = nulColS + String.format("%02x", this.bitsetToByteArray(this.bitset)[i]);
                        }
                    }
                    System.out.println("DSG" + this.id + ": Writing record #" + this.rowCount + " size " + this.rowSize + ", indicator bytes are " + nulColS);
                    if (offset + curSize + 2 + this.indByteSize + this.rowSize < size) {
                        System.arraycopy(ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)this.rowSize).array(), 0, buffer, offset + curSize, 2);
                        System.arraycopy(this.bitsetToByteArray(this.bitset), 0, buffer, offset + curSize + 2, this.indByteSize);
                        curSize += 2 + this.indByteSize;
                    } else {
                        System.out.println("Just kidding, not writing that record (or its header bytes to the output stream");
                        break;
                    }
                }
                data = this.gens[this.curCol].genData();
            }
            return curSize == 0 ? -1 : curSize;
        }

        private byte[] bitsetToByteArray(BitSet bits) {
            byte[] bytes = new byte[(bits.size() + 7) / 8];
            for (int i = 0; i < bits.size(); ++i) {
                if (!bits.get(i)) continue;
                int n = i / 8;
                bytes[n] = (byte)(bytes[n] | 1 << 7 - i % 8);
            }
            return bytes;
        }

        public class varcharGen
        extends DataGen {
            private static final int MAX_VARCHAR_SIZE = 20;
            private byte[] buffer;

            public varcharGen() {
                this.buffer = null;
            }

            @Override
            public int getSize(boolean isNull) {
                int datasize = 0;
                datasize = isNull ? 0 : 1 + ((DataGen)this).r.nextInt(19);
                System.out.println("Generating string of size " + datasize + ", isNull is " + isNull);
                this.buffer = new byte[datasize + 2];
                byte[] dsize = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)datasize).array();
                System.out.println(String.format("Size bytes are %02x%02x", dsize[0], dsize[1]));
                Arrays.fill(this.buffer, (byte)0);
                System.arraycopy(dsize, 0, this.buffer, 0, 2);
                for (int i = 2; i < datasize + 2; ++i) {
                    this.buffer[i] = (byte)(((DataGen)this).r.nextInt(26) + 65);
                }
                String bufstr = "";
                for (int i = 0; i < this.buffer.length; ++i) {
                    bufstr = bufstr + String.format("%02x", this.buffer[i]);
                }
                System.out.println("varchar buffer is " + bufstr);
                return this.buffer.length;
            }

            @Override
            public byte[] genData() {
                return this.buffer;
            }
        }

        public class intGen
        extends DataGen {
            private boolean isNull;

            public intGen() {
                this.isNull = false;
            }

            @Override
            public int getSize(boolean isNull) {
                this.isNull = isNull;
                return 4;
            }

            @Override
            public byte[] genData() {
                int gen = 0;
                gen = this.isNull ? 0 : ((DataGen)this).r.nextInt(1024);
                System.out.println("Generating int " + gen + " of size " + 4);
                return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(gen).array();
            }
        }

        public abstract class DataGen {
            private Random r = new Random();

            public abstract int getSize(boolean var1);

            public abstract byte[] genData();
        }
    }

    private class DataWriter
    implements Runnable {
        private static final int BUFFER_SIZE = 1024;
        private int myID;
        private InputStream inputStream;
        private List<OutputStream> outputStreams;
        private byte[] buffer;

        public DataWriter(int myID, InputStream inputStream, List<OutputStream> outputStreams) {
            this.myID = myID;
            this.inputStream = inputStream;
            this.outputStreams = new ArrayList<OutputStream>();
            for (OutputStream outputStream : outputStreams) {
                this.outputStreams.add(outputStream);
            }
            this.buffer = new byte[1024];
        }

        @Override
        public void run() {
            int bytesRead = 0;
            try {
                bytesRead = this.inputStream.read(this.buffer, 0, 1024);
            }
            catch (Exception e) {
                e.printStackTrace();
                bytesRead = -1;
            }
            while (bytesRead > 0) {
                try {
                    System.out.println("Writing " + bytesRead + " to the output stream");
                    for (OutputStream outputStream : this.outputStreams) {
                        outputStream.write(this.buffer, 0, bytesRead);
                    }
                    bytesRead = this.inputStream.read(this.buffer, 0, 1024);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bytesRead = -1;
                }
            }
            try {
                this.inputStream.close();
                for (OutputStream outputStream : this.outputStreams) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            IDataStreamImportServer.this.dataWriterComplete(this.myID);
        }
    }

    public class IDataStreamExportServer
    extends IDataStreamImportServer
    implements Runnable {
        public IDataStreamExportServer(int port, int nummappers, String outputdatafile) {
            this.port = port;
            this.nummappers = nummappers;
            this.outputdatafile = outputdatafile;
            this.execSockets = new Socket[nummappers];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            this.outputdatafiles = new String[this.nummappers];
            if (this.outputdatafile.equals("internal") || this.outputdatafile.split(",").length != this.nummappers) {
                for (int i2 = 0; i2 < this.nummappers; ++i2) {
                    this.outputdatafiles[i2] = "part_m_00000" + i2 + ".out";
                }
            } else {
                String[] datafiles = this.outputdatafile.split(",");
                for (i = 0; i < this.nummappers; ++i) {
                    this.outputdatafiles[i] = datafiles[i];
                }
            }
            ExecutorService exe = Executors.newFixedThreadPool(this.nummappers);
            try {
                boolean completed;
                this.serverSocket = new ServerSocket(this.port);
                for (i = 0; i < this.nummappers; ++i) {
                    Socket s;
                    System.out.println("Waiting for " + (this.nummappers - i) + " incoming connections for export");
                    this.execSockets[i] = s = this.serverSocket.accept();
                    InputStream is = s.getInputStream();
                    byte[] final_nummappers = new byte[2];
                    is.read(final_nummappers, 0, 2);
                    short fnummappers = ByteBuffer.wrap(final_nummappers).getShort();
                    if (i == 0 && fnummappers != this.nummappers) {
                        this.nummappers = fnummappers;
                        System.out.println(" Updating nummappers with advertised number of mappers.");
                    } else if (fnummappers != this.nummappers) {
                        System.out.println(" Advertised number of mappers is not equal to the defined number of mappers!!!");
                    }
                    FileOutputStream os = new FileOutputStream(this.outputdatafiles[i]);
                    System.out.println("created FOS for " + this.outputdatafiles[i]);
                    ArrayList<OutputStream> oss = new ArrayList<OutputStream>();
                    oss.add(os);
                    exe.execute(new DataWriter(i, is, oss));
                }
                exe.shutdown();
                try {
                    completed = exe.awaitTermination(50L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    completed = false;
                }
                if (completed) {
                    System.out.println("DataWriters shutdown gracefully");
                } else {
                    System.out.println("DataWriters shutdown by timeout/interruption");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void dataWriterComplete(int id) {
            System.out.println("Datawriter " + id + " complete");
            try {
                this.execSockets[id].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

