/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.idatastream;

import com.teradata.connector.common.exception.ConnectorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class IDataStreamConnection {
    private boolean connectionOpen = false;
    private boolean leserver = true;
    private int port = -1;
    private String host = null;
    private Socket socket = null;
    private BufferedOutputStream outputstream = null;
    private BufferedInputStream inputstream = null;

    public IDataStreamConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void connect() throws ConnectorException {
        if (this.connectionOpen) {
            return;
        }
        try {
            this.socket = new Socket(this.host, this.port);
            this.socket.setSoTimeout(0);
            this.outputstream = new BufferedOutputStream(this.socket.getOutputStream());
            this.inputstream = new BufferedInputStream(this.socket.getInputStream());
            this.connectionOpen = true;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
    }

    public void disconnect() throws ConnectorException {
        if (!this.connectionOpen) {
            return;
        }
        try {
            this.outputstream.close();
            this.inputstream.close();
            this.socket.close();
            this.connectionOpen = false;
        }
        catch (Exception e) {
            throw new ConnectorException(e.getMessage());
        }
    }

    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    public InputStream getInputStream() {
        return this.inputstream;
    }

    public boolean isClosed() {
        return !this.connectionOpen;
    }

    public void setLEServer(boolean leserver) {
        this.leserver = leserver;
    }

    public boolean isLEServer() {
        return this.leserver;
    }
}

