/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.idatastream;

import com.teradata.connector.common.exception.ConnectorException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class IDataStreamByteArray
implements Writable {
    int datalen = 0;
    byte[] data = null;

    public IDataStreamByteArray(int datalen) {
        this.datalen = datalen;
        this.data = new byte[datalen];
    }

    public void setByteArray(byte[] data, int offset, int length) throws ConnectorException {
        if (length != this.datalen) {
            throw new ConnectorException(1000);
        }
        System.arraycopy(data, offset, this.data, 0, this.datalen);
    }

    public byte[] getByteArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public void readFields(DataInput in) throws IOException {
        in.readFully(this.data, 0, this.datalen);
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.data);
    }
}

