/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.serde.HiveConnectorSerDe;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveSchemaUtils;
import com.teradata.connector.hive.utils.HiveUtils;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class HiveParquetFileSerDe
extends HiveConnectorSerDe {
    protected static LazyStruct cachedLazyStruct = null;
    protected StructObjectInspector structInspector = null;
    protected ParquetHiveSerDe serde = null;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        super.initialize(context, direction2);
        if (direction2.equals((Object)ConnectorConfiguration.direction.input)) {
            String sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(this.configuration);
            List<String> columns = ConnectorSchemaUtils.parseColumns(sourceTableSchema.toLowerCase());
            List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
            List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
            HiveSchemaUtils.updateNonScaleDecimalColumns(columnTypes);
            this.serde = new ParquetHiveSerDe();
            Properties props = new Properties();
            props.setProperty("columns", HiveUtils.listToString(columnNames));
            props.setProperty("columns.types", HiveUtils.listToString(columnTypes));
            try {
                this.serde.initialize(this.configuration, props);
                this.structInspector = (StructObjectInspector)this.serde.getObjectInspector();
            }
            catch (SerDeException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(context.getConfiguration());
        List<String> columns = ConnectorSchemaUtils.parseColumns(targetTableSchema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        Properties props = new Properties();
        props.setProperty("columns", HiveUtils.listToString(columnNames));
        props.setProperty("columns.types", HiveUtils.listToString(columnTypes));
        this.serde = new ParquetHiveSerDe();
        try {
            this.serde.initialize(context.getConfiguration(), props);
            this.structInspector = (StructObjectInspector)this.serde.getObjectInspector();
        }
        catch (SerDeException e) {
            throw new ConnectorException(e.getMessage());
        }
    }

    @Override
    protected Writable doSerialize(ConnectorRecord r) throws SerDeException {
        try {
            String targetTableSchema = HivePlugInConfiguration.getOutputTableSchema(this.context.getConfiguration());
            List<String> columns = ConnectorSchemaUtils.parseColumns(targetTableSchema.toLowerCase());
            return this.serde.serialize((Object)new ArrayWritable(Writable.class, r.getAllWritableObject(columns)), (ObjectInspector)this.structInspector);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final Object getWritableToPrimitiveTypes(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BooleanWritable) {
            return ((BooleanWritable)object).get();
        }
        if (object instanceof ByteWritable) {
            return ((ByteWritable)object).get();
        }
        if (object instanceof ShortWritable) {
            return ((ShortWritable)object).get();
        }
        if (object instanceof LongWritable) {
            return ((LongWritable)object).get();
        }
        if (object instanceof IntWritable) {
            return ((IntWritable)object).get();
        }
        if (object instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)object).get());
        }
        if (object instanceof DoubleWritable) {
            return ((DoubleWritable)object).get();
        }
        if (object instanceof Text) {
            return ((Text)object).toString();
        }
        if (object instanceof BytesWritable) {
            return ((BytesWritable)object).getBytes();
        }
        if (object instanceof NullWritable) {
            return null;
        }
        return object.toString();
    }

    @Override
    protected ConnectorRecord doDeserialize(Writable w) throws SerDeException {
        ArrayWritable value = (ArrayWritable)w;
        List fields = this.structInspector.getAllStructFieldRefs();
        Object row = this.serde.deserialize((Writable)value);
        for (int i = 0; i < this.nonPartSize; ++i) {
            Object obj = this.structInspector.getStructFieldData(row, (StructField)fields.get(i));
            try {
                this.deserRecord.set(i, HiveParquetFileSerDe.getWritableToPrimitiveTypes(obj));
                continue;
            }
            catch (ConnectorException e) {
                e.printStackTrace();
            }
        }
        return this.deserRecord;
    }
}

