/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.converter;

import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.hive.converter.HiveDataTypeConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;

public class HiveDataTypeConverterTest {
    @Test
    public void testJsonStringToMap() {
        HiveDataTypeConverter.JsonStringToMap hiveconverter = new HiveDataTypeConverter.JsonStringToMap("test", "map<int,int>");
        ConnectorDataTypeConverter.ObjectToJsonString converter = new ConnectorDataTypeConverter.ObjectToJsonString();
        HashMap<Integer, Integer> inputMap = new HashMap<Integer, Integer>();
        inputMap.put(1, 2);
        String input = (String)((ConnectorDataTypeConverter)converter).convert(inputMap);
        Object output = ((ConnectorDataTypeConverter)hiveconverter).convert(input);
        Assert.assertTrue((boolean)inputMap.equals(output));
    }

    @Test
    public void testJsonStringToArray() {
        HiveDataTypeConverter.JsonStringToStruct hiveconverter = new HiveDataTypeConverter.JsonStringToStruct("test", "array<map<int,int>>");
        ConnectorDataTypeConverter.ObjectToJsonString converter = new ConnectorDataTypeConverter.ObjectToJsonString();
        ArrayList inputArray = new ArrayList();
        HashMap<Integer, Integer> inputMap = new HashMap<Integer, Integer>();
        inputMap.put(1, 2);
        inputArray.add(inputMap);
        String input = (String)((ConnectorDataTypeConverter)converter).convert(inputArray);
        Object output = ((ConnectorDataTypeConverter)hiveconverter).convert(input);
        Assert.assertTrue((boolean)inputArray.toString().equals(output.toString()));
    }

    @Test
    public void testJsonStringToStruct() {
        HiveDataTypeConverter.JsonStringToStruct hiveconverter = new HiveDataTypeConverter.JsonStringToStruct("test", "struct<col1:int,col2:map<string,int>>");
        ConnectorDataTypeConverter.ObjectToJsonString converter = new ConnectorDataTypeConverter.ObjectToJsonString();
        HashMap<String, Integer> inputMap = new HashMap<String, Integer>();
        inputMap.put(String.valueOf(1), 2);
        ArrayList<Serializable> input = new ArrayList<Serializable>(2);
        input.add(Integer.valueOf(1));
        input.add(inputMap);
        ArrayList output = (ArrayList)((ConnectorDataTypeConverter)hiveconverter).convert(((ConnectorDataTypeConverter)converter).convert(input));
        Assert.assertTrue((output.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals(output.get(0), (Object)1);
        Assert.assertEquals(output.get(1), inputMap);
    }
}

