/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive.converter;

import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.hive.converter.HiveDataTypeDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class HiveDataTypeConverter
extends ConnectorDataTypeConverter {
    protected static final String PATTERN_VARCHAR_TYPE = "\\s*VARCHAR\\s*\\(\\s*(\\d+)\\s*\\)";
    protected static final String PATTERN_CHAR_TYPE = "\\s*CHAR\\s*\\(\\s*(\\d+)\\s*\\)";
    protected String colName;
    protected String colTypeName;

    protected HiveDataTypeConverter(String colName, String typeName) {
        this.colName = colName;
        this.colTypeName = typeName;
    }

    private static final Object parseKeyField(Object field, TypeInfo fieldTypeInfo) {
        switch (fieldTypeInfo.getCategory()) {
            case PRIMITIVE: {
                String typeName = fieldTypeInfo.getTypeName();
                if (typeName.equals("string")) {
                    return field;
                }
                if (Pattern.matches(PATTERN_CHAR_TYPE, typeName.toUpperCase())) {
                    HiveChar hc = new HiveChar(field.toString(), field.toString().length());
                    return hc;
                }
                if (Pattern.matches(PATTERN_VARCHAR_TYPE, typeName.toUpperCase())) {
                    HiveVarchar hv = new HiveVarchar(field.toString(), field.toString().length());
                    return hv;
                }
                if (typeName.equals("int")) {
                    return Integer.valueOf((String)field);
                }
                if (typeName.equals("bigint")) {
                    return Long.valueOf((String)field);
                }
                if (typeName.equals("smallint")) {
                    return Short.valueOf((String)field);
                }
                if (typeName.equals("tinyint")) {
                    return Byte.valueOf((String)field);
                }
                if (typeName.equals("float")) {
                    return Float.valueOf((String)field);
                }
                if (typeName.equals("double")) {
                    return Double.valueOf((String)field);
                }
                if (typeName.equals("timestamp")) {
                    return Timestamp.valueOf((String)field);
                }
                if (typeName.equals("binary")) {
                    return ((String)field).getBytes();
                }
                return field;
            }
            case LIST: {
                return HiveDataTypeConverter.parseList(field, (ListTypeInfo)fieldTypeInfo);
            }
            case MAP: {
                return HiveDataTypeConverter.parseMap(field, (MapTypeInfo)fieldTypeInfo);
            }
            case STRUCT: {
                return HiveDataTypeConverter.parseStruct(field, (StructTypeInfo)fieldTypeInfo);
            }
        }
        return null;
    }

    private static final Object parseValueField(Object field, TypeInfo fieldTypeInfo) {
        switch (fieldTypeInfo.getCategory()) {
            case PRIMITIVE: {
                String typeName = fieldTypeInfo.getTypeName();
                if (typeName.equals("string")) {
                    return field.toString();
                }
                if (typeName.equals("float")) {
                    if (field instanceof Double) {
                        return Float.valueOf(((Double)field).floatValue());
                    }
                    if (field instanceof String) {
                        return Float.valueOf((String)field);
                    }
                    return field;
                }
                if (Pattern.matches(PATTERN_CHAR_TYPE, typeName.toUpperCase())) {
                    HiveChar hc = new HiveChar(field.toString(), field.toString().length());
                    return hc;
                }
                if (Pattern.matches(PATTERN_VARCHAR_TYPE, typeName.toUpperCase())) {
                    HiveVarchar hv = new HiveVarchar(field.toString(), field.toString().length());
                    return hv;
                }
                if (typeName.equals("bigint")) {
                    if (field instanceof Integer) {
                        return ((Integer)field).longValue();
                    }
                    if (field instanceof String) {
                        return Long.valueOf((String)field);
                    }
                    return field;
                }
                if (typeName.equals("smallint")) {
                    if (field instanceof Integer) {
                        return ((Integer)field).shortValue();
                    }
                    if (field instanceof String) {
                        return Short.valueOf((String)field);
                    }
                    return field;
                }
                if (typeName.equals("tinyint")) {
                    if (field instanceof Integer) {
                        return ((Integer)field).byteValue();
                    }
                    if (field instanceof String) {
                        return Byte.valueOf((String)field);
                    }
                    return field;
                }
                if (typeName.equals("timestamp")) {
                    if (field instanceof Long) {
                        return new Timestamp((Long)field);
                    }
                    if (field instanceof String) {
                        return Timestamp.valueOf((String)field);
                    }
                    return field;
                }
                if (typeName.equals("binary")) {
                    if (field instanceof String) {
                        return ((String)field).getBytes();
                    }
                    return field;
                }
                return field;
            }
            case LIST: {
                return HiveDataTypeConverter.parseList(field, (ListTypeInfo)fieldTypeInfo);
            }
            case MAP: {
                return HiveDataTypeConverter.parseMap(field, (MapTypeInfo)fieldTypeInfo);
            }
            case STRUCT: {
                return HiveDataTypeConverter.parseStruct(field, (StructTypeInfo)fieldTypeInfo);
            }
        }
        return null;
    }

    private static final Object parseStruct(Object field, StructTypeInfo fieldTypeInfo) {
        ArrayList list = (ArrayList)field;
        ArrayList structTypes = fieldTypeInfo.getAllStructFieldTypeInfos();
        ArrayList structNames = fieldTypeInfo.getAllStructFieldNames();
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int i = 0; i < structNames.size(); ++i) {
            newList.add(HiveDataTypeConverter.parseValueField(list.get(i), (TypeInfo)structTypes.get(i)));
        }
        return newList;
    }

    private static final Object parseList(Object field, ListTypeInfo fieldTypeInfo) {
        ArrayList list = (ArrayList)field;
        TypeInfo elemTypeInfo = fieldTypeInfo.getListElementTypeInfo();
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            newList.add(HiveDataTypeConverter.parseValueField(list.get(i), elemTypeInfo));
        }
        return newList;
    }

    private static final Object parseMap(Object field, MapTypeInfo fieldTypeInfo) {
        Map map = (Map)field;
        TypeInfo keyTypeInfo = fieldTypeInfo.getMapKeyTypeInfo();
        TypeInfo valueTypeInfo = fieldTypeInfo.getMapValueTypeInfo();
        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            newMap.put(HiveDataTypeConverter.parseKeyField(entry.getKey(), keyTypeInfo), HiveDataTypeConverter.parseValueField(entry.getValue(), valueTypeInfo));
        }
        return newMap;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public String getColTypeName() {
        return this.colTypeName;
    }

    public void setColTypeName(String colTypeName) {
        this.colTypeName = colTypeName;
    }

    public static final class BigDecimalToHiveDecimalWithCreateMethod
    extends HiveDataTypeConverter {
        Method create = null;

        public BigDecimalToHiveDecimalWithCreateMethod(String colName, String typeName) {
            super(colName, typeName);
            try {
                this.create = HiveDecimal.class.getDeclaredMethod("create", BigDecimal.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            try {
                return (HiveDecimal)this.create.invoke(null, (BigDecimal)object);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static final class StringToHiveChar
    extends HiveDataTypeConverter {
        public StringToHiveChar(String colName, String typeName) {
            super(colName, typeName);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            String objstr = (String)object;
            HiveChar hc = new HiveChar(objstr, objstr.length());
            return hc;
        }
    }

    public static final class StringToHiveVarchar
    extends HiveDataTypeConverter {
        public StringToHiveVarchar(String colName, String typeName) {
            super(colName, typeName);
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            String objstr = (String)object;
            HiveVarchar hv = new HiveVarchar(objstr, objstr.length());
            return hv;
        }
    }

    public static final class BigDecimalToHiveDecimalWithConstructor
    extends HiveDataTypeConverter {
        Constructor<?> cost = null;

        public BigDecimalToHiveDecimalWithConstructor(String colName, String typeName) {
            super(colName, typeName);
            try {
                this.cost = HiveDecimal.class.getDeclaredConstructor(BigDecimal.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            try {
                return (HiveDecimal)this.cost.newInstance((BigDecimal)object);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static final class JsonStringToStruct
    extends HiveDataTypeConverter {
        public JsonStringToStruct(String colName, String typeName) {
            super(colName, typeName);
            this.defaultValue = HiveDataTypeDefinition.STRUCT_NULL_VALUE;
        }

        @Override
        public Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            ArrayList columnType = TypeInfoUtils.getTypeInfosFromTypeString((String)this.colTypeName);
            ArrayList<String> columnName = new ArrayList<String>();
            columnName.add(this.colName);
            StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnName, (List)columnType);
            List root = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                root = (List)mapper.readValue(object.toString(), List.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Object value = null;
            try {
                TypeInfo fieldTypeInfo = rowTypeInfo.getStructFieldTypeInfo((String)columnName.get(0));
                value = HiveDataTypeConverter.parseValueField(root, fieldTypeInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return value;
        }
    }

    public static final class JsonStringToArray
    extends HiveDataTypeConverter {
        public JsonStringToArray(String colName, String typeName) {
            super(colName, typeName);
            this.defaultValue = HiveDataTypeDefinition.ARRAY_NULL_VALUE;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            ArrayList columnType = TypeInfoUtils.getTypeInfosFromTypeString((String)this.colTypeName);
            ArrayList<String> columnName = new ArrayList<String>();
            columnName.add(this.colName);
            StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnName, (List)columnType);
            List root = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                root = (List)mapper.readValue(object.toString(), List.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Object value = null;
            try {
                TypeInfo fieldTypeInfo = rowTypeInfo.getStructFieldTypeInfo((String)columnName.get(0));
                value = HiveDataTypeConverter.parseValueField(root, fieldTypeInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return value;
        }
    }

    public static final class JsonStringToMap
    extends HiveDataTypeConverter {
        public JsonStringToMap(String colName, String typeName) {
            super(colName, typeName);
            this.defaultValue = HiveDataTypeDefinition.MAP_NULL_VALUE;
        }

        @Override
        public final Object convert(Object object) {
            if (object == null) {
                return this.nullable ? null : this.defaultValue;
            }
            ArrayList columnType = TypeInfoUtils.getTypeInfosFromTypeString((String)this.colTypeName.toLowerCase());
            ArrayList<String> columnName = new ArrayList<String>();
            columnName.add(this.colName);
            StructTypeInfo rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(columnName, (List)columnType);
            Map root = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                root = (Map)mapper.readValue(object.toString(), Map.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Object value = null;
            try {
                TypeInfo fieldTypeInfo = rowTypeInfo.getStructFieldTypeInfo((String)columnName.get(0));
                value = HiveDataTypeConverter.parseValueField(root, fieldTypeInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return value;
        }
    }
}

