/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.hive.BasicDataTypes;
import com.teradata.connector.hive.ParquetInt96Value;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

class ParquetNanoTime
extends BasicDataTypes {
    private final int julianDay;
    private final long timeOfDayNanos;

    public static ParquetNanoTime fromBinary(Binary bytes) {
        Preconditions.checkArgument((bytes.length() == 12 ? 1 : 0) != 0, (String)"Must be 12 bytes");
        ByteBuffer buf = bytes.toByteBuffer();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buf.getLong();
        int julianDay = buf.getInt();
        return new ParquetNanoTime(julianDay, timeOfDayNanos);
    }

    public static ParquetNanoTime fromInt96(ParquetInt96Value int96) {
        ByteBuffer buf = int96.getInt96().toByteBuffer();
        return new ParquetNanoTime(buf.getInt(), buf.getLong());
    }

    public ParquetNanoTime(int julianDay, long timeOfDayNanos) {
        this.julianDay = julianDay;
        this.timeOfDayNanos = timeOfDayNanos;
    }

    public int getJulianDay() {
        return this.julianDay;
    }

    public long getTimeOfDayNanos() {
        return this.timeOfDayNanos;
    }

    public Binary toBinary() {
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(this.timeOfDayNanos);
        buf.putInt(this.julianDay);
        buf.flip();
        return Binary.fromByteBuffer((ByteBuffer)buf);
    }

    public ParquetInt96Value toInt96() {
        return new ParquetInt96Value(this.toBinary());
    }

    @Override
    public void writeValue(RecordConsumer recordConsumer) {
        recordConsumer.addBinary(this.toBinary());
    }

    public String toString() {
        return "ParquetNanoTime{julianDay=" + this.julianDay + ", timeOfDayNanos=" + this.timeOfDayNanos + "}";
    }
}

