/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class HiveRCFileOutputFormat<K, V>
extends FileOutputFormat<WritableComparable<LongWritable>, BytesRefArrayWritable> {
    public static void setColumnNumber(Configuration configuration, int columnNum) {
        assert (columnNum > 0);
        configuration.setInt(RCFile.COLUMN_NUMBER_CONF_STR, columnNum);
    }

    public static int getColumnNumber(Configuration configuration) {
        return configuration.getInt(RCFile.COLUMN_NUMBER_CONF_STR, 0);
    }

    public RecordWriter<WritableComparable<LongWritable>, BytesRefArrayWritable> getRecordWriter(TaskAttemptContext arg0) throws IOException, InterruptedException {
        Configuration configuration = arg0.getConfiguration();
        configuration.setBoolean("mapred.output.compress", true);
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)arg0);
        FileSystem fs = outputPath.getFileSystem(configuration);
        if (!fs.exists(outputPath)) {
            fs.mkdirs(outputPath);
        }
        Path file = this.getDefaultWorkFile(arg0, "");
        CompressionCodec codec = null;
        if (HiveRCFileOutputFormat.getCompressOutput((JobContext)arg0)) {
            Class codecClass = HiveRCFileOutputFormat.getOutputCompressorClass((JobContext)arg0, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)configuration);
        }
        if (HiveRCFileOutputFormat.getColumnNumber(configuration) == 0) {
            String targetSchema = HivePlugInConfiguration.getOutputTableSchema(configuration);
            HiveRCFileOutputFormat.setColumnNumber(configuration, ConnectorSchemaUtils.parseColumnNames(ConnectorSchemaUtils.parseColumns(targetSchema)).size());
        }
        final RCFile.Writer out = new RCFile.Writer(fs, configuration, file, null, codec);
        return new RecordWriter<WritableComparable<LongWritable>, BytesRefArrayWritable>(){

            public void write(WritableComparable<LongWritable> key, BytesRefArrayWritable value) throws IOException {
                out.append((Writable)value);
            }

            public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
                out.close();
            }
        };
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) throws IOException {
        return new Path(context.getConfiguration().get("mapred.output.dir"), FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)HadoopConfigurationUtils.getOutputBaseName((JobContext)context), (String)extension));
    }
}

