/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hive;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hive.HiveParquetReadSupportExt;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class HiveParquetPlainToWritable {
    protected static final String PATTERN_VARCHAR_TYPE = "\\s*VARCHAR\\s*\\(\\s*(\\d+)\\s*\\)";
    protected static final String PATTERN_CHAR_TYPE = "\\s*CHAR\\s*\\(\\s*(\\d+)\\s*\\)";

    ArrayWritable getArrayWritable(HiveParquetReadSupportExt.PlainParquetExt value, Configuration configuration) throws ConnectorException {
        String sourceTableSchema = HivePlugInConfiguration.getInputTableSchema(configuration);
        List<String> columns = ConnectorSchemaUtils.parseColumns(sourceTableSchema.toLowerCase());
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        int length = columnNames.size();
        HiveParquetReadSupportExt.PlainParquetExt PlainParquetExtValue = value;
        Writable[] arr = new Writable[length];
        boolean nullCheckFlag = true;
        for (int i = 0; i < length; ++i) {
            String typeName = columnTypes.get(i).toUpperCase();
            String strVal = "null";
            if (nullCheckFlag) {
                try {
                    strVal = PlainParquetExtValue.getString(i, 0);
                }
                catch (Exception e) {
                    --i;
                    nullCheckFlag = false;
                    continue;
                }
            }
            if (strVal == null) {
                arr[i] = NullWritable.get();
            } else if (typeName.equals("INT") || typeName.equals("INTEGER")) {
                arr[i] = new IntWritable(PlainParquetExtValue.getInteger(i, 0));
            } else if (typeName.equals("BIGINT") || typeName.equals("LONG")) {
                arr[i] = new LongWritable(PlainParquetExtValue.getLong(i, 0));
            } else if (typeName.equals("SMALLINT")) {
                arr[i] = new ShortWritable((short)PlainParquetExtValue.getInteger(i, 0));
            } else if (typeName.equals("TINYINT")) {
                Integer in = new Integer(PlainParquetExtValue.getInteger(i, 0));
                arr[i] = new ByteWritable(in.byteValue());
            } else if (typeName.equals("STRING")) {
                arr[i] = new Text(PlainParquetExtValue.getString(i, 0));
            } else if (Pattern.matches(PATTERN_VARCHAR_TYPE, typeName)) {
                arr[i] = new Text(PlainParquetExtValue.getString(i, 0));
            } else if (Pattern.matches(PATTERN_CHAR_TYPE, typeName)) {
                arr[i] = new Text(PlainParquetExtValue.getString(i, 0));
            } else if (typeName.equals("DOUBLE") || typeName.equals("DOUBLE PRECISION")) {
                arr[i] = new DoubleWritable(PlainParquetExtValue.getDouble(i, 0));
            } else if (typeName.equals("BOOLEAN")) {
                arr[i] = new BooleanWritable(PlainParquetExtValue.getBoolean(i, 0));
            } else if (typeName.equals("FLOAT")) {
                arr[i] = new FloatWritable(PlainParquetExtValue.getFloat(i, 0));
            } else if (typeName.equals("BINARY")) {
                arr[i] = new BytesWritable(PlainParquetExtValue.getBinary(i, 0).getBytes());
            } else {
                throw new ConnectorException(14006, typeName);
            }
            nullCheckFlag = true;
        }
        ArrayWritable arrWritable = new ArrayWritable(Writable.class, arr);
        return arrWritable;
    }
}

