/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.serde;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorCsvParser;
import com.teradata.connector.common.utils.ConnectorCsvPrinter;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import com.teradata.connector.hdfs.utils.HdfsTextTransform;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;

public class HdfsTextSerDe
implements ConnectorSerDe {
    protected Configuration configuration;
    protected ConnectorRecord sourceConnectorRecord = null;
    protected String sourceSeparator = null;
    protected String sourceNullString = null;
    protected String sourceNullNonString = null;
    protected String sourceEscapedByString = null;
    protected String sourceEnclosedByString = null;
    protected int[] sourceDataTypes = null;
    protected ConnectorCsvParser csvParser = null;
    protected int[] sourceMapping = null;
    protected HdfsTextTransform[] sourceTransformer = null;
    protected String targetSeparator = null;
    protected String targetNullString = null;
    protected String targetNullNonString = null;
    protected String targetEscapedByString = null;
    protected String targetEnclosedByString = null;
    protected int[] targetDataTypes = null;
    protected int[] targetMappings = null;
    protected ConnectorCsvPrinter csvPrinter = null;
    protected Text outValue = null;
    protected StringBuilder outStringBuilder = new StringBuilder();
    protected String[] outStringArray = null;
    protected HdfsTextTransform[] targetTransformer = null;

    @Override
    public void initialize(JobContext context, ConnectorConfiguration.direction direction2) throws ConnectorException {
        this.configuration = context.getConfiguration();
        if (direction2 == ConnectorConfiguration.direction.input) {
            this.sourceSeparator = HdfsPlugInConfiguration.getInputSeparator(this.configuration);
            this.sourceNullString = HdfsPlugInConfiguration.getInputNullString(this.configuration);
            this.sourceNullNonString = HdfsPlugInConfiguration.getInputNullNonString(this.configuration);
            this.sourceEscapedByString = HdfsPlugInConfiguration.getInputEscapedBy(this.configuration);
            this.sourceEnclosedByString = HdfsPlugInConfiguration.getInputEnclosedBy(this.configuration);
            if (!this.sourceEscapedByString.isEmpty() || !this.sourceEnclosedByString.isEmpty()) {
                this.csvParser = new ConnectorCsvParser(this.sourceSeparator, this.sourceEnclosedByString, this.sourceEscapedByString);
            } else if (ConnectorStringUtils.isRegexSpecialChar(this.sourceSeparator)) {
                this.sourceSeparator = "\\" + this.sourceSeparator;
            }
            String sourceSchema = HdfsPlugInConfiguration.getInputSchema(this.configuration);
            String[] sourceFieldNames = HdfsPlugInConfiguration.getInputFieldNamesArray(this.configuration);
            if (!sourceSchema.isEmpty()) {
                List<String> sourceColumnNames = ConnectorSchemaUtils.parseColumnNames(ConnectorSchemaUtils.parseColumns(sourceSchema));
                if (sourceFieldNames.length > 0) {
                    this.sourceConnectorRecord = new ConnectorRecord(sourceFieldNames.length);
                    this.sourceMapping = HdfsSchemaUtils.getColumnMapping(sourceColumnNames, sourceFieldNames);
                } else {
                    this.sourceConnectorRecord = new ConnectorRecord(sourceColumnNames.size());
                }
                this.sourceTransformer = HdfsTextTransform.lookupTextTransformClass(sourceSchema, this.sourceNullString, this.sourceNullNonString, this.configuration, direction2);
            } else {
                this.sourceDataTypes = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(this.configuration)).getFieldTypes();
            }
        } else {
            this.targetSeparator = HdfsPlugInConfiguration.getOutputSeparator(this.configuration);
            this.targetNullString = HdfsPlugInConfiguration.getOutputNullString(this.configuration);
            this.targetNullNonString = HdfsPlugInConfiguration.getOutputNullNonString(this.configuration);
            this.targetEscapedByString = HdfsPlugInConfiguration.getOutputEscapedBy(this.configuration);
            this.targetEnclosedByString = HdfsPlugInConfiguration.getOutputEnclosedBy(this.configuration);
            List<String> targetSchema = ConnectorSchemaUtils.parseColumns(HdfsPlugInConfiguration.getOutputSchema(this.configuration).toLowerCase());
            String[] targetFieldNames = HdfsPlugInConfiguration.getOutputFieldNamesArray(this.configuration);
            if (!targetSchema.isEmpty()) {
                List<String> targetColumnNames = ConnectorSchemaUtils.parseColumnNames(targetSchema);
                if (targetFieldNames.length > 0) {
                    this.targetMappings = HdfsSchemaUtils.getColumnMapping(targetColumnNames, targetFieldNames);
                    this.outStringArray = new String[targetFieldNames.length];
                    this.targetDataTypes = new int[targetFieldNames.length];
                    this.targetDataTypes = HdfsSchemaUtils.getDataTypes(targetSchema, this.targetMappings);
                } else {
                    this.outStringArray = new String[targetColumnNames.size()];
                    this.targetDataTypes = new int[targetColumnNames.size()];
                    this.targetDataTypes = HdfsSchemaUtils.getDataTypes(targetSchema);
                }
                this.targetTransformer = HdfsTextTransform.lookupTextTransformClass(HdfsPlugInConfiguration.getOutputSchema(this.configuration), this.targetNullString, this.targetNullNonString, this.configuration, direction2);
            } else {
                this.targetTransformer = null;
                this.targetDataTypes = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(this.configuration)).getFieldTypes();
            }
            if (!this.targetEnclosedByString.isEmpty() || !this.targetEscapedByString.isEmpty()) {
                this.csvPrinter = new ConnectorCsvPrinter(this.targetSeparator, this.targetEnclosedByString, this.targetEscapedByString);
            }
            this.outValue = new Text();
        }
    }

    @Override
    public Writable serialize(ConnectorRecord connectorRecord) throws ConnectorException {
        int i;
        if (this.outStringArray == null) {
            this.outStringArray = new String[connectorRecord.getAllObject().length];
        }
        Object[] objects = connectorRecord.getAllObject();
        int l = objects.length;
        for (i = 0; i < l; ++i) {
            if (this.targetMappings != null && objects[i] != null) {
                this.outStringArray[i] = this.targetTransformer != null ? this.targetTransformer[this.targetMappings[i]].toString(objects[i]) : objects[i].toString();
                continue;
            }
            this.outStringArray[i] = objects[i] != null ? (this.targetTransformer != null ? this.targetTransformer[i].toString(objects[i]) : objects[i].toString()) : null;
        }
        if (!this.targetNullString.isEmpty() || !this.targetNullNonString.isEmpty()) {
            for (i = 0; i < this.outStringArray.length; ++i) {
                if (this.outStringArray[i] != null) continue;
                if (HdfsSchemaUtils.isCharType(this.targetDataTypes[i]) && !this.targetNullString.isEmpty()) {
                    this.outStringArray[i] = this.targetNullString;
                    continue;
                }
                if (HdfsSchemaUtils.isCharType(this.targetDataTypes[i]) || this.targetNullNonString.isEmpty()) continue;
                this.outStringArray[i] = this.targetNullNonString;
            }
        }
        if (this.csvPrinter != null) {
            try {
                this.outValue.set(this.csvPrinter.print(this.outStringArray));
            }
            catch (IOException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        } else {
            int colnum = 0;
            int numcols = this.outStringArray.length;
            this.outStringBuilder.setLength(0);
            for (String column : this.outStringArray) {
                if (column != null) {
                    this.outStringBuilder.append(column);
                }
                if (++colnum == numcols) continue;
                this.outStringBuilder.append(this.targetSeparator);
            }
            this.outValue.set(this.outStringBuilder.toString());
        }
        return this.outValue;
    }

    @Override
    public ConnectorRecord deserialize(Writable writable) throws ConnectorException {
        String text = ((Text)writable).toString();
        String[] values = null;
        if (this.sourceEscapedByString.isEmpty() && this.sourceEnclosedByString.isEmpty()) {
            values = text.split(this.sourceSeparator, -1);
        } else {
            try {
                values = this.csvParser.parse(text);
            }
            catch (IOException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        if (this.sourceConnectorRecord == null) {
            this.sourceConnectorRecord = new ConnectorRecord(values.length);
        }
        if (this.sourceTransformer != null) {
            if (this.sourceMapping != null && this.sourceMapping.length > 0) {
                int l = this.sourceMapping.length;
                for (int i = 0; i < l; ++i) {
                    this.sourceConnectorRecord.set(i, this.sourceTransformer[this.sourceMapping[i]].transform(values[this.sourceMapping[i]]));
                }
            } else {
                int l = this.sourceTransformer.length;
                for (int i = 0; i < l; ++i) {
                    this.sourceConnectorRecord.set(i, this.sourceTransformer[i].transform(values[i]));
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (this.sourceDataTypes == null || HdfsSchemaUtils.isCharType(this.sourceDataTypes[i])) {
                    if (values[i].isEmpty() || !this.sourceNullString.isEmpty() && values[i].equals(this.sourceNullString)) {
                        this.sourceConnectorRecord.set(i, null);
                        continue;
                    }
                    this.sourceConnectorRecord.set(i, values[i]);
                    continue;
                }
                if (values[i].isEmpty() || !this.sourceNullNonString.isEmpty() && values[i].equals(this.sourceNullNonString)) {
                    this.sourceConnectorRecord.set(i, null);
                    continue;
                }
                this.sourceConnectorRecord.set(i, values[i]);
            }
        }
        return this.sourceConnectorRecord;
    }
}

