/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.processor;

import com.teradata.connector.common.ConnectorInputProcessor;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.hdfs.converter.HdfsAvroDataTypeDefinition;
import com.teradata.connector.hdfs.utils.HdfsAvroSchemaUtils;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class HdfsAvroInputProcessor
implements ConnectorInputProcessor {
    private Log logger = LogFactory.getLog(HdfsAvroInputProcessor.class);

    @Override
    public int inputPreProcessor(JobContext context) throws ConnectorException {
        boolean isUDMapper;
        String[] fieldNames;
        Configuration configuration = context.getConfiguration();
        String inputPaths = HdfsPlugInConfiguration.getInputPaths(configuration);
        if (inputPaths.isEmpty()) {
            String dir = configuration.get("mapred.input.dir", "");
            if (dir.isEmpty()) {
                throw new ConnectorException(13005);
            }
            HdfsPlugInConfiguration.setInputPaths(configuration, dir);
        }
        try {
            inputPaths = HdfsPlugInConfiguration.getInputPaths(configuration);
            String allPaths = HadoopConfigurationUtils.getAllFilePaths(configuration, new String[]{inputPaths});
            if (allPaths.isEmpty()) {
                this.logger.warn((Object)"HDFS input source path is empty with no data");
                return 1001;
            }
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        String avroSchemaText = HdfsPlugInConfiguration.getInputAvroSchema(configuration);
        String avroSchemaFile = HdfsPlugInConfiguration.getInputAvroSchemaFile(configuration);
        Schema avroSchema = null;
        if (!avroSchemaText.isEmpty()) {
            avroSchema = new Schema.Parser().parse(avroSchemaText);
            if (avroSchema == null) {
                throw new ConnectorException(50011);
            }
        } else if (!avroSchemaFile.isEmpty()) {
            avroSchema = HdfsAvroSchemaUtils.buildAvroSchemaFromFile(configuration, avroSchemaFile);
            if (avroSchema == null) {
                throw new ConnectorException(50011);
            }
            HdfsPlugInConfiguration.setInputAvroSchema(configuration, avroSchema.toString());
        } else {
            avroSchema = HdfsAvroSchemaUtils.fetchSchemaFromInputPath(configuration);
            if (avroSchema == null) {
                throw new ConnectorException(50005);
            }
            HdfsPlugInConfiguration.setInputAvroSchema(configuration, avroSchema.toString());
        }
        if ((fieldNames = HdfsPlugInConfiguration.getInputFieldNamesArray(configuration)).length > 0 && avroSchema != null) {
            HdfsAvroSchemaUtils.checkFieldNamesInSchema(fieldNames, avroSchema);
        }
        boolean bl = isUDMapper = !ConnectorConfiguration.getJobMapper(configuration).isEmpty();
        if (!isUDMapper) {
            int[] mappings;
            ConnectorRecordSchema userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration));
            List fields = avroSchema.getFields();
            if (fieldNames.length != 0) {
                mappings = HdfsAvroSchemaUtils.getAvroColumnMapping(avroSchema, fieldNames);
            } else {
                int size = fields.size();
                mappings = new int[size];
                for (int i = 0; i < size; ++i) {
                    mappings[i] = i;
                }
            }
            ConnectorRecordSchema sourceRecordSchema = new ConnectorRecordSchema(mappings.length);
            for (int index = 0; index < mappings.length; ++index) {
                sourceRecordSchema.setFieldType(index, HdfsAvroDataTypeDefinition.getAvroDataType(((Schema.Field)fields.get(mappings[index])).schema()));
            }
            HdfsAvroSchemaUtils.formalizeAvroRecordSchema(fields, sourceRecordSchema, mappings);
            ConnectorSchemaUtils.formalizeConnectorRecordSchema(sourceRecordSchema);
            if (userRecordSchema != null) {
                int columnCount = sourceRecordSchema.getLength();
                if (columnCount != userRecordSchema.getLength()) {
                    throw new ConnectorException(14013);
                }
                for (int i = 0; i < columnCount; ++i) {
                    if (userRecordSchema.getFieldType(i) == 1883 || userRecordSchema.getFieldType(i) == sourceRecordSchema.getFieldType(i)) continue;
                    throw new ConnectorException(14015);
                }
                HdfsAvroSchemaUtils.formalizeAvroRecordSchema(fields, userRecordSchema, mappings);
            } else {
                ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(sourceRecordSchema)));
            }
        }
        return 0;
    }

    @Override
    public int inputPostProcessor(JobContext context) throws ConnectorException {
        return 0;
    }
}

