/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hdfs.converter;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorConverter;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.hdfs.converter.HdfsAvroDataTypeConverter;
import com.teradata.connector.hdfs.converter.HdfsAvroDataTypeDefinition;
import com.teradata.connector.hdfs.utils.HdfsSchemaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class HdfsAvroConverter
extends ConnectorConverter {
    protected ConnectorRecordSchema targetRecordSchema = null;
    protected ConnectorRecordSchema sourceRecordSchema = null;
    protected int columnCount = 0;
    protected ConnectorDataTypeConverter[] dataTypeConverters = null;
    protected ConnectorRecord targetRecord = null;
    protected Configuration configuration;

    @Override
    public void initialize(JobContext context) throws ConnectorException {
        this.configuration = context.getConfiguration();
        this.sourceRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(this.configuration));
        this.targetRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(this.configuration));
        if (!(this.sourceRecordSchema != null && this.sourceRecordSchema.getLength() != 0 || this.targetRecordSchema != null && this.targetRecordSchema.getLength() != 0)) {
            throw new ConnectorException("user must input source/target record schema");
        }
        if (this.sourceRecordSchema != null && (this.targetRecordSchema == null || this.targetRecordSchema.getLength() == 0)) {
            this.targetRecordSchema = this.sourceRecordSchema;
        } else if (this.targetRecordSchema != null && (this.sourceRecordSchema == null || this.sourceRecordSchema.getLength() == 0)) {
            ConnectorRecordSchema generateRecordSchema = new ConnectorRecordSchema(this.targetRecordSchema.getLength());
            for (int i = 0; i < this.targetRecordSchema.getLength(); ++i) {
                generateRecordSchema.setFieldType(i, 12);
            }
            this.sourceRecordSchema = generateRecordSchema;
        }
        if (this.sourceRecordSchema.getLength() != this.targetRecordSchema.getLength()) {
            throw new ConnectorException(14017);
        }
        this.columnCount = this.sourceRecordSchema.getLength();
        this.targetRecord = new ConnectorRecord(this.columnCount);
        ConnectorConfiguration.setOutputConverterRecordSchema(this.configuration, ConnectorSchemaUtils.recordSchemaToString(this.targetRecordSchema));
    }

    @Override
    public void lookupConverter(ConnectorRecordSchema sourceRecordSchema) throws ConnectorException {
        this.dataTypeConverters = super.lookupConverter(this.configuration, sourceRecordSchema);
    }

    @Override
    public ConnectorRecord convert(ConnectorRecord sourceRecord) throws ConnectorException {
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                this.targetRecord.set(i, this.dataTypeConverters[i].convert(sourceRecord.get(i)));
                continue;
            }
            catch (ConnectorException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        return this.targetRecord;
    }

    public static ConnectorDataTypeConverter lookupSimpleTypeConverter(JobContext context, Schema sourceAvroSchema, int sourceType, int targetType) throws ConnectorException {
        ConnectorDataTypeConverter converter;
        Schema s = ((Schema.Field)sourceAvroSchema.getFields().get(0)).schema();
        switch (sourceType) {
            case -2005: {
                converter = HdfsAvroConverter.lookupAvroUnionToSimpleTypeConverter(context, s, targetType);
                break;
            }
            case -2006: 
            case -2004: 
            case -2003: 
            case -2002: 
            case -2001: {
                converter = new HdfsAvroDataTypeConverter.AvroObjectToJsonString(s);
                converter.setDefaultValue(HdfsAvroDataTypeDefinition.getAvroDefaultNullJson(s));
                break;
            }
            case -2: {
                converter = new HdfsAvroDataTypeConverter.AvroBinaryToBytes();
                converter.setDefaultValue(HdfsAvroDataTypeDefinition.getAvroDefaultNullJson(s));
                break;
            }
            default: {
                HdfsAvroConverter avroConverter = new HdfsAvroConverter();
                avroConverter.initialize(context);
                Map<Integer, Object> defaultVal = avroConverter.initializeDefaultValue();
                Map<Integer, Object> falseDefVal = avroConverter.initializeFalseDefaultValue();
                Map<Integer, Object> trueDefVal = avroConverter.initializeTrueDefaultValue();
                converter = avroConverter.lookupDataTypeConverter(sourceType, targetType, 6, 5, Integer.MAX_VALUE, defaultVal, falseDefVal, trueDefVal, context.getConfiguration());
                break;
            }
        }
        return converter;
    }

    public static HdfsAvroDataTypeConverter.AvroUnionToSimpleType lookupAvroUnionToSimpleTypeConverter(JobContext context, Schema unionSchema, int targetType) throws ConnectorException {
        boolean foundConverters = false;
        List schema = unionSchema.getTypes();
        ConnectorDataTypeConverter[] converters = new ConnectorDataTypeConverter[schema.size()];
        for (int i = 0; i < schema.size(); ++i) {
            int avroType;
            Schema s = (Schema)schema.get(i);
            ConnectorDataTypeConverter converter = null;
            try {
                avroType = HdfsSchemaUtils.lookupHdfsAvroDatatype(s.getType().name());
                if (avroType == -2000) {
                }
            }
            catch (Exception e) {}
            continue;
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            Schema.Field f = new Schema.Field("dummy_col", s, null, null);
            fields.add(f);
            Schema record = Schema.createRecord((String)"dummy_record", null, null, (boolean)false);
            record.setFields(fields);
            try {
                converter = HdfsAvroConverter.lookupSimpleTypeConverter(context, record, avroType, targetType);
            }
            catch (ConnectorException e) {
                continue;
            }
            converters[i] = converter;
            converter.setNullable(true);
            foundConverters = true;
        }
        if (!foundConverters) {
            throw new ConnectorException(14007, " for Avro type");
        }
        HdfsAvroDataTypeConverter.AvroUnionToSimpleType unionConvert = new HdfsAvroDataTypeConverter.AvroUnionToSimpleType();
        unionConvert.setConverter(converters);
        return unionConvert;
    }

    public static boolean isComplexType(int type) {
        return -2005 == type || -2004 == type || -2003 == type || -2001 == type || -2002 == type || -2006 == type || -2000 == type;
    }

    public static ConnectorDataTypeConverter lookupUnionConverter(JobContext context, Schema targetAvroSchema, int sourceType, int targetType) throws ConnectorException {
        ConnectorDataTypeConverter converter;
        Schema s = ((Schema.Field)targetAvroSchema.getFields().get(0)).schema();
        if (targetType == -2005) {
            converter = HdfsAvroConverter.lookupSimpleTypeToAvroUnionConverter(context, s, sourceType);
        } else if (HdfsAvroConverter.isComplexType(targetType)) {
            converter = sourceType == 2005 ? new HdfsAvroDataTypeConverter.ClobToAvroObject(s) : new HdfsAvroDataTypeConverter.JsonStringToAvroObject(s);
        } else if (targetType == -2) {
            converter = new HdfsAvroDataTypeConverter.ByteArrayToAvroBinary();
        } else {
            HdfsAvroConverter avroConverter = new HdfsAvroConverter();
            avroConverter.initialize(context);
            Map<Integer, Object> defaultVal = avroConverter.initializeDefaultValue();
            Map<Integer, Object> falseDefVal = avroConverter.initializeFalseDefaultValue();
            Map<Integer, Object> trueDefVal = avroConverter.initializeTrueDefaultValue();
            converter = avroConverter.lookupDataTypeConverter(sourceType, targetType, 6, 5, Integer.MAX_VALUE, defaultVal, falseDefVal, trueDefVal, context.getConfiguration());
        }
        return converter;
    }

    public static HdfsAvroDataTypeConverter.NonStringToAvroUnion lookupSimpleTypeToAvroUnionConverter(JobContext context, Schema unionSchema, int sourceType) throws ConnectorException {
        boolean foundConverters = false;
        List schema = unionSchema.getTypes();
        ConnectorDataTypeConverter[] converters = new ConnectorDataTypeConverter[schema.size()];
        for (int i = 0; i < schema.size(); ++i) {
            Schema s = (Schema)schema.get(i);
            ConnectorDataTypeConverter converter = null;
            int avroType = HdfsSchemaUtils.lookupHdfsAvroDatatype(s.getType().name());
            if (avroType == -2000) continue;
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            Schema.Field f = new Schema.Field("dummy_col", s, null, null);
            fields.add(f);
            Schema record = Schema.createRecord((String)"dummy_record", null, null, (boolean)false);
            record.setFields(fields);
            try {
                converter = HdfsAvroConverter.lookupUnionConverter(context, record, sourceType, avroType);
            }
            catch (ConnectorException e) {
                continue;
            }
            converters[i] = converter;
            foundConverters = true;
        }
        if (!foundConverters) {
            throw new ConnectorException(14007, " for Avro type");
        }
        HdfsAvroDataTypeConverter.NonStringToAvroUnion unionConvert = new HdfsAvroDataTypeConverter.NonStringToAvroUnion();
        unionConvert.setConverter(converters);
        return unionConvert;
    }

    @Override
    public Map<Integer, Boolean> initializeNullable() throws ConnectorException {
        HashMap<Integer, Boolean> nullableMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < this.columnCount; ++i) {
            nullableMap.put(i, true);
        }
        return nullableMap;
    }

    @Override
    public Map<Integer, Object> initializeDefaultValue() throws ConnectorException {
        HashMap<Integer, Object> defValMap = new HashMap<Integer, Object>();
        defValMap.put(4, HdfsAvroDataTypeDefinition.INTEGER_NULL_VALUE);
        defValMap.put(-5, HdfsAvroDataTypeDefinition.BIGINT_NULL_VALUE);
        defValMap.put(5, HdfsAvroDataTypeDefinition.SMALLINT_NULL_VALUE);
        defValMap.put(-6, HdfsAvroDataTypeDefinition.TINYINT_NULL_VALUE);
        defValMap.put(3, HdfsAvroDataTypeDefinition.BIGDECIMAL_NULL_VALUE);
        defValMap.put(91, HdfsAvroDataTypeDefinition.DATE_NULL_VALUE);
        defValMap.put(92, HdfsAvroDataTypeDefinition.TIME_NULL_VALUE);
        defValMap.put(93, HdfsAvroDataTypeDefinition.TIMESTAMP_NULL_VALUE);
        defValMap.put(8, HdfsAvroDataTypeDefinition.DOUBLE_NULL_VALUE);
        defValMap.put(16, HdfsAvroDataTypeDefinition.BOOLEAN_NULL_VALUE);
        defValMap.put(-2, HdfsAvroDataTypeDefinition.BYTE_NULL_VALUE);
        defValMap.put(6, HdfsAvroDataTypeDefinition.FLOAT_NULL_VALUE);
        defValMap.put(12, "");
        defValMap.put(2002, "");
        defValMap.put(1111, "");
        defValMap.put(2003, "");
        return defValMap;
    }

    @Override
    public Map<Integer, Object> initializeFalseDefaultValue() throws ConnectorException {
        HashMap<Integer, Object> defVal = new HashMap<Integer, Object>();
        defVal.put(4, HdfsAvroDataTypeDefinition.INTEGER_FALSE_VALUE);
        defVal.put(-5, HdfsAvroDataTypeDefinition.LONG_FALSE_VALUE);
        defVal.put(5, HdfsAvroDataTypeDefinition.SHORT_FALSE_VALUE);
        defVal.put(6, HdfsAvroDataTypeDefinition.FLOAT_FALSE_VALUE);
        defVal.put(8, HdfsAvroDataTypeDefinition.DOUBLE_FALSE_VALUE);
        defVal.put(7, HdfsAvroDataTypeDefinition.DOUBLE_FALSE_VALUE);
        defVal.put(2, HdfsAvroDataTypeDefinition.BIGDECIMAL_FALSE_VALUE);
        defVal.put(3, HdfsAvroDataTypeDefinition.BIGDECIMAL_FALSE_VALUE);
        defVal.put(-2, HdfsAvroDataTypeDefinition.BYTE_FALSE_VALUE);
        return defVal;
    }

    @Override
    public Map<Integer, Object> initializeTrueDefaultValue() throws ConnectorException {
        HashMap<Integer, Object> defVal = new HashMap<Integer, Object>();
        defVal.put(4, HdfsAvroDataTypeDefinition.INTEGER_TRUE_VALUE);
        defVal.put(-5, HdfsAvroDataTypeDefinition.LONG_TRUE_VALUE);
        defVal.put(5, HdfsAvroDataTypeDefinition.SHORT_TRUE_VALUE);
        defVal.put(6, HdfsAvroDataTypeDefinition.FLOAT_TRUE_VALUE);
        defVal.put(8, HdfsAvroDataTypeDefinition.DOUBLE_TRUE_VALUE);
        defVal.put(7, HdfsAvroDataTypeDefinition.DOUBLE_TRUE_VALUE);
        defVal.put(2, HdfsAvroDataTypeDefinition.BIGDECIMAL_TRUE_VALUE);
        defVal.put(3, HdfsAvroDataTypeDefinition.BIGDECIMAL_TRUE_VALUE);
        defVal.put(-2, HdfsAvroDataTypeDefinition.BYTE_TRUE_VALUE);
        return defVal;
    }
}

