/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.hcat;

import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.hcat.ConnectorCombineFileHCatSplit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;

@Deprecated
public class ConnectorCombineFileHCatInputFormat<K, V>
extends CombineFileInputFormat<K, V> {
    private static Log logger = LogFactory.getLog(ConnectorCombineFileHCatInputFormat.class);
    InputFormat<K, Writable> plugedInInputFormat = null;

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List splits = null;
        try {
            this.configurePlugedInInputFormat();
            splits = this.plugedInInputFormat.getSplits(job);
        }
        catch (InterruptedException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        int actualSize = splits.size();
        int numSplits = ConnectorConfiguration.getNumMappers(job.getConfiguration());
        if (numSplits == 0) {
            numSplits = actualSize;
        }
        Collections.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit o1, InputSplit o2) {
                try {
                    return (int)(o2.getLength() - o1.getLength());
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        logger.info((Object)("expected split number is " + numSplits));
        logger.info((Object)("hcat split number is " + splits.size()));
        ArrayList<InputSplit> combinedSplits = new ArrayList<InputSplit>();
        if (actualSize <= numSplits) {
            for (InputSplit split : splits) {
                combinedSplits.add(new ConnectorCombineFileHCatSplit(new InputSplit[]{split}));
            }
        } else {
            int i;
            ArrayList packageSplits = new ArrayList();
            for (int i2 = 0; i2 < numSplits; ++i2) {
                packageSplits.add(new ArrayList());
            }
            boolean odd = true;
            int lastRound = 0;
            for (i = 0; i < actualSize; ++i) {
                int lane = i % numSplits;
                int round = i / numSplits;
                if (round != lastRound) {
                    boolean bl = odd = !odd;
                }
                if (odd) {
                    ((List)packageSplits.get(lane)).add((InputSplit)splits.get(i));
                } else {
                    ((List)packageSplits.get(numSplits - 1 - lane)).add((InputSplit)splits.get(i));
                }
                lastRound = round;
            }
            for (i = 0; i < numSplits; ++i) {
                ConnectorCombineFileHCatSplit combineSplit = new ConnectorCombineFileHCatSplit(((List)packageSplits.get(i)).toArray(new InputSplit[0]));
                combinedSplits.add(combineSplit);
            }
        }
        logger.info((Object)("final split number is " + combinedSplits.size()));
        return combinedSplits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException {
        return new ConnectorCombineFileHCatRecordReader(split, taskContext, this);
    }

    public RecordReader<K, V> createBaseRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        this.configurePlugedInInputFormat();
        return this.plugedInInputFormat.createRecordReader(split, taskContext);
    }

    protected void configurePlugedInInputFormat() {
        block7: {
            try {
                if (this.plugedInInputFormat != null) break block7;
                Class<?> HCatInputFormatClass = null;
                try {
                    HCatInputFormatClass = Class.forName("org.apache.hive.hcatalog.mapreduce.HCatInputFormat");
                }
                catch (ClassNotFoundException e) {
                    try {
                        HCatInputFormatClass = Class.forName("org.apache.hcatalog.mapreduce.HCatInputFormat");
                    }
                    catch (ClassNotFoundException e2) {
                        throw new RuntimeException(e);
                    }
                }
                this.plugedInInputFormat = (InputFormat)HCatInputFormatClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    class ConnectorCombineFileHCatRecordReader
    extends RecordReader<K, V> {
        protected ConnectorCombineFileHCatInputFormat hcatInputFormat;
        protected ConnectorCombineFileHCatSplit split;
        protected TaskAttemptContext context;
        protected int index;
        protected long progress;
        protected RecordReader<K, V> currentRecordReader;
        protected ConnectorSerDe sourceSerDe;

        public ConnectorCombineFileHCatRecordReader(InputSplit split, TaskAttemptContext context, ConnectorCombineFileHCatInputFormat hcatInputFormat) throws IOException {
            this.split = (ConnectorCombineFileHCatSplit)split;
            this.context = context;
            this.index = 0;
            this.currentRecordReader = null;
            this.progress = 0L;
            this.hcatInputFormat = hcatInputFormat;
            try {
                this.initNextRecordReader();
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage());
            }
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.split = (ConnectorCombineFileHCatSplit)split;
            this.context = context;
            if (this.currentRecordReader != null) {
                this.currentRecordReader.initialize(((ConnectorCombineFileHCatSplit)split).get(0), context);
            }
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            while (this.currentRecordReader == null || !this.currentRecordReader.nextKeyValue()) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentRecordReader.getCurrentKey();
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.currentRecordReader.getCurrentValue();
        }

        public void close() throws IOException {
            if (this.currentRecordReader != null) {
                this.currentRecordReader.close();
                this.currentRecordReader = null;
            }
        }

        public float getProgress() throws IOException, InterruptedException {
            long currentProgress = 0L;
            if (null != this.currentRecordReader) {
                currentProgress = (long)(this.currentRecordReader.getProgress() * (float)this.split.get(this.index - 1).getLength());
            }
            long splitLength = this.split.getLength();
            return Math.min(1.0f, (float)(this.progress + currentProgress) / (float)splitLength);
        }

        protected boolean initNextRecordReader() throws IOException, InterruptedException {
            if (this.currentRecordReader != null) {
                this.currentRecordReader.close();
                this.currentRecordReader = null;
                if (this.index > 0) {
                    this.progress += this.split.get(this.index - 1).getLength();
                }
            }
            if (this.split.length() == this.index) {
                return false;
            }
            try {
                Configuration configuration = this.context.getConfiguration();
                this.currentRecordReader = ConnectorCombineFileHCatInputFormat.this.createBaseRecordReader(this.split.get(this.index), this.context);
                this.sourceSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getInputSerDe(configuration)).newInstance();
                this.sourceSerDe.initialize((JobContext)this.context, ConnectorConfiguration.direction.input);
                if (this.index > 0) {
                    this.currentRecordReader.initialize(this.split.get(this.index), this.context);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.index;
            return true;
        }
    }
}

