/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.converter.ConnectorDataWritable;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.jdbc.ResultStruct;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class ConnectorSchemaUtilsTest {
    @Test
    public void testParseColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("\\  \\  ");
        columnNames.add("col\\'1  ");
        Assert.assertEquals((String)"", (String)ConnectorSchemaUtils.parseColumnNames(columnNames).get(0));
        Assert.assertEquals((String)"col'1", (String)ConnectorSchemaUtils.parseColumnNames(columnNames).get(1));
    }

    @Test
    public void testParseColumnTypes() {
        ArrayList<String> columnTypes = new ArrayList<String>();
        columnTypes.add("\\   ");
        Assert.assertEquals((String)"", (String)ConnectorSchemaUtils.parseColumnTypes(columnTypes).get(0));
    }

    @Test
    public void testConcatFieldNamesArray() {
        String[] fieldNamesArray = new String[]{};
        Assert.assertEquals((String)"", (String)ConnectorSchemaUtils.concatFieldNamesArray(fieldNamesArray));
    }

    @Test
    public void testQuoteFieldName() {
        Assert.assertEquals((String)"\"\"", (String)ConnectorSchemaUtils.quoteFieldName("", ""));
    }

    @Test
    public void testQuoteFieldNames() {
        Assert.assertEquals((String)"\"col1\",\"col2\"", (String)ConnectorSchemaUtils.quoteFieldNames("col1,col2"));
    }

    @Test
    public void testQuoteFieldNamesArray() {
        Assert.assertEquals((int)0, (int)ConnectorSchemaUtils.quoteFieldNamesArray(null).length);
        Assert.assertEquals((String)"[\"col1, col2\"]", (String)Arrays.toString(ConnectorSchemaUtils.quoteFieldNamesArray(new String[]{"col1, col2"})));
    }

    @Test
    public void testQuoteFieldValue() {
        Assert.assertEquals((String)"''", (String)ConnectorSchemaUtils.quoteFieldValue("", ""));
        Assert.assertEquals((String)"'test\"'", (String)ConnectorSchemaUtils.quoteFieldValue("test\"", "\\'"));
    }

    @Test
    public void testUnquoteFieldValue() {
        Assert.assertEquals((String)"test", (String)ConnectorSchemaUtils.unquoteFieldValue("'test'"));
        Assert.assertEquals((String)"", (String)ConnectorSchemaUtils.unquoteFieldValue(null));
    }

    @Test
    public void testUnquoteFieldName() {
        Assert.assertEquals((String)"", (String)ConnectorSchemaUtils.unquoteFieldName(null));
        Assert.assertEquals((String)"test", (String)ConnectorSchemaUtils.unquoteFieldName("\"test\""));
    }

    @Test
    public void testGetHivePathString() {
        Assert.assertEquals((String)"4.3", (String)ConnectorSchemaUtils.getHivePathString(new Double(4.3)));
        Assert.assertEquals((String)"true", (String)ConnectorSchemaUtils.getHivePathString(new Boolean(true)));
        Assert.assertEquals((String)"4", (String)ConnectorSchemaUtils.getHivePathString((short)4));
        Assert.assertEquals((String)"16", (String)ConnectorSchemaUtils.getHivePathString((byte)16));
        Assert.assertEquals((String)"44", (String)ConnectorSchemaUtils.getHivePathString(new Long(44L)));
    }

    @Test
    public void testLookupUDF() throws Exception {
        ConnectorRecordSchema schema = new ConnectorRecordSchema(3);
        for (int i = 0; i < 3; ++i) {
            schema.setFieldType(i, 4);
        }
        schema.setDataTypeConverter(0, "TestUserConverter0Args");
        schema.setDataTypeConverter(1, "com.teradata.connector.common.utils.ConnectorSchemaUtilsTest$TestUserConverter1Arg");
        schema.setDataTypeConverter(2, "com.teradata.connector.common.utils.ConnectorSchemaUtilsTest$TestUserConverter2Args");
        schema.setParameters(0, new String[]{"1", "2", "3"});
        Assert.assertEquals(null, (Object)ConnectorSchemaUtils.lookupUDF(schema, 0));
        schema.setParameters(2, new String[]{"1"});
        Assert.assertEquals(null, (Object)ConnectorSchemaUtils.lookupUDF(schema, 2));
        schema.setParameters(1, new String[0]);
        Assert.assertEquals(null, (Object)ConnectorSchemaUtils.lookupUDF(schema, 1));
        schema.setParameters(0, new String[0]);
        Assert.assertTrue((boolean)ConnectorSchemaUtils.lookupUDF(schema, 0).toString().contains("TestUserConverter0Args"));
        schema.setParameters(1, new String[]{"1"});
        Assert.assertTrue((boolean)ConnectorSchemaUtils.lookupUDF(schema, 1).toString().contains("$TestUserConverter1Arg"));
        schema.setParameters(2, new String[]{"1", "2"});
        Assert.assertTrue((boolean)ConnectorSchemaUtils.lookupUDF(schema, 2).toString().contains("$TestUserConverter2Args"));
    }

    @Test
    public void testRecordSchema() throws Exception {
        ConnectorRecordSchema test = new ConnectorRecordSchema(3);
        ConnectorRecordSchema newTest = new ConnectorRecordSchema();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        test.setFieldType(0, 5);
        test.setFieldType(1, 1883);
        test.setFieldType(2, 1883);
        test.setDataTypeConverter(1, "StringToDateFormat");
        test.setDataTypeConverter(2, "StringToDateFormat");
        test.setParameters(1, new String[]{"a", "b", "c"});
        test.setParameters(2, new String[0]);
        test.write(out);
        byte[] arrayList = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(arrayList);
        DataInputStream in = new DataInputStream(input);
        newTest.readFields(in);
        Assert.assertEquals((int)1883, (int)newTest.getFieldType(1));
        Assert.assertTrue((boolean)newTest.getDataTypeConverter(1).contains("StringToDateFormat"));
        String[] parameters = newTest.getParameters(1);
        Assert.assertTrue((parameters.length == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)parameters[0].equals("a"));
        Assert.assertTrue((boolean)parameters[1].equals("b"));
        Assert.assertTrue((boolean)parameters[2].equals("c"));
        Assert.assertTrue((newTest.getParameters(2).length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecordSchema0Args() throws Exception {
        ConnectorRecordSchema test = new ConnectorRecordSchema(1);
        ConnectorRecordSchema newTest = new ConnectorRecordSchema();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        test.setFieldType(0, 1883);
        test.setDataTypeConverter(0, "StringToDateFormat");
        test.setParameters(0, new String[0]);
        test.write(out);
        byte[] arrayList = output.toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(arrayList);
        DataInputStream in = new DataInputStream(input);
        newTest.readFields(in);
        Assert.assertEquals((int)1883, (int)newTest.getFieldType(0));
        Assert.assertTrue((boolean)newTest.getDataTypeConverter(0).contains("StringToDateFormat"));
        Assert.assertTrue((newTest.getParameters(0).length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLookupDataTypeAndValidate() throws Exception {
        Assert.assertEquals((int)3, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("DECIMAL"));
        Assert.assertEquals((int)16, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("BOOLEAN"));
        Assert.assertEquals((int)1885, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("time with time zone"));
        Assert.assertEquals((int)1111, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("INTERVAL"));
        Assert.assertEquals((int)1, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("CHAR"));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("MAP"));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("ARRAY"));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("STRUCT"));
        Assert.assertEquals((int)-6, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("TINYINT"));
        Assert.assertEquals((int)-1, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("LONGVARCHAR"));
        Assert.assertEquals((int)2005, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("CLOB"));
        Assert.assertEquals((int)2004, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("BLOB"));
        Assert.assertEquals((int)8, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("REAL"));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("ENUM"));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("NULL"));
        Assert.assertEquals((int)1882, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("UNION"));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("FIXED"));
        Assert.assertEquals((int)1882, (int)ConnectorSchemaUtils.lookupDataTypeAndValidate("OTHER"));
    }

    @Test
    public void testGetUdfParameters() {
        Assert.assertEquals((String)"", (String)ConnectorSchemaUtils.getUdfParameters("")[0]);
        Assert.assertEquals((String)"two", (String)ConnectorSchemaUtils.getUdfParameters("(one,two)")[1]);
    }

    @Test
    public void testGetWritableObjectType() throws Exception {
        Assert.assertEquals((int)4, (int)ConnectorSchemaUtils.getWritableObjectType(new IntWritable()));
        Assert.assertEquals((int)-5, (int)ConnectorSchemaUtils.getWritableObjectType(new LongWritable()));
        Assert.assertEquals((int)5, (int)ConnectorSchemaUtils.getWritableObjectType(new ShortWritable()));
        Assert.assertEquals((int)-6, (int)ConnectorSchemaUtils.getWritableObjectType(new ByteWritable()));
        Assert.assertEquals((int)6, (int)ConnectorSchemaUtils.getWritableObjectType(new FloatWritable()));
        Assert.assertEquals((int)7, (int)ConnectorSchemaUtils.getWritableObjectType(new DoubleWritable()));
        Assert.assertEquals((int)16, (int)ConnectorSchemaUtils.getWritableObjectType(new BooleanWritable()));
        Assert.assertEquals((int)2, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.BigDecimalWritable()));
        Assert.assertEquals((int)2005, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.ClobWritable()));
        Assert.assertEquals((int)2004, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.BlobWritable()));
        Assert.assertEquals((int)12, (int)ConnectorSchemaUtils.getWritableObjectType(new Text()));
        Assert.assertEquals((int)-2, (int)ConnectorSchemaUtils.getWritableObjectType(new BytesWritable()));
        Assert.assertEquals((int)91, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.DateWritable()));
        Assert.assertEquals((int)92, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.TimeWritable()));
        Assert.assertEquals((int)93, (int)ConnectorSchemaUtils.getWritableObjectType(new TimestampWritable()));
        Assert.assertEquals((int)2002, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.PeriodWritable()));
        Assert.assertEquals((int)1886, (int)ConnectorSchemaUtils.getWritableObjectType(new ConnectorDataWritable.CalendarWritable()));
    }

    @Test
    public void testGetGenericObjectType() {
        Assert.assertEquals((int)5, (int)ConnectorSchemaUtils.getGenericObjectType((short)4));
        Assert.assertEquals((int)-6, (int)ConnectorSchemaUtils.getGenericObjectType((byte)16));
        Assert.assertEquals((int)16, (int)ConnectorSchemaUtils.getGenericObjectType(new Boolean(true)));
        Assert.assertEquals((int)-2, (int)ConnectorSchemaUtils.getGenericObjectType(new byte[0]));
        ResultStruct rs = new ResultStruct();
        rs.setSQLTypeName("PERIOD");
        Assert.assertEquals((int)2002, (int)ConnectorSchemaUtils.getGenericObjectType(rs));
    }

    public static class TestUserConverter2Args
    extends ConnectorDataTypeConverter {
        public TestUserConverter2Args(String arg1, String arg2) {
        }

        @Override
        public final Object convert(Object object) {
            return (String)object;
        }
    }

    public static class TestUserConverter1Arg
    extends ConnectorDataTypeConverter {
        public TestUserConverter1Arg(String arg1) {
        }

        @Override
        public final Object convert(Object object) {
            return (String)object;
        }
    }
}

