/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ConnectorSchemaParser {
    private HashSet<Character> delimChars;
    private HashSet<Character> quoteChars;
    private HashMap<Character, Character> bracketChars;
    private char escapeChar = (char)92;
    private boolean matchBrackets = true;
    private boolean trimSpaces = false;
    private boolean ignoreQuotes = false;
    private boolean ignoreContinousDelim = false;

    public ConnectorSchemaParser() {
        this.delimChars = new HashSet();
        this.quoteChars = new HashSet();
        this.bracketChars = new HashMap();
        this.delimChars.add(Character.valueOf(','));
        this.delimChars.add(Character.valueOf(';'));
        this.quoteChars.add(Character.valueOf('\"'));
        this.quoteChars.add(Character.valueOf('\''));
        this.bracketChars.put(Character.valueOf('('), Character.valueOf(')'));
        this.bracketChars.put(Character.valueOf('<'), Character.valueOf('>'));
    }

    public void setDelimChar(char delimChar) {
        this.delimChars.clear();
        this.delimChars.add(Character.valueOf(delimChar));
    }

    public void addDelimChar(char delimChar) {
        this.delimChars.add(Character.valueOf(delimChar));
    }

    public void setQuoteChar(char quoteChar) {
        this.quoteChars.clear();
        this.quoteChars.add(Character.valueOf(quoteChar));
    }

    public void addQuoteChar(char quoteChar) {
        this.quoteChars.add(Character.valueOf(quoteChar));
    }

    public void setBracketChars(char bracketBeginChar, char bracketEndChar) {
        this.bracketChars.clear();
        this.bracketChars.put(Character.valueOf(bracketBeginChar), Character.valueOf(bracketEndChar));
    }

    public void addBracketChars(char bracketBeginChar, char bracketEndChar) {
        this.bracketChars.put(Character.valueOf(bracketBeginChar), Character.valueOf(bracketEndChar));
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public void setIgnoreQuotes(boolean ignoreQuotes) {
        this.ignoreQuotes = ignoreQuotes;
    }

    public void setMatchBrackets(boolean matchBrackets) {
        this.matchBrackets = matchBrackets;
    }

    public void setTrimSpaces(boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }

    public void setIgnoreContinousDelim(boolean ignoreContinousDelim) {
        this.ignoreContinousDelim = ignoreContinousDelim;
    }

    public boolean isQuoted(String text) {
        return this.isQuoted(text, this.trimSpaces);
    }

    public boolean isQuoted(String text, boolean toTrimSpaces) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        String textCopy = toTrimSpaces ? text.trim() : text;
        int currPos = 0;
        int endPos = textCopy.length();
        char currChar = textCopy.charAt(currPos++);
        ArrayList<Character> quotes = new ArrayList<Character>();
        if (this.ignoreQuotes || !this.isQuoteChar(currChar)) {
            return false;
        }
        quotes.add(Character.valueOf(currChar));
        int quoteCount = quotes.size();
        while (currPos < endPos) {
            currChar = textCopy.charAt(currPos++);
            if (quoteCount == 0) {
                return false;
            }
            if (this.ignoreQuotes || !this.isQuoteChar(currChar)) continue;
            if (currChar == ((Character)quotes.get(quoteCount - 1)).charValue()) {
                quotes.remove(quoteCount - 1);
            }
            quoteCount = quotes.size();
        }
        return quoteCount == 0;
    }

    public List<String> tokenize(String text) {
        return this.tokenize(text, 0, false);
    }

    public List<String> tokenizeKeepEscape(String text) {
        return this.tokenize(text, 0, true);
    }

    public List<String> tokenize(String text, int maxTokens, boolean keepEscape) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null && !text.isEmpty()) {
            if (maxTokens == 1) {
                tokens.add(text);
                return tokens;
            }
            int currPos = 0;
            int endPos = text.length();
            boolean escaped = false;
            boolean continousDelim = false;
            char currChar = text.charAt(currPos++);
            ArrayList<Character> quotes = new ArrayList<Character>();
            ArrayList<Character> bracketBegins = new ArrayList<Character>();
            StringBuilder builder = new StringBuilder();
            if (currChar == this.escapeChar) {
                if (endPos > 1) {
                    escaped = true;
                    if (keepEscape) {
                        builder.append(this.escapeChar);
                    }
                } else {
                    builder.append(this.escapeChar);
                }
            } else if (this.isDelimChar(currChar)) {
                tokens.add("");
                if (maxTokens == 2) {
                    tokens.add(this.trimSpaces ? text.substring(currPos).trim() : text.substring(currPos));
                    return tokens;
                }
            } else {
                builder.append(currChar);
                if (!this.ignoreQuotes && this.isQuoteChar(currChar)) {
                    quotes.add(Character.valueOf(currChar));
                } else if (this.matchBrackets && this.isBracketBeginChar(currChar)) {
                    bracketBegins.add(Character.valueOf(currChar));
                }
            }
            while (currPos < endPos) {
                int bracketBeginCount;
                currChar = text.charAt(currPos++);
                if (escaped) {
                    builder.append(currChar);
                    escaped = false;
                    continue;
                }
                if (currChar == this.escapeChar) {
                    if (currPos == endPos) {
                        builder.append(this.escapeChar);
                        continue;
                    }
                    escaped = true;
                    if (!keepEscape) continue;
                    builder.append(this.escapeChar);
                    continue;
                }
                if (this.isDelimChar(currChar) && tokens.size() != maxTokens - 1) {
                    if (!this.ignoreQuotes && quotes.size() > 0 || this.matchBrackets && bracketBegins.size() > 0) {
                        builder.append(currChar);
                        continue;
                    }
                    boolean bl = continousDelim = builder.length() == 0;
                    if (!continousDelim) {
                        tokens.add(this.trimSpaces ? builder.toString().trim() : builder.toString());
                        builder.setLength(0);
                        continue;
                    }
                    if (this.ignoreContinousDelim) continue;
                    tokens.add("");
                    continue;
                }
                if (!this.ignoreQuotes && this.isQuoteChar(currChar)) {
                    int quoteCount = quotes.size();
                    if (quoteCount == 0) {
                        quotes.add(Character.valueOf(currChar));
                    } else if (quoteCount > 0 && currChar == ((Character)quotes.get(quoteCount - 1)).charValue()) {
                        quotes.remove(quoteCount - 1);
                    }
                } else if (this.matchBrackets && this.isBracketBeginChar(currChar)) {
                    if (quotes.size() == 0) {
                        bracketBegins.add(Character.valueOf(currChar));
                    }
                } else if (this.matchBrackets && this.isBracketEndChar(currChar) && quotes.size() == 0 && (bracketBeginCount = bracketBegins.size()) > 0 && currChar == this.bracketChars.get(bracketBegins.get(bracketBeginCount - 1)).charValue()) {
                    bracketBegins.remove(bracketBeginCount - 1);
                }
                builder.append(currChar);
            }
            tokens.add(this.trimSpaces ? builder.toString().trim() : builder.toString());
        }
        return tokens;
    }

    private boolean isDelimChar(char c) {
        return this.delimChars.contains(Character.valueOf(c));
    }

    private boolean isQuoteChar(char c) {
        return this.quoteChars.contains(Character.valueOf(c));
    }

    private boolean isBracketBeginChar(char c) {
        return this.bracketChars.containsKey(Character.valueOf(c));
    }

    private boolean isBracketEndChar(char c) {
        return this.bracketChars.containsValue(Character.valueOf(c));
    }
}

