/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.ConnectorPlugin;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConnectorJobRunner;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorPluginUtils;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ConnectorPluginTool
extends Configured
implements Tool {
    private static Log logger = LogFactory.getLog(ConnectorPluginTool.class);

    public int run(String[] args) throws Exception {
        Configuration configuration = this.getConf();
        Job job = new Job(configuration);
        try {
            if (this.processArgs(configuration, args) < 0) {
                this.printHelp();
                return 0;
            }
        }
        catch (ConnectorException e) {
            this.printHelp();
            throw e;
        }
        return ConnectorJobRunner.runJob(job);
    }

    private void printHelp() {
        System.out.println("hadoop jar teradata-hadoop-connector.jar");
        System.out.println("     com.teradata.connector.common.tool.ConnectorPluginTool");
        System.out.println("     [-pluginconf <conf file>] (optional)");
        System.out.println("     [-sourceplugin <name>] (required, the name of source plugin)");
        System.out.println("     [-targetplugin <name>] (required, the name of target plugin)");
        System.out.println("     [-sourcerecordschema <record schema>] (optional, comma delimited format)");
        System.out.println("     [-targetrecordschema <record schema>] (optional, comma delimited format)");
        System.out.println("     [-nummappers <num>] (optional, default is 2)");
        System.out.println("     [-writephaseclose <true|false>] (optional, a debug option to close write stage of the whole hadoop job)");
        System.out.println("    [-h|help] (optional)");
        System.out.println("");
    }

    public int processArgs(Configuration configuration, String[] args) throws ConnectorException {
        int pos;
        String[] newparameter;
        String[] parameters;
        int position;
        int index;
        ConnectorRecordSchema recordschema;
        List<String> schemalist;
        ConnectorSchemaParser parser;
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        int length = args.length;
        if (length < 1) {
            throw new ConnectorException(12021);
        }
        for (int i = 0; i < length; ++i) {
            String arg = args[i];
            if (arg == null || arg.isEmpty()) {
                return 0;
            }
            if (arg.charAt(0) != '-') {
                throw new ConnectorException(12001);
            }
            if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("-help")) {
                return -1;
            }
            if (++i < length) {
                String value = args[i];
                if (value == null) {
                    throw new ConnectorException(12001);
                }
                configurationMap.put(arg, value);
                continue;
            }
            throw new ConnectorException(12001);
        }
        if (configurationMap.containsKey("-pluginconf")) {
            ConnectorConfiguration.setPluginConf(configuration, (String)configurationMap.remove("-pluginconf"));
            try {
                ConnectorPlugin.loadConnectorPluginFromConf(configuration);
            }
            catch (Exception e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        String sourcePlugin = "";
        if (configurationMap.containsKey("-sourceplugin")) {
            sourcePlugin = (String)configurationMap.remove("-sourceplugin");
        }
        String targetPlugin = "";
        if (configurationMap.containsKey("-targetplugin")) {
            targetPlugin = (String)configurationMap.remove("-targetplugin");
        }
        if (sourcePlugin.trim().equals("") || targetPlugin.trim().equals("")) {
            throw new ConnectorException(15026);
        }
        ConnectorPluginUtils.configConnectorInputPlugins(configuration, sourcePlugin);
        ConnectorPluginUtils.configConnectorOutputPlugins(configuration, targetPlugin);
        if (configurationMap.containsKey("-nummappers")) {
            try {
                int numMappers = Integer.parseInt((String)configurationMap.remove("-nummappers"));
                if (numMappers < 0) {
                    throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", " a value equals or more than zero "));
                }
                ConnectorConfiguration.setNumMappers(configuration, numMappers);
            }
            catch (NumberFormatException e) {
                logger.info((Object)String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", "integer"));
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", "integer"), e);
            }
        }
        if (configurationMap.containsKey("-sourcerecordschema")) {
            String sourceRecordSchema = (String)configurationMap.remove("-sourcerecordschema");
            parser = new ConnectorSchemaParser();
            schemalist = parser.tokenize(sourceRecordSchema);
            recordschema = new ConnectorRecordSchema(schemalist.size());
            index = 0;
            for (String schema : schemalist) {
                recordschema.setFieldType(index, ConnectorSchemaUtils.lookupDataTypeAndValidate(schema));
                if (ConnectorSchemaUtils.lookupDataTypeAndValidate(schema) == 1883) {
                    position = schema.indexOf(40);
                    if (position == -1) {
                        throw new ConnectorException(15013);
                    }
                    recordschema.setDataTypeConverter(index, schema.substring(0, position));
                    parameters = ConnectorSchemaUtils.getUdfParameters(schema);
                    newparameter = new String[parameters.length];
                    pos = 0;
                    for (String parameter : parameters) {
                        newparameter[pos++] = configuration.get(parameter, "");
                    }
                    recordschema.setParameters(index, newparameter);
                }
                ++index;
            }
            ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(recordschema)));
            logger.info((Object)("source record schema is " + sourceRecordSchema));
        }
        if (configurationMap.containsKey("-targetrecordschema")) {
            String targetRecordSchema = (String)configurationMap.remove("-targetrecordschema");
            parser = new ConnectorSchemaParser();
            schemalist = parser.tokenize(targetRecordSchema);
            recordschema = new ConnectorRecordSchema(schemalist.size());
            index = 0;
            for (String schema : schemalist) {
                recordschema.setFieldType(index, ConnectorSchemaUtils.lookupDataTypeAndValidate(schema));
                if (ConnectorSchemaUtils.lookupDataTypeAndValidate(schema) == 1883) {
                    position = schema.indexOf(40);
                    if (position == -1) {
                        throw new ConnectorException(15013);
                    }
                    recordschema.setDataTypeConverter(index, schema.substring(0, position));
                    parameters = ConnectorSchemaUtils.getUdfParameters(schema);
                    newparameter = new String[parameters.length];
                    pos = 0;
                    for (String parameter : parameters) {
                        newparameter[pos++] = configuration.get(parameter, "");
                    }
                    recordschema.setParameters(index, newparameter);
                }
                ++index;
            }
            ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(recordschema)));
            logger.info((Object)("target record schema is " + targetRecordSchema));
        }
        if (configurationMap.containsKey("-debugoption")) {
            int debugOption = Integer.parseInt((String)configurationMap.remove("-debugoption"));
            ConnectorConfiguration.setDebugOption(configuration, debugOption);
        }
        if (!configurationMap.isEmpty()) {
            String unrecognizedParams = "";
            for (String key : configurationMap.keySet()) {
                unrecognizedParams = unrecognizedParams + key + " ";
            }
            throw new ConnectorException(15008, unrecognizedParams);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int res = 1;
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)("ConnectorPluginTool starts at " + start));
            res = ToolRunner.run((Tool)new ConnectorPluginTool(), (String[])args);
            long end = System.currentTimeMillis();
            logger.info((Object)("ConnectorPluginTool ends at " + end));
            logger.info((Object)("ConnectorPluginTool time is " + (end - start) / 1000L + "s"));
        }
        catch (Throwable e) {
            logger.info((Object)ConnectorStringUtils.getExceptionStack(e));
            res = e instanceof ConnectorException ? ((ConnectorException)e).getCode() : 10000;
        }
        finally {
            logger.info((Object)("job completed with exit code " + res));
            if (res > 255) {
                res /= 1000;
            }
            System.exit(res);
        }
    }
}

