/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.ConnectorCombineInputFormat;
import com.teradata.connector.common.ConnectorInputFormat;
import com.teradata.connector.common.ConnectorMMapper;
import com.teradata.connector.common.ConnectorMRMapper;
import com.teradata.connector.common.ConnectorOutputFormat;
import com.teradata.connector.common.ConnectorPartitionedOutputFormat;
import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorReducer;
import com.teradata.connector.common.Hook;
import com.teradata.connector.common.PreJobHook;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;

public class ConnectorJobRunner {
    private static Log logger = LogFactory.getLog(ConnectorJobRunner.class);
    public static boolean jobSucceeded = false;

    public static int runJob(Configuration configuration) throws ConnectorException {
        Job mapreduceJob;
        try {
            mapreduceJob = new Job(configuration);
        }
        catch (IOException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return ConnectorJobRunner.runJob(mapreduceJob);
    }

    /*
     * Exception decompiling
     */
    public static int runJob(Job job) throws ConnectorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [75[SIMPLE_IF_TAKEN]], but top level block is 26[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static Boolean validatePlugedIn(Configuration configuration) {
        String plugedInInputFormat = ConnectorConfiguration.getPlugInInputFormat(configuration);
        String plugedInOutputFormat = ConnectorConfiguration.getPlugInOutputFormat(configuration);
        String sourceSerDe = ConnectorConfiguration.getInputSerDe(configuration);
        String targetSerDe = ConnectorConfiguration.getOutputSerDe(configuration);
        if (plugedInInputFormat.isEmpty()) {
            return false;
        }
        if (plugedInOutputFormat.isEmpty()) {
            return false;
        }
        if (sourceSerDe.isEmpty()) {
            return false;
        }
        if (targetSerDe.isEmpty()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("plugedIn InputFormat is " + plugedInInputFormat));
            logger.debug((Object)("plugedIn OutputFormat is " + plugedInOutputFormat));
        }
        return true;
    }

    protected static void configureJob(Job job) throws ConnectorException {
        Configuration configuration = job.getConfiguration();
        try {
            List<Hook> preJobHooks = ConnectorJobRunner.getJobHooks(job.getConfiguration(), PreJobHook.class);
            for (Hook hook : preJobHooks) {
                hook.run(configuration);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        boolean useCombinedInputFormat = ConnectorConfiguration.getUseCombinedInputFormat(configuration);
        if (!useCombinedInputFormat) {
            try {
                InputFormat plugedInInputFormat = (InputFormat)Class.forName(ConnectorConfiguration.getPlugInInputFormat(configuration)).newInstance();
                useCombinedInputFormat = plugedInInputFormat.getSplits((JobContext)job).size() > ConnectorConfiguration.getNumMappers(configuration);
            }
            catch (InstantiationException e) {
                logger.warn((Object)e);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)e);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)e);
            }
            catch (IOException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        }
        boolean usePartitionedOutputFormat = ConnectorConfiguration.getUsePartitionedOutputFormat(configuration);
        job.setJarByClass(ConnectorJobRunner.class);
        if (!useCombinedInputFormat) {
            job.setInputFormatClass(ConnectorInputFormat.class);
        } else {
            job.setInputFormatClass(ConnectorCombineInputFormat.class);
        }
        if (!usePartitionedOutputFormat) {
            job.setOutputFormatClass(ConnectorOutputFormat.class);
        } else {
            job.setOutputFormatClass(ConnectorPartitionedOutputFormat.class);
        }
        int numReducers = ConnectorConfiguration.getNumReducers(configuration);
        if (numReducers == 0) {
            job.setOutputKeyClass(NullWritable.class);
            job.setMapperClass(ConnectorMMapper.class);
            job.setNumReduceTasks(0);
        } else {
            job.setMapperClass(ConnectorMRMapper.class);
            job.setReducerClass(ConnectorReducer.class);
            job.setNumReduceTasks(numReducers);
            if (configuration.getClass("mapred.mapoutput.value.class", null, Object.class) == null) {
                job.setMapOutputValueClass(ConnectorRecord.class);
            }
        }
        job.setSpeculativeExecution(false);
        if (logger.isDebugEnabled()) {
            if (configuration.getBoolean("mapred.map.tasks.speculative.execution", false) || configuration.getBoolean("mapreduce.map.speculative", false)) {
                logger.debug((Object)"speculative configuration is true");
            } else {
                logger.debug((Object)"speculative configuration is false");
            }
            logger.debug((Object)("scheduler class is " + configuration.get("mapred.jobtracker.taskScheduler", "")));
        }
    }

    private static <T> List<Hook> getJobHooks(Configuration configuration, Class<T> clazz) throws Exception {
        String[] hookClasses;
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        String csHooks = clazz.isAssignableFrom(PreJobHook.class) ? ConnectorConfiguration.getPreJobHook(configuration) : ConnectorConfiguration.getPostJobHook(configuration);
        if (csHooks == null) {
            return hooks;
        }
        if ((csHooks = csHooks.trim()).equals("")) {
            return hooks;
        }
        for (String hookClass : hookClasses = csHooks.split(",")) {
            try {
                Hook hook = (Hook)Class.forName(hookClass.trim()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        return hooks;
    }
}

