/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.tool;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tdwallet.WalletCaller;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorPluginUtils;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.common.utils.HadoopConfigurationUtils;
import com.teradata.connector.common.utils.StandardCharsets;
import com.teradata.connector.hcat.utils.HCatPlugInConfiguration;
import com.teradata.connector.hdfs.utils.HdfsPlugInConfiguration;
import com.teradata.connector.hive.utils.HivePlugInConfiguration;
import com.teradata.connector.hive.utils.HiveUtils;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.hadoop.db.TeradataConfiguration;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;

public class ConfigurationMappingUtils {
    private static final byte[] TRIGGER_WORD = "$tdwallet".getBytes(StandardCharsets.UTF_8);
    private static final int TRIGGER_WORD_LENGTH = TRIGGER_WORD.length;

    public static void importConfigurationMapping(Configuration configuration) throws ConnectorException {
        String enclosedby;
        String escapedby;
        String nullnonstring;
        String stagedatabase;
        String sourcequery;
        String sourcefieldnames;
        String sourceconditions;
        String sourcedatabase;
        String sourcetable;
        String password;
        String username;
        String url;
        String classname;
        String jobType = TeradataConfiguration.getInputJobType(configuration);
        if (!(jobType.equalsIgnoreCase("hcat") || jobType.equalsIgnoreCase("hdfs") || jobType.equalsIgnoreCase("hive"))) {
            throw new ConnectorException(12002);
        }
        String fileFormat = TeradataConfiguration.getInputFileFormat(configuration);
        if (!((fileFormat = HadoopConfigurationUtils.getAliasFileFormatName(fileFormat)).equalsIgnoreCase("textfile") || fileFormat.equalsIgnoreCase("rcfile") || fileFormat.equalsIgnoreCase("orcfile") || fileFormat.equalsIgnoreCase("sequencefile") || fileFormat.equalsIgnoreCase("avrofile"))) {
            throw new ConnectorException(12016);
        }
        String method = TeradataConfiguration.getInputMethod(configuration);
        if (!(method.equalsIgnoreCase("split.by.partition") || method.equalsIgnoreCase("split.by.hash") || method.equalsIgnoreCase("split.by.value") || method.equalsIgnoreCase("split.by.amp") || method.equalsIgnoreCase("internal.fastexport"))) {
            throw new ConnectorException(12010);
        }
        try {
            int numMappers = TeradataConfiguration.getInputNumMappers(configuration);
            if (numMappers < 0) {
                throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", " a value equals or more than zero "));
            }
            ConnectorConfiguration.setNumMappers(configuration, numMappers);
        }
        catch (NumberFormatException e) {
            throw new ConnectorException(String.format("invalid provided value for parameter %s, %s value is required for this parameter", "-nummappers", "integer"), e);
        }
        String hiveconf = TeradataConfiguration.getHiveConfigureFile(configuration);
        if (hiveconf != null && !hiveconf.isEmpty()) {
            HivePlugInConfiguration.setOutputConfigureFile(configuration, hiveconf);
        }
        if ((classname = TeradataConfiguration.getJDBCDriverClass(configuration)) != null && !classname.isEmpty()) {
            TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, classname);
        }
        if ((url = TeradataConfiguration.getJDBCURL(configuration)) != null && !url.isEmpty()) {
            TeradataPlugInConfiguration.setInputJdbcUrl(configuration, url);
        }
        if ((username = TeradataConfiguration.getJDBCUsername(configuration)) != null && !username.isEmpty()) {
            TeradataPlugInConfiguration.setInputJdbcUserName(configuration, username);
        }
        if ((password = TeradataConfiguration.getJDBCPassword(configuration)) != null && !password.isEmpty()) {
            TeradataPlugInConfiguration.setInputJdbcPassword(configuration, password);
        }
        boolean accesslock = TeradataConfiguration.getInputAccessLock(configuration);
        TeradataPlugInConfiguration.setInputAccessLock(configuration, accesslock);
        String queryband = TeradataConfiguration.getInputQueryBand(configuration);
        if (queryband != null && !queryband.isEmpty()) {
            TeradataPlugInConfiguration.setInputQueryBand(configuration, queryband);
        }
        if ((sourcetable = TeradataConfiguration.getInputSourceTable(configuration)) != null && !sourcetable.isEmpty()) {
            TeradataPlugInConfiguration.setInputTable(configuration, sourcetable);
        }
        if ((sourcedatabase = TeradataConfiguration.getInputSourceDatabase(configuration)) != null && !sourcedatabase.isEmpty()) {
            TeradataPlugInConfiguration.setInputDatabase(configuration, sourcedatabase);
        }
        if ((sourceconditions = TeradataConfiguration.getInputSourceConditions(configuration)) != null && !sourceconditions.isEmpty()) {
            TeradataPlugInConfiguration.setInputConditions(configuration, sourceconditions);
        }
        if ((sourcefieldnames = TeradataConfiguration.getInputSourceFieldNames(configuration)) != null && !sourcefieldnames.isEmpty()) {
            String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(sourcefieldnames);
            TeradataPlugInConfiguration.setInputFieldNamesArray(configuration, fieldNamesArray);
        }
        if ((sourcequery = TeradataConfiguration.getInputSourceQuery(configuration)) != null && !sourcequery.isEmpty()) {
            TeradataPlugInConfiguration.setInputQuery(configuration, sourcequery);
            method = "split.by.partition";
        }
        String outputPluginName = jobType.equalsIgnoreCase("hcat") ? jobType : jobType + "-" + fileFormat;
        ConnectorPluginUtils.configConnectorOutputPlugins(configuration, outputPluginName);
        ConnectorPluginUtils.configConnectorInputPlugins(configuration, "teradata-" + method);
        String targetdatabase = "";
        targetdatabase = TeradataConfiguration.getInputTargetDatabase(configuration);
        if (targetdatabase != null && !targetdatabase.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputDatabase(configuration, targetdatabase);
            } else if (jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setOutputDatabase(configuration, targetdatabase);
            }
        }
        String targettable = "";
        targettable = TeradataConfiguration.getInputTargetTable(configuration);
        if (targettable != null && !targettable.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputTable(configuration, targettable);
            } else if (jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setOutputTable(configuration, targettable);
            }
        }
        String dir = configuration.get("mapred.output.dir", "");
        String targetpaths = TeradataConfiguration.getInputTargetPaths(configuration);
        if (targetpaths.isEmpty() && !dir.isEmpty()) {
            targetpaths = dir;
        }
        if (targetpaths != null && !targetpaths.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputPaths(configuration, targetpaths);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputPaths(configuration, targetpaths);
            }
        }
        String targetfieldnames = "";
        targetfieldnames = TeradataConfiguration.getInputTargetFieldNames(configuration);
        if (targetfieldnames != null && !targetfieldnames.isEmpty()) {
            String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(targetfieldnames);
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputFieldNamesArray(configuration, fieldNamesArray);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputFieldNamesArray(configuration, fieldNamesArray);
            } else if (jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setOutputFieldNamesArray(configuration, fieldNamesArray);
            }
        }
        String targettableschema = "";
        targettableschema = TeradataConfiguration.getInputTargetTableSchema(configuration);
        if (targettableschema != null && !targettableschema.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputTableSchema(configuration, targettableschema);
            } else if (jobType.equalsIgnoreCase("hdfs") && fileFormat.equalsIgnoreCase("avrofile")) {
                HdfsPlugInConfiguration.setOutputSchema(configuration, targettableschema);
            }
        }
        String separator = TeradataConfiguration.getInputSeparator(configuration);
        if (jobType.equalsIgnoreCase("hive")) {
            HivePlugInConfiguration.setOutputSeparator(configuration, separator);
        } else if (jobType.equalsIgnoreCase("hdfs") && fileFormat.equalsIgnoreCase("textfile")) {
            HdfsPlugInConfiguration.setOutputSeparator(configuration, separator);
        }
        boolean forcestage = TeradataConfiguration.getInputStageForced(configuration);
        TeradataPlugInConfiguration.setInputStageTableForced(configuration, forcestage);
        String stagetablename = TeradataConfiguration.getInputStageTableName(configuration);
        if (stagetablename != null && !stagetablename.isEmpty()) {
            TeradataPlugInConfiguration.setInputStageTableName(configuration, stagetablename);
        }
        if ((stagedatabase = TeradataConfiguration.getInputStageDatabase(configuration)) != null && !stagedatabase.isEmpty()) {
            TeradataPlugInConfiguration.setInputStageDatabase(configuration, stagedatabase);
        }
        int batchsize = TeradataConfiguration.getInputBatchSize(configuration);
        TeradataPlugInConfiguration.setInputBatchSize(configuration, batchsize);
        String splitbycolumn = TeradataConfiguration.getInputSplitByColumn(configuration);
        if (splitbycolumn != null && !splitbycolumn.isEmpty()) {
            TeradataPlugInConfiguration.setInputSplitByColumn(configuration, splitbycolumn);
        }
        String lineseparator = TeradataConfiguration.getInputLineSeparator(configuration);
        HivePlugInConfiguration.setOutputLineSeparator(configuration, lineseparator);
        String nullstring = TeradataConfiguration.getNullString(configuration);
        if (nullstring != null && !nullstring.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setOutputNullString(configuration, nullstring);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setOutputNullString(configuration, nullstring);
            }
        }
        if ((nullnonstring = TeradataConfiguration.getNullNonString(configuration)) != null && !nullnonstring.isEmpty()) {
            HdfsPlugInConfiguration.setOutputNullNonString(configuration, nullnonstring);
        }
        if ((escapedby = TeradataConfiguration.getInputEscapedByString(configuration)) != null && !escapedby.isEmpty()) {
            HdfsPlugInConfiguration.setOutputEscapedBy(configuration, escapedby);
        }
        if ((enclosedby = TeradataConfiguration.getInputEnclosedByString(configuration)) != null && !enclosedby.isEmpty()) {
            HdfsPlugInConfiguration.setOutputEnclosedBy(configuration, enclosedby);
        }
        boolean usexviews = TeradataConfiguration.getDataDictionaryUseXViews(configuration);
        TeradataPlugInConfiguration.setInputDataDictionaryUseXView(configuration, usexviews);
        String avroschemafile = TeradataConfiguration.getAvroSchemaFilePath(configuration);
        if (avroschemafile != null && !avroschemafile.isEmpty()) {
            HdfsPlugInConfiguration.setOutputAvroSchemaFile(configuration, avroschemafile);
        }
        long numpartitionsinstaging = TeradataConfiguration.getInputNumPartitionsInStaging(configuration);
        TeradataPlugInConfiguration.setInputNumPartitions(configuration, numpartitionsinstaging);
        String fastexportsockethost = TeradataConfiguration.getInputFastExportSocketHost(configuration);
        if (fastexportsockethost != null && !fastexportsockethost.isEmpty()) {
            TeradataPlugInConfiguration.setInputFastExportSocketHost(configuration, fastexportsockethost);
        }
        int fastexportsocketport = TeradataConfiguration.getInputFastExportSocketPort(configuration);
        TeradataPlugInConfiguration.setInputFastExportSocketPort(configuration, fastexportsocketport);
        long fastexportsockettimeout = TeradataConfiguration.getInputFastExportSocketTimeout(configuration);
        TeradataPlugInConfiguration.setInputFastExportSocketTimeout(configuration, fastexportsockettimeout);
        String targetpartitionschema = TeradataConfiguration.getInputTargetPartitionSchema(configuration);
        if (targetpartitionschema != null && !targetpartitionschema.isEmpty()) {
            ConnectorConfiguration.setUsePartitionedOutputFormat(configuration, true);
            HivePlugInConfiguration.setOutputPartitionSchema(configuration, targetpartitionschema);
            List<String> targetPartitionList = ConnectorSchemaUtils.parseColumns(targetpartitionschema);
            List<String> targetPartitonColNmList = ConnectorSchemaUtils.parseColumnNames(targetPartitionList);
            if (!targetfieldnames.isEmpty()) {
                List<String> targetFieldList = ConnectorSchemaUtils.parseColumns(targetfieldnames);
                List<String> targetFieldColNmList = ConnectorSchemaUtils.parseColumnNames(targetFieldList);
                int[] mapping = TeradataSchemaUtils.getColumnMapping(targetFieldColNmList, targetPartitonColNmList.toArray(new String[targetPartitonColNmList.size()]));
                List<String> sourceFieldList = ConnectorSchemaUtils.parseColumns(sourcefieldnames);
                List<String> sourceFieldColNmList = ConnectorSchemaUtils.parseColumnNames(sourceFieldList);
                String[] partitionArray = new String[targetPartitonColNmList.size()];
                for (int index = 0; index < mapping.length; ++index) {
                    partitionArray[index] = sourceFieldColNmList.get(mapping[index]);
                }
                ConnectorConfiguration.setOutputPartitionColumnNames(configuration, ConnectorSchemaUtils.concatFieldNamesArray(partitionArray));
            }
        }
        if (jobType.equalsIgnoreCase("hive") && HiveUtils.isHiveOutputTablePartitioned(configuration)) {
            ConnectorConfiguration.setUsePartitionedOutputFormat(configuration, true);
        }
    }

    public static void exportConfigurationMapping(Configuration configuration) throws ConnectorException {
        String sourcepartitionschema;
        String errortablename;
        String stagedatabase;
        String queryband;
        String enclosedby;
        String escapedby;
        String nullnonstring;
        String targetfieldnames;
        String targettable;
        String sourcetableschema;
        String sourcefieldnames;
        String sourcetable;
        String sourcedatabase;
        String password;
        String username;
        String url;
        String classname;
        String jobType = TeradataConfiguration.getOutputJobType(configuration);
        if (!(jobType.equalsIgnoreCase("hcat") || jobType.equalsIgnoreCase("hdfs") || jobType.equalsIgnoreCase("hive"))) {
            throw new ConnectorException(13002);
        }
        String fileFormat = TeradataConfiguration.getOutputFileFormat(configuration);
        if (!((fileFormat = HadoopConfigurationUtils.getAliasFileFormatName(fileFormat)).equalsIgnoreCase("textfile") || fileFormat.equalsIgnoreCase("rcfile") || fileFormat.equalsIgnoreCase("orcfile") || fileFormat.equalsIgnoreCase("sequencefile") || fileFormat.equalsIgnoreCase("avrofile"))) {
            throw new ConnectorException(12016);
        }
        String method = TeradataConfiguration.getOutputMethod(configuration);
        if (!method.equalsIgnoreCase("batch.insert") && !method.equalsIgnoreCase("internal.fastload")) {
            throw new ConnectorException(13004);
        }
        String inputPluginName = jobType.equalsIgnoreCase("hcat") ? jobType : jobType + "-" + fileFormat;
        ConnectorPluginUtils.configConnectorInputPlugins(configuration, inputPluginName);
        ConnectorPluginUtils.configConnectorOutputPlugins(configuration, "teradata-" + method);
        String hiveconf = TeradataConfiguration.getHiveConfigureFile(configuration);
        if (hiveconf != null && !hiveconf.isEmpty()) {
            HivePlugInConfiguration.setInputConfigureFile(configuration, hiveconf);
        }
        if ((classname = TeradataConfiguration.getJDBCDriverClass(configuration)) != null && !classname.isEmpty()) {
            TeradataPlugInConfiguration.setOutputJdbcDriverClass(configuration, classname);
        }
        if ((url = TeradataConfiguration.getJDBCURL(configuration)) != null && !url.isEmpty()) {
            TeradataPlugInConfiguration.setOutputJdbcUrl(configuration, url);
        }
        if ((username = TeradataConfiguration.getJDBCUsername(configuration)) != null && !username.isEmpty()) {
            TeradataPlugInConfiguration.setOutputJdbcUserName(configuration, username);
        }
        if ((password = TeradataConfiguration.getJDBCPassword(configuration)) != null && !password.isEmpty()) {
            TeradataPlugInConfiguration.setOutputJdbcPassword(configuration, password);
        }
        String dir = configuration.get("mapred.input.dir", "");
        String sourcepaths = TeradataConfiguration.getOutputSourcePaths(configuration);
        if (sourcepaths.isEmpty() && !dir.isEmpty()) {
            sourcepaths = dir;
        }
        if (sourcepaths != null && !sourcepaths.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setInputPaths(configuration, sourcepaths);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setInputPaths(configuration, sourcepaths);
            }
        }
        if ((sourcedatabase = TeradataConfiguration.getOutputSourceDatabase(configuration)) != null && !sourcedatabase.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setInputDatabase(configuration, sourcedatabase);
            } else if (jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setInputDatabase(configuration, sourcedatabase);
            }
        }
        if ((sourcetable = TeradataConfiguration.getOutputSourceTable(configuration)) != null && !sourcetable.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setInputTable(configuration, sourcetable);
            } else if (jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setInputTable(configuration, sourcetable);
            }
        }
        if ((sourcefieldnames = TeradataConfiguration.getOutputSourceFieldNames(configuration)) != null && !sourcefieldnames.isEmpty()) {
            String[] sourceFieldNamesArray = sourcefieldnames.split(",");
            int index = 0;
            for (String fieldName : sourceFieldNamesArray) {
                sourceFieldNamesArray[index++] = fieldName.trim();
            }
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setInputFieldNamesArray(configuration, sourceFieldNamesArray);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setInputFieldNamesArray(configuration, sourceFieldNamesArray);
            } else if (jobType.equalsIgnoreCase("hcat")) {
                HCatPlugInConfiguration.setInputFieldNamesArray(configuration, sourceFieldNamesArray);
            }
        }
        if ((sourcetableschema = TeradataConfiguration.getOutputSourceTableSchema(configuration)) != null && !sourcetableschema.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setInputTableSchema(configuration, sourcetableschema);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setInputSchema(configuration, sourcetableschema);
            }
        }
        if ((targettable = TeradataConfiguration.getOutputTargetTable(configuration)) != null && !targettable.isEmpty()) {
            TeradataPlugInConfiguration.setOutputTable(configuration, targettable);
        }
        if ((targetfieldnames = TeradataConfiguration.getOutputTargetFieldNames(configuration)) != null && !targetfieldnames.isEmpty()) {
            String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(targetfieldnames);
            fieldNamesArray = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNamesArray);
            TeradataPlugInConfiguration.setOutputFieldNamesArray(configuration, fieldNamesArray);
        }
        int targetfieldcount = TeradataConfiguration.getOutputTargetFieldCount(configuration);
        TeradataPlugInConfiguration.setOutputFieldCount(configuration, targetfieldcount);
        String separator = TeradataConfiguration.getOutputSeparator(configuration);
        if (jobType.equalsIgnoreCase("hive")) {
            HivePlugInConfiguration.setInputSeparator(configuration, separator);
        } else if (jobType.equalsIgnoreCase("hdfs") && fileFormat.equalsIgnoreCase("textfile")) {
            HdfsPlugInConfiguration.setInputSeparator(configuration, separator);
        }
        String lineseparator = TeradataConfiguration.getOutputLineSeparator(configuration);
        HivePlugInConfiguration.setInputLineSeparator(configuration, lineseparator);
        String nullstring = TeradataConfiguration.getNullString(configuration);
        if (nullstring != null && !nullstring.isEmpty()) {
            if (jobType.equalsIgnoreCase("hive")) {
                HivePlugInConfiguration.setInputNullString(configuration, nullstring);
            } else if (jobType.equalsIgnoreCase("hdfs")) {
                HdfsPlugInConfiguration.setInputNullString(configuration, nullstring);
            }
        }
        if ((nullnonstring = TeradataConfiguration.getNullNonString(configuration)) != null && !nullnonstring.isEmpty()) {
            HdfsPlugInConfiguration.setInputNullNonString(configuration, nullnonstring);
        }
        if ((escapedby = TeradataConfiguration.getOutputEscapedByString(configuration)) != null && !escapedby.isEmpty()) {
            HdfsPlugInConfiguration.setInputEscapedBy(configuration, escapedby);
        }
        if ((enclosedby = TeradataConfiguration.getOutputEnclosedByString(configuration)) != null && !enclosedby.isEmpty()) {
            HdfsPlugInConfiguration.setInputEnclosedBy(configuration, enclosedby);
        }
        if ((queryband = TeradataConfiguration.getOutputQueryBand(configuration)) != null && !queryband.isEmpty()) {
            TeradataPlugInConfiguration.setOutputQueryBand(configuration, queryband);
        }
        int batchsize = TeradataConfiguration.getOutputBatchSize(configuration);
        TeradataPlugInConfiguration.setOutputBatchSize(configuration, batchsize);
        int numMappers = TeradataConfiguration.getOutputNumMappers(configuration);
        ConnectorConfiguration.setNumMappers(configuration, numMappers);
        int numReducers = TeradataConfiguration.getOutputNumReducers(configuration);
        ConnectorConfiguration.setNumReducers(configuration, numReducers);
        if (numMappers != 0 && numReducers != 0) {
            throw new ConnectorException(13011);
        }
        String fastloadsockethost = TeradataConfiguration.getOutputFastloadSocketHost(configuration);
        if (fastloadsockethost != null && !fastloadsockethost.isEmpty()) {
            TeradataPlugInConfiguration.setOutputFastloadSocketHost(configuration, fastloadsockethost);
        }
        int fastloadsocketport = TeradataConfiguration.getOutputFastloadSocketPort(configuration);
        TeradataPlugInConfiguration.setOutputFastloadSocketPort(configuration, fastloadsocketport);
        long fastloadsockettimeout = TeradataConfiguration.getOutputFastloadSocketTimeout(configuration);
        TeradataPlugInConfiguration.setOutputFastloadSocketTimeout(configuration, fastloadsockettimeout);
        boolean forcestage = TeradataConfiguration.getOutputStageForced(configuration);
        TeradataPlugInConfiguration.setOutputStageTableForced(configuration, forcestage);
        String stagetablename = TeradataConfiguration.getOutputStageTableName(configuration);
        if (stagetablename != null && !stagetablename.isEmpty()) {
            TeradataPlugInConfiguration.setOutputStageTableName(configuration, stagetablename);
        }
        if ((stagedatabase = TeradataConfiguration.getOutputStageDatabase(configuration)) != null && !stagedatabase.isEmpty()) {
            TeradataPlugInConfiguration.setOutputStageDatabase(configuration, stagedatabase);
        }
        if ((errortablename = TeradataConfiguration.getOutputErrorTableName(configuration)) != null && !errortablename.isEmpty()) {
            TeradataPlugInConfiguration.setOutputErrorTableName(configuration, errortablename);
        }
        boolean keepstagetable = TeradataConfiguration.getOutputStageTableKept(configuration);
        TeradataPlugInConfiguration.setOutputStageTableKept(configuration, keepstagetable);
        boolean usexviews = TeradataConfiguration.getDataDictionaryUseXViews(configuration);
        TeradataPlugInConfiguration.setOutputDataDictionaryUseXView(configuration, usexviews);
        String avroschemafile = TeradataConfiguration.getAvroSchemaFilePath(configuration);
        if (avroschemafile != null && !avroschemafile.isEmpty()) {
            HdfsPlugInConfiguration.setInputAvroSchemaFile(configuration, avroschemafile);
        }
        if ((sourcepartitionschema = TeradataConfiguration.getOutputSourcePartitionSchema(configuration)) != null && !sourcepartitionschema.isEmpty()) {
            HivePlugInConfiguration.setInputPartitionSchema(configuration, sourcepartitionschema);
        }
    }

    public static void associateCredentialsForOozieJavaAction(JobContext context) {
        if (System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            context.getConfiguration().set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
            context.getConfiguration().set("tez.credentials.path", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
    }

    public static void loadOozieJavaActionConf(JobContext context) {
        if (System.getProperty("oozie.action.conf.xml") != null) {
            context.getConfiguration().addResource(new Path("file:///", System.getProperty("oozie.action.conf.xml")));
        }
    }

    public static void hideCredentials(JobContext context) {
        String password;
        String username;
        String outputPassword;
        String outputUserName;
        String inputPassword;
        Configuration configuration = context.getConfiguration();
        String inputUserName = TeradataPlugInConfiguration.getInputJdbcUserName(configuration);
        if (null != inputUserName && 0 != inputUserName.length()) {
            TeradataPlugInConfiguration.setInputTeradataUserName(context, inputUserName.getBytes(StandardCharsets.UTF_8));
            TeradataPlugInConfiguration.setInputJdbcUserName(configuration, "");
        }
        if (null != (inputPassword = TeradataPlugInConfiguration.getInputJdbcPassword(configuration)) && 0 != inputPassword.length()) {
            TeradataPlugInConfiguration.setInputTeradataPassword(context, inputPassword.getBytes(StandardCharsets.UTF_8));
            TeradataPlugInConfiguration.setInputJdbcPassword(configuration, "");
        }
        if (null != (outputUserName = TeradataPlugInConfiguration.getOutputJdbcUserName(configuration)) && 0 != outputUserName.length()) {
            TeradataPlugInConfiguration.setOutputTeradataUserName(context, outputUserName.getBytes(StandardCharsets.UTF_8));
            TeradataPlugInConfiguration.setOutputJdbcUserName(configuration, "");
        }
        if (null != (outputPassword = TeradataPlugInConfiguration.getOutputJdbcPassword(configuration)) && 0 != outputPassword.length()) {
            TeradataPlugInConfiguration.setOutputTeradataPassword(context, outputPassword.getBytes(StandardCharsets.UTF_8));
            TeradataPlugInConfiguration.setOutputJdbcPassword(configuration, "");
        }
        if (null != (username = TeradataConfiguration.getJDBCUsername(configuration)) && 0 != username.length()) {
            TeradataConfiguration.setJDBCUsername(configuration, "");
        }
        if (null != (password = TeradataConfiguration.getJDBCPassword(configuration)) && 0 != password.length()) {
            TeradataConfiguration.setJDBCPassword(configuration, "");
        }
    }

    public static void performWalletSubstitutions(JobContext context) throws ConnectorException {
        if (ConfigurationMappingUtils.containsWalletKeyword(TeradataPlugInConfiguration.getInputTeradataUserName(context)) || ConfigurationMappingUtils.containsWalletKeyword(TeradataPlugInConfiguration.getInputTeradataPassword(context)) || ConfigurationMappingUtils.containsWalletKeyword(TeradataPlugInConfiguration.getOutputTeradataUserName(context)) || ConfigurationMappingUtils.containsWalletKeyword(TeradataPlugInConfiguration.getOutputTeradataPassword(context))) {
            WalletCaller.performSubstitutions(context);
        }
    }

    private static boolean containsWalletKeyword(byte[] credential) {
        if (null == TRIGGER_WORD || null == credential) {
            return false;
        }
        int last_start_position = credential.length - TRIGGER_WORD_LENGTH;
        block0: for (int start_position = 0; start_position <= last_start_position; ++start_position) {
            for (int offset = 0; offset < TRIGGER_WORD_LENGTH; ++offset) {
                if (credential[start_position + offset] != TRIGGER_WORD[offset]) continue block0;
            }
            return true;
        }
        return false;
    }
}

