/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.converter;

import com.teradata.connector.common.converter.ConnectorDataWritable;
import com.teradata.connector.common.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import junit.framework.Assert;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Test;

public class ConnectorDataWritableTest {
    @Test
    public void testShortWritable() throws Exception {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteArray);
        ConnectorDataWritable.ShortWritable sw = new ConnectorDataWritable.ShortWritable();
        sw.set((short)12);
        sw.write(output);
        output.close();
        byte[] buf = byteArray.toByteArray();
        Assert.assertEquals((int)12, (int)ByteBuffer.wrap(buf).getShort());
        ConnectorDataWritable.ShortWritable sw2 = new ConnectorDataWritable.ShortWritable();
        sw2.set((short)22);
        Assert.assertEquals((int)-1, (int)sw.compareTo(sw2));
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(buf));
        sw.readFields(input);
        Assert.assertEquals((Object)new Short(12), (Object)sw.get());
    }

    @Test
    public void testBigDecimalWritable() throws Exception {
        ConnectorDataWritable.BigDecimalWritable big = new ConnectorDataWritable.BigDecimalWritable();
        big.set(new BigDecimal(9999));
        ConnectorDataWritable.BigDecimalWritable big2 = new ConnectorDataWritable.BigDecimalWritable();
        big2.set(new BigDecimal(9999));
        Assert.assertEquals((int)0, (int)big.compareTo(big2));
        big2.set(new BigDecimal(99999));
        Assert.assertEquals((int)-1, (int)big.compareTo(big2));
    }

    @Test
    public void testClobWritable() throws Exception {
        ConnectorDataWritable.ClobWritable cw = new ConnectorDataWritable.ClobWritable();
        cw.set("Test");
        Assert.assertEquals((Object)"Test", (Object)cw.get());
        DataInputStream input = new DataInputStream(new ByteArrayInputStream("Test2".getBytes()));
        cw.set(new SerialClob("Test2".toCharArray()));
        Assert.assertTrue((boolean)(cw.get() instanceof SerialClob));
    }

    @Test
    public void testBlobWritable() throws Exception {
        ConnectorDataWritable.BlobWritable bw = new ConnectorDataWritable.BlobWritable();
        bw.set("Test".getBytes());
        Assert.assertEquals((String)"Test", (String)new String((byte[])bw.get()));
        ByteArrayInputStream byteArray = new ByteArrayInputStream("Test2".getBytes());
        DataInputStream input = new DataInputStream(byteArray);
        bw.set(new SerialBlob("Test2".getBytes()));
        Assert.assertTrue((boolean)(bw.get() instanceof SerialBlob));
    }

    @Test
    public void testDateWritable() throws Exception {
        ConnectorDataWritable.DateWritable dw = new ConnectorDataWritable.DateWritable();
        dw.set(new Date(new java.util.Date().getTime()));
        ConnectorDataWritable.DateWritable dw2 = new ConnectorDataWritable.DateWritable();
        Thread.sleep(1L);
        dw2.set(new Date(new java.util.Date().getTime()));
        Assert.assertEquals((int)-1, (int)dw.compareTo(dw2));
    }

    @Test
    public void testTimeWritable() throws Exception {
        ConnectorDataWritable.TimeWritable tw = new ConnectorDataWritable.TimeWritable();
        tw.set(new Time(new java.util.Date().getTime()));
        ConnectorDataWritable.TimeWritable tw2 = new ConnectorDataWritable.TimeWritable();
        Thread.sleep(1L);
        tw2.set(new Time(new java.util.Date().getTime()));
        Assert.assertEquals((int)1, (int)tw2.compareTo(tw));
    }

    @Test
    public void testTimestampWritable() throws Exception {
        ConnectorDataWritable.TimestampWritable tw = new ConnectorDataWritable.TimestampWritable();
        tw.set(new Timestamp(66666L));
        ConnectorDataWritable.TimestampWritable tw2 = new ConnectorDataWritable.TimestampWritable();
        tw2.set(new Timestamp(66666L));
        Assert.assertEquals((int)0, (int)tw.compareTo(tw2));
    }

    @Test
    public void testPeriodWritable() throws Exception {
        ConnectorDataWritable.PeriodWritable pw = new ConnectorDataWritable.PeriodWritable();
        pw.set("(2013-12-18, 2013-12-19)");
        Assert.assertEquals((Object)"(2013-12-18, 2013-12-19)", (Object)pw.get());
    }

    @Test
    public void testCalendarWritable() throws Exception {
        ConnectorDataWritable.CalendarWritable cw = new ConnectorDataWritable.CalendarWritable();
        cw.set(new GregorianCalendar());
        ConnectorDataWritable.CalendarWritable cw2 = new ConnectorDataWritable.CalendarWritable();
        Thread.sleep(1L);
        cw2.set(new GregorianCalendar());
        Assert.assertEquals((int)-1, (int)cw.compareTo(cw2));
    }

    @Test
    public void testConnectorWritableFactory() throws Exception {
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(new Integer(0)) instanceof IntWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory("") instanceof Text));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(8) instanceof DoubleWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(16) instanceof BooleanWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(-3) instanceof BytesWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(-6) instanceof ByteWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(5) instanceof ConnectorDataWritable.ShortWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(3) instanceof ConnectorDataWritable.BigDecimalWritable));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(1) instanceof Text));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(-1) instanceof Text));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(1111) instanceof Text));
        Assert.assertTrue((boolean)(ConnectorDataWritable.connectorWritableFactory(1885) instanceof ConnectorDataWritable.CalendarWritable));
        try {
            ConnectorDataWritable.connectorWritableFactory(-900);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("invalid object type \"-900\""));
        }
    }

    @Test
    public void testSetWritableValue() throws Exception {
        BooleanWritable bw = new BooleanWritable();
        ConnectorDataWritable.setWritableValue((Writable)bw, true, 16);
        Assert.assertEquals((boolean)true, (boolean)bw.get());
        BytesWritable bwr = new BytesWritable();
        ConnectorDataWritable.setWritableValue((Writable)bwr, "Test".getBytes(), -3);
        Assert.assertEquals((String)"Test", (String)new String(bwr.getBytes()).trim());
        ByteWritable byter = new ByteWritable();
        ConnectorDataWritable.setWritableValue((Writable)byter, (byte)26, -6);
        Assert.assertEquals((int)26, (int)byter.get());
        ConnectorDataWritable.ShortWritable sw = new ConnectorDataWritable.ShortWritable();
        ConnectorDataWritable.setWritableValue((Writable)sw, (short)26, 5);
        Assert.assertEquals((Object)new Short(26), (Object)sw.get());
        ConnectorDataWritable.BigDecimalWritable bdw = new ConnectorDataWritable.BigDecimalWritable();
        ConnectorDataWritable.setWritableValue((Writable)bdw, new BigDecimal(26), 3);
        Assert.assertEquals((Object)new BigDecimal(26), (Object)bdw.get());
        Text text = new Text();
        ConnectorDataWritable.setWritableValue((Writable)text, "d", 1);
        Assert.assertEquals((int)100, (int)text.charAt(0));
        ConnectorDataWritable.setWritableValue((Writable)text, "Test", -1);
        Assert.assertEquals((String)"Test", (String)text.toString());
        try {
            ConnectorDataWritable.setWritableValue((Writable)text, "d", 1883);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("invalid object type \"1,883\""));
            Assert.assertEquals((int)100, (int)text.charAt(0));
        }
    }

    @Test
    public void testGetWritableValue() throws Exception {
        DoubleWritable dw = new DoubleWritable(23.0);
        Assert.assertEquals((Object)23.0, (Object)ConnectorDataWritable.getWritableValue((Writable)dw, 8));
        BooleanWritable bw = new BooleanWritable(true);
        Assert.assertEquals((Object)true, (Object)ConnectorDataWritable.getWritableValue((Writable)bw, 16));
        BytesWritable bwr = new BytesWritable("bin".getBytes());
        byte[] barray = (byte[])ConnectorDataWritable.getWritableValue((Writable)bwr, -3);
        Assert.assertEquals((String)"bin", (String)new String(barray));
        ByteWritable byter = new ByteWritable(9);
        Assert.assertEquals((Object)9, (Object)ConnectorDataWritable.getWritableValue((Writable)byter, -6));
        ConnectorDataWritable cdw = new ConnectorDataWritable.ShortWritable();
        cdw.set((short)10);
        Assert.assertEquals((Object)10, (Object)ConnectorDataWritable.getWritableValue((Writable)cdw, 5));
        cdw = new ConnectorDataWritable.BigDecimalWritable();
        cdw.set(new BigDecimal(20));
        Assert.assertEquals((Object)new BigDecimal(20), (Object)ConnectorDataWritable.getWritableValue((Writable)cdw, 3));
        cdw = new ConnectorDataWritable.ClobWritable();
        cdw.set("large char");
        Assert.assertEquals((Object)"large char", (Object)ConnectorDataWritable.getWritableValue((Writable)cdw, 2005));
        cdw = new ConnectorDataWritable.BlobWritable();
        cdw.set("large char".getBytes());
        barray = (byte[])ConnectorDataWritable.getWritableValue((Writable)cdw, 2004);
        Assert.assertEquals((String)"large char", (String)new String(barray));
        cdw = new ConnectorDataWritable.CalendarWritable();
        cdw.set(Calendar.getInstance());
        Calendar cal = (Calendar)ConnectorDataWritable.getWritableValue((Writable)cdw, 1885);
        Assert.assertEquals((int)Calendar.getInstance().get(12), (int)cal.get(12));
        Text text = new Text("c");
        Assert.assertEquals((Object)"c", (Object)ConnectorDataWritable.getWritableValue((Writable)text, 1));
        Assert.assertEquals((Object)"c", (Object)ConnectorDataWritable.getWritableValue((Writable)text, -1));
        Assert.assertEquals((Object)"()", (Object)ConnectorDataWritable.getWritableValue((Writable)new Text("()"), 1111));
        try {
            ConnectorDataWritable.getWritableValue((Writable)text, 1883);
        }
        catch (ConnectorException ce) {
            Assert.assertTrue((boolean)ce.getMessage().contains("invalid object type \"1,883\""));
        }
    }
}

