/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common.converter;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.jdbc.ResultStruct;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class ConnectorDataWritable
implements WritableComparable {
    public abstract void set(Object var1) throws ConnectorException;

    public abstract Object get();

    public static void writeObjectAsText(Object o, DataOutput out) throws IOException {
        Text n = new Text(o.toString());
        n.write(out);
    }

    public static String readObjectAsText(DataInput in) throws IOException {
        Text n = new Text();
        n.readFields(in);
        return n.toString();
    }

    public static Writable connectorWritableFactory(Object o) throws ConnectorException {
        int type = ConnectorSchemaUtils.getGenericObjectType(o);
        return ConnectorDataWritable.connectorWritableFactory(type);
    }

    public static Writable connectorWritableFactory(int type) throws ConnectorException {
        switch (type) {
            case 7: 
            case 8: {
                return new DoubleWritable();
            }
            case 16: {
                return new BooleanWritable();
            }
            case -3: 
            case -2: {
                return new BytesWritable();
            }
            case -6: {
                return new org.apache.hadoop.io.ByteWritable();
            }
            case 6: {
                return new FloatWritable();
            }
            case 4: {
                return new IntWritable();
            }
            case -5: {
                return new LongWritable();
            }
            case 5: {
                return new ShortWritable();
            }
            case 2: 
            case 3: {
                return new BigDecimalWritable();
            }
            case 2004: {
                return new BlobWritable();
            }
            case 2005: {
                return new ClobWritable();
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                return new Text();
            }
            case 91: {
                return new DateWritable();
            }
            case 92: {
                return new TimeWritable();
            }
            case 93: {
                return new TimestampWritable();
            }
            case 2002: {
                return new PeriodWritable();
            }
            case 1884: {
                return NullWritable.get();
            }
            case 1885: 
            case 1886: {
                return new CalendarWritable();
            }
        }
        throw new ConnectorException(15028, type);
    }

    public static Writable connectorWritableFactoryParquet(int type) throws ConnectorException {
        switch (type) {
            case 7: 
            case 8: {
                return new DoubleWritable();
            }
            case 16: {
                return new BooleanWritable();
            }
            case -3: 
            case -2: {
                return new BytesWritable();
            }
            case -6: {
                return new ByteWritable();
            }
            case 6: {
                return new FloatWritable();
            }
            case 4: {
                return new IntWritable();
            }
            case -5: {
                return new LongWritable();
            }
            case 5: {
                return new org.apache.hadoop.hive.serde2.io.ShortWritable();
            }
            case 2: 
            case 3: {
                return new BigDecimalWritable();
            }
            case 2004: {
                return new BlobWritable();
            }
            case 2005: {
                return new ClobWritable();
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                return new Text();
            }
            case 91: {
                return new DateWritable();
            }
            case 92: {
                return new TimeWritable();
            }
            case 93: {
                return new TimestampWritable();
            }
            case 2002: {
                return new PeriodWritable();
            }
            case 1884: {
                return NullWritable.get();
            }
            case 1885: 
            case 1886: {
                return new CalendarWritable();
            }
        }
        throw new ConnectorException(15028, type);
    }

    public static void setWritableValue(Writable writable, Object o, int type) throws ConnectorException {
        if (o == null) {
            return;
        }
        switch (type) {
            case 7: 
            case 8: {
                DoubleWritable w1 = (DoubleWritable)writable;
                w1.set(((Double)o).doubleValue());
                return;
            }
            case 16: {
                BooleanWritable w2 = (BooleanWritable)writable;
                w2.set(((Boolean)o).booleanValue());
                return;
            }
            case -3: 
            case -2: {
                BytesWritable w3 = (BytesWritable)writable;
                byte[] bytes = (byte[])o;
                w3.set(bytes, 0, bytes.length);
                return;
            }
            case -6: {
                org.apache.hadoop.io.ByteWritable w4 = (org.apache.hadoop.io.ByteWritable)writable;
                w4.set(((Byte)o).byteValue());
                return;
            }
            case 6: {
                FloatWritable w5 = (FloatWritable)writable;
                w5.set(((Float)o).floatValue());
                return;
            }
            case 4: {
                IntWritable w6 = (IntWritable)writable;
                w6.set(((Integer)o).intValue());
                return;
            }
            case -5: {
                LongWritable w7 = (LongWritable)writable;
                w7.set(((Long)o).longValue());
                return;
            }
            case 2: 
            case 3: 
            case 5: 
            case 91: 
            case 92: 
            case 93: 
            case 1885: 
            case 1886: 
            case 2002: 
            case 2004: 
            case 2005: {
                ConnectorDataWritable w8 = (ConnectorDataWritable)writable;
                w8.set(o);
                return;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                Text w9 = (Text)writable;
                w9.set((String)o);
                return;
            }
            case 1882: 
            case 1883: {
                int primType = ConnectorSchemaUtils.getGenericObjectType(o);
                ConnectorDataWritable.setWritableValue(writable, o, primType);
            }
        }
        throw new ConnectorException(15028, type);
    }

    public static void setWritableValueParquet(Writable writable, Object o, int type) throws ConnectorException {
        if (o == null) {
            return;
        }
        switch (type) {
            case 7: 
            case 8: {
                DoubleWritable w1 = (DoubleWritable)writable;
                w1.set(((Double)o).doubleValue());
                return;
            }
            case 16: {
                BooleanWritable w2 = (BooleanWritable)writable;
                w2.set(((Boolean)o).booleanValue());
                return;
            }
            case -3: 
            case -2: {
                BytesWritable w3 = (BytesWritable)writable;
                byte[] bytes = (byte[])o;
                w3.set(bytes, 0, bytes.length);
                return;
            }
            case -6: {
                ByteWritable w4 = (ByteWritable)writable;
                w4.set(((Byte)o).byteValue());
                return;
            }
            case 6: {
                FloatWritable w5 = (FloatWritable)writable;
                w5.set(((Float)o).floatValue());
                return;
            }
            case 4: {
                IntWritable w6 = (IntWritable)writable;
                w6.set(((Integer)o).intValue());
                return;
            }
            case -5: {
                LongWritable w7 = (LongWritable)writable;
                w7.set(((Long)o).longValue());
                return;
            }
            case 5: {
                org.apache.hadoop.hive.serde2.io.ShortWritable ws4 = (org.apache.hadoop.hive.serde2.io.ShortWritable)writable;
                ws4.set(((Short)o).shortValue());
                return;
            }
            case 2: 
            case 3: 
            case 91: 
            case 92: 
            case 93: 
            case 1885: 
            case 1886: 
            case 2002: 
            case 2004: 
            case 2005: {
                ConnectorDataWritable w8 = (ConnectorDataWritable)writable;
                w8.set(o);
                return;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                Text w9 = (Text)writable;
                if (o instanceof HiveVarchar) {
                    HiveVarchar hv = new HiveVarchar((HiveVarchar)o, ((HiveVarchar)o).getCharacterLength());
                    w9.set(hv.getValue());
                    return;
                }
                if (o instanceof HiveChar) {
                    HiveChar hv = new HiveChar((HiveChar)o, ((HiveChar)o).getCharacterLength());
                    w9.set(hv.getValue());
                    return;
                }
                w9.set((String)o);
                return;
            }
            case 1882: 
            case 1883: {
                int primType = ConnectorSchemaUtils.getGenericObjectType(o);
                ConnectorDataWritable.setWritableValue(writable, o, primType);
            }
        }
        throw new ConnectorException(15028, type);
    }

    public static Object getWritableValue(Writable writable, int type) throws ConnectorException {
        if (writable instanceof NullWritable) {
            return null;
        }
        switch (type) {
            case 7: 
            case 8: {
                DoubleWritable w1 = (DoubleWritable)writable;
                return w1.get();
            }
            case 16: {
                BooleanWritable w2 = (BooleanWritable)writable;
                return w2.get();
            }
            case -3: 
            case -2: {
                BytesWritable w3 = (BytesWritable)writable;
                return w3.getBytes();
            }
            case -6: {
                org.apache.hadoop.io.ByteWritable w4 = (org.apache.hadoop.io.ByteWritable)writable;
                return w4.get();
            }
            case 6: {
                FloatWritable w5 = (FloatWritable)writable;
                return Float.valueOf(w5.get());
            }
            case 4: {
                IntWritable w6 = (IntWritable)writable;
                return w6.get();
            }
            case -5: {
                LongWritable w7 = (LongWritable)writable;
                return w7.get();
            }
            case 2: 
            case 3: 
            case 5: 
            case 91: 
            case 92: 
            case 93: 
            case 1885: 
            case 1886: 
            case 2002: 
            case 2004: 
            case 2005: {
                ConnectorDataWritable w8 = (ConnectorDataWritable)writable;
                return w8.get();
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                Text w9 = (Text)writable;
                return w9.toString();
            }
            case 1882: 
            case 1883: {
                int primType = ConnectorSchemaUtils.getWritableObjectType(writable);
                ConnectorDataWritable.getWritableValue(writable, primType);
            }
        }
        throw new ConnectorException(15028, type);
    }

    public static final class CalendarWritable
    extends ConnectorDataWritable {
        Calendar cal;

        public void write(DataOutput out) throws IOException {
            Long l = this.cal.getTimeInMillis();
            TimeZone tz = this.cal.getTimeZone();
            out.writeLong(l);
            CalendarWritable.writeObjectAsText(tz.getID(), out);
        }

        public void readFields(DataInput in) throws IOException {
            long l = in.readLong();
            String tzStr = CalendarWritable.readObjectAsText(in);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone(tzStr));
            this.cal.setTimeInMillis(l);
        }

        public int compareTo(Object o) {
            long thatVal;
            long thisVal = this.cal.getTimeInMillis();
            return thisVal < (thatVal = ((CalendarWritable)o).cal.getTimeInMillis()) ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public void set(Object o) throws ConnectorException {
            this.cal = (Calendar)o;
        }

        @Override
        public Object get() {
            return this.cal;
        }
    }

    public static final class PeriodWritable
    extends ConnectorDataWritable {
        private Object value;
        private String sValue;

        private static String periodToString(Object value) {
            String result = value.toString();
            int bracketPos = result.indexOf(91);
            if (bracketPos > 0 && (bracketPos = (result = result.substring(bracketPos + 1)).lastIndexOf(93)) > 0) {
                result = "(" + result.substring(0, bracketPos) + ")";
            }
            return result;
        }

        public void write(DataOutput out) throws IOException {
            PeriodWritable.writeObjectAsText(PeriodWritable.periodToString(this.value), out);
        }

        public void readFields(DataInput in) throws IOException {
            String sVal;
            this.sValue = sVal = PeriodWritable.readObjectAsText(in);
        }

        public int compareTo(Object o) {
            return 0;
        }

        @Override
        public void set(Object o) throws ConnectorException {
            if (o instanceof ResultStruct) {
                this.value = o;
            } else if (o instanceof String) {
                this.sValue = (String)o;
            }
        }

        @Override
        public Object get() {
            if (this.value != null) {
                return this.value;
            }
            return this.sValue;
        }
    }

    public static final class TimestampWritable
    extends ConnectorDataWritable {
        private Timestamp value;

        public void write(DataOutput out) throws IOException {
            TimestampWritable.writeObjectAsText(this.value, out);
        }

        public void readFields(DataInput in) throws IOException {
            String s = TimestampWritable.readObjectAsText(in);
            this.value = Timestamp.valueOf(s);
        }

        public int compareTo(Object o) {
            long thatVal;
            long thisVal = this.value.getTime();
            return thisVal < (thatVal = ((TimestampWritable)o).value.getTime()) ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public void set(Object o) throws ConnectorException {
            this.value = (Timestamp)o;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    public static final class TimeWritable
    extends ConnectorDataWritable {
        private Time value;

        public void write(DataOutput out) throws IOException {
            TimeWritable.writeObjectAsText(this.value, out);
        }

        public void readFields(DataInput in) throws IOException {
            String s = TimeWritable.readObjectAsText(in);
            this.value = Time.valueOf(s);
        }

        public int compareTo(Object o) {
            long thatVal;
            long thisVal = this.value.getTime();
            return thisVal < (thatVal = ((TimeWritable)o).value.getTime()) ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public void set(Object o) throws ConnectorException {
            this.value = (Time)o;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    public static final class DateWritable
    extends ConnectorDataWritable {
        private Date value;

        public void write(DataOutput out) throws IOException {
            DateWritable.writeObjectAsText(this.value, out);
        }

        public void readFields(DataInput in) throws IOException {
            String s = DateWritable.readObjectAsText(in);
            this.value = Date.valueOf(s);
        }

        public int compareTo(Object o) {
            long thatVal;
            long thisVal = this.value.getTime();
            return thisVal < (thatVal = ((DateWritable)o).value.getTime()) ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public void set(Object o) throws ConnectorException {
            this.value = (Date)o;
        }

        @Override
        public Object get() {
            return this.value;
        }
    }

    public static final class BlobWritable
    extends ConnectorDataWritable {
        private Blob value;
        private byte[] bytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] toBytes() {
            Blob object = this.value;
            int bufsize = 10000;
            int size = 100000;
            int offset = 0;
            int nbytes = 0;
            Blob blobObj = object;
            byte[] buf = new byte[bufsize];
            byte[] data = new byte[size];
            InputStream stream = null;
            try {
                stream = blobObj.getBinaryStream();
                while ((nbytes = stream.read(buf, 0, bufsize)) > 0) {
                    if (offset + nbytes > size) {
                        byte[] newdata = new byte[size *= 2];
                        System.arraycopy(data, 0, newdata, 0, offset);
                        data = newdata;
                    }
                    System.arraycopy(buf, 0, data, offset, nbytes);
                    offset += nbytes;
                }
            }
            catch (IOException newdata) {
            }
            catch (SQLException newdata) {
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException newdata) {}
            }
            if (offset == 0) {
                return new byte[0];
            }
            byte[] lob = new byte[offset];
            System.arraycopy(data, 0, lob, 0, offset);
            return lob;
        }

        public void write(DataOutput out) throws IOException {
            BytesWritable bw = new BytesWritable();
            byte[] bytes = this.toBytes();
            bw.set(bytes, 0, bytes.length);
            bw.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            BytesWritable bw = new BytesWritable();
            bw.readFields(in);
            this.bytes = bw.getBytes();
        }

        public int compareTo(Object o) {
            return 0;
        }

        @Override
        public void set(Object o) {
            if (o instanceof Blob) {
                this.value = (Blob)o;
            } else if (o instanceof byte[]) {
                this.bytes = (byte[])o;
            }
        }

        @Override
        public Object get() {
            if (this.value != null) {
                return this.value;
            }
            return this.bytes;
        }
    }

    public static final class ClobWritable
    extends ConnectorDataWritable {
        private Clob value;
        private String sValue;

        private String toClobString() throws IOException {
            StringBuffer builder = new StringBuffer();
            int bufsize = 10000;
            Clob clobObj = this.value;
            byte[] bytesData = new byte[bufsize];
            InputStream stream = null;
            builder.setLength(0);
            try {
                int nbytes;
                stream = clobObj.getAsciiStream();
                while ((nbytes = stream.read(bytesData, 0, bufsize)) > 0) {
                    for (int i = 0; i < nbytes; ++i) {
                        byte b = bytesData[i];
                        int c = b & 0xFF;
                        builder.append((char)c);
                    }
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            return builder.toString();
        }

        @Override
        public Object get() {
            if (this.value != null) {
                return this.value;
            }
            return this.sValue;
        }

        public void write(DataOutput out) throws IOException {
            ClobWritable.writeObjectAsText(this.toClobString(), out);
        }

        public void readFields(DataInput in) throws IOException {
            this.sValue = ClobWritable.readObjectAsText(in);
        }

        public int compareTo(Object o) {
            return 0;
        }

        @Override
        public void set(Object o) throws ConnectorException {
            if (o instanceof Clob) {
                this.value = (Clob)o;
            } else if (o instanceof String) {
                this.sValue = (String)o;
            } else {
                throw new ConnectorException(15028, o.getClass());
            }
        }
    }

    public static final class BigDecimalWritable
    extends ConnectorDataWritable {
        private BigDecimal value;

        @Override
        public void set(Object val) {
            this.value = (BigDecimal)val;
        }

        @Override
        public BigDecimal get() {
            return this.value;
        }

        public void write(DataOutput out) throws IOException {
            BigDecimalWritable.writeObjectAsText(this.value, out);
        }

        public void readFields(DataInput in) throws IOException {
            this.value = new BigDecimal(BigDecimalWritable.readObjectAsText(in));
        }

        public int compareTo(Object o) {
            BigDecimal thisVal = this.value;
            BigDecimal thatVal = ((BigDecimalWritable)o).value;
            return thisVal.compareTo(thatVal);
        }
    }

    public static final class ShortWritable
    extends ConnectorDataWritable {
        private short value;

        public void write(DataOutput out) throws IOException {
            out.writeShort(this.value);
        }

        public void readFields(DataInput in) throws IOException {
            this.value = in.readShort();
        }

        public int compareTo(Object o) {
            short thisVal = this.value;
            short thatVal = ((ShortWritable)o).value;
            return thisVal < thatVal ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public Short get() {
            return this.value;
        }

        @Override
        public void set(Object o) {
            this.value = (Short)o;
        }
    }
}

