/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Reducer;

public class ConnectorReducer
extends Reducer<WritableComparable, ConnectorRecord, ConnectorRecord, Writable> {
    public void run(Reducer.Context context) throws IOException, InterruptedException {
        String jobReducer = ConnectorConfiguration.getJobReducer(context.getConfiguration());
        if (!jobReducer.isEmpty()) {
            try {
                Reducer userReducer = (Reducer)Class.forName(ConnectorConfiguration.getJobReducer(context.getConfiguration())).newInstance();
                userReducer.run(context);
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        } else {
            this.setup(context);
            while (context.nextKey()) {
                this.reduce((WritableComparable)context.getCurrentKey(), (Iterable<ConnectorRecord>)context.getValues(), context);
            }
            this.cleanup(context);
        }
    }

    protected void reduce(WritableComparable key, Iterable<ConnectorRecord> values, Reducer.Context context) throws IOException, InterruptedException {
        for (ConnectorRecord value : values) {
            context.write((Object)value, (Object)key);
        }
    }
}

