/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.exception.ConnectorException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ConnectorRecordSchema
implements Writable {
    int length;
    int[] types;
    String[] dataTypeConverters;
    String[][] parameters;

    public ConnectorRecordSchema() {
    }

    public ConnectorRecordSchema(int valueLength) {
        this.length = valueLength;
        this.types = new int[valueLength];
        this.dataTypeConverters = new String[valueLength];
        this.parameters = new String[valueLength][];
    }

    public int getLength() {
        return this.length;
    }

    public void setFieldType(int index, int fieldType) throws ConnectorException {
        if (index > this.length || index < 0) {
            throw new ConnectorException(15012);
        }
        this.types[index] = fieldType;
    }

    public int getFieldType(int index) throws ConnectorException {
        if (index > this.length || index < 0) {
            throw new ConnectorException(15012);
        }
        return this.types[index];
    }

    public int[] getFieldTypes() {
        return this.types;
    }

    public void setDataTypeConverter(int index, String dataTypeConverter) throws ConnectorException {
        if (index > this.length || index < 0) {
            throw new ConnectorException(15012);
        }
        this.dataTypeConverters[index] = dataTypeConverter;
    }

    public String getDataTypeConverter(int index) throws ConnectorException {
        if (index > this.length || index < 0) {
            throw new ConnectorException(15012);
        }
        return this.dataTypeConverters[index];
    }

    public String[] getDataTypeConverters() throws ConnectorException {
        return this.dataTypeConverters;
    }

    public void setParameters(int index, String[] parameter) throws ConnectorException {
        if (index > this.length || index < 0) {
            throw new ConnectorException(15012);
        }
        this.parameters[index] = parameter;
    }

    public String[] getParameters(int index) throws ConnectorException {
        if (index > this.length || index < 0) {
            throw new ConnectorException(15012);
        }
        return this.parameters[index];
    }

    public String[][] getParametersArray() throws ConnectorException {
        return this.parameters;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        int udfCount = 0;
        out.writeInt(this.length);
        for (i = 0; i < this.length; ++i) {
            out.writeInt(this.types[i]);
            if (this.types[i] != 1883) continue;
            ++udfCount;
        }
        out.writeInt(udfCount);
        if (udfCount != 0) {
            for (i = 0; i < this.length; ++i) {
                if (this.dataTypeConverters[i] == null || this.dataTypeConverters[i].isEmpty()) continue;
                out.writeInt(i);
                out.writeUTF(this.dataTypeConverters[i]);
                if (this.parameters[i] != null) {
                    int parameterCount = this.parameters[i].length;
                    out.writeInt(parameterCount);
                    for (int j = 0; j < parameterCount; ++j) {
                        out.writeUTF(this.parameters[i][j]);
                    }
                    continue;
                }
                out.writeInt(0);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.types = new int[this.length];
        this.dataTypeConverters = new String[this.length];
        this.parameters = new String[this.length][];
        for (int i = 0; i < this.length; ++i) {
            this.types[i] = in.readInt();
        }
        int udfCount = in.readInt();
        if (udfCount != 0) {
            int j = 0;
            int m = 0;
            int n = 0;
            for (int i = 0; i < udfCount; ++i) {
                j = in.readInt();
                this.dataTypeConverters[j] = in.readUTF();
                m = in.readInt();
                this.parameters[j] = new String[m];
                for (n = 0; n < m; ++n) {
                    this.parameters[j][n] = in.readUTF();
                }
            }
        }
    }
}

