/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class ConnectorPlugin {
    private static HashMap<String, ConnectorPlugin> sourcePlugins;
    private static HashMap<String, ConnectorPlugin> targetPlugins;
    private static final String CONNECTOR_PLUGINS_FILE = "teradata.connector.plugins.xml";
    private static Log logger;
    public static final String DUMMY_TERA_MODULE_TYPE = "teradata";
    public static final String TAG_PLUGINS = "plugins";
    public static final String TAG_SOURCE = "source";
    public static final String TAG_TARGET = "target";
    public static final String TAG_NAME = "name";
    public static final String TAG_DESC = "description";
    public static final String TAG_CONF_CLZ = "configurationClass";
    public static final String TAG_INPUT_FORMAT_CLZ = "inputformatClass";
    public static final String TAG_SERDE_CLZ = "serdeClass";
    public static final String TAG_CONVERTER_CLZ = "converterClass";
    public static final String TAG_INPUT_PROC = "inputProcessor";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_VALUE = "value";
    public static final String TAG_OUTPUT_FORMAT_CLZ = "outputformatClass";
    public static final String TAG_OUTPUT_PROC = "outputProcessor";
    public static final String TAG_PRE_HOOK = "preHook";
    public static final String TAG_POST_HOOK = "postHook";
    protected String pluginName = "";
    protected String configurationClass = "";
    protected String preHook = "";
    protected String postHook = "";
    protected HashMap<String, String> properties = new HashMap();

    public static void loadConnectorPluginFromConf(Configuration configuration) throws ParserConfigurationException, SAXException, IOException {
        String filePath = ConnectorConfiguration.getPluginConf(configuration);
        if (filePath == null || filePath.trim().equals("")) {
            return;
        }
        ConnectorPlugin.loadConnectorPlugins(configuration, filePath);
    }

    public static void loadConnectorPluginsAsResource(String fileName) throws ParserConfigurationException, SAXException, IOException {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ConnectorPlugin.class.getClassLoader();
        }
        if ((url = classLoader.getResource(fileName)) == null) {
            throw new ConnectorException(15019, fileName);
        }
        logger.info((Object)("load plugins in " + url.toString()));
        ConnectorPlugin.loadConnectorPlugins(null, url);
    }

    public static void loadConnectorPlugins(Configuration configuration, Object name) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = null;
        Element root = null;
        if (name instanceof URL) {
            doc = builder.parse(((URL)name).toString());
        } else if (name instanceof String) {
            Path filePath = new Path((String)name);
            FileSystem fs = filePath.getFileSystem(configuration);
            logger.info((Object)("Using plugin configuration file: " + fs.makeQualified(filePath)));
            if (!fs.exists(filePath)) {
                throw new ConnectorException(15023, filePath);
            }
            if (!fs.isFile(filePath)) {
                throw new ConnectorException(15024, filePath);
            }
            BufferedInputStream is = new BufferedInputStream((InputStream)fs.open(filePath));
            doc = builder.parse(is);
        } else {
            throw new ConnectorException(15025, name.getClass().getName());
        }
        root = doc.getDocumentElement();
        if (!root.getNodeName().equals(TAG_PLUGINS)) {
            throw new ConnectorException(15017, TAG_PLUGINS);
        }
        NodeList subroot = root.getChildNodes();
        for (int i = 0; i < subroot.getLength(); ++i) {
            ConnectorPlugin plugin;
            Node sub = subroot.item(i);
            if (!(sub instanceof Element)) continue;
            Element subEle = (Element)sub;
            if (subEle.getTagName().equals(TAG_SOURCE)) {
                plugin = new ConnectorSourcePlugin();
                plugin.readFields(subEle);
                plugin.validate();
                if (sourcePlugins.get(plugin.getName()) != null) {
                    throw new ConnectorException(15016, plugin.getName());
                }
                sourcePlugins.put(plugin.getName(), plugin);
                continue;
            }
            if (subEle.getTagName().equals(TAG_TARGET)) {
                plugin = new ConnectorTargetPlugin();
                plugin.readFields(subEle);
                plugin.validate();
                if (targetPlugins.get(plugin.getName()) != null) {
                    throw new ConnectorException(15016, plugin.getName());
                }
                targetPlugins.put(plugin.getName(), plugin);
                continue;
            }
            throw new ConnectorException(15014, subEle.getTagName());
        }
    }

    public static ConnectorPlugin getConnectorSourcePlugin(String name) throws ConnectorException {
        ConnectorPlugin plugin = sourcePlugins.get(name);
        if (plugin == null) {
            throw new ConnectorException(15022, name);
        }
        return plugin;
    }

    public static ConnectorPlugin getConnectorTargetPlugin(String name) throws ConnectorException {
        ConnectorPlugin plugin = targetPlugins.get(name);
        if (plugin == null) {
            throw new ConnectorException(15022, name);
        }
        return plugin;
    }

    public String getName() {
        return this.pluginName;
    }

    public void setName(String name) {
        this.pluginName = name;
    }

    public String getConfigurationClass() {
        return this.configurationClass;
    }

    public void setConfigurationClass(String configurationClass) {
        this.configurationClass = configurationClass;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    public String getPreHook() {
        return this.preHook;
    }

    public void setPreHook(String preHook) {
        this.preHook = preHook;
    }

    public String getPostHook() {
        return this.postHook;
    }

    public void setPostHook(String postHook) {
        this.postHook = postHook;
    }

    protected void loadProperties(Element e) throws ConnectorException {
        if (!e.hasChildNodes()) {
            return;
        }
        NodeList items = e.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node item = items.item(i);
            if (!(item instanceof Element)) continue;
            Element le = (Element)item;
            if (le.getTagName().equals(TAG_PROPERTY)) {
                if (!le.hasChildNodes()) continue;
                NodeList pros = le.getChildNodes();
                String name = null;
                String value = null;
                for (int k = 0; k < pros.getLength(); ++k) {
                    Node pro = pros.item(k);
                    if (!(pro instanceof Element)) continue;
                    Element field = (Element)pro;
                    if (field.getTagName().equals(TAG_NAME)) {
                        if (!field.hasChildNodes()) continue;
                        name = ((Text)field.getFirstChild()).getData().trim();
                        continue;
                    }
                    if (field.getTagName().equals(TAG_VALUE)) {
                        if (!field.hasChildNodes()) continue;
                        value = ((Text)field.getFirstChild()).getData().trim();
                        continue;
                    }
                    if (field.getTagName().equals(TAG_DESC)) continue;
                    throw new ConnectorException(15014, field.getTagName());
                }
                if (value == null || name == null) continue;
                this.properties.put(name, value);
                continue;
            }
            throw new ConnectorException(15014, le.getTagName());
        }
    }

    protected void validate() throws ConnectorException {
        if (this.pluginName == null) {
            throw new ConnectorException(15015, TAG_NAME);
        }
        if (this.configurationClass == null) {
            throw new ConnectorException(15021, this.pluginName);
        }
    }

    public void loadConfiguration(Configuration conf) {
        for (Map.Entry<String, String> en : this.properties.entrySet()) {
            String name = en.getKey();
            String value = en.getValue();
            if (conf.get(name, null) != null) continue;
            conf.set(name, value);
        }
    }

    protected abstract void readFields(Element var1) throws ConnectorException;

    static {
        logger = LogFactory.getLog(ConnectorPlugin.class);
        try {
            sourcePlugins = new HashMap();
            targetPlugins = new HashMap();
            ConnectorPlugin.loadConnectorPluginsAsResource(CONNECTOR_PLUGINS_FILE);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static class ConnectorTargetPlugin
    extends ConnectorPlugin {
        private String outputFormatClass = "";
        private String serdeClass = "";
        private String outputProcessor = "";
        private String converterClass = "";

        public String getOutputFormatClass() {
            return this.outputFormatClass;
        }

        public void setOutputFormatClass(String outputformatClass) {
            this.outputFormatClass = outputformatClass;
        }

        public String getSerdeClass() {
            return this.serdeClass;
        }

        public void setSerdeClass(String serdeClass) {
            this.serdeClass = serdeClass;
        }

        public String getOutputProcessor() {
            return this.outputProcessor;
        }

        public void setOutputProcessor(String outputProcessor) {
            this.outputProcessor = outputProcessor;
        }

        public String getConverterClass() {
            return this.converterClass;
        }

        public void setConverterClass(String converterClass) {
            this.converterClass = converterClass;
        }

        @Override
        public void readFields(Element e) throws ConnectorException {
            if (!e.hasChildNodes()) {
                throw new ConnectorException(15020, e.getTagName());
            }
            NodeList items = e.getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Node item = items.item(j);
                if (!(item instanceof Element)) continue;
                Element el = (Element)item;
                String tagName = el.getTagName();
                if (!el.hasChildNodes()) {
                    throw new ConnectorException(15015, tagName);
                }
                if (tagName.equals(ConnectorPlugin.TAG_NAME)) {
                    if (!el.hasChildNodes()) continue;
                    this.pluginName = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_DESC)) continue;
                if (tagName.equals(ConnectorPlugin.TAG_CONF_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.configurationClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_OUTPUT_FORMAT_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.outputFormatClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_SERDE_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.serdeClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_CONVERTER_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.converterClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_OUTPUT_PROC)) {
                    if (!el.hasChildNodes()) continue;
                    this.outputProcessor = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_PRE_HOOK)) {
                    if (!el.hasChildNodes()) continue;
                    this.preHook = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_POST_HOOK)) {
                    if (!el.hasChildNodes()) continue;
                    this.postHook = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_PROPERTIES)) {
                    if (!el.hasChildNodes()) continue;
                    this.loadProperties(el);
                    continue;
                }
                throw new ConnectorException(15014, tagName);
            }
        }

        @Override
        protected void validate() throws ConnectorException {
            super.validate();
            if (this.outputFormatClass == null || this.serdeClass == null) {
                throw new ConnectorException(15021, this.pluginName);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("name: " + this.pluginName + "\n");
            sb.append("configurationClass: " + this.configurationClass + "\n");
            sb.append("preHook: " + this.preHook + "\n");
            sb.append("postHook: " + this.postHook + "\n");
            sb.append("outputFormatClass: " + this.outputFormatClass + "\n");
            sb.append("serdeClass: " + this.serdeClass + "\n");
            sb.append("outputProcessor: " + this.outputProcessor + "\n");
            sb.append("converterClass: " + this.converterClass + "\n");
            sb.append("properties: " + this.properties + "\n");
            return sb.toString();
        }
    }

    public static class ConnectorSourcePlugin
    extends ConnectorPlugin {
        private String inputFormatClass = "";
        private String serDeClass = "";
        private String inputProcessor = "";

        public String getInputFormatClass() {
            return this.inputFormatClass;
        }

        public void setInputFormatClass(String inputFormatClass) {
            this.inputFormatClass = inputFormatClass;
        }

        public String getSerDeClass() {
            return this.serDeClass;
        }

        public void setSerDeClass(String serDeClass) {
            this.serDeClass = serDeClass;
        }

        public String getInputProcessor() {
            return this.inputProcessor;
        }

        public void setInputProcessor(String inputProcessor) {
            this.inputProcessor = inputProcessor;
        }

        @Override
        public void readFields(Element e) throws ConnectorException {
            if (!e.hasChildNodes()) {
                throw new ConnectorException(15020, e.getTagName());
            }
            NodeList items = e.getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Node item = items.item(j);
                if (!(item instanceof Element)) continue;
                Element el = (Element)item;
                String tagName = el.getTagName();
                if (!el.hasChildNodes()) {
                    throw new ConnectorException(15015, tagName);
                }
                if (tagName.equals(ConnectorPlugin.TAG_NAME)) {
                    if (!el.hasChildNodes()) continue;
                    this.pluginName = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_DESC)) continue;
                if (tagName.equals(ConnectorPlugin.TAG_CONF_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.configurationClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_INPUT_FORMAT_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.inputFormatClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_SERDE_CLZ)) {
                    if (!el.hasChildNodes()) continue;
                    this.serDeClass = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_INPUT_PROC)) {
                    if (!el.hasChildNodes()) continue;
                    this.inputProcessor = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_PRE_HOOK)) {
                    if (!el.hasChildNodes()) continue;
                    this.preHook = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_POST_HOOK)) {
                    if (!el.hasChildNodes()) continue;
                    this.postHook = ((Text)el.getFirstChild()).getData();
                    continue;
                }
                if (tagName.equals(ConnectorPlugin.TAG_PROPERTIES)) {
                    if (!el.hasChildNodes()) continue;
                    this.loadProperties(el);
                    continue;
                }
                throw new ConnectorException(15014, tagName);
            }
        }

        @Override
        protected void validate() throws ConnectorException {
            super.validate();
            if (this.inputFormatClass == null || this.serDeClass == null) {
                throw new ConnectorException(15021, this.pluginName);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("pluginName: " + this.pluginName + "\n");
            sb.append("configurationClass: " + this.configurationClass + "\n");
            sb.append("preHook: " + this.preHook + "\n");
            sb.append("postHook: " + this.postHook + "\n");
            sb.append("inputFormatClass: " + this.inputFormatClass + "\n");
            sb.append("serdeClass: " + this.serDeClass + "\n");
            sb.append("inputProcessor: " + this.inputProcessor + "\n");
            sb.append("properties: " + this.properties.toString() + "\n");
            return sb.toString();
        }
    }
}

