/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorPartitionedRecordWriter;
import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.DummyRecordWriter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ConnectorPartitionedOutputFormat<K, V>
extends OutputFormat<ConnectorRecord, Writable> {
    OutputFormat<K, Writable> plugedInOutputFormat = null;

    public RecordWriter<ConnectorRecord, Writable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        if (ConnectorConfiguration.getDebugOption(context.getConfiguration()) == 1) {
            return new DummyRecordWriter(context);
        }
        return new ConnectorPartitionedRecordWriter(context);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        if (this.plugedInOutputFormat == null) {
            this.configurePlugedInOutputFormat(context.getConfiguration());
        }
        this.plugedInOutputFormat.checkOutputSpecs(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.plugedInOutputFormat == null) {
            this.configurePlugedInOutputFormat(context.getConfiguration());
        }
        return this.plugedInOutputFormat.getOutputCommitter(context);
    }

    protected void configurePlugedInOutputFormat(Configuration configuration) throws IOException, InterruptedException {
        try {
            this.plugedInOutputFormat = (OutputFormat)Class.forName(ConnectorConfiguration.getPlugInOutputFormat(configuration)).newInstance();
        }
        catch (InstantiationException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }
}

