/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.converter.ConnectorConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ConnectorOutputFormat<K, V>
extends OutputFormat<ConnectorRecord, Writable> {
    OutputFormat<K, Writable> plugedInOutputFormat = null;

    public RecordWriter<ConnectorRecord, Writable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        if (ConnectorConfiguration.getDebugOption(context.getConfiguration()) == 1) {
            return new DummyRecordWriter(context);
        }
        return new ConnectorFileRecordWriter(context);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        if (this.plugedInOutputFormat == null) {
            this.configurePlugedInOutputFormat(context.getConfiguration());
        }
        this.plugedInOutputFormat.checkOutputSpecs(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.plugedInOutputFormat == null) {
            this.configurePlugedInOutputFormat(context.getConfiguration());
        }
        return this.plugedInOutputFormat.getOutputCommitter(context);
    }

    protected void configurePlugedInOutputFormat(Configuration configuration) throws IOException, InterruptedException {
        try {
            this.plugedInOutputFormat = (OutputFormat)Class.forName(ConnectorConfiguration.getPlugInOutputFormat(configuration)).newInstance();
        }
        catch (InstantiationException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    protected ConnectorRecordSchema getSourceConnectorRecordSchema(Configuration configuration) {
        ConnectorRecordSchema schema = null;
        try {
            schema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration));
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        return schema;
    }

    class DummyRecordWriter
    extends RecordWriter<ConnectorRecord, Writable> {
        private Log logger = LogFactory.getLog(DummyRecordWriter.class);
        protected RecordWriter<Writable, Writable> baseRecordWriter = null;
        protected ConnectorSerDe targetSerDe = null;
        protected ConnectorConverter dataConverter = null;
        protected Configuration configuration;
        protected ConnectorRecord targetConnectorRecord = null;
        private long end_timestamp = 0L;
        private long start_timestamp = System.currentTimeMillis();

        public DummyRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            this.logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
            this.configuration = context.getConfiguration();
            if (ConnectorOutputFormat.this.plugedInOutputFormat == null) {
                ConnectorOutputFormat.this.configurePlugedInOutputFormat(this.configuration);
            }
            this.baseRecordWriter = ConnectorOutputFormat.this.plugedInOutputFormat.getRecordWriter(context);
            try {
                this.targetSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getOutputSerDe(this.configuration)).newInstance();
                this.targetSerDe.initialize((JobContext)context, ConnectorConfiguration.direction.output);
                String converterClass = ConnectorConfiguration.getDataConverter(this.configuration);
                if (!converterClass.isEmpty()) {
                    this.dataConverter = (ConnectorConverter)Class.forName(ConnectorConfiguration.getDataConverter(this.configuration)).newInstance();
                    this.dataConverter.initialize((JobContext)context);
                    this.dataConverter.lookupConverter(ConnectorOutputFormat.this.getSourceConnectorRecordSchema(this.configuration));
                }
            }
            catch (InstantiationException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        public void write(ConnectorRecord key, Writable value) throws IOException, InterruptedException {
            if (this.dataConverter != null) {
                this.targetConnectorRecord = this.dataConverter.convert(key);
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.baseRecordWriter.close(context);
            this.end_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
            this.logger.info((Object)("the total elapsed time of recordwriter " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
        }
    }

    class ConnectorFileRecordWriter
    extends RecordWriter<ConnectorRecord, Writable> {
        private Log logger = LogFactory.getLog(ConnectorFileRecordWriter.class);
        protected RecordWriter<Writable, Writable> baseRecordWriter = null;
        protected ConnectorSerDe targetSerDe = null;
        protected ConnectorConverter dataConverter = null;
        protected Configuration configuration;
        protected ConnectorRecord targetConnectorRecord = null;
        private long end_timestamp = 0L;
        private long start_timestamp = System.currentTimeMillis();

        public ConnectorFileRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            this.logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
            this.configuration = context.getConfiguration();
            if (ConnectorOutputFormat.this.plugedInOutputFormat == null) {
                ConnectorOutputFormat.this.configurePlugedInOutputFormat(this.configuration);
            }
            this.baseRecordWriter = ConnectorOutputFormat.this.plugedInOutputFormat.getRecordWriter(context);
            try {
                this.targetSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getOutputSerDe(this.configuration)).newInstance();
                this.targetSerDe.initialize((JobContext)context, ConnectorConfiguration.direction.output);
                String converterClass = ConnectorConfiguration.getDataConverter(this.configuration);
                if (!converterClass.isEmpty()) {
                    this.dataConverter = (ConnectorConverter)Class.forName(ConnectorConfiguration.getDataConverter(this.configuration)).newInstance();
                    this.dataConverter.initialize((JobContext)context);
                    this.dataConverter.lookupConverter(ConnectorOutputFormat.this.getSourceConnectorRecordSchema(this.configuration));
                }
            }
            catch (InstantiationException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        public void write(ConnectorRecord key, Writable value) throws IOException, InterruptedException {
            if (this.dataConverter != null) {
                this.targetConnectorRecord = this.dataConverter.convert(key);
                this.baseRecordWriter.write((Object)NullWritable.get(), (Object)this.targetSerDe.serialize(this.targetConnectorRecord));
            } else {
                this.baseRecordWriter.write((Object)NullWritable.get(), (Object)this.targetSerDe.serialize(key));
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.baseRecordWriter.close(context);
            this.end_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordwriter class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
            this.logger.info((Object)("the total elapsed time of recordwriter " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
        }
    }
}

