/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Mapper;

public class ConnectorMMapper
extends Mapper<WritableComparable, ConnectorRecord, ConnectorRecord, Writable> {
    private static Log logger = LogFactory.getLog(ConnectorMMapper.class);
    private boolean startupKeepAliveThread = true;

    public void setStartupKeepAliveThread(boolean val) {
        this.startupKeepAliveThread = val;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        if (logger.isDebugEnabled()) {
            Field[] fields;
            InputSplit inputSplit = context.getInputSplit();
            for (Field field : fields = inputSplit.getClass().getFields()) {
                try {
                    logger.debug((Object)(field.getName() + " is: " + field.get(inputSplit)));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            logger.debug((Object)("task tracker ip address is " + InetAddress.getLocalHost().getHostAddress()));
        }
    }

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        String jobMapper;
        Configuration conf = context.getConfiguration();
        long timeout = Integer.parseInt(conf.get("mapred.task.timeout"));
        if (timeout != 0L && this.startupKeepAliveThread) {
            KeepAliveThread updateCounterThread = new KeepAliveThread(context);
            updateCounterThread.setDaemon(true);
            updateCounterThread.start();
            logger.info((Object)"keep-alive thread started");
        }
        if (!(jobMapper = ConnectorConfiguration.getJobMapper(conf)).isEmpty()) {
            try {
                Mapper mapperClass = (Mapper)Class.forName(jobMapper).newInstance();
                mapperClass.run(context);
            }
            catch (InstantiationException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        } else {
            this.setup(context);
            while (context.nextKeyValue()) {
                this.map((WritableComparable)context.getCurrentKey(), (ConnectorRecord)context.getCurrentValue(), context);
            }
            this.cleanup(context);
        }
    }

    protected void map(WritableComparable key, ConnectorRecord value, Mapper.Context context) throws IOException, InterruptedException {
        context.write((Object)value, (Object)key);
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (logger.isDebugEnabled()) {
            Counter counter = context.getCounter((Enum)Task.Counter.MAP_INPUT_BYTES);
            logger.debug((Object)("     " + counter.getDisplayName() + "=" + counter.getValue()));
            counter = context.getCounter((Enum)Task.Counter.MAP_INPUT_RECORDS);
            logger.debug((Object)("     " + counter.getDisplayName() + "=" + counter.getValue()));
            counter = context.getCounter((Enum)Task.Counter.MAP_OUTPUT_BYTES);
            logger.debug((Object)("     " + counter.getDisplayName() + "=" + counter.getValue()));
            counter = context.getCounter((Enum)Task.Counter.MAP_OUTPUT_RECORDS);
            logger.debug((Object)("     " + counter.getDisplayName() + "=" + counter.getValue()));
            counter = context.getCounter((Enum)Task.Counter.MAP_OUTPUT_MATERIALIZED_BYTES);
            logger.debug((Object)("     " + counter.getDisplayName() + "=" + counter.getValue()));
            counter = context.getCounter((Enum)Task.Counter.MAP_SKIPPED_RECORDS);
            logger.debug((Object)("     " + counter.getDisplayName() + "=" + counter.getValue()));
        }
    }

    public class KeepAliveThread
    extends Thread {
        private Mapper.Context context;
        private final long UPDATE_FREQ = 3000L;

        public KeepAliveThread(Mapper.Context context) {
            super("Teradata Connector Keep-Alive Thread");
            this.UPDATE_FREQ = 3000L;
            this.context = context;
        }

        @Override
        public void run() {
            while (true) {
                this.context.progress();
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)ConnectorStringUtils.getExceptionStack(e));
                    continue;
                }
                break;
            }
        }
    }
}

