/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.common;

import com.teradata.connector.common.ConnectorRecord;
import com.teradata.connector.common.ConnectorSerDe;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ConnectorInputFormat<K, V>
extends InputFormat<K, ConnectorRecord> {
    InputFormat<K, Writable> plugedInInputFormat = null;

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        if (this.plugedInInputFormat == null) {
            this.configurePlugedInInuputFormat(context);
        }
        return this.plugedInInputFormat.getSplits(context);
    }

    public RecordReader<K, ConnectorRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new ConnectorRecordReader();
    }

    protected Path[] filterPath(Path[] paths) {
        return null;
    }

    protected void configurePlugedInInuputFormat(JobContext context) throws ConnectorException {
        Configuration configuration = context.getConfiguration();
        try {
            this.plugedInInputFormat = (InputFormat)Class.forName(ConnectorConfiguration.getPlugInInputFormat(configuration)).newInstance();
        }
        catch (InstantiationException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public class ConnectorRecordReader
    extends RecordReader<K, ConnectorRecord> {
        private Log logger = LogFactory.getLog(ConnectorRecordReader.class);
        protected ConnectorSerDe sourceSerDe;
        protected RecordReader<K, Writable> plugedInRecordReader;
        protected ConnectorRecord connectorRecord;
        protected Configuration configuration;
        private long end_timestamp = 0L;
        private long start_timestamp = 0L;

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.start_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "initialize time is:  " + this.start_timestamp));
            if (ConnectorInputFormat.this.plugedInInputFormat == null) {
                ConnectorInputFormat.this.configurePlugedInInuputFormat((JobContext)context);
            }
            this.configuration = context.getConfiguration();
            try {
                this.sourceSerDe = (ConnectorSerDe)Class.forName(ConnectorConfiguration.getInputSerDe(this.configuration)).newInstance();
                this.sourceSerDe.initialize((JobContext)context, ConnectorConfiguration.direction.input);
            }
            catch (InstantiationException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
            this.plugedInRecordReader = ConnectorInputFormat.this.plugedInInputFormat.createRecordReader(split, context);
            this.plugedInRecordReader.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.plugedInRecordReader.nextKeyValue();
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.plugedInRecordReader.getCurrentKey();
        }

        public ConnectorRecord getCurrentValue() throws IOException, InterruptedException {
            return this.sourceSerDe.deserialize((Writable)this.plugedInRecordReader.getCurrentValue());
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.plugedInRecordReader.getProgress();
        }

        public void close() throws IOException {
            this.plugedInRecordReader.close();
            this.end_timestamp = System.currentTimeMillis();
            this.logger.info((Object)("recordreader class " + ((Object)((Object)this)).getClass().getName() + "close time is:  " + this.end_timestamp));
            this.logger.info((Object)("the total elapsed time of recordreader " + ((Object)((Object)this)).getClass().getName() + (this.end_timestamp - this.start_timestamp) / 1000L + "s"));
        }
    }
}

