/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.hadoop.tool;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.tool.ConnectorImportTool;
import com.teradata.connector.common.utils.ConnectorStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeradataImportTool {
    private static Log logger = LogFactory.getLog(ConnectorImportTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int res = 1;
        try {
            long start = System.currentTimeMillis();
            logger.info((Object)("ConnectorImportTool starts at " + start));
            res = ToolRunner.run((Tool)new ConnectorImportTool(), (String[])args);
            long end = System.currentTimeMillis();
            logger.info((Object)("ConnectorImportTool ends at " + end));
            logger.info((Object)("ConnectorImportTool time is " + (end - start) / 1000L + "s"));
        }
        catch (Throwable e) {
            logger.info((Object)ConnectorStringUtils.getExceptionStack(e));
            res = e instanceof ConnectorException ? ((ConnectorException)e).getCode() : 10000;
        }
        finally {
            logger.info((Object)("job completed with exit code " + res));
            if (res > 255) {
                res /= 1000;
            }
            System.exit(res);
        }
    }
}

