/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.utils;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class TeradataUtils {
    private static Log logger = LogFactory.getLog(TeradataUtils.class);
    protected static final String TDCH_VERSION = "Implementation-Version";

    public static TeradataConnection openInputConnection(JobContext context) throws ConnectorException {
        TeradataConnection connection = null;
        try {
            Configuration configuration = context.getConfiguration();
            String jdbcClassName = TeradataPlugInConfiguration.getInputJdbcDriverClass(configuration);
            String jdbcUrl = TeradataPlugInConfiguration.getInputJdbcUrl(configuration);
            Boolean useXview = TeradataPlugInConfiguration.getInputDataDictionaryUseXView(configuration);
            if (jdbcUrl != null && jdbcUrl.length() != 0) {
                boolean enableUnicodePassthrough;
                connection = new TeradataConnection(jdbcClassName, jdbcUrl, "", "", useXview);
                connection.connect(TeradataPlugInConfiguration.getInputTeradataUserName(context), TeradataPlugInConfiguration.getInputTeradataPassword(context));
                String queryBandProperty = TeradataPlugInConfiguration.getInputQueryBand(configuration);
                if (queryBandProperty != null && !queryBandProperty.isEmpty()) {
                    try {
                        connection.setQueryBandProperty(queryBandProperty);
                    }
                    catch (SQLException e) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                }
                if (enableUnicodePassthrough = TeradataPlugInConfiguration.getUnicodePassthrough(configuration)) {
                    try {
                        connection.enableUnicodePassthrough();
                    }
                    catch (SQLException e) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                }
                connection.getDatabaseProperty();
            }
            return connection;
        }
        catch (SQLException e) {
            connection = null;
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static TeradataConnection openOutputConnection(JobContext context) throws ConnectorException {
        TeradataConnection connection = null;
        try {
            Configuration configuration = context.getConfiguration();
            String jdbcClassName = TeradataPlugInConfiguration.getOutputJdbcDriverClass(configuration);
            String jdbcUrl = TeradataPlugInConfiguration.getOutputJdbcUrl(configuration);
            Boolean useXview = TeradataPlugInConfiguration.getOutputDataDictionaryUseXView(configuration);
            if (jdbcUrl != null && jdbcUrl.length() != 0) {
                boolean enableUnicodePassthrough;
                connection = new TeradataConnection(jdbcClassName, jdbcUrl, "", "", useXview);
                connection.connect(TeradataPlugInConfiguration.getOutputTeradataUserName(context), TeradataPlugInConfiguration.getOutputTeradataPassword(context));
                String queryBandProperty = TeradataPlugInConfiguration.getOutputQueryBand(configuration);
                if (queryBandProperty != null && !queryBandProperty.isEmpty()) {
                    try {
                        connection.setQueryBandProperty(queryBandProperty);
                    }
                    catch (SQLException e) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                }
                if (enableUnicodePassthrough = TeradataPlugInConfiguration.getUnicodePassthrough(configuration)) {
                    try {
                        connection.enableUnicodePassthrough();
                    }
                    catch (SQLException e) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                }
                connection.getDatabaseProperty();
            }
            return connection;
        }
        catch (SQLException e) {
            connection = null;
            throw new ConnectorException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static void closeConnection(TeradataConnection connection) throws ConnectorException {
        if (connection != null) {
            connection.close();
            connection = null;
        }
    }

    public static void closeConnection(Connection connection) throws ConnectorException {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        finally {
            connection = null;
        }
    }

    public static void validateQueryBand(String queryBandProperty) throws ConnectorException {
        if (!queryBandProperty.isEmpty()) {
            if (queryBandProperty.length() > 2046) {
                throw new ConnectorException(21001);
            }
            int equalNumber = 0;
            int semicolonNumber = 0;
            int queryBandNamePostition = 0;
            int queryBandValuePosition = 0;
            HashSet<String> queryKeys = new HashSet<String>();
            int length = queryBandProperty.length();
            for (int i = 0; i < length; ++i) {
                if (queryBandProperty.charAt(i) == '=') {
                    ++equalNumber;
                    queryBandValuePosition = i + 1;
                    String queryBandName = queryBandProperty.substring(queryBandNamePostition, i).trim();
                    if (queryBandName.length() > 128) {
                        throw new ConnectorException(21003);
                    }
                    if (queryKeys.contains(queryBandName)) {
                        throw new ConnectorException(21002);
                    }
                    queryKeys.add(queryBandName);
                    continue;
                }
                if (queryBandProperty.charAt(i) != ';') continue;
                ++semicolonNumber;
                queryBandNamePostition = i + 1;
                String queryBandValue = queryBandProperty.substring(queryBandValuePosition, i);
                if (queryBandValue.length() <= 256) continue;
                throw new ConnectorException(21004);
            }
            if (equalNumber == 0 || equalNumber != semicolonNumber) {
                throw new ConnectorException(21005);
            }
            queryKeys.clear();
        }
    }

    public static void validateDatabase(TeradataConnection connection, ConnectorConfiguration.direction direction2) throws ConnectorException {
        try {
            if (connection != null) {
                connection.getDatabaseProperty();
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        if (direction2 == ConnectorConfiguration.direction.output) {
            logger.info((Object)("the output database product is " + connection.getDatabaseProductName()));
            logger.info((Object)("the output database version is " + connection.getDatabaseMajorVersion() + "." + connection.getDatabaseMinorVersion()));
        } else {
            logger.info((Object)("the input database product is " + connection.getDatabaseProductName()));
            logger.info((Object)("the input database version is " + connection.getDatabaseMajorVersion() + "." + connection.getDatabaseMinorVersion()));
        }
        logger.info((Object)("the jdbc driver version is " + connection.getJDBCMajorVersion() + "." + connection.getJDBCMinorVersion()));
        if (!connection.isSupportedDatabase()) {
            throw new ConnectorException(200010);
        }
        if (!connection.isSupportedJDBC()) {
            throw new ConnectorException(20001);
        }
        try {
            if (direction2 == ConnectorConfiguration.direction.output) {
                logger.debug((Object)("the amp count of output database is: " + connection.getAMPCount()));
            } else {
                logger.debug((Object)("the amp count of input database is: " + connection.getAMPCount()));
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static void validateConnectivity(Configuration configuration, TeradataConnection connection, ConnectorConfiguration.direction direction2) throws ConnectorException {
        try {
            connection.getDatabaseProperty();
            if (!connection.isSupportedDatabase()) {
                throw new ConnectorException(200010);
            }
            if (!connection.isSupportedJDBC()) {
                throw new ConnectorException(20001);
            }
            int numAmps = connection.getAMPCount();
            if (direction2 == ConnectorConfiguration.direction.input) {
                TeradataPlugInConfiguration.setInputNumAmps(configuration, numAmps);
            } else {
                TeradataPlugInConfiguration.setOutputNumAmps(configuration, numAmps);
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static String getTdchVersionNumber() {
        String version = "";
        Manifest manifest = null;
        try {
            File path = new File(TeradataUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            if (path.isDirectory()) {
                File mfpath = new File(TeradataUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath() + File.separator + "META-INF/MANIFEST.MF");
                if (mfpath.exists()) {
                    manifest = new Manifest(new FileInputStream(mfpath));
                }
            } else {
                JarInputStream jarStream = new JarInputStream(new FileInputStream(path));
                manifest = jarStream.getManifest();
                jarStream.close();
            }
            if (manifest != null) {
                Attributes mainAttribs = manifest.getMainAttributes();
                version = mainAttribs.getValue(TDCH_VERSION);
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get the Teradata connector for hadoop version number.");
        }
        return version;
    }

    public static void validateInputTeradataProperties(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        String inputQuery = TeradataPlugInConfiguration.getInputQuery(configuration);
        String inputDatabase = TeradataPlugInConfiguration.getInputDatabase(configuration);
        String inputTableName = TeradataPlugInConfiguration.getInputTable(configuration);
        String[] inputTableFieldNames = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        String inputCondition = TeradataPlugInConfiguration.getInputConditions(configuration);
        String objectName = inputTableName;
        inputTableName = TeradataConnection.getQuotedEscapedName(inputDatabase, inputTableName);
        if (inputQuery.isEmpty()) {
            if (objectName.isEmpty()) {
                throw new ConnectorException(12007);
            }
            if (inputTableFieldNames == null || inputTableFieldNames.length == 0) {
                inputTableFieldNames = new String[]{"*"};
            }
        } else {
            if (!objectName.isEmpty()) {
                throw new ConnectorException(12008);
            }
            int maxLength = connection.getMaxTableNameLength();
            if (objectName.length() > maxLength) {
                throw new ConnectorException(12012, maxLength);
            }
        }
        if (!inputCondition.isEmpty() && inputCondition.toLowerCase().contains("where")) {
            throw new ConnectorException("input condition can't include where keyword");
        }
        TeradataUtils.validateQueryBand(TeradataPlugInConfiguration.getInputQueryBand(configuration));
        TeradataUtils.validateDatabase(connection, ConnectorConfiguration.direction.input);
        TeradataUtils.validateConnectivity(configuration, connection, ConnectorConfiguration.direction.input);
        try {
            String[] sourceFieldNames = !inputTableName.isEmpty() ? connection.getColumnNamesForTable(inputTableName) : connection.getColumnNamesForSQL(inputQuery);
            if (!(inputTableFieldNames.length == 0 || inputTableFieldNames.length == 1 && inputTableFieldNames[0].equals("*"))) {
                int length = inputTableFieldNames.length;
                for (int i = 0; i < length; ++i) {
                    int j;
                    int inputFieldsCount = sourceFieldNames.length;
                    for (j = 0; j < inputFieldsCount && !inputTableFieldNames[i].equalsIgnoreCase(sourceFieldNames[j]); ++j) {
                    }
                    if (j != inputFieldsCount) continue;
                    throw new ConnectorException(14005);
                }
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }

    public static void validateOutputTeradataProperties(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        String outputTableName;
        String outputDatabase = TeradataPlugInConfiguration.getOutputDatabase(configuration);
        String objectName = outputTableName = TeradataPlugInConfiguration.getOutputTable(configuration);
        outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
        TeradataUtils.validateQueryBand(TeradataPlugInConfiguration.getOutputQueryBand(configuration));
        TeradataUtils.validateDatabase(connection, ConnectorConfiguration.direction.output);
        TeradataUtils.validateConnectivity(configuration, connection, ConnectorConfiguration.direction.output);
        if (objectName.isEmpty()) {
            throw new ConnectorException(13007);
        }
        int maxLength = connection.getMaxTableNameLength();
        if (objectName.length() > maxLength) {
            throw new ConnectorException(13012, maxLength);
        }
        try {
            if (!connection.isTable(outputTableName)) {
                throw new ConnectorException(20008);
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
    }
}

