/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.utils;

import com.teradata.connector.common.ConnectorRecordSchema;
import com.teradata.connector.common.converter.ConnectorDataTypeConverter;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.common.utils.ConnectorSchemaParser;
import com.teradata.connector.common.utils.ConnectorSchemaUtils;
import com.teradata.connector.teradata.converter.TeradataDataType;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jackson.map.ObjectMapper;

public class TeradataSchemaUtils {
    private static Log logger = LogFactory.getLog(TeradataSchemaUtils.class);
    protected static final String PATTERN_MAP_TYPE = "\\s*(map\\s*[<].*[>])";
    protected static final String PATTERN_ARRAY_TYPE = "\\s*(array\\s*[<].*[>])";
    protected static final String PATTERN_STRUCT_TYPE = "\\s*(struct\\s*[<].*[>])";
    protected static final String PATTERN_UNION_TYPE = "\\s*(union\\s*[<].*[>])";
    public static final String LIST_COLUMNS = "columns";
    public static final String LIST_COLUMN_TYPES = "columns.types";
    private static final char DOT_CHAR = '.';
    private static final char COMMA_CHAR = ',';
    private static final String REPLACE_DOUBLE_QUOTE_SQL = "\"\"";
    private static final String REPLACE_SINGLE_QUOTE_SQL = "''";

    public static String quoteFieldNameForSql(String fieldName) {
        return ConnectorSchemaUtils.quoteFieldName(fieldName, REPLACE_DOUBLE_QUOTE_SQL);
    }

    public static String quoteFieldValueForSql(String fieldValue) {
        return ConnectorSchemaUtils.quoteFieldValue(fieldValue, REPLACE_SINGLE_QUOTE_SQL);
    }

    public static String quoteFieldNamesForSql(String fieldNames) {
        if (fieldNames == null || fieldNames.isEmpty()) {
            return "";
        }
        String[] fieldNamesArray = ConnectorSchemaUtils.convertFieldNamesToArray(fieldNames);
        StringBuilder builder = new StringBuilder();
        for (String fieldName : fieldNamesArray) {
            builder.append(TeradataSchemaUtils.quoteFieldNameForSql(fieldName)).append(',');
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String unquoteFieldValueForSql(String fieldValue) {
        return ConnectorSchemaUtils.unquoteFieldValue(fieldValue, REPLACE_SINGLE_QUOTE_SQL);
    }

    public static void setupTeradataSourceTableSchema(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        String inputTableName;
        String inputQuery = TeradataPlugInConfiguration.getInputQuery(configuration);
        String inputDatabase = TeradataPlugInConfiguration.getInputDatabase(configuration);
        String objectName = inputTableName = TeradataPlugInConfiguration.getInputTable(configuration);
        inputTableName = TeradataConnection.getQuotedEscapedName(inputDatabase, inputTableName);
        String[] inputTableFieldNames = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        TeradataColumnDesc[] fieldDescs = null;
        if (objectName != null && !objectName.isEmpty()) {
            try {
                fieldDescs = connection.getColumnDescsForTable(inputTableName, inputTableFieldNames);
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
        try {
            String charset = TeradataConnection.getURLParamValue(TeradataPlugInConfiguration.getInputJdbcUrl(configuration), "CHARSET");
            fieldDescs = connection.getColumnDescsForSQLWithCharSet(inputQuery, charset);
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        TeradataTableDesc sourceTableDesc = new TeradataTableDesc();
        sourceTableDesc.setColumns(fieldDescs);
        TeradataPlugInConfiguration.setInputTableDesc(configuration, TeradataSchemaUtils.tableDescToJson(sourceTableDesc));
        int sourceFieldLen = inputTableFieldNames.length;
        if (sourceFieldLen == 0) {
            TeradataPlugInConfiguration.setInputFieldNamesArray(configuration, sourceTableDesc.getColumnNames());
        }
    }

    public static boolean isPrimaryIndexInFieldNames(String[] indices, String[] fieldNames) {
        if (indices.length > 0) {
            int i;
            String[] unquotedFieldNames = ConnectorSchemaUtils.unquoteFieldNamesArray(fieldNames);
            ArrayList<String> indicesList = new ArrayList<String>();
            ArrayList<String> unquotedFieldsList = new ArrayList<String>();
            for (i = 0; i < indices.length; ++i) {
                indicesList.add(indices[i].toLowerCase());
            }
            for (i = 0; unquotedFieldNames != null && i < fieldNames.length; ++i) {
                unquotedFieldsList.add(unquotedFieldNames[i].toLowerCase());
            }
            return unquotedFieldsList.containsAll(indicesList);
        }
        return true;
    }

    public static void setupTeradataTargetTableSchema(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        TeradataColumnDesc[] fieldDescs;
        String outputDatabase = TeradataPlugInConfiguration.getOutputDatabase(configuration);
        String outputTableName = TeradataPlugInConfiguration.getOutputTable(configuration);
        int outputTableFieldCount = TeradataPlugInConfiguration.getOutputFieldCount(configuration);
        String[] outputTableFieldNames = TeradataPlugInConfiguration.getOutputFieldNamesArray(configuration);
        String objectName = outputTableName;
        outputTableName = TeradataConnection.getQuotedEscapedName(outputDatabase, outputTableName);
        try {
            String[] indices;
            fieldDescs = connection.getColumnDescsForTable(outputTableName, outputTableFieldNames);
            if (outputTableFieldCount > 0 && outputTableFieldCount > fieldDescs.length) {
                throw new ConnectorException(13010);
            }
            outputTableFieldCount = fieldDescs.length;
            if (outputTableFieldNames != null && outputTableFieldNames.length > 0 && !TeradataSchemaUtils.isPrimaryIndexInFieldNames(indices = connection.getPrimaryIndex(outputTableName), outputTableFieldNames)) {
                throw new ConnectorException(13015);
            }
            if (TeradataPlugInConfiguration.getOutputTeradataTruncate(configuration)) {
                connection.truncateTable(outputTableName);
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        TeradataTableDesc targetTableDesc = new TeradataTableDesc();
        targetTableDesc.setDatabaseName(outputDatabase);
        targetTableDesc.setName(objectName);
        targetTableDesc.setColumns(fieldDescs);
        TeradataPlugInConfiguration.setOutputTableDesc(configuration, TeradataSchemaUtils.tableDescToJson(targetTableDesc));
        String[] fieldNames = new String[outputTableFieldCount];
        for (int i = 0; i < outputTableFieldCount; ++i) {
            TeradataColumnDesc fieldDesc = fieldDescs[i];
            fieldNames[i] = fieldDesc.getName();
        }
        TeradataPlugInConfiguration.setOutputFieldCount(configuration, outputTableFieldCount);
        TeradataPlugInConfiguration.setOutputFieldNamesArray(configuration, fieldNames);
    }

    public static void configureSourceConnectorRecordSchema(Configuration configuration) throws ConnectorException {
        boolean needReducerPhase;
        ConnectorRecordSchema userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getInputConverterRecordSchema(configuration));
        String[] sourceFieldNameArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        boolean isUDMapper = !ConnectorConfiguration.getJobMapper(configuration).isEmpty();
        boolean isUDReducer = !ConnectorConfiguration.getJobReducer(configuration).isEmpty();
        boolean bl = needReducerPhase = ConnectorConfiguration.getNumReducers(configuration) != 0;
        if (!(isUDMapper || isUDReducer || needReducerPhase)) {
            if (userRecordSchema != null && sourceFieldNameArray.length != userRecordSchema.getLength()) {
                throw new ConnectorException(14013);
            }
            TeradataTableDesc sourceTableDesc = TeradataSchemaUtils.tableDescFromText(TeradataPlugInConfiguration.getInputTableDesc(configuration));
            TeradataColumnDesc[] columnDescs = sourceTableDesc.getColumns();
            ConnectorRecordSchema sourceRecordSchema = new ConnectorRecordSchema(sourceFieldNameArray.length);
            int index = 0;
            boolean findField = false;
            for (String fieldName : sourceFieldNameArray) {
                findField = false;
                for (TeradataColumnDesc column : columnDescs) {
                    if (!fieldName.equalsIgnoreCase(column.getName())) continue;
                    sourceRecordSchema.setFieldType(index++, TeradataSchemaUtils.transformTeradataTimeType(TeradataSchemaUtils.tranformTeradataDataType(column.getType()), column.getTypeName()));
                    findField = true;
                    break;
                }
                if (findField) continue;
                throw new ConnectorException(14005);
            }
            if (userRecordSchema != null) {
                int columnCount = sourceRecordSchema.getLength();
                if (userRecordSchema.getLength() != columnCount) {
                    throw new ConnectorException(14013);
                }
                for (int i = 0; i < columnCount; ++i) {
                    if (userRecordSchema.getFieldType(i) == 1883 || userRecordSchema.getFieldType(i) == sourceRecordSchema.getFieldType(i)) continue;
                    throw new ConnectorException(14015);
                }
            } else {
                ConnectorConfiguration.setInputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(sourceRecordSchema)));
            }
        }
    }

    public static void configureTargetConnectorRecordSchema(Configuration configuration) throws ConnectorException {
        ConnectorRecordSchema userRecordSchema = ConnectorSchemaUtils.recordSchemaFromString(ConnectorConfiguration.getOutputConverterRecordSchema(configuration));
        String[] targetFieldNameArray = TeradataPlugInConfiguration.getOutputFieldNamesArray(configuration);
        if (userRecordSchema != null && targetFieldNameArray.length != userRecordSchema.getLength()) {
            throw new ConnectorException(14014);
        }
        TeradataTableDesc tagetTableDesc = TeradataSchemaUtils.tableDescFromText(TeradataPlugInConfiguration.getOutputTableDesc(configuration));
        TeradataColumnDesc[] columnDescs = tagetTableDesc.getColumns();
        ConnectorRecordSchema targetRecordSchema = new ConnectorRecordSchema(targetFieldNameArray.length);
        int index = 0;
        boolean findField = false;
        for (String fieldName : targetFieldNameArray) {
            findField = false;
            for (TeradataColumnDesc column : columnDescs) {
                if (!fieldName.equalsIgnoreCase(column.getName())) continue;
                targetRecordSchema.setFieldType(index++, TeradataSchemaUtils.transformTeradataTimeType(column.getType(), column.getTypeName()));
                findField = true;
                break;
            }
            if (findField) continue;
            throw new ConnectorException(14005);
        }
        if (userRecordSchema != null) {
            int columnCount = targetRecordSchema.getLength();
            for (int i = 0; i < columnCount; ++i) {
                if (userRecordSchema.getFieldType(i) == targetRecordSchema.getFieldType(i)) continue;
                throw new ConnectorException(14016);
            }
        } else {
            ConnectorConfiguration.setOutputConverterRecordSchema(configuration, ConnectorSchemaUtils.recordSchemaToString(ConnectorSchemaUtils.formalizeConnectorRecordSchema(targetRecordSchema)));
        }
    }

    public static int transformTeradataTimeType(int dataType, String typeName) {
        if (dataType == 92) {
            if (ConnectorSchemaUtils.isTimeWithTimeZoneType(typeName)) {
                return 1885;
            }
        } else if (dataType == 93 && ConnectorSchemaUtils.isTimestampWithTimeZoneType(typeName)) {
            return 1886;
        }
        return dataType;
    }

    public static int tranformTeradataDataType(int dataType) {
        if (dataType == 3 || dataType == 2) {
            return 3;
        }
        if (dataType == 8 || dataType == 6 || dataType == 8) {
            return 8;
        }
        if (dataType == 5 || dataType == 4 || dataType == -6) {
            return 4;
        }
        return dataType;
    }

    public static String getStageTableName(int maxLength, String tableName, String bkupTableName) {
        String stageTableName;
        int tableNameLen = tableName == null ? 0 : tableName.length();
        int bkupTableNameLen = bkupTableName == null ? 0 : bkupTableName.length();
        SimpleDateFormat sdf = new SimpleDateFormat("hhmmssSSS");
        String identifier = sdf.format(new Date());
        int identifierLen = identifier.length();
        if (tableNameLen != 0 && tableNameLen + 1 + identifierLen <= maxLength) {
            stageTableName = tableName + "_" + identifier;
        } else if (bkupTableNameLen != 0 && bkupTableNameLen + 1 + identifierLen <= maxLength) {
            stageTableName = bkupTableName + "_" + identifier;
        } else {
            stageTableName = "TDCH_STAGE_" + identifier;
            stageTableName = stageTableName.substring(0, maxLength);
        }
        return stageTableName;
    }

    public static int[] lookupMappingFromTableDescText(String tableDescText, String[] fieldNames) throws ConnectorException {
        if (tableDescText == null || tableDescText.length() <= 0) {
            throw new ConnectorException(14012);
        }
        if (fieldNames == null || fieldNames.length <= 0) {
            throw new ConnectorException(14004);
        }
        TeradataTableDesc schemaDesc = TeradataSchemaUtils.tableDescFromText(tableDescText);
        Map<String, Integer> schemaColumnNames = schemaDesc.getColumnNameLowerCaseMap();
        ConnectorSchemaParser parser = new ConnectorSchemaParser();
        parser.setTrimSpaces(true);
        int fieldCount = fieldNames.length;
        parser.setDelimChar('.');
        int[] mappings = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = fieldNames[i].toLowerCase();
            Integer columnPosition = schemaColumnNames.get(fieldName);
            if (columnPosition == null) {
                logger.error((Object)("Column \"" + fieldName + "\" is not in schema " + tableDescText));
                throw new ConnectorException(14005);
            }
            mappings[i] = columnPosition;
        }
        return mappings;
    }

    public static int[] lookupFieldsSQLDataScales(String tableDescText, String[] fieldNamesArray) throws ConnectorException {
        TeradataTableDesc tableDesc = TeradataSchemaUtils.tableDescFromText(tableDescText);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        int[] mappings = null;
        int[] fieldDataScales = null;
        int realFieldCount = 0;
        mappings = TeradataSchemaUtils.lookupMappingFromTableDescText(tableDescText, fieldNamesArray);
        realFieldCount = mappings.length;
        fieldDataScales = realFieldCount > 0 ? new int[realFieldCount] : null;
        for (int i = 0; i < realFieldCount; ++i) {
            fieldDataScales[i] = columnDescs[mappings[i]].getScale();
        }
        return fieldDataScales;
    }

    public static int[] lookupTypesFromTableDescText(String tableDescText, String[] fieldNamesArray) throws ConnectorException {
        if (tableDescText == null || tableDescText.length() <= 0) {
            throw new ConnectorException(14012);
        }
        TeradataTableDesc tableDesc = TeradataSchemaUtils.tableDescFromText(tableDescText);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        int[] mappings = null;
        int[] fieldDataTypes = null;
        int realFieldCount = 0;
        mappings = TeradataSchemaUtils.lookupMappingFromTableDescText(tableDescText, fieldNamesArray);
        realFieldCount = mappings.length;
        fieldDataTypes = realFieldCount > 0 ? new int[realFieldCount] : null;
        for (int i = 0; i < realFieldCount; ++i) {
            fieldDataTypes[i] = columnDescs[mappings[i]].getType();
        }
        return fieldDataTypes;
    }

    public static HashMap<String, Object> lookupTeradataDataTypes(String tableDescText, String[] fieldNamesArray) throws ConnectorException {
        TeradataDataType[] fieldDataTypes = new TeradataDataType[fieldNamesArray.length];
        HashMap<String, Object> retHashMap = new HashMap<String, Object>();
        boolean SQLXMLEXISTS = false;
        TeradataTableDesc tableDesc = TeradataSchemaUtils.tableDescFromText(tableDescText);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        int index = 0;
        boolean findField = false;
        for (String fieldName : fieldNamesArray) {
            findField = false;
            for (TeradataColumnDesc column : columnDescs) {
                if (!fieldName.equalsIgnoreCase(column.getName())) continue;
                if (column.getType() == 2009) {
                    fieldDataTypes[index++] = TeradataDataType.TeradataDataTypeImpl.SQLXML;
                    SQLXMLEXISTS = true;
                } else {
                    fieldDataTypes[index++] = TeradataDataType.TeradataDataTypeImpl.OTHER;
                }
                findField = true;
                break;
            }
            if (findField) continue;
            throw new ConnectorException(14005);
        }
        retHashMap.put("SQLXMLEXISTS", SQLXMLEXISTS);
        retHashMap.put("TeradataDataType", fieldDataTypes);
        return retHashMap;
    }

    public static String[] lookupTypeNamesFromTableDescText(String tableDescText, String[] fieldNamesArray) throws ConnectorException {
        if (tableDescText == null || tableDescText.length() <= 0) {
            throw new ConnectorException(14012);
        }
        TeradataTableDesc tableDesc = TeradataSchemaUtils.tableDescFromText(tableDescText);
        TeradataColumnDesc[] columnDescs = tableDesc.getColumns();
        int[] mappings = null;
        String[] fieldDataTypeNames = null;
        int realFieldCount = 0;
        mappings = TeradataSchemaUtils.lookupMappingFromTableDescText(tableDescText, fieldNamesArray);
        realFieldCount = mappings.length;
        Assert.assertTrue((realFieldCount > 0 ? 1 : 0) != 0);
        fieldDataTypeNames = new String[realFieldCount];
        for (int i = 0; i < realFieldCount; ++i) {
            fieldDataTypeNames[i] = columnDescs[mappings[i]].getTypeName();
        }
        return fieldDataTypeNames;
    }

    public static String tableDescToJson(TeradataTableDesc tableDesc) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"database\":\"").append(tableDesc.getDatabaseName()).append("\"");
        sb.append(",\"table\":\"").append(tableDesc.getName()).append("\"");
        sb.append(",\"columns\":[");
        TeradataColumnDesc[] columns = tableDesc.getColumns();
        int columnCount = columns.length;
        for (int i = 0; i < columnCount; ++i) {
            try {
                ObjectMapper om = new ObjectMapper();
                StringWriter writer = new StringWriter();
                om.writeValue((Writer)writer, (Object)columns[i].getName());
                sb.append("{\"name\":").append(writer.toString());
            }
            catch (Exception e) {
                sb.append("{\"name\":\"").append(columns[i].getName()).append("\"");
            }
            sb.append(",\"type\":").append(columns[i].getType());
            sb.append(",\"typename\":\"").append(columns[i].getTypeName()).append("\"");
            sb.append(",\"nullable\":").append(columns[i].isNullable() ? 1 : 0);
            sb.append(",\"format\":\"").append(columns[i].getFormat()).append("\"");
            sb.append(",\"length\":").append(columns[i].getLength());
            sb.append(",\"chartype\":").append(columns[i].getCharType());
            sb.append(",\"casesensitive\":").append(columns[i].isCaseSensitive() ? 1 : 0);
            sb.append(",\"scale\":").append(columns[i].getScale());
            sb.append(",\"precision\":").append(columns[i].getPrecision());
            sb.append("},");
        }
        sb.setCharAt(sb.length() - 1, ']');
        sb.append("}}");
        return sb.toString();
    }

    public static TeradataTableDesc tableDescFromText(String tableDescText) {
        TeradataTableDesc tableDesc = new TeradataTableDesc();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map tableMap = (Map)objectMapper.readValue(tableDescText, Map.class);
            tableDesc.setDatabaseName((String)tableMap.get("database"));
            tableDesc.setName((String)tableMap.get("table"));
            ArrayList columnList = (ArrayList)tableMap.get(LIST_COLUMNS);
            for (int i = 0; i < columnList.size(); ++i) {
                TeradataColumnDesc columnDesc = new TeradataColumnDesc();
                Map columnMap = (Map)columnList.get(i);
                columnDesc.setName((String)columnMap.get("name"));
                columnDesc.setType((Integer)columnMap.get("type"));
                columnDesc.setTypeName((String)columnMap.get("typename"));
                columnDesc.setFormat((String)columnMap.get("format"));
                columnDesc.setNullable((Integer)columnMap.get("nullable") > 0);
                Object lenObject = columnMap.get("length");
                columnDesc.setCharType((Integer)columnMap.get("chartype"));
                columnDesc.setCaseSensitive((Integer)columnMap.get("casesensitive") > 0);
                if (lenObject instanceof Integer) {
                    columnDesc.setLength(((Integer)lenObject).intValue());
                } else if (lenObject instanceof Long) {
                    columnDesc.setLength((Long)lenObject);
                }
                columnDesc.setScale((Integer)columnMap.get("scale"));
                columnDesc.setPrecision((Integer)columnMap.get("precision"));
                tableDesc.addColumn(columnDesc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableDesc;
    }

    public static TeradataColumnDesc[] addTaskIDColumn(TeradataColumnDesc[] inputColumns, String colName) {
        TeradataColumnDesc[] outputColumns = new TeradataColumnDesc[inputColumns.length + 1];
        for (int i = 0; i < inputColumns.length; ++i) {
            outputColumns[i] = new TeradataColumnDesc(inputColumns[i]);
        }
        outputColumns[inputColumns.length] = new TeradataColumnDesc();
        outputColumns[inputColumns.length].setName(colName);
        outputColumns[inputColumns.length].setType(12);
        outputColumns[inputColumns.length].setLength(40L);
        return outputColumns;
    }

    public static int[] getColumnMapping(List<String> ColNames, String[] mappingNames) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] ColNamesArray = new String[ColNames.size()];
        ColNames.toArray(ColNamesArray);
        for (int i = 0; i < ColNamesArray.length; ++i) {
            map.put(ColNamesArray[i].toLowerCase(), i);
        }
        int[] mapping = new int[mappingNames.length];
        for (int i = 0; i < mappingNames.length; ++i) {
            mapping[i] = (Integer)map.get(mappingNames[i].toLowerCase());
        }
        return mapping;
    }

    public static String getFieldNamesFromSchema(String schema) throws ConnectorException {
        TeradataColumnDesc[] columns;
        TeradataTableDesc tableDesc = TeradataSchemaUtils.columnSchemaToTableDesc(schema);
        StringBuilder sb = new StringBuilder();
        for (TeradataColumnDesc column : columns = tableDesc.getColumns()) {
            sb.append(ConnectorSchemaUtils.quoteFieldName(column.getName())).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static int lookupTeradataDataTypeByTypeName(String typeName) {
        if ((typeName = typeName.toUpperCase()).equals("INT") || typeName.equals("INTEGER")) {
            return 4;
        }
        if (typeName.equals("BIGINT") || typeName.equals("LONG")) {
            return -5;
        }
        if (typeName.equals("SMALLINT")) {
            return 5;
        }
        if (typeName.equals("STRING") || typeName.equals("VARCHAR")) {
            return 12;
        }
        if (typeName.equals("FLOAT")) {
            return 6;
        }
        if (typeName.equals("DOUBLE") || typeName.equals("DOUBLE PRECISION")) {
            return 8;
        }
        if (typeName.equals("DECIMAL")) {
            return 3;
        }
        if (typeName.equals("BOOLEAN")) {
            return 16;
        }
        if (typeName.equals("DATE")) {
            return 91;
        }
        if (typeName.equals("TIME")) {
            return 92;
        }
        if (typeName.equals("TIMESTAMP")) {
            return 93;
        }
        if (typeName.startsWith("PERIOD")) {
            return 2002;
        }
        if (typeName.startsWith("INTERVAL")) {
            return 1111;
        }
        if (typeName.equals("CHAR")) {
            return 1;
        }
        if (typeName.equals("TINYINT")) {
            return -6;
        }
        if (typeName.equals("LONGVARCHAR")) {
            return -1;
        }
        if (typeName.equals("CLOB")) {
            return 2005;
        }
        if (typeName.equals("BLOB")) {
            return 2004;
        }
        if (typeName.equals("BINARY") || typeName.equals("VARBINARY") || typeName.equals("BYTES")) {
            return -2;
        }
        if (typeName.equals("REAL")) {
            return 8;
        }
        if (typeName.equals("NUMERIC")) {
            return 3;
        }
        if (typeName.equals("OTHER")) {
            return 1882;
        }
        return 1883;
    }

    public static TeradataTableDesc columnSchemaToTableDesc(String tableColumnSchema) throws ConnectorException {
        TeradataTableDesc tableDesc = new TeradataTableDesc();
        List<String> columns = ConnectorSchemaUtils.parseColumns(tableColumnSchema);
        List<String> columnNames = ConnectorSchemaUtils.parseColumnNames(columns);
        List<String> columnTypes = ConnectorSchemaUtils.parseColumnTypes(columns);
        for (int i = 0; i < columnNames.size(); ++i) {
            TeradataColumnDesc columnDesc = new TeradataColumnDesc();
            String columnName = ConnectorSchemaUtils.unquoteFieldName(columnNames.get(i).trim());
            columnDesc.setName(columnName);
            columnDesc.setType(TeradataSchemaUtils.lookupTeradataDataTypeByTypeName(columnTypes.get(i).trim()));
            columnDesc.setTypeName(columnTypes.get(i).trim());
            columnDesc.setNullable(true);
            tableDesc.addColumn(columnDesc);
        }
        return tableDesc;
    }

    public static Timestamp getTimestampFromCalendar(Calendar cal) {
        long millisec = cal.getTimeInMillis();
        millisec = ConnectorDataTypeConverter.convertMillisecFromDefaultToTargetTZ(millisec, cal.getTimeZone());
        return new Timestamp(millisec);
    }
}

