/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.schema;

import com.teradata.connector.common.utils.ConnectorSchemaUtils;

public class TeradataColumnDesc {
    public static final int KBYTES = 1024;
    public static final int TIME_SCALE_DEFAULT = 6;
    public static final int TIME_SCALE_MAX = 6;
    public static final int DECIMAL_PRECISION_DEFAULT = 5;
    public static final int INTERVAL_N_DEFAULT = 2;
    public static final int INTERVAL_M_DEFAULT = 6;
    public static final int BYTE_DEFAULT = 1;
    public static final int CHAR_DEFAULT = 1;
    public static final int NUMBER_PRECISION_MAX = 38;
    public static final int NUMBER_SCALE_DEFAULT = 0;
    public static final String NUMBER_DATA_TYPE = "NUMBER";
    public static final int DECIMAL_SCALE_DEFAULT = 0;
    public static final int INTERVAL_N_MAX = 4;
    public static final int INTERVAL_M_MAX = 6;
    public static final String INTERVAL_NM_SEPARATOR = "TO";
    public static final String INTERVAL_NM_SECOND = "SECOND";
    private String name = "";
    private String typeName = "";
    private String className = "";
    private String format = "";
    private int type = 0;
    private int precision = 0;
    private int scale = 0;
    private long length = 0L;
    private int timeScale = -1;
    private boolean nullable = true;
    private int charType = 0;
    private boolean caseSensitive = false;

    public TeradataColumnDesc() {
    }

    public TeradataColumnDesc(TeradataColumnDesc inputColumn) {
        this.name = inputColumn.getName();
        this.typeName = inputColumn.getTypeName();
        this.className = inputColumn.getClassName();
        this.format = inputColumn.getFormat();
        this.type = inputColumn.getType();
        this.precision = inputColumn.getPrecision();
        this.scale = inputColumn.getScale();
        this.length = inputColumn.getLength();
        this.timeScale = inputColumn.getScale();
        this.nullable = inputColumn.isNullable();
        this.charType = inputColumn.getCharType();
        this.caseSensitive = inputColumn.isCaseSensitive();
    }

    public void setName(String name_) {
        this.name = name_;
    }

    public void setTypeName(String typeName_) {
        this.typeName = typeName_.toUpperCase();
    }

    public void setClassName(String className_) {
        this.className = className_;
    }

    public void setFormat(String format_) {
        this.format = format_;
    }

    public void setType(int type_) {
        this.type = type_;
    }

    public void setPrecision(int precision_) {
        if (precision_ >= 0) {
            this.precision = precision_;
        }
    }

    public void setScale(int scale_) {
        if (scale_ >= 0) {
            this.scale = scale_;
            this.timeScale = scale_;
        }
    }

    public void setLength(long length_) {
        if (length_ >= 0L) {
            this.length = length_;
        }
    }

    public void setNullable(boolean nullable_) {
        this.nullable = nullable_;
    }

    public void setCaseSensitive(boolean caseSensitive_) {
        this.caseSensitive = caseSensitive_;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFormat() {
        return this.format;
    }

    public int getType() {
        return this.type;
    }

    public int getPrecision() {
        switch (this.type) {
            case 2: 
            case 3: {
                return this.precision == 0 ? 5 : this.precision;
            }
        }
        return this.precision;
    }

    public int getScale() {
        switch (this.type) {
            case 92: 
            case 93: {
                if (this.timeScale < 0 || this.timeScale > 6) {
                    return 6;
                }
                return this.timeScale;
            }
            case 2002: {
                if (!this.typeName.contains("PERIOD") || !this.typeName.contains("TIME")) break;
                if (this.timeScale < 0 || this.timeScale > 6) {
                    return 6;
                }
                return this.timeScale;
            }
        }
        return this.scale;
    }

    public long getLength() {
        switch (this.type) {
            case 1: {
                return this.length == 0L ? 1L : this.length;
            }
            case -2: {
                return this.length == 0L ? 1L : this.length;
            }
        }
        return this.length;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCharType(int charType) {
        this.charType = charType;
    }

    public int getCharType() {
        return this.charType;
    }

    public String getLobLengthInKMG() {
        String unit = "";
        long len = this.length;
        if (len > 1024L && len % 1024L == 0L) {
            len /= 1024L;
            unit = "K";
        }
        if (len > 1024L && len % 1024L == 0L) {
            len /= 1024L;
            unit = "M";
        }
        if (len > 1024L && len % 1024L == 0L) {
            len /= 1024L;
            unit = "G";
        }
        return "" + len + unit;
    }

    public String getTypeString() {
        String string = this.getTypeStringWithoutNullability();
        string = string + (this.nullable ? " NULL" : " NOT NULL");
        return string;
    }

    public String getTypeString4Using(String charset) {
        int timeZoneLen = 0;
        switch (this.type) {
            case 2: 
            case 3: {
                return "DECIMAL (38, " + this.scale + ")";
            }
            case 1: 
            case 12: 
            case 1111: {
                int strCharOrVarcharMultiplier = 1;
                if ("UTF16".equalsIgnoreCase(charset)) {
                    strCharOrVarcharMultiplier = 2;
                } else if ("UTF8".equalsIgnoreCase(charset)) {
                    strCharOrVarcharMultiplier = 3;
                }
                return "VARCHAR(" + (long)strCharOrVarcharMultiplier * this.getLength() + ")";
            }
            case 2005: {
                return "CLOB(" + this.getLobLengthInKMG() + ")";
            }
            case 92: {
                int tnanoLength;
                int strTimeOrIntervalMultiplier = 1;
                if ("UTF16".equalsIgnoreCase(charset)) {
                    strTimeOrIntervalMultiplier = 2;
                }
                int n = tnanoLength = this.scale > 0 ? 8 + this.scale + 1 : 8;
                if (ConnectorSchemaUtils.isTimeWithTimeZoneType(this.typeName)) {
                    timeZoneLen = 6;
                }
                return "CHAR(" + strTimeOrIntervalMultiplier * (tnanoLength + timeZoneLen) + ")";
            }
            case 93: {
                int tsnanoLength;
                int strTimeOrIntervalMultiplier = 1;
                if ("UTF16".equalsIgnoreCase(charset)) {
                    strTimeOrIntervalMultiplier = 2;
                }
                int n = tsnanoLength = this.scale > 0 ? 19 + this.scale + 1 : 19;
                if (ConnectorSchemaUtils.isTimestampWithTimeZoneType(this.typeName)) {
                    timeZoneLen = 6;
                }
                return "CHAR(" + strTimeOrIntervalMultiplier * (tsnanoLength + timeZoneLen) + ")";
            }
            case 0: {
                return this.getTypeStringWithoutNullability();
            }
        }
        return this.getTypeStringWithoutNullability();
    }

    public String getTypeStringWithoutNullability() {
        String string = "";
        switch (this.type) {
            case 1: {
                string = string + "CHAR(" + this.length + ")";
                if (this.charType == 1) {
                    string = string + " CHARACTER SET LATIN";
                } else if (this.charType == 2) {
                    string = string + " CHARACTER SET UNICODE";
                }
                if (this.caseSensitive) {
                    string = string + " CASESPECIFIC";
                    break;
                }
                string = string + " NOT CASESPECIFIC";
                break;
            }
            case 12: {
                string = string + "VARCHAR(" + this.length + ")";
                if (this.charType == 1) {
                    string = string + " CHARACTER SET LATIN";
                } else if (this.charType == 2) {
                    string = string + " CHARACTER SET UNICODE";
                }
                if (this.caseSensitive) {
                    string = string + " CASESPECIFIC";
                    break;
                }
                string = string + " NOT CASESPECIFIC";
                break;
            }
            case -1: {
                string = string + "LONG VARCHAR";
                if (this.charType == 1) {
                    string = string + " CHARACTER SET LATIN";
                } else if (this.charType == 2) {
                    string = string + " CHARACTER SET UNICODE";
                }
                if (this.caseSensitive) {
                    string = string + " CASESPECIFIC";
                    break;
                }
                string = string + " NOT CASESPECIFIC";
                break;
            }
            case 4: {
                string = string + "INTEGER";
                break;
            }
            case 5: {
                string = string + "SMALLINT";
                break;
            }
            case -5: {
                string = string + "BIGINT";
                break;
            }
            case -6: {
                string = string + "BYTEINT";
                break;
            }
            case 6: {
                string = string + "FLOAT";
                break;
            }
            case 7: {
                string = string + "REAL";
                break;
            }
            case 8: {
                string = string + "DOUBLE PRECISION";
                break;
            }
            case 3: {
                string = string + "DECIMAL(" + this.precision + ", " + this.scale + ")";
                break;
            }
            case 2: {
                if (this.typeName.equalsIgnoreCase(NUMBER_DATA_TYPE)) {
                    if (this.precision > 38) {
                        if (this.scale > 0) {
                            string = string + "NUMBER(*, " + this.scale + ")";
                            break;
                        }
                        string = string + "NUMBER(*)";
                        break;
                    }
                    string = string + "NUMBER(" + this.precision + ", " + this.scale + ")";
                    break;
                }
                string = string + "NUMERIC(" + this.precision + ", " + this.scale + ")";
                break;
            }
            case -2: {
                string = string + "BYTE(" + this.length + ")";
                break;
            }
            case -3: {
                string = string + "VARBYTE(" + this.length + ")";
                break;
            }
            case 91: {
                string = string + "DATE";
                break;
            }
            case 92: {
                string = string + "TIME";
                if (this.scale >= 0 && this.scale < 6) {
                    string = string + "(" + this.scale + ")";
                }
                if (ConnectorSchemaUtils.isTimeWithTimeZoneType(this.typeName)) {
                    string = string + " WITH TIME ZONE ";
                }
                if (this.isEmptyString(this.format)) break;
                string = string + " FORMAT '" + this.format + "'";
                break;
            }
            case 93: {
                string = string + "TIMESTAMP";
                if (this.scale >= 0 && this.scale < 6) {
                    string = string + "(" + this.scale + ")";
                }
                if (ConnectorSchemaUtils.isTimestampWithTimeZoneType(this.typeName)) {
                    string = string + " WITH TIME ZONE ";
                }
                if (this.isEmptyString(this.format)) break;
                string = string + " FORMAT '" + this.format + "'";
                break;
            }
            case 2004: {
                string = string + "BLOB(" + this.getLobLengthInKMG() + ")";
                break;
            }
            case 2005: {
                string = string + "CLOB(" + this.getLobLengthInKMG() + ")";
                if (this.charType == 1) {
                    string = string + " CHARACTER SET LATIN";
                    break;
                }
                if (this.charType != 2) break;
                string = string + " CHARACTER SET UNICODE";
                break;
            }
            case 2002: {
                if (this.typeName.contains("PERIOD")) {
                    if (this.typeName.contains("TIMESTAMP")) {
                        string = string + "PERIOD(TIMESTAMP";
                        if (this.scale >= 0 && this.scale < 6) {
                            string = string + "(" + this.scale + ")";
                        }
                        string = string + ")";
                        break;
                    }
                    if (this.typeName.contains("TIME")) {
                        string = string + "PERIOD(TIME";
                        if (this.scale >= 0 && this.scale < 6) {
                            string = string + "(" + this.scale + ")";
                        }
                        string = string + ")";
                        break;
                    }
                    if (this.typeName.contains("DATE")) {
                        string = string + "PERIOD(DATE)";
                        break;
                    }
                    string = string + this.typeName;
                    break;
                }
                string = string + this.typeName;
                break;
            }
            case 1111: {
                if (!this.typeName.contains("INTERVAL")) break;
                int index = this.typeName.indexOf(INTERVAL_NM_SEPARATOR);
                if (index >= 0) {
                    String typeN = this.typeName.substring(0, index);
                    String typeM = this.typeName.substring(index + INTERVAL_NM_SEPARATOR.length());
                    int n = 2;
                    int m = 6;
                    String formatString = this.format.trim();
                    int pos = formatString.length();
                    if (typeM.contains(INTERVAL_NM_SECOND) && pos > 3 && formatString.charAt(pos - 1) == ')') {
                        try {
                            m = Integer.parseInt("" + formatString.charAt(pos - 2));
                            formatString = formatString.substring(0, pos - 3);
                        }
                        catch (NumberFormatException e) {
                            m = 6;
                        }
                    }
                    if ((pos = formatString.indexOf(40)) > 0) {
                        try {
                            n = Integer.parseInt("" + formatString.charAt(pos + 1));
                        }
                        catch (NumberFormatException e) {
                            n = 2;
                        }
                    }
                    string = string + typeN;
                    if (n != 2) {
                        string = string + "(" + n + ") ";
                    }
                    string = string + INTERVAL_NM_SEPARATOR + typeM;
                    if (m == 6) break;
                    string = string + " (" + m + ")";
                    break;
                }
                int n = 2;
                String formatString = this.format.trim();
                int pos = formatString.indexOf(40);
                if (pos > 0) {
                    try {
                        n = Integer.parseInt("" + formatString.charAt(pos + 1));
                    }
                    catch (NumberFormatException e) {
                        n = 2;
                    }
                }
                string = string + this.typeName;
                if (n == 2) break;
                string = string + "(" + n + ")";
                break;
            }
            case 2003: {
                string = string + this.typeName;
                break;
            }
            default: {
                string = string + this.typeName;
            }
        }
        return string;
    }

    protected boolean isEmptyString(String text) {
        return text == null || text.isEmpty();
    }
}

