/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.processor;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataInputProcessor;
import com.teradata.connector.teradata.schema.TeradataColumnDesc;
import com.teradata.connector.teradata.schema.TeradataTableDesc;
import com.teradata.connector.teradata.schema.TeradataViewDesc;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class TeradataSplitByPartitionProcessor
extends TeradataInputProcessor {
    private static Log logger = LogFactory.getLog(TeradataSplitByPartitionProcessor.class);
    protected static final int VALUE_PARTITION_ID_TYPE = 4;
    protected static final String COLUMN_PARTITION_ID = "TDIN_PARTID";
    protected static final String COLUMN_PARTITION = "PARTITION";
    protected static final int PARTITION_RANGE_MIN = 10;

    @Override
    protected void setupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
        String inputDatabase = TeradataPlugInConfiguration.getInputDatabase(configuration);
        String inputTableName = TeradataPlugInConfiguration.getInputTable(configuration);
        String inputQuery = TeradataPlugInConfiguration.getInputQuery(configuration);
        String inputCondition = TeradataPlugInConfiguration.getInputConditions(configuration);
        String[] inputFieldNameArray = TeradataPlugInConfiguration.getInputFieldNamesArray(configuration);
        String targetPartitionColName = ConnectorConfiguration.getOutputPartitionColumnNames(configuration);
        String[] targetPartitionColNames = targetPartitionColName.isEmpty() ? new String[]{} : targetPartitionColName.split(",");
        ArrayList<String> inputFieldNameList = new ArrayList<String>();
        for (String s : inputFieldNameArray) {
            inputFieldNameList.add(s);
        }
        int[] posPartitionCols = TeradataSchemaUtils.getColumnMapping(inputFieldNameList, targetPartitionColNames);
        int[] posFieldCols = TeradataSchemaUtils.getColumnMapping(inputFieldNameList, inputFieldNameArray);
        boolean accessLock = TeradataPlugInConfiguration.getInputAccessLock(configuration);
        String objectName = inputTableName;
        inputTableName = TeradataConnection.getQuotedEscapedName(inputDatabase, inputTableName);
        long numPartitions = TeradataPlugInConfiguration.getInputNumPartitions(configuration);
        int numMappers = 1;
        if (numPartitions == 1L) {
            ConnectorConfiguration.setNumMappers(configuration, numMappers);
        } else {
            numMappers = ConnectorConfiguration.getNumMappers(configuration);
        }
        boolean stagingEnabled = this.stagingTableEnabeled(configuration, inputTableName, inputQuery, numMappers);
        if (stagingEnabled) {
            String stageDatabase = TeradataPlugInConfiguration.getInputStageDatabase(configuration);
            String stageTableName = TeradataPlugInConfiguration.getInputStageTableName(configuration);
            int maxLength = this.connection.getMaxTableNameLength();
            if (numPartitions < (long)numMappers) {
                numMappers = (int)numPartitions;
                ConnectorConfiguration.setNumMappers(configuration, numMappers);
            }
            if (stageTableName.isEmpty()) {
                stageTableName = TeradataSchemaUtils.getStageTableName(maxLength, objectName, "TDCSPSTAGE");
            } else if (stageTableName.length() > maxLength) {
                throw new ConnectorException(12013, maxLength);
            }
            try {
                TeradataColumnDesc[] fieldDescs;
                if (objectName != null && !objectName.isEmpty()) {
                    fieldDescs = TeradataSchemaUtils.tableDescFromText(TeradataPlugInConfiguration.getInputTableDesc(configuration)).getColumns();
                } else {
                    try {
                        String charset = TeradataConnection.getURLParamValue(TeradataPlugInConfiguration.getInputJdbcUrl(configuration), "CHARSET");
                        fieldDescs = this.connection.getColumnDescsForSQLWithCharSet(inputQuery, charset);
                    }
                    catch (SQLException e) {
                        throw new ConnectorException(e.getMessage(), e);
                    }
                }
                TeradataTableDesc sourceTableDesc = new TeradataTableDesc();
                sourceTableDesc.setColumns(fieldDescs);
                int columnDescsSize = fieldDescs.length;
                TeradataColumnDesc[] columnDescs = fieldDescs;
                for (int i = 0; i < columnDescsSize; ++i) {
                    columnDescs[i].setName("c" + (i + 1));
                    columnDescs[i].setNullable(true);
                }
                TeradataColumnDesc cpDesc = new TeradataColumnDesc();
                cpDesc.setName(COLUMN_PARTITION_ID);
                cpDesc.setType(4);
                TeradataTableDesc tableDesc = new TeradataTableDesc();
                tableDesc.setBlockSize(TeradataPlugInConfiguration.getInputStageTableBlocksize(configuration));
                tableDesc.setName(stageTableName);
                tableDesc.setDatabaseName(stageDatabase);
                tableDesc.setColumns(columnDescs);
                if (posFieldCols.length > 0) {
                    String[] fieldname = new String[posFieldCols.length];
                    int i = 0;
                    for (int pos : posFieldCols) {
                        fieldname[i] = tableDesc.getColumn(pos).getName();
                        ++i;
                    }
                    TeradataPlugInConfiguration.setInputFieldNamesArray(configuration, fieldname);
                } else {
                    TeradataPlugInConfiguration.setInputFieldNamesArray(configuration, tableDesc.getColumnNames());
                }
                String insertStageTableSQL = null;
                tableDesc.addColumn(cpDesc);
                tableDesc.addPrimaryIndex(COLUMN_PARTITION_ID);
                tableDesc.addPartitionColumn(COLUMN_PARTITION_ID);
                TeradataPlugInConfiguration.setInputTableDesc(configuration, TeradataSchemaUtils.tableDescToJson(tableDesc));
                String selectExpression = TeradataConnection.getQuotedColumnNames(sourceTableDesc.getColumnsString()) + ", ";
                if (targetPartitionColNames.length == 0) {
                    selectExpression = selectExpression + "RANDOM(1, " + numPartitions + ")";
                } else {
                    selectExpression = selectExpression + "(";
                    for (int i = 0; i < posPartitionCols.length; ++i) {
                        if (i > 0) {
                            selectExpression = selectExpression + " + ";
                        }
                        selectExpression = selectExpression + "HASHBUCKET(HASHROW(" + TeradataConnection.getQuotedName(columnDescs[posPartitionCols[i]].getName()) + "))";
                    }
                    selectExpression = selectExpression + ") MOD " + numPartitions + " + 1";
                }
                String stageView = "V" + stageTableName;
                TeradataViewDesc viewDesc = new TeradataViewDesc();
                viewDesc.setName(stageView);
                viewDesc.setDatabaseName(stageDatabase);
                if (inputQuery.isEmpty()) {
                    viewDesc.setQuery(TeradataConnection.getSelectSQL(inputTableName, inputFieldNameArray, inputCondition));
                } else {
                    viewDesc.setQuery(inputQuery);
                }
                if (accessLock) {
                    viewDesc.setAccessLock(true);
                }
                viewDesc.setColumns(columnDescs);
                insertStageTableSQL = TeradataConnection.getInsertSelectSQL(tableDesc.getQualifiedName(), tableDesc.getColumnsString(), viewDesc.getQualifiedName(), selectExpression);
                this.connection.createView(viewDesc);
                logger.info((Object)("create stage view " + viewDesc.getQualifiedName()));
                this.connection.createTable(tableDesc);
                logger.info((Object)("create stage table " + tableDesc.getQualifiedName()));
                logger.info((Object)("insert from source table to staget table, the insert select sql " + insertStageTableSQL));
                long startTime = System.currentTimeMillis();
                logger.info((Object)("the insert select sql starts at: " + startTime));
                this.connection.executeUpdate(insertStageTableSQL);
                long endTime = System.currentTimeMillis();
                logger.info((Object)("the insert select sql ends at: " + endTime));
                logger.info((Object)("the total elapsed time of the insert select sql  is: " + (endTime - startTime) / 1000L + "s"));
                if (!inputQuery.isEmpty()) {
                    TeradataPlugInConfiguration.setInputFinalQuery(configuration, inputQuery);
                    TeradataPlugInConfiguration.setInputQuery(configuration, "");
                } else {
                    TeradataPlugInConfiguration.setInputFinalTable(configuration, inputTableName);
                    TeradataPlugInConfiguration.setInputFinalDatabase(configuration, inputDatabase);
                    TeradataPlugInConfiguration.setInputFinalConditions(configuration, inputCondition);
                }
                TeradataPlugInConfiguration.setInputStageTableEnabled(configuration, stagingEnabled);
                TeradataPlugInConfiguration.setInputStageAreas(configuration, stageTableName);
                TeradataPlugInConfiguration.setInputDatabase(configuration, stageDatabase);
                TeradataPlugInConfiguration.setInputTable(configuration, stageTableName);
                TeradataPlugInConfiguration.setInputConditions(configuration, "");
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void cleanupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
        if (TeradataPlugInConfiguration.getInputStageTableEnabled(configuration)) {
            boolean isStageTableDeleted = false;
            boolean isStageViewDeleted = false;
            String stageTable = null;
            String stageDatabase = TeradataPlugInConfiguration.getInputStageDatabase(configuration);
            String stageTableName = TeradataPlugInConfiguration.getInputStageAreas(configuration);
            TeradataTableDesc tableDesc = new TeradataTableDesc();
            tableDesc.setName(stageTableName);
            tableDesc.setDatabaseName(stageDatabase);
            stageTable = tableDesc.getQualifiedName();
            try {
                this.connection.dropTable(stageTable);
                isStageTableDeleted = true;
                logger.info((Object)("staging table " + stageTable + " is dropped"));
            }
            catch (SQLException e) {
                logger.debug((Object)e.getMessage());
            }
            TeradataViewDesc viewDesc = new TeradataViewDesc();
            viewDesc.setName("V" + stageTableName);
            viewDesc.setDatabaseName(stageDatabase);
            String stageView = viewDesc.getQualifiedName();
            try {
                this.connection.dropView(stageView);
                isStageViewDeleted = true;
                logger.info((Object)("staging view " + stageView + " is dropped"));
            }
            catch (SQLException e) {
                logger.debug((Object)e.getMessage());
            }
            if (!isStageViewDeleted) {
                logger.warn((Object)("staging view " + stageView + " is not dropped"));
            }
            if (!isStageTableDeleted) {
                logger.warn((Object)("staging table " + stageTable + " is not dropped"));
            }
        }
    }

    protected boolean stagingTableEnabeled(Configuration configuration, String inputTableName, String inputQuery, int numMappers) throws ConnectorException {
        if (TeradataPlugInConfiguration.getInputStageTableForced(configuration)) {
            return true;
        }
        if (numMappers == 1) {
            return false;
        }
        if (!inputQuery.isEmpty()) {
            return true;
        }
        try {
            if (!this.connection.isTablePPI(inputTableName)) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new ConnectorException(e.getMessage(), e);
        }
        return false;
    }

    @Override
    protected void validateConfiguration(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        super.validateConfiguration(configuration, connection);
        long numPartitions = TeradataPlugInConfiguration.getInputNumPartitions(configuration);
        if (numPartitions < 1L) {
            throw new ConnectorException(12018);
        }
    }
}

