/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.processor;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataInputProcessor;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import java.sql.SQLException;
import org.apache.hadoop.conf.Configuration;

public class TeradataSplitByHashProcessor
extends TeradataInputProcessor {
    @Override
    protected void setupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
    }

    @Override
    protected void cleanupDatabaseEnvironment(Configuration configuration) throws ConnectorException {
    }

    @Override
    protected void validateConfiguration(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        super.validateConfiguration(configuration, connection);
        int numMappers = ConnectorConfiguration.getNumMappers(configuration);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        if (splitColumn.isEmpty() && numMappers != 1) {
            try {
                String[] tempPiColNames;
                String inputTableName = TeradataConnection.getQuotedEscapedName(TeradataPlugInConfiguration.getInputDatabase(configuration), TeradataPlugInConfiguration.getInputTable(configuration));
                String[] piColNames = connection.getPrimaryIndex(inputTableName);
                if (piColNames.length < 1 && (tempPiColNames = connection.getColumnNamesForTable(inputTableName)).length > 0) {
                    piColNames = new String[]{tempPiColNames[0]};
                }
                if (piColNames.length == 0) {
                    throw new ConnectorException(23002);
                }
                splitColumn = piColNames[0];
                TeradataPlugInConfiguration.setInputSplitByColumn(configuration, splitColumn);
            }
            catch (SQLException e) {
                throw new ConnectorException(e.getMessage(), e);
            }
        }
    }
}

