/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata.processor;

import com.teradata.connector.common.ConnectorInputProcessor;
import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.ConnectorConfiguration;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import com.teradata.connector.teradata.utils.TeradataUtils;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public abstract class TeradataInputProcessor
implements ConnectorInputProcessor {
    private static Log logger = LogFactory.getLog(TeradataInputProcessor.class);
    protected TeradataConnection connection = null;
    protected static final String INNER_QUERY_ALIAS = "DT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inputPreProcessor(JobContext context) throws ConnectorException {
        try {
            long startTime = System.currentTimeMillis();
            logger.info((Object)("input preprocessor " + this.getClass().getName() + " starts at:  " + startTime));
            this.connection = TeradataUtils.openInputConnection(context);
            Configuration configuration = context.getConfiguration();
            String inputTableName = TeradataPlugInConfiguration.getInputTable(configuration);
            if (!inputTableName.isEmpty()) {
                try {
                    inputTableName = TeradataConnection.getQuotedEscapedName(inputTableName);
                    if (!this.connection.isTableNonEmpty(inputTableName)) {
                        throw new ConnectorException(12022);
                    }
                }
                catch (SQLException e) {
                    throw new ConnectorException(e.getMessage(), e);
                }
            }
            this.validateConfiguration(configuration, this.connection);
            String tdchVersion = TeradataUtils.getTdchVersionNumber();
            logger.info((Object)("the teradata connector for hadoop version is: " + tdchVersion));
            logger.info((Object)("input jdbc properties are " + TeradataPlugInConfiguration.getInputJdbcUrl(configuration)));
            TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, this.connection);
            this.setupDatabaseEnvironment(configuration);
            TeradataSchemaUtils.configureSourceConnectorRecordSchema(configuration);
            logger.info((Object)("the number of mappers are " + ConnectorConfiguration.getNumMappers(configuration)));
            long endTime = System.currentTimeMillis();
            logger.info((Object)("input preprocessor " + this.getClass().getName() + " ends at:  " + endTime));
            logger.info((Object)("the total elapsed time of input preprocessor " + this.getClass().getName() + " is: " + (endTime - startTime) / 1000L + "s"));
        }
        finally {
            try {
                TeradataUtils.closeConnection(this.connection);
            }
            catch (ConnectorException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inputPostProcessor(JobContext context) throws ConnectorException {
        long startTime = System.currentTimeMillis();
        logger.info((Object)("input postprocessor " + this.getClass().getName() + " starts at:  " + startTime));
        try {
            this.connection = TeradataUtils.openInputConnection(context);
            this.cleanupDatabaseEnvironment(context.getConfiguration());
        }
        finally {
            try {
                TeradataUtils.closeConnection(this.connection);
            }
            catch (ConnectorException e) {
                e.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            logger.info((Object)("input postprocessor " + this.getClass().getName() + " ends at:  " + startTime));
            logger.info((Object)("the total elapsed time of input postprocessor " + this.getClass().getName() + " is: " + (endTime - startTime) / 1000L + "s"));
        }
        return 0;
    }

    protected abstract void setupDatabaseEnvironment(Configuration var1) throws ConnectorException;

    protected abstract void cleanupDatabaseEnvironment(Configuration var1) throws ConnectorException;

    protected void validateConfiguration(Configuration configuration, TeradataConnection connection) throws ConnectorException {
        TeradataUtils.validateInputTeradataProperties(configuration, connection);
    }
}

