/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.connector.teradata;

import com.teradata.connector.common.exception.ConnectorException;
import com.teradata.connector.common.utils.StandardCharsets;
import com.teradata.connector.teradata.db.TeradataConnection;
import com.teradata.connector.teradata.processor.TeradataInputProcessor;
import com.teradata.connector.teradata.processor.TeradataSplitByHashProcessor;
import com.teradata.connector.teradata.utils.TeradataPlugInConfiguration;
import com.teradata.connector.teradata.utils.TeradataSchemaUtils;
import java.io.IOException;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TeradataSplitByHashFunctionalityTest {
    private static String dbJdbcUrl;
    private static String dbIpAddress;
    private static String dbDatabase;
    private static String dbUsername;
    private static String dbPassword;
    private static String dbJdbcDriverClass;
    private static TeradataConnection dbConnection;
    private static Log logger;
    protected static final int VALUE_PARTITION_ID_TYPE = 4;
    protected static final String COLUMN_PARTITION_ID = "TDIN_PARTID";
    protected static final String COLUMN_PARTITION = "PARTITION";
    protected static final int PARTITION_RANGE_MIN = 10;

    @BeforeClass
    public static void initializeTests() throws Exception {
        dbIpAddress = System.getProperty("test.database.ipaddress", "10.25.35.197");
        dbDatabase = System.getProperty("test.database.databasename", "tdch_testing2");
        dbUsername = System.getProperty("test.database.username", "tdch_testing2");
        dbPassword = System.getProperty("test.database.userpassword", "tdch_testing2");
        dbJdbcDriverClass = System.getProperty("test.database.jdbcdriver.class", "com.teradata.jdbc.TeraDriver");
        dbJdbcUrl = "jdbc:teradata://" + dbIpAddress + "/database=" + dbDatabase;
        dbConnection = new TeradataConnection(dbJdbcDriverClass, dbJdbcUrl, dbUsername, dbPassword, false);
        dbConnection.connect();
        TeradataSplitByHashFunctionalityTest.createDatabaseTables();
    }

    @AfterClass
    public static void cleanupTests() throws Exception {
        TeradataSplitByHashFunctionalityTest.dropDatabaseTables();
        dbConnection.close();
    }

    @Test
    public void testValidateConfigurationFailNumMappers2() {
        try {
            TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
            Job context = new Job();
            Configuration configuration = context.getConfiguration();
            configuration.set("tdch.num.mappers", "2");
            TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
            TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
            TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTEST2");
            TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
            TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
            TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
            processor.inputPreProcessor((JobContext)context);
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testValidateConfigurationNOPINumMappers2() throws Exception {
        TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
        Job context = new Job();
        Configuration configuration = context.getConfiguration();
        configuration.set("tdch.num.mappers", "2");
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
        TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTEST");
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
        TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
        processor.inputPreProcessor((JobContext)context);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        Assert.assertTrue((boolean)splitColumn.toUpperCase().equals("NAME"));
    }

    @Test
    public void testValidateConfigurationNOPINumMappers1() throws Exception {
        TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
        Job context = new Job();
        Configuration configuration = context.getConfiguration();
        configuration.set("tdch.num.mappers", "1");
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
        TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTEST");
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
        TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
        processor.inputPreProcessor((JobContext)context);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        Assert.assertTrue((boolean)splitColumn.toUpperCase().equals(""));
    }

    @Test
    public void testValidateConfigurationPINumMappers1() throws Exception {
        TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
        Job context = new Job();
        Configuration configuration = context.getConfiguration();
        configuration.set("tdch.num.mappers", "1");
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
        TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTESTPI");
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
        TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
        processor.inputPreProcessor((JobContext)context);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        Assert.assertTrue((boolean)splitColumn.toUpperCase().equals(""));
    }

    @Test
    public void testValidateConfigurationPINumMappers2() throws Exception {
        TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
        Job context = new Job();
        Configuration configuration = context.getConfiguration();
        configuration.set("tdch.num.mappers", "2");
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
        TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTESTPI");
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
        TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
        processor.inputPreProcessor((JobContext)context);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        Assert.assertTrue((boolean)splitColumn.toUpperCase().equals("NAME"));
    }

    @Test
    public void testValidateConfigurationNOPICol1NumMappers1() throws Exception {
        TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
        Job context = new Job();
        Configuration configuration = context.getConfiguration();
        configuration.set("tdch.num.mappers", "1");
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
        TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTESTNOPI1");
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
        TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
        processor.inputPreProcessor((JobContext)context);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        Assert.assertTrue((boolean)splitColumn.toUpperCase().equals(""));
    }

    @Test
    public void testValidateConfigurationNOPICol1NumMappers2() throws Exception {
        TeradataSplitByHashProcessor processor = new TeradataSplitByHashProcessor();
        Job context = new Job();
        Configuration configuration = context.getConfiguration();
        configuration.set("tdch.num.mappers", "2");
        TeradataPlugInConfiguration.setInputJdbcDriverClass(configuration, dbJdbcDriverClass);
        TeradataPlugInConfiguration.setInputJdbcUrl(configuration, dbJdbcUrl);
        TeradataPlugInConfiguration.setInputTable(configuration, dbDatabase + ".TDCHIMPORTTESTNOPI1");
        TeradataPlugInConfiguration.setInputTeradataUserName((JobContext)context, dbUsername.getBytes(StandardCharsets.UTF_8));
        TeradataPlugInConfiguration.setInputTeradataPassword((JobContext)context, dbPassword.getBytes(StandardCharsets.UTF_8));
        TeradataSchemaUtils.setupTeradataSourceTableSchema(configuration, dbConnection);
        processor.inputPreProcessor((JobContext)context);
        String splitColumn = TeradataPlugInConfiguration.getInputSplitByColumn(configuration);
        Assert.assertTrue((boolean)splitColumn.toUpperCase().equals("NAME"));
    }

    private static void createDatabaseTables() throws Exception {
        TeradataSplitByHashFunctionalityTest.dropDatabaseTables();
        dbConnection.executeDDL("CREATE MULTISET TABLE " + dbDatabase + ".TDCHIMPORTTEST (NAME VARCHAR(10),ADDR VARCHAR(10)) NO PRIMARY INDEX;");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTEST VALUES ('jimmy','boston');");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTEST VALUES ('Tom','Cumberland');");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTEST VALUES ('jimmy','Cumberland');");
        dbConnection.executeDDL("CREATE MULTISET TABLE " + dbDatabase + ".TDCHIMPORTTESTPI (NAME VARCHAR(10),ADDR VARCHAR(10)) UNIQUE PRIMARY INDEX ( NAME );");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTESTPI VALUES ('jimmy','boston');");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTESTPI VALUES ('Tom','Cumberland');");
        dbConnection.executeDDL("CREATE MULTISET TABLE " + dbDatabase + ".TDCHIMPORTTESTNOPI1 (NAME VARCHAR(10)) NO PRIMARY INDEX;");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTESTNOPI1 VALUES ('jimmy');");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTESTNOPI1 VALUES ('Tom');");
        dbConnection.executeDDL("INSERT INTO " + dbDatabase + ".TDCHIMPORTTESTNOPI1 VALUES ('jimmy');");
    }

    private static void dropDatabaseTables() throws Exception {
        try {
            dbConnection.dropTable(dbDatabase + ".TDCHIMPORTTEST");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            dbConnection.dropTable(dbDatabase + ".TDCHIMPORTTESTPI");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            dbConnection.dropTable(dbDatabase + ".TDCHIMPORTTESTNOPI1");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static {
        logger = LogFactory.getLog(TeradataInputProcessor.class);
    }
}

